/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.StructureReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class BytecodeGenerator
implements Opcodes {
    public static byte[] getClassBytes(StructureReader.StructureDescriptor structure, String fullClassName) throws ClassNotFoundException {
        ClassWriter cw = new ClassWriter(0);
        int bitFieldBitCount = 0;
        cw.visit(49, 49, fullClassName, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(25, "SIZEOF", "J", null, (Object)structure.getSizeOf());
        for (StructureReader.ConstantDescriptor constantDescriptor : structure.getConstants()) {
            fv = cw.visitField(25, constantDescriptor.getName(), "J", null, (Object)constantDescriptor.getValue());
            fv.visitEnd();
        }
        for (StructureReader.FieldDescriptor field : structure.getFields()) {
            String fieldName = field.getName();
            String type = field.getType();
            int colonIndex = type.replace("::", "__").indexOf(58);
            if (colonIndex != -1) {
                String getter = fieldName;
                int bitSize = Integer.parseInt(type.substring(colonIndex + 1).trim());
                if (bitSize > 32 - bitFieldBitCount % 32) {
                    throw new InternalError(String.format("Bitfield %s->%s must not span cells", structure.getName(), type));
                }
                String name = String.format("_%s_s_", getter);
                fv = cw.visitField(25, name, "I", null, (Object)bitFieldBitCount);
                fv.visitEnd();
                name = String.format("_%s_b_", getter);
                fv = cw.visitField(25, name, "I", null, (Object)new Integer(bitSize));
                fv.visitEnd();
                bitFieldBitCount += bitSize;
                continue;
            }
            String name = String.format("_%sOffset_", fieldName);
            fv = cw.visitField(25, name, "I", null, (Object)field.getOffset());
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

