/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation.
 * All rights reserved. 
 *******************************************************************************
 
/***************************************************** 
* Example of calling the collapse() function:
* 
* <div class="collapseheadlearnmore"><a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)">Learn more about something</a></div><div class="collapsecontent">This section should be collapsed and hidden.</div>
* 
* The collapse effect works standalone, but can take advantage of styles for better appearance.
* For example, you could define styles for div.collapsehead, div.collapsecontent, and a.collapsehead
* for nice results.
*
* IMPORTANT: For this to work, there must be no spaces or linebreaks 
* between the collapsehead div and the collapsecontent div.
* 
* Also, in the runtime output, provide a <noscript>, like this:
* 
* <noscript>
* <style type="text/css"><!--
* div.collapsecontent{display:block;}
* //--></style>
* </noscript>
* 20100318: jta  Updated function to improve node traversal in case browser counts text nodes
*
*******************************************************/

function collapse(loc){
	
	//Navigate to the content division using DOM, then change its style
	var foc=loc.parentNode.parentNode;
	for (i=0;i<foc.childNodes.length;i++) {
		var foc2=foc.childNodes[i];
		if (foc2.attributes) {
			for (j=0;j<foc2.attributes.length;j++) {
				if (foc2.attributes[j].nodeName.toLowerCase() == 'class') {
			   		if (foc2.attributes[j].nodeValue == 'collapsecontent') {
			      			foc2.style.display=foc2.style.display=='block'?'none':'block';
						break;
			   		}
				}
		   	}
		}
	}
	
	//Find the header anchor by navigating the DOM tree, then change its class attribute to use a different style
	//var headA = loc.parentNode.firstChild;
	var headA = loc.parentNode;
	for (i=0;i<headA.childNodes.length;i++) {
		var headB=headA.childNodes[i];
		if (headB.attributes) {
			for (j=0;j<headB.attributes.length;j++) {
				if (headB.attributes[j].nodeName.toLowerCase() == 'class') {
			   		if ((headB.attributes[j].nodeValue == 'collapsehead') || (headB.attributes[j].nodeValue == 'collapseheadopen')) {
			      			headB.className=headB.className=='collapsehead'?'collapseheadopen':'collapsehead';
						break;
			   		}
				}
		   	}
		}
	}
}  