/*
 *+------------------------------------------------------------------------+
 *| Licensed Materials - Property of IBM                                   |
 *| (C) Copyright IBM Corp. 2007, 2008.  All Rights Reserved.              |
 *|                                                                        |
 *| US Government Users Restricted Rights - Use, duplication or disclosure |
 *| restricted by GSA ADP Schedule Contract with IBM Corp.                 |
 *+------------------------------------------------------------------------+
 */

var wait = false;
var folders = new Array();
var WshShell = WScript.CreateObject("WScript.Shell");
var fso = WScript.CreateObject("Scripting.FileSystemObject");
var renameFolder = null;
var renameFolders = new Array();
var WAIT_ARG = "-wait";

WshShell.CurrentDirectory =
    fso.GetFile(WScript.ScriptFullName).ParentFolder.Path;

processArgs();
cleanup();

function cleanup() {
    if (!wait) {
        // Delete as much as we can now (i.e. for synchronous
        // silent uninstall).
        deleteFolders(folders);
        forcefullyDeleteFolders(folders);

        // Then run a background process to delete what remains.
        if (renameFolders.length != 0) {
            var cmdstring = "\"" + WScript.FullName + "\" //e:jscript \"" +
                WScript.ScriptFullName + "\" " + WAIT_ARG;
            var i;
            for (i = 0; i < renameFolders.length; i++) {
                cmdstring = cmdstring + " \"" + renameFolders[i] + "\"";
            }
            WshShell.Run(cmdstring, 1, false);
        }
    } else {
        // This is the background process.  Keep trying to delete
        // until successful (i.e. allow enough time for the
        // parent process to exit).

        // Delete what remains.
        deleteFolders(folders);

        // Delete this script.
        deleteFile(WScript.ScriptFullName);
    }
}

function processArgs() {
    var args = WScript.Arguments;
    var i;
    var j = 0;
    for (i = 0; i < args.length; i++) {
        if (args(i) == WAIT_ARG) {
            wait = true;
        } else {
            folders[j++] = args(i);
        }
    }
}

function deleteFolders(folders) {
    var i;
    for (i = 0; i < folders.length; i++) {
        deleteFolder(folders[i]);
    }
}

function deleteFolder(location) {
    if (!fso.FolderExists(location)) {
        return;
    }

    var folder = fso.GetFolder(location);
    if (folder.IsRootFolder) {
        return; // don't delete a root folder
    }

    try {
        fso.DeleteFolder(location, true);
    } catch(e) {
    }

    if (wait) {
        // This is the background process.  Keep trying to delete the
        // folder until successful (i.e. allow enough time for the
        // parent process to exit).
        var i;
        for (i = 0; i < 960; i++) { // 4 minutes max
            if (!fso.FolderExists(location)) {
                break;
            }
            WScript.Sleep(250);
            try {
                fso.DeleteFolder(location, true);
            } catch(e) {
            }
        }
    }
}

function forcefullyDeleteFolders(folders) {
    var i;
    var j = 0;
    for (i = 0; i < folders.length; i++) {
        forcefullyDeleteFolder(folders[i]);
        if (renameFolder != null) {
            renameFolders[j++] = renameFolder;
        }
    }
}

// The fso.DeleteFolder() method will stop deleting as soon as it
// encounters a file it can't delete (e.g. uninstall.exe) and will
// leave around a bunch of other files that could have been deleted.
// Attempt to delete or rename whatever is left.
function forcefullyDeleteFolder(location) {
    renameFolder = null;

    if (!fso.FolderExists(location)) {
        return;
    }

    var folder = fso.GetFolder(location);
    if (folder.IsRootFolder) {
        return; // don't delete a root folder
    }

    var parentFolder = folder.ParentFolder;
    try {
        renameFolder = fso.CreateFolder(fso.BuildPath(
            parentFolder.Path, fso.GetTempName()));
    } catch(e) {
        renameFolder = null;
    }

    if (renameFolder == null) {
        // Couldn't create folder in parent folder.  Try creating it
        // in the folder.
        try {
            renameFolder = fso.CreateFolder(fso.BuildPath(
                folder.Path, fso.GetTempName()));
        } catch(e) {
            renameFolder = null;
        }
    }

    deleteOrRename(folder);
}

function getArray(collection) {
    var i = 0;
    var a = new Array();
    var e = new Enumerator(collection);
    for (; !e.atEnd(); e.moveNext()) {
        a[i++] = e.item();
    }
    return a;
}

function deleteOrRename(folder) {
    var folderPath = folder.Path;
    try {
        fso.DeleteFolder(folderPath, true);
    } catch(e) {
    }

    if (!fso.FolderExists(folderPath)) {
        return;
    }

    var i;

    var subfolders = getArray(folder.SubFolders);
    for (i = 0; i < subfolders.length; i++) {
        var subfolder = subfolders[i];
        if (renameFolder == null || renameFolder.Path != subfolder.Path) { 
            deleteOrRename(subfolder);
        }
    }

    var files = getArray(folder.Files);
    for (i = 0; i < files.length; i++) {
        var file = files[i];
        var location = file.Path;
        deleteFile(location);
        if (!fso.FileExists(location)) {
            continue;
        }
        if (renameFolder == null) {
            continue;
        }
        var dest = fso.BuildPath(renameFolder.Path, file.Name);
        try {
            fso.MoveFile(location, dest);
        } catch(e) {
        }
    }

    try {
        fso.DeleteFolder(folderPath, true);
    } catch(e) {
    }
}

function deleteFile(location) {
    if (!fso.FileExists(location)) {
        return;
    }
    try {
        fso.DeleteFile(location, true);
    } catch(e) {
    }
}
