<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
  xmlns:fo='http://www.w3.org/1999/XSL/Format'>
  <!-- NOTE: need strict mode in IE for "white-space: pre" to work -->
  <xsl:output method="html" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" 
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    indent="yes"/>
  <xsl:template match='/'>
    <html>
      <head>
        <style type='text/css'>
          body {
            font-family: sans-serif;
          }
          h1 {
            font-size: 150%;
          }
          h2 {
            font-size: 120%;
          }
          table {
            border-collapse: collapse;
            border: 1 solid black;
          }
          th, td {
            padding: 0.0em 0.5em;
            vertical-align: top;
            text-align: left;
          }
          .ERROR {
            font-weight: bold;
            background-color: #f44;
            text-align: right;
          }
          .WARNING {
            font-weight: bold;
            background-color: #ff8;
            text-align: right;
          }
          .NOTE {
            font-weight: bold;
            background-color: #8f8;
            text-align: right;
          }
          .INFO {
            font-weight: bold;
            background-color: #8f8;
            text-align: right;
          }
          .DEBUG {
            font-weight: bold;
            background-color: #ddd;
            text-align: right;
          }
          .message {
            white-space: pre;
          }
        </style>
        <title>
          %History_Title
        </title>
      </head>
      <body>
        <h1>
          %History_Title
        </h1>

        <table border='1'>
          <xsl:text>
          </xsl:text>
          <tr>
            <th>%Start_Time</th>
            <th>%End_Time</th>
            <th>%Activity</th>
            <th>%Status</th>
            <th>%Package</th>
            <th>%Feature_Id</th>
            <th>%Log_File</th>
          </tr>
          <xsl:text>
          </xsl:text>
  		  <xsl:apply-templates select="install-history" />
        </table>

      </body>
    </html>
  </xsl:template>

<xsl:template match="install">
          	<xsl:for-each select='offering'>
            <tr>
              <td>
                <xsl:value-of select='../@start'/>
              </td>
              <td>
                <xsl:value-of select='../@end'/>
              </td>
              <td>
                <xsl:value-of select='local-name(..)'/>
              </td>
              <td>
                <xsl:value-of select='../@status'/>
              </td>
              <td>
    		    <xsl:variable name='id' select='@id'/>
    		    <xsl:variable name='version' select='@version'/>
                <xsl:value-of select='concat($id,"_",$version)'/>
              </td>
              <td>
          		<xsl:for-each select='feature'>
				<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:value-of select='@name'/>				
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select='concat(",",@name)'/>				
				</xsl:otherwise>
				</xsl:choose>                		
          		</xsl:for-each>
              </td>
              <td>
                <a>
                  <xsl:attribute name='href'>
                    ../../logs/<xsl:value-of select='../@logfile'/>
                  </xsl:attribute>
                  <xsl:value-of select='../@logfile'/>
                </a>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
          	</xsl:for-each>

</xsl:template>
<xsl:template match="uninstall">
          	<xsl:for-each select='offering'>
            <tr>
              <td>
                <xsl:value-of select='../@start'/>
              </td>
              <td>
                <xsl:value-of select='../@end'/>
              </td>
              <td>
                <xsl:value-of select='local-name(..)'/>
              </td>
              <td>
                <xsl:value-of select='../@status'/>
              </td>
              <td>
    		    <xsl:variable name='id' select='@id'/>
    		    <xsl:variable name='version' select='@version'/>
                <xsl:value-of select='concat($id,"_",$version)'/>
              </td>
              <td>
          		<xsl:for-each select='feature'>
				<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:value-of select='@name'/>				
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select='concat(",",@name)'/>				
				</xsl:otherwise>
				</xsl:choose>                		
          		</xsl:for-each>
              </td>
              <td>
                <a>
                  <xsl:attribute name='href'>
                    ../../logs/<xsl:value-of select='../@logfile'/>
                  </xsl:attribute>
                  <xsl:value-of select='../@logfile'/>
                </a>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
          	</xsl:for-each>

</xsl:template>
<xsl:template match="update">
            <tr>
              <td>
                <xsl:value-of select='@start'/>
              </td>
              <td>
                <xsl:value-of select='@end'/>
              </td>
              <td>
                <xsl:value-of select='local-name()'/>
              </td>
              <td>
                <xsl:value-of select='@status'/>
              </td>
              <td>
          		<xsl:for-each select='offering'>
				<xsl:choose>
				<xsl:when test="position()=1">
            			<xsl:text>from  </xsl:text>
				</xsl:when>
				<xsl:otherwise>
            			<xsl:text> to  </xsl:text>
				</xsl:otherwise>
				</xsl:choose>                		
    		    		<xsl:variable name='id' select='@id'/>
    		    		<xsl:variable name='version' select='@version'/>
                		<xsl:value-of select='concat($id,"_",$version)'/>
                		
          		</xsl:for-each>
              </td>
              <td>
                <xsl:for-each select='offering'>
                  <xsl:choose>
                    <xsl:when test="position()=2">
                      <xsl:for-each select='feature'>
                        <xsl:choose>
                          <xsl:when test="position()=1">
                            <xsl:value-of select='@name'/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select='concat(",",@name)'/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </xsl:when>
                  </xsl:choose>
                </xsl:for-each>
              </td>
              <td>
                <a>
                  <xsl:attribute name='href'>
                    ../../logs/<xsl:value-of select='@logfile'/>
                  </xsl:attribute>
                  <xsl:value-of select='@logfile'/>
                </a>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
</xsl:template>
<xsl:template match="rollback">
         	<xsl:for-each select='offering'>
            <tr>
              <td>
                <xsl:value-of select='../@start'/>
              </td>
              <td>
                <xsl:value-of select='../@end'/>
              </td>
              <td>
                <xsl:value-of select='local-name(..)'/>
              </td>
              <td>
                <xsl:value-of select='../@status'/>
              </td>
              <td>
    			<xsl:variable name='id' select='@id'/>
    			<xsl:variable name='version' select='@version'/>
    			<xsl:value-of select='concat($id,"_",$version)'/>
              </td>
              <td>
          		<xsl:for-each select='feature'>
				<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:value-of select='@name'/>				
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select='concat(",",@name)'/>				
				</xsl:otherwise>
				</xsl:choose>                		
          		</xsl:for-each>
              </td>
              <td>
                <a>
                  <xsl:attribute name='href'>
                    ../../logs/<xsl:value-of select='../@logfile'/>
                  </xsl:attribute>
                  <xsl:value-of select='../@logfile'/>
                </a>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
          	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
