-------------------------------------------------------------------------
--
--	Licensed Materials - Property of IBM
--
--	5724O4800
--
--	(C) Copyright IBM Corp. 1994, 2017. All Rights Reserved
--
--	US Government Users Restricted Rights - Use, duplication
--	or disclosure restricted by GSA ADP Schedule Contract
--	with IBM Corp.
--
------------------------------------------------------------------------

------------------------------------------------------------------------
-- SQL file contains schema, data and automation changes to be applied
-- to a v8.1.0 FP13 ObjectServer instance to bring it up to v8.1.0 FP15.
--
-- The contents of this file should be reviewed prior to adding it to
-- the ObjectServer.
-- Applying this file may cause automations to be replaced, meaning
-- any customization of the automations will be lost
--
-- Prior to applying this file, it is advisable to backup your
-- ObjectServer instance
--
----------------------------------------------------------------------

------------------------------------------------------------------------------
-- Fix the iduc_stats triggers IV77452
-- 
-- The triggers are updated so that multiple instances of an IDUC client
-- connecting with the same Application Name and Application Description
-- are not deleted from the iduc_system.iduc_stats table.
--
-- The failure time calculation is reworked so that it is set by trigger
-- iduc_stats_disconnect after the iduc_disconnect signal is raised.
--
-- If a client connects with the same Application Name, Description and
-- connection ID as an existing entry in the table, a deduplication trigger
-- deduplicate_iduc_stats will reset the LastIducTime to 0 as it is
-- likely to be a different application instance
------------------------------------------------------------------------------

-------------------------------------------------------------------
-- Triggers to record statistics for iduc clients
-------------------------------------------------------------------

CREATE OR REPLACE TRIGGER iduc_stats_insert
GROUP iduc_triggers
PRIORITY 1
COMMENT 'Insert client entry into iduc_system.iduc_stats table on signal iduc_connect'
ON SIGNAL iduc_connect
begin
	insert into iduc_system.iduc_stats (ServerName,AppName,AppDesc,ConnectionId) values (getservername(),%signal.process,%signal.description,%signal.conn_id);
end;
go

CREATE OR REPLACE TRIGGER iduc_stats_disconnect
GROUP iduc_triggers
PRIORITY 1
COMMENT 'Update client entry failure time on disconnect'
ON SIGNAL iduc_disconnect
declare
	failure_time utc;
begin
	set failure_time = getdate();

	for each row cnxn in iduc_system.iduc_stats where cnxn.AppDesc = %signal.description 
		and cnxn.ConnectionId = %signal.conn_id and cnxn.ServerName = getservername() 
	begin
		set cnxn.LastIducTime = failure_time;
	end;
end;
go

CREATE OR REPLACE TRIGGER deduplicate_iduc_stats
GROUP iduc_triggers
PRIORITY 1
COMMENT 'Deduplicate rows on iduc_system.iduc_stats'
BEFORE REINSERT ON iduc_system.iduc_stats 
for each row
begin
	set old.AppName = new.AppName;
	set old.LastIducTime = 0;
end;
go

CREATE OR REPLACE TRIGGER iduc_stats_update
GROUP iduc_triggers
PRIORITY 1
COMMENT 'update LastIducTime in iduc_system.iduc_stats table on signal iduc_data_fetch'
ON SIGNAL iduc_data_fetch
begin
	update iduc_system.iduc_stats set LastIducTime = %signal.at where ServerName = getservername()
		and AppName = %signal.process and AppDesc = %signal.description
		and ConnectionId = %signal.connectionid;
end;
go
