/*
 * $Id: ibmcommon.js,v 1.97 2010/11/17 14:28:26 mbaierl Exp $
*/
/*
 * Copyright (c) 2009 IBM Corporation
 * Owner: Corporate Webmaster (NUS_N_NIWWW)
 * Documentation is available at https://w3.tap.ibm.com/w3ki04/display/cwt/ibmcommon.js
*/
/*
 * jQuery JavaScript Library v1.3.2
 * http://jquery.com/
 *
 * Copyright (c) 2009 John Resig
 * Dual licensed under the MIT and GPL licenses.
 * http://docs.jquery.com/License
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 * Date: 2009-02-19 17:34:21 -0500 (Thu, 19 Feb 2009)
 * Revision: 6246
 */
(function(){var window=this,undefined,_jQuery=window.jQuery,_$=window.$,jQuery=window.jQuery=window.$=function(selector,context){return new jQuery.fn.init(selector,context)
},quickExpr=/^[^<]*(<(.|\s)+>)[^>]*$|^#([\w-]+)$/,isSimple=/^.[^:#\[\.,]*$/;jQuery.fn=jQuery.prototype={init:function(selector,context){selector=selector||document;if(selector.nodeType){this[0]=selector;this.length=1;this.context=selector;return this}if(typeof selector==="string"){var match=quickExpr.exec(selector);if(match&&(match[1]||!context)){if(match[1]){selector=jQuery.clean([match[1]],context)}else{var elem=document.getElementById(match[3]);if(elem&&elem.id!=match[3]){return jQuery().find(selector)
}var ret=jQuery(elem||[]);ret.context=document;ret.selector=selector;return ret}}else{return jQuery(context).find(selector)}}else{if(jQuery.isFunction(selector)){return jQuery(document).ready(selector)}}if(selector.selector&&selector.context){this.selector=selector.selector;this.context=selector.context}return this.setArray(jQuery.isArray(selector)?selector:jQuery.makeArray(selector))},selector:"",jquery:"1.3.2",size:function(){return this.length},get:function(num){return num===undefined?Array.prototype.slice.call(this):this[num]
},pushStack:function(elems,name,selector){var ret=jQuery(elems);ret.prevObject=this;ret.context=this.context;if(name==="find"){ret.selector=this.selector+(this.selector?" ":"")+selector}else{if(name){ret.selector=this.selector+"."+name+"("+selector+")"}}return ret},setArray:function(elems){this.length=0;Array.prototype.push.apply(this,elems);return this},each:function(callback,args){return jQuery.each(this,callback,args)},index:function(elem){return jQuery.inArray(elem&&elem.jquery?elem[0]:elem,this)
},attr:function(name,value,type){var options=name;if(typeof name==="string"){if(value===undefined){return this[0]&&jQuery[type||"attr"](this[0],name)}else{options={};options[name]=value}}return this.each(function(i){for(name in options){jQuery.attr(type?this.style:this,name,jQuery.prop(this,options[name],type,i,name))}})},css:function(key,value){if((key=="width"||key=="height")&&parseFloat(value)<0){value=undefined}return this.attr(key,value,"curCSS")},text:function(text){if(typeof text!=="object"&&text!=null){return this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(text))
}var ret="";jQuery.each(text||this,function(){jQuery.each(this.childNodes,function(){if(this.nodeType!=8){ret+=this.nodeType!=1?this.nodeValue:jQuery.fn.text([this])}})});return ret},wrapAll:function(html){if(this[0]){var wrap=jQuery(html,this[0].ownerDocument).clone();if(this[0].parentNode){wrap.insertBefore(this[0])}wrap.map(function(){var elem=this;while(elem.firstChild){elem=elem.firstChild}return elem}).append(this)}return this},wrapInner:function(html){return this.each(function(){jQuery(this).contents().wrapAll(html)
})},wrap:function(html){return this.each(function(){jQuery(this).wrapAll(html)})},append:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType==1){this.appendChild(elem)}})},prepend:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType==1){this.insertBefore(elem,this.firstChild)}})},before:function(){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this)})},after:function(){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this.nextSibling)
})},end:function(){return this.prevObject||jQuery([])},push:[].push,sort:[].sort,splice:[].splice,find:function(selector){if(this.length===1){var ret=this.pushStack([],"find",selector);ret.length=0;jQuery.find(selector,this[0],ret);return ret}else{return this.pushStack(jQuery.unique(jQuery.map(this,function(elem){return jQuery.find(selector,elem)})),"find",selector)}},clone:function(events){var ret=this.map(function(){if(!jQuery.support.noCloneEvent&&!jQuery.isXMLDoc(this)){var html=this.outerHTML;
if(!html){var div=this.ownerDocument.createElement("div");div.appendChild(this.cloneNode(true));html=div.innerHTML}return jQuery.clean([html.replace(/ jQuery\d+="(?:\d+|null)"/g,"").replace(/^\s*/,"")])[0]}else{return this.cloneNode(true)}});if(events===true){var orig=this.find("*").andSelf(),i=0;ret.find("*").andSelf().each(function(){if(this.nodeName!==orig[i].nodeName){return }var events=jQuery.data(orig[i],"events");for(var type in events){for(var handler in events[type]){jQuery.event.add(this,type,events[type][handler],events[type][handler].data)
}}i++})}return ret},filter:function(selector){return this.pushStack(jQuery.isFunction(selector)&&jQuery.grep(this,function(elem,i){return selector.call(elem,i)})||jQuery.multiFilter(selector,jQuery.grep(this,function(elem){return elem.nodeType===1})),"filter",selector)},closest:function(selector){var pos=jQuery.expr.match.POS.test(selector)?jQuery(selector):null,closer=0;return this.map(function(){var cur=this;while(cur&&cur.ownerDocument){if(pos?pos.index(cur)>-1:jQuery(cur).is(selector)){jQuery.data(cur,"closest",closer);
return cur}cur=cur.parentNode;closer++}})},not:function(selector){if(typeof selector==="string"){if(isSimple.test(selector)){return this.pushStack(jQuery.multiFilter(selector,this,true),"not",selector)}else{selector=jQuery.multiFilter(selector,this)}}var isArrayLike=selector.length&&selector[selector.length-1]!==undefined&&!selector.nodeType;return this.filter(function(){return isArrayLike?jQuery.inArray(this,selector)<0:this!=selector})},add:function(selector){return this.pushStack(jQuery.unique(jQuery.merge(this.get(),typeof selector==="string"?jQuery(selector):jQuery.makeArray(selector))))
},is:function(selector){return !!selector&&jQuery.multiFilter(selector,this).length>0},hasClass:function(selector){return !!selector&&this.is("."+selector)},val:function(value){if(value===undefined){var elem=this[0];if(elem){if(jQuery.nodeName(elem,"option")){return(elem.attributes.value||{}).specified?elem.value:elem.text}if(jQuery.nodeName(elem,"select")){var index=elem.selectedIndex,values=[],options=elem.options,one=elem.type=="select-one";if(index<0){return null}for(var i=one?index:0,max=one?index+1:options.length;
i<max;i++){var option=options[i];if(option.selected){value=jQuery(option).val();if(one){return value}values.push(value)}}return values}return(elem.value||"").replace(/\r/g,"")}return undefined}if(typeof value==="number"){value+=""}return this.each(function(){if(this.nodeType!=1){return }if(jQuery.isArray(value)&&/radio|checkbox/.test(this.type)){this.checked=(jQuery.inArray(this.value,value)>=0||jQuery.inArray(this.name,value)>=0)}else{if(jQuery.nodeName(this,"select")){var values=jQuery.makeArray(value);
jQuery("option",this).each(function(){this.selected=(jQuery.inArray(this.value,values)>=0||jQuery.inArray(this.text,values)>=0)});if(!values.length){this.selectedIndex=-1}}else{this.value=value}}})},html:function(value){return value===undefined?(this[0]?this[0].innerHTML.replace(/ jQuery\d+="(?:\d+|null)"/g,""):null):this.empty().append(value)},replaceWith:function(value){return this.after(value).remove()},eq:function(i){return this.slice(i,+i+1)},slice:function(){return this.pushStack(Array.prototype.slice.apply(this,arguments),"slice",Array.prototype.slice.call(arguments).join(","))
},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem)}))},andSelf:function(){return this.add(this.prevObject)},domManip:function(args,table,callback){if(this[0]){var fragment=(this[0].ownerDocument||this[0]).createDocumentFragment(),scripts=jQuery.clean(args,(this[0].ownerDocument||this[0]),fragment),first=fragment.firstChild;if(first){for(var i=0,l=this.length;i<l;i++){callback.call(root(this[i],first),this.length>1||i>0?fragment.cloneNode(true):fragment)
}}if(scripts){jQuery.each(scripts,evalScript)}}return this;function root(elem,cur){return table&&jQuery.nodeName(elem,"table")&&jQuery.nodeName(cur,"tr")?(elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody"))):elem}}};jQuery.fn.init.prototype=jQuery.fn;function evalScript(i,elem){if(elem.src){jQuery.ajax({url:elem.src,async:false,dataType:"script"})}else{jQuery.globalEval(elem.text||elem.textContent||elem.innerHTML||"")}if(elem.parentNode){elem.parentNode.removeChild(elem)
}}function now(){return +new Date}jQuery.extend=jQuery.fn.extend=function(){var target=arguments[0]||{},i=1,length=arguments.length,deep=false,options;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2}if(typeof target!=="object"&&!jQuery.isFunction(target)){target={}}if(length==i){target=this;--i}for(;i<length;i++){if((options=arguments[i])!=null){for(var name in options){var src=target[name],copy=options[name];if(target===copy){continue}if(deep&&copy&&typeof copy==="object"&&!copy.nodeType){target[name]=jQuery.extend(deep,src||(copy.length!=null?[]:{}),copy)
}else{if(copy!==undefined){target[name]=copy}}}}}return target};var exclude=/z-?index|font-?weight|opacity|zoom|line-?height/i,defaultView=document.defaultView||{},toString=Object.prototype.toString;jQuery.extend({noConflict:function(deep){window.$=_$;if(deep){window.jQuery=_jQuery}return jQuery},isFunction:function(obj){return toString.call(obj)==="[object Function]"},isArray:function(obj){return toString.call(obj)==="[object Array]"},isXMLDoc:function(elem){return elem.nodeType===9&&elem.documentElement.nodeName!=="HTML"||!!elem.ownerDocument&&jQuery.isXMLDoc(elem.ownerDocument)
},globalEval:function(data){if(data&&/\S/.test(data)){var head=document.getElementsByTagName("head")[0]||document.documentElement,script=document.createElement("script");script.type="text/javascript";if(jQuery.support.scriptEval){script.appendChild(document.createTextNode(data))}else{script.text=data}head.insertBefore(script,head.firstChild);head.removeChild(script)}},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()==name.toUpperCase()},each:function(object,callback,args){var name,i=0,length=object.length;
if(args){if(length===undefined){for(name in object){if(callback.apply(object[name],args)===false){break}}}else{for(;i<length;){if(callback.apply(object[i++],args)===false){break}}}}else{if(length===undefined){for(name in object){if(callback.call(object[name],name,object[name])===false){break}}}else{for(var value=object[0];i<length&&callback.call(value,i,value)!==false;value=object[++i]){}}}return object},prop:function(elem,value,type,i,name){if(jQuery.isFunction(value)){value=value.call(elem,i)}return typeof value==="number"&&type=="curCSS"&&!exclude.test(name)?value+"px":value
},className:{add:function(elem,classNames){jQuery.each((classNames||"").split(/\s+/),function(i,className){if(elem.nodeType==1&&!jQuery.className.has(elem.className,className)){elem.className+=(elem.className?" ":"")+className}})},remove:function(elem,classNames){if(elem.nodeType==1){elem.className=classNames!==undefined?jQuery.grep(elem.className.split(/\s+/),function(className){return !jQuery.className.has(classNames,className)}).join(" "):""}},has:function(elem,className){return elem&&jQuery.inArray(className,(elem.className||elem).toString().split(/\s+/))>-1
}},swap:function(elem,options,callback){var old={};for(var name in options){old[name]=elem.style[name];elem.style[name]=options[name]}callback.call(elem);for(var name in options){elem.style[name]=old[name]}},css:function(elem,name,force,extra){if(name=="width"||name=="height"){var val,props={position:"absolute",visibility:"hidden",display:"block"},which=name=="width"?["Left","Right"]:["Top","Bottom"];function getWH(){val=name=="width"?elem.offsetWidth:elem.offsetHeight;if(extra==="border"){return 
}jQuery.each(which,function(){if(!extra){val-=parseFloat(jQuery.curCSS(elem,"padding"+this,true))||0}if(extra==="margin"){val+=parseFloat(jQuery.curCSS(elem,"margin"+this,true))||0}else{val-=parseFloat(jQuery.curCSS(elem,"border"+this+"Width",true))||0}})}if(elem.offsetWidth!==0){getWH()}else{jQuery.swap(elem,props,getWH)}return Math.max(0,Math.round(val))}return jQuery.curCSS(elem,name,force)},curCSS:function(elem,name,force){var ret,style=elem.style;if(name=="opacity"&&!jQuery.support.opacity){ret=jQuery.attr(style,"opacity");
return ret==""?"1":ret}if(name.match(/float/i)){name=styleFloat}if(!force&&style&&style[name]){ret=style[name]}else{if(defaultView.getComputedStyle){if(name.match(/float/i)){name="float"}name=name.replace(/([A-Z])/g,"-$1").toLowerCase();var computedStyle=defaultView.getComputedStyle(elem,null);if(computedStyle){ret=computedStyle.getPropertyValue(name)}if(name=="opacity"&&ret==""){ret="1"}}else{if(elem.currentStyle){var camelCase=name.replace(/\-(\w)/g,function(all,letter){return letter.toUpperCase()
});ret=elem.currentStyle[name]||elem.currentStyle[camelCase];if(!/^\d+(px)?$/i.test(ret)&&/^\d/.test(ret)){var left=style.left,rsLeft=elem.runtimeStyle.left;elem.runtimeStyle.left=elem.currentStyle.left;style.left=ret||0;ret=style.pixelLeft+"px";style.left=left;elem.runtimeStyle.left=rsLeft}}}}return ret},clean:function(elems,context,fragment){context=context||document;if(typeof context.createElement==="undefined"){context=context.ownerDocument||context[0]&&context[0].ownerDocument||document}if(!fragment&&elems.length===1&&typeof elems[0]==="string"){var match=/^<(\w+)\s*\/?>$/.exec(elems[0]);
if(match){return[context.createElement(match[1])]}}var ret=[],scripts=[],div=context.createElement("div");jQuery.each(elems,function(i,elem){if(typeof elem==="number"){elem+=""}if(!elem){return }if(typeof elem==="string"){elem=elem.replace(/(<(\w+)[^>]*?)\/>/g,function(all,front,tag){return tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i)?all:front+"></"+tag+">"});var tags=elem.replace(/^\s+/,"").substring(0,10).toLowerCase();var wrap=!tags.indexOf("<opt")&&[1,"<select multiple='multiple'>","</select>"]||!tags.indexOf("<leg")&&[1,"<fieldset>","</fieldset>"]||tags.match(/^<(thead|tbody|tfoot|colg|cap)/)&&[1,"<table>","</table>"]||!tags.indexOf("<tr")&&[2,"<table><tbody>","</tbody></table>"]||(!tags.indexOf("<td")||!tags.indexOf("<th"))&&[3,"<table><tbody><tr>","</tr></tbody></table>"]||!tags.indexOf("<col")&&[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"]||!jQuery.support.htmlSerialize&&[1,"div<div>","</div>"]||[0,"",""];
div.innerHTML=wrap[1]+elem+wrap[2];while(wrap[0]--){div=div.lastChild}if(!jQuery.support.tbody){var hasBody=/<tbody/i.test(elem),tbody=!tags.indexOf("<table")&&!hasBody?div.firstChild&&div.firstChild.childNodes:wrap[1]=="<table>"&&!hasBody?div.childNodes:[];for(var j=tbody.length-1;j>=0;--j){if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length){tbody[j].parentNode.removeChild(tbody[j])}}}if(!jQuery.support.leadingWhitespace&&/^\s/.test(elem)){div.insertBefore(context.createTextNode(elem.match(/^\s*/)[0]),div.firstChild)
}elem=jQuery.makeArray(div.childNodes)}if(elem.nodeType){ret.push(elem)}else{ret=jQuery.merge(ret,elem)}});if(fragment){for(var i=0;ret[i];i++){if(jQuery.nodeName(ret[i],"script")&&(!ret[i].type||ret[i].type.toLowerCase()==="text/javascript")){scripts.push(ret[i].parentNode?ret[i].parentNode.removeChild(ret[i]):ret[i])}else{if(ret[i].nodeType===1){ret.splice.apply(ret,[i+1,0].concat(jQuery.makeArray(ret[i].getElementsByTagName("script"))))}fragment.appendChild(ret[i])}}return scripts}return ret},attr:function(elem,name,value){if(!elem||elem.nodeType==3||elem.nodeType==8){return undefined
}var notxml=!jQuery.isXMLDoc(elem),set=value!==undefined;name=notxml&&jQuery.props[name]||name;if(elem.tagName){var special=/href|src|style/.test(name);if(name=="selected"&&elem.parentNode){elem.parentNode.selectedIndex}if(name in elem&&notxml&&!special){if(set){if(name=="type"&&jQuery.nodeName(elem,"input")&&elem.parentNode){throw"type property can't be changed"}elem[name]=value}if(jQuery.nodeName(elem,"form")&&elem.getAttributeNode(name)){return elem.getAttributeNode(name).nodeValue}if(name=="tabIndex"){var attributeNode=elem.getAttributeNode("tabIndex");
return attributeNode&&attributeNode.specified?attributeNode.value:elem.nodeName.match(/(button|input|object|select|textarea)/i)?0:elem.nodeName.match(/^(a|area)$/i)&&elem.href?0:undefined}return elem[name]}if(!jQuery.support.style&&notxml&&name=="style"){return jQuery.attr(elem.style,"cssText",value)}if(set){elem.setAttribute(name,""+value)}var attr=!jQuery.support.hrefNormalized&&notxml&&special?elem.getAttribute(name,2):elem.getAttribute(name);return attr===null?undefined:attr}if(!jQuery.support.opacity&&name=="opacity"){if(set){elem.zoom=1;
elem.filter=(elem.filter||"").replace(/alpha\([^)]*\)/,"")+(parseInt(value)+""=="NaN"?"":"alpha(opacity="+value*100+")")}return elem.filter&&elem.filter.indexOf("opacity=")>=0?(parseFloat(elem.filter.match(/opacity=([^)]*)/)[1])/100)+"":""}name=name.replace(/-([a-z])/ig,function(all,letter){return letter.toUpperCase()});if(set){elem[name]=value}return elem[name]},trim:function(text){return(text||"").replace(/^\s+|\s+$/g,"")},makeArray:function(array){var ret=[];if(array!=null){var i=array.length;
if(i==null||typeof array==="string"||jQuery.isFunction(array)||array.setInterval){ret[0]=array}else{while(i){ret[--i]=array[i]}}}return ret},inArray:function(elem,array){for(var i=0,length=array.length;i<length;i++){if(array[i]===elem){return i}}return -1},merge:function(first,second){var i=0,elem,pos=first.length;if(!jQuery.support.getAll){while((elem=second[i++])!=null){if(elem.nodeType!=8){first[pos++]=elem}}}else{while((elem=second[i++])!=null){first[pos++]=elem}}return first},unique:function(array){var ret=[],done={};
try{for(var i=0,length=array.length;i<length;i++){var id=jQuery.data(array[i]);if(!done[id]){done[id]=true;ret.push(array[i])}}}catch(e){ret=array}return ret},grep:function(elems,callback,inv){var ret=[];for(var i=0,length=elems.length;i<length;i++){if(!inv!=!callback(elems[i],i)){ret.push(elems[i])}}return ret},map:function(elems,callback){var ret=[];for(var i=0,length=elems.length;i<length;i++){var value=callback(elems[i],i);if(value!=null){ret[ret.length]=value}}return ret.concat.apply([],ret)
}});var userAgent=navigator.userAgent.toLowerCase();jQuery.browser={version:(userAgent.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[0,"0"])[1],safari:/webkit/.test(userAgent),opera:/opera/.test(userAgent),msie:/msie/.test(userAgent)&&!/opera/.test(userAgent),mozilla:/mozilla/.test(userAgent)&&!/(compatible|webkit)/.test(userAgent)};jQuery.each({parent:function(elem){return elem.parentNode},parents:function(elem){return jQuery.dir(elem,"parentNode")},next:function(elem){return jQuery.nth(elem,2,"nextSibling")
},prev:function(elem){return jQuery.nth(elem,2,"previousSibling")},nextAll:function(elem){return jQuery.dir(elem,"nextSibling")},prevAll:function(elem){return jQuery.dir(elem,"previousSibling")},siblings:function(elem){return jQuery.sibling(elem.parentNode.firstChild,elem)},children:function(elem){return jQuery.sibling(elem.firstChild)},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes)}},function(name,fn){jQuery.fn[name]=function(selector){var ret=jQuery.map(this,fn);
if(selector&&typeof selector=="string"){ret=jQuery.multiFilter(selector,ret)}return this.pushStack(jQuery.unique(ret),name,selector)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var ret=[],insert=jQuery(selector);for(var i=0,l=insert.length;i<l;i++){var elems=(i>0?this.clone(true):this).get();jQuery.fn[original].apply(jQuery(insert[i]),elems);ret=ret.concat(elems)
}return this.pushStack(ret,name,selector)}});jQuery.each({removeAttr:function(name){jQuery.attr(this,name,"");if(this.nodeType==1){this.removeAttribute(name)}},addClass:function(classNames){jQuery.className.add(this,classNames)},removeClass:function(classNames){jQuery.className.remove(this,classNames)},toggleClass:function(classNames,state){if(typeof state!=="boolean"){state=!jQuery.className.has(this,classNames)}jQuery.className[state?"add":"remove"](this,classNames)},remove:function(selector){if(!selector||jQuery.filter(selector,[this]).length){jQuery("*",this).add([this]).each(function(){jQuery.event.remove(this);
jQuery.removeData(this)});if(this.parentNode){this.parentNode.removeChild(this)}}},empty:function(){jQuery(this).children().remove();while(this.firstChild){this.removeChild(this.firstChild)}}},function(name,fn){jQuery.fn[name]=function(){return this.each(fn,arguments)}});function num(elem,prop){return elem[0]&&parseInt(jQuery.curCSS(elem[0],prop,true),10)||0}var expando="jQuery"+now(),uuid=0,windowData={};jQuery.extend({cache:{},data:function(elem,name,data){elem=elem==window?windowData:elem;var id=elem[expando];
if(!id){id=elem[expando]=++uuid}if(name&&!jQuery.cache[id]){jQuery.cache[id]={}}if(data!==undefined){jQuery.cache[id][name]=data}return name?jQuery.cache[id][name]:id},removeData:function(elem,name){elem=elem==window?windowData:elem;var id=elem[expando];if(name){if(jQuery.cache[id]){delete jQuery.cache[id][name];name="";for(name in jQuery.cache[id]){break}if(!name){jQuery.removeData(elem)}}}else{try{delete elem[expando]}catch(e){if(elem.removeAttribute){elem.removeAttribute(expando)}}delete jQuery.cache[id]
}},queue:function(elem,type,data){if(elem){type=(type||"fx")+"queue";var q=jQuery.data(elem,type);if(!q||jQuery.isArray(data)){q=jQuery.data(elem,type,jQuery.makeArray(data))}else{if(data){q.push(data)}}}return q},dequeue:function(elem,type){var queue=jQuery.queue(elem,type),fn=queue.shift();if(!type||type==="fx"){fn=queue[0]}if(fn!==undefined){fn.call(elem)}}});jQuery.fn.extend({data:function(key,value){var parts=key.split(".");parts[1]=parts[1]?"."+parts[1]:"";if(value===undefined){var data=this.triggerHandler("getData"+parts[1]+"!",[parts[0]]);
if(data===undefined&&this.length){data=jQuery.data(this[0],key)}return data===undefined&&parts[1]?this.data(parts[0]):data}else{return this.trigger("setData"+parts[1]+"!",[parts[0],value]).each(function(){jQuery.data(this,key,value)})}},removeData:function(key){return this.each(function(){jQuery.removeData(this,key)})},queue:function(type,data){if(typeof type!=="string"){data=type;type="fx"}if(data===undefined){return jQuery.queue(this[0],type)}return this.each(function(){var queue=jQuery.queue(this,type,data);
if(type=="fx"&&queue.length==1){queue[0].call(this)}})},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type)})}});
/*
 * Sizzle CSS Selector Engine - v0.9.3
 *  Copyright 2009, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^[\]]*\]|['"][^'"]*['"]|[^[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?/g,done=0,toString=Object.prototype.toString;
var Sizzle=function(selector,context,results,seed){results=results||[];context=context||document;if(context.nodeType!==1&&context.nodeType!==9){return[]}if(!selector||typeof selector!=="string"){return results}var parts=[],m,set,checkSet,check,mode,extra,prune=true;chunker.lastIndex=0;while((m=chunker.exec(selector))!==null){parts.push(m[1]);if(m[2]){extra=RegExp.rightContext;break}}if(parts.length>1&&origPOS.exec(selector)){if(parts.length===2&&Expr.relative[parts[0]]){set=posProcess(parts[0]+parts[1],context)
}else{set=Expr.relative[parts[0]]?[context]:Sizzle(parts.shift(),context);while(parts.length){selector=parts.shift();if(Expr.relative[selector]){selector+=parts.shift()}set=posProcess(selector,set)}}}else{var ret=seed?{expr:parts.pop(),set:makeArray(seed)}:Sizzle.find(parts.pop(),parts.length===1&&context.parentNode?context.parentNode:context,isXML(context));set=Sizzle.filter(ret.expr,ret.set);if(parts.length>0){checkSet=makeArray(set)}else{prune=false}while(parts.length){var cur=parts.pop(),pop=cur;
if(!Expr.relative[cur]){cur=""}else{pop=parts.pop()}if(pop==null){pop=context}Expr.relative[cur](checkSet,pop,isXML(context))}}if(!checkSet){checkSet=set}if(!checkSet){throw"Syntax error, unrecognized expression: "+(cur||selector)}if(toString.call(checkSet)==="[object Array]"){if(!prune){results.push.apply(results,checkSet)}else{if(context.nodeType===1){for(var i=0;checkSet[i]!=null;i++){if(checkSet[i]&&(checkSet[i]===true||checkSet[i].nodeType===1&&contains(context,checkSet[i]))){results.push(set[i])
}}}else{for(var i=0;checkSet[i]!=null;i++){if(checkSet[i]&&checkSet[i].nodeType===1){results.push(set[i])}}}}}else{makeArray(checkSet,results)}if(extra){Sizzle(extra,context,results,seed);if(sortOrder){hasDuplicate=false;results.sort(sortOrder);if(hasDuplicate){for(var i=1;i<results.length;i++){if(results[i]===results[i-1]){results.splice(i--,1)}}}}}return results};Sizzle.matches=function(expr,set){return Sizzle(expr,null,null,set)};Sizzle.find=function(expr,context,isXML){var set,match;if(!expr){return[]
}for(var i=0,l=Expr.order.length;i<l;i++){var type=Expr.order[i],match;if((match=Expr.match[type].exec(expr))){var left=RegExp.leftContext;if(left.substr(left.length-1)!=="\\"){match[1]=(match[1]||"").replace(/\\/g,"");set=Expr.find[type](match,context,isXML);if(set!=null){expr=expr.replace(Expr.match[type],"");break}}}}if(!set){set=context.getElementsByTagName("*")}return{set:set,expr:expr}};Sizzle.filter=function(expr,set,inplace,not){var old=expr,result=[],curLoop=set,match,anyFound,isXMLFilter=set&&set[0]&&isXML(set[0]);
while(expr&&set.length){for(var type in Expr.filter){if((match=Expr.match[type].exec(expr))!=null){var filter=Expr.filter[type],found,item;anyFound=false;if(curLoop==result){result=[]}if(Expr.preFilter[type]){match=Expr.preFilter[type](match,curLoop,inplace,result,not,isXMLFilter);if(!match){anyFound=found=true}else{if(match===true){continue}}}if(match){for(var i=0;(item=curLoop[i])!=null;i++){if(item){found=filter(item,match,i,curLoop);var pass=not^!!found;if(inplace&&found!=null){if(pass){anyFound=true
}else{curLoop[i]=false}}else{if(pass){result.push(item);anyFound=true}}}}}if(found!==undefined){if(!inplace){curLoop=result}expr=expr.replace(Expr.match[type],"");if(!anyFound){return[]}break}}}if(expr==old){if(anyFound==null){throw"Syntax error, unrecognized expression: "+expr}else{break}}old=expr}return curLoop};var Expr=Sizzle.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF_-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF_-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF_-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF_-]|\\.)+)\s*(?:(\S?=)\s*(['"]*)(.*?)\3|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*_-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\((even|odd|[\dn+-]*)\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF_-]|\\.)+)(?:\((['"]*)((?:\([^\)]+\)|[^\2\(\)]*)+)\2\))?/},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(elem){return elem.getAttribute("href")
}},relative:{"+":function(checkSet,part,isXML){var isPartStr=typeof part==="string",isTag=isPartStr&&!/\W/.test(part),isPartStrNotTag=isPartStr&&!isTag;if(isTag&&!isXML){part=part.toUpperCase()}for(var i=0,l=checkSet.length,elem;i<l;i++){if((elem=checkSet[i])){while((elem=elem.previousSibling)&&elem.nodeType!==1){}checkSet[i]=isPartStrNotTag||elem&&elem.nodeName===part?elem||false:elem===part}}if(isPartStrNotTag){Sizzle.filter(part,checkSet,true)}},">":function(checkSet,part,isXML){var isPartStr=typeof part==="string";
if(isPartStr&&!/\W/.test(part)){part=isXML?part:part.toUpperCase();for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var parent=elem.parentNode;checkSet[i]=parent.nodeName===part?parent:false}}}else{for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){checkSet[i]=isPartStr?elem.parentNode:elem.parentNode===part}}if(isPartStr){Sizzle.filter(part,checkSet,true)}}},"":function(checkSet,part,isXML){var doneName=done++,checkFn=dirCheck;if(!part.match(/\W/)){var nodeCheck=part=isXML?part:part.toUpperCase();
checkFn=dirNodeCheck}checkFn("parentNode",part,doneName,checkSet,nodeCheck,isXML)},"~":function(checkSet,part,isXML){var doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!part.match(/\W/)){var nodeCheck=part=isXML?part:part.toUpperCase();checkFn=dirNodeCheck}checkFn("previousSibling",part,doneName,checkSet,nodeCheck,isXML)}},find:{ID:function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?[m]:[]}},NAME:function(match,context,isXML){if(typeof context.getElementsByName!=="undefined"){var ret=[],results=context.getElementsByName(match[1]);
for(var i=0,l=results.length;i<l;i++){if(results[i].getAttribute("name")===match[1]){ret.push(results[i])}}return ret.length===0?null:ret}},TAG:function(match,context){return context.getElementsByTagName(match[1])}},preFilter:{CLASS:function(match,curLoop,inplace,result,not,isXML){match=" "+match[1].replace(/\\/g,"")+" ";if(isXML){return match}for(var i=0,elem;(elem=curLoop[i])!=null;i++){if(elem){if(not^(elem.className&&(" "+elem.className+" ").indexOf(match)>=0)){if(!inplace){result.push(elem)}}else{if(inplace){curLoop[i]=false
}}}}return false},ID:function(match){return match[1].replace(/\\/g,"")},TAG:function(match,curLoop){for(var i=0;curLoop[i]===false;i++){}return curLoop[i]&&isXML(curLoop[i])?match[1]:match[1].toUpperCase()},CHILD:function(match){if(match[1]=="nth"){var test=/(-?)(\d*)n((?:\+|-)?\d*)/.exec(match[2]=="even"&&"2n"||match[2]=="odd"&&"2n+1"||!/\D/.test(match[2])&&"0n+"+match[2]||match[2]);match[2]=(test[1]+(test[2]||1))-0;match[3]=test[3]-0}match[0]=done++;return match},ATTR:function(match,curLoop,inplace,result,not,isXML){var name=match[1].replace(/\\/g,"");
if(!isXML&&Expr.attrMap[name]){match[1]=Expr.attrMap[name]}if(match[2]==="~="){match[4]=" "+match[4]+" "}return match},PSEUDO:function(match,curLoop,inplace,result,not){if(match[1]==="not"){if(match[3].match(chunker).length>1||/^\w/.test(match[3])){match[3]=Sizzle(match[3],null,null,curLoop)}else{var ret=Sizzle.filter(match[3],curLoop,inplace,true^not);if(!inplace){result.push.apply(result,ret)}return false}}else{if(Expr.match.POS.test(match[0])||Expr.match.CHILD.test(match[0])){return true}}return match
},POS:function(match){match.unshift(true);return match}},filters:{enabled:function(elem){return elem.disabled===false&&elem.type!=="hidden"},disabled:function(elem){return elem.disabled===true},checked:function(elem){return elem.checked===true},selected:function(elem){elem.parentNode.selectedIndex;return elem.selected===true},parent:function(elem){return !!elem.firstChild},empty:function(elem){return !elem.firstChild},has:function(elem,i,match){return !!Sizzle(match[3],elem).length},header:function(elem){return/h\d/i.test(elem.nodeName)
},text:function(elem){return"text"===elem.type},radio:function(elem){return"radio"===elem.type},checkbox:function(elem){return"checkbox"===elem.type},file:function(elem){return"file"===elem.type},password:function(elem){return"password"===elem.type},submit:function(elem){return"submit"===elem.type},image:function(elem){return"image"===elem.type},reset:function(elem){return"reset"===elem.type},button:function(elem){return"button"===elem.type||elem.nodeName.toUpperCase()==="BUTTON"},input:function(elem){return/input|select|textarea|button/i.test(elem.nodeName)
}},setFilters:{first:function(elem,i){return i===0},last:function(elem,i,match,array){return i===array.length-1},even:function(elem,i){return i%2===0},odd:function(elem,i){return i%2===1},lt:function(elem,i,match){return i<match[3]-0},gt:function(elem,i,match){return i>match[3]-0},nth:function(elem,i,match){return match[3]-0==i},eq:function(elem,i,match){return match[3]-0==i}},filter:{PSEUDO:function(elem,match,i,array){var name=match[1],filter=Expr.filters[name];if(filter){return filter(elem,i,match,array)
}else{if(name==="contains"){return(elem.textContent||elem.innerText||"").indexOf(match[3])>=0}else{if(name==="not"){var not=match[3];for(var i=0,l=not.length;i<l;i++){if(not[i]===elem){return false}}return true}}}},CHILD:function(elem,match){var type=match[1],node=elem;switch(type){case"only":case"first":while(node=node.previousSibling){if(node.nodeType===1){return false}}if(type=="first"){return true}node=elem;case"last":while(node=node.nextSibling){if(node.nodeType===1){return false}}return true;
case"nth":var first=match[2],last=match[3];if(first==1&&last==0){return true}var doneName=match[0],parent=elem.parentNode;if(parent&&(parent.sizcache!==doneName||!elem.nodeIndex)){var count=0;for(node=parent.firstChild;node;node=node.nextSibling){if(node.nodeType===1){node.nodeIndex=++count}}parent.sizcache=doneName}var diff=elem.nodeIndex-last;if(first==0){return diff==0}else{return(diff%first==0&&diff/first>=0)}}},ID:function(elem,match){return elem.nodeType===1&&elem.getAttribute("id")===match
},TAG:function(elem,match){return(match==="*"&&elem.nodeType===1)||elem.nodeName===match},CLASS:function(elem,match){return(" "+(elem.className||elem.getAttribute("class"))+" ").indexOf(match)>-1},ATTR:function(elem,match){var name=match[1],result=Expr.attrHandle[name]?Expr.attrHandle[name](elem):elem[name]!=null?elem[name]:elem.getAttribute(name),value=result+"",type=match[2],check=match[4];return result==null?type==="!=":type==="="?value===check:type==="*="?value.indexOf(check)>=0:type==="~="?(" "+value+" ").indexOf(check)>=0:!check?value&&result!==false:type==="!="?value!=check:type==="^="?value.indexOf(check)===0:type==="$="?value.substr(value.length-check.length)===check:type==="|="?value===check||value.substr(0,check.length+1)===check+"-":false
},POS:function(elem,match,i,array){var name=match[2],filter=Expr.setFilters[name];if(filter){return filter(elem,i,match,array)}}}};var origPOS=Expr.match.POS;for(var type in Expr.match){Expr.match[type]=RegExp(Expr.match[type].source+/(?![^\[]*\])(?![^\(]*\))/.source)}var makeArray=function(array,results){array=Array.prototype.slice.call(array);if(results){results.push.apply(results,array);return results}return array};try{Array.prototype.slice.call(document.documentElement.childNodes)}catch(e){makeArray=function(array,results){var ret=results||[];
if(toString.call(array)==="[object Array]"){Array.prototype.push.apply(ret,array)}else{if(typeof array.length==="number"){for(var i=0,l=array.length;i<l;i++){ret.push(array[i])}}else{for(var i=0;array[i];i++){ret.push(array[i])}}}return ret}}var sortOrder;if(document.documentElement.compareDocumentPosition){sortOrder=function(a,b){var ret=a.compareDocumentPosition(b)&4?-1:a===b?0:1;if(ret===0){hasDuplicate=true}return ret}}else{if("sourceIndex" in document.documentElement){sortOrder=function(a,b){var ret=a.sourceIndex-b.sourceIndex;
if(ret===0){hasDuplicate=true}return ret}}else{if(document.createRange){sortOrder=function(a,b){var aRange=a.ownerDocument.createRange(),bRange=b.ownerDocument.createRange();aRange.selectNode(a);aRange.collapse(true);bRange.selectNode(b);bRange.collapse(true);var ret=aRange.compareBoundaryPoints(Range.START_TO_END,bRange);if(ret===0){hasDuplicate=true}return ret}}}}(function(){var form=document.createElement("form"),id="script"+(new Date).getTime();form.innerHTML="<input name='"+id+"'/>";var root=document.documentElement;
root.insertBefore(form,root.firstChild);if(!!document.getElementById(id)){Expr.find.ID=function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?m.id===match[1]||typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id").nodeValue===match[1]?[m]:undefined:[]}};Expr.filter.ID=function(elem,match){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return elem.nodeType===1&&node&&node.nodeValue===match
}}root.removeChild(form)})();(function(){var div=document.createElement("div");div.appendChild(document.createComment(""));if(div.getElementsByTagName("*").length>0){Expr.find.TAG=function(match,context){var results=context.getElementsByTagName(match[1]);if(match[1]==="*"){var tmp=[];for(var i=0;results[i];i++){if(results[i].nodeType===1){tmp.push(results[i])}}results=tmp}return results}}div.innerHTML="<a href='#'></a>";if(div.firstChild&&typeof div.firstChild.getAttribute!=="undefined"&&div.firstChild.getAttribute("href")!=="#"){Expr.attrHandle.href=function(elem){return elem.getAttribute("href",2)
}}})();if(document.querySelectorAll){(function(){var oldSizzle=Sizzle,div=document.createElement("div");div.innerHTML="<p class='TEST'></p>";if(div.querySelectorAll&&div.querySelectorAll(".TEST").length===0){return }Sizzle=function(query,context,extra,seed){context=context||document;if(!seed&&context.nodeType===9&&!isXML(context)){try{return makeArray(context.querySelectorAll(query),extra)}catch(e){}}return oldSizzle(query,context,extra,seed)};Sizzle.find=oldSizzle.find;Sizzle.filter=oldSizzle.filter;
Sizzle.selectors=oldSizzle.selectors;Sizzle.matches=oldSizzle.matches})()}if(document.getElementsByClassName&&document.documentElement.getElementsByClassName){(function(){var div=document.createElement("div");div.innerHTML="<div class='test e'></div><div class='test'></div>";if(div.getElementsByClassName("e").length===0){return }div.lastChild.className="e";if(div.getElementsByClassName("e").length===1){return }Expr.order.splice(1,0,"CLASS");Expr.find.CLASS=function(match,context,isXML){if(typeof context.getElementsByClassName!=="undefined"&&!isXML){return context.getElementsByClassName(match[1])
}}})()}function dirNodeCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){var sibDir=dir=="previousSibling"&&!isXML;for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){if(sibDir&&elem.nodeType===1){elem.sizcache=doneName;elem.sizset=i}elem=elem[dir];var match=false;while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1&&!isXML){elem.sizcache=doneName;elem.sizset=i}if(elem.nodeName===cur){match=elem;break}elem=elem[dir]}checkSet[i]=match}}}function dirCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){var sibDir=dir=="previousSibling"&&!isXML;
for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){if(sibDir&&elem.nodeType===1){elem.sizcache=doneName;elem.sizset=i}elem=elem[dir];var match=false;while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break}if(elem.nodeType===1){if(!isXML){elem.sizcache=doneName;elem.sizset=i}if(typeof cur!=="string"){if(elem===cur){match=true;break}}else{if(Sizzle.filter(cur,[elem]).length>0){match=elem;break}}}elem=elem[dir]}checkSet[i]=match}}}var contains=document.compareDocumentPosition?function(a,b){return a.compareDocumentPosition(b)&16
}:function(a,b){return a!==b&&(a.contains?a.contains(b):true)};var isXML=function(elem){return elem.nodeType===9&&elem.documentElement.nodeName!=="HTML"||!!elem.ownerDocument&&isXML(elem.ownerDocument)};var posProcess=function(selector,context){var tmpSet=[],later="",match,root=context.nodeType?[context]:context;while((match=Expr.match.PSEUDO.exec(selector))){later+=match[0];selector=selector.replace(Expr.match.PSEUDO,"")}selector=Expr.relative[selector]?selector+"*":selector;for(var i=0,l=root.length;
i<l;i++){Sizzle(selector,root[i],tmpSet)}return Sizzle.filter(later,tmpSet)};jQuery.find=Sizzle;jQuery.filter=Sizzle.filter;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.filters;Sizzle.selectors.filters.hidden=function(elem){return elem.offsetWidth===0||elem.offsetHeight===0};Sizzle.selectors.filters.visible=function(elem){return elem.offsetWidth>0||elem.offsetHeight>0};Sizzle.selectors.filters.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem
}).length};jQuery.multiFilter=function(expr,elems,not){if(not){expr=":not("+expr+")"}return Sizzle.matches(expr,elems)};jQuery.dir=function(elem,dir){var matched=[],cur=elem[dir];while(cur&&cur!=document){if(cur.nodeType==1){matched.push(cur)}cur=cur[dir]}return matched};jQuery.nth=function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir]){if(cur.nodeType==1&&++num==result){break}}return cur};jQuery.sibling=function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType==1&&n!=elem){r.push(n)
}}return r};return ;window.Sizzle=Sizzle})();jQuery.event={add:function(elem,types,handler,data){if(elem.nodeType==3||elem.nodeType==8){return }if(elem.setInterval&&elem!=window){elem=window}if(!handler.guid){handler.guid=this.guid++}if(data!==undefined){var fn=handler;handler=this.proxy(fn);handler.data=data}var events=jQuery.data(elem,"events")||jQuery.data(elem,"events",{}),handle=jQuery.data(elem,"handle")||jQuery.data(elem,"handle",function(){return typeof jQuery!=="undefined"&&!jQuery.event.triggered?jQuery.event.handle.apply(arguments.callee.elem,arguments):undefined
});handle.elem=elem;jQuery.each(types.split(/\s+/),function(index,type){var namespaces=type.split(".");type=namespaces.shift();handler.type=namespaces.slice().sort().join(".");var handlers=events[type];if(jQuery.event.specialAll[type]){jQuery.event.specialAll[type].setup.call(elem,data,namespaces)}if(!handlers){handlers=events[type]={};if(!jQuery.event.special[type]||jQuery.event.special[type].setup.call(elem,data,namespaces)===false){if(elem.addEventListener){elem.addEventListener(type,handle,false)
}else{if(elem.attachEvent){elem.attachEvent("on"+type,handle)}}}}handlers[handler.guid]=handler;jQuery.event.global[type]=true});elem=null},guid:1,global:{},remove:function(elem,types,handler){if(elem.nodeType==3||elem.nodeType==8){return }var events=jQuery.data(elem,"events"),ret,index;if(events){if(types===undefined||(typeof types==="string"&&types.charAt(0)==".")){for(var type in events){this.remove(elem,type+(types||""))}}else{if(types.type){handler=types.handler;types=types.type}jQuery.each(types.split(/\s+/),function(index,type){var namespaces=type.split(".");
type=namespaces.shift();var namespace=RegExp("(^|\\.)"+namespaces.slice().sort().join(".*\\.")+"(\\.|$)");if(events[type]){if(handler){delete events[type][handler.guid]}else{for(var handle in events[type]){if(namespace.test(events[type][handle].type)){delete events[type][handle]}}}if(jQuery.event.specialAll[type]){jQuery.event.specialAll[type].teardown.call(elem,namespaces)}for(ret in events[type]){break}if(!ret){if(!jQuery.event.special[type]||jQuery.event.special[type].teardown.call(elem,namespaces)===false){if(elem.removeEventListener){elem.removeEventListener(type,jQuery.data(elem,"handle"),false)
}else{if(elem.detachEvent){elem.detachEvent("on"+type,jQuery.data(elem,"handle"))}}}ret=null;delete events[type]}}})}for(ret in events){break}if(!ret){var handle=jQuery.data(elem,"handle");if(handle){handle.elem=null}jQuery.removeData(elem,"events");jQuery.removeData(elem,"handle")}}},trigger:function(event,data,elem,bubbling){var type=event.type||event;if(!bubbling){event=typeof event==="object"?event[expando]?event:jQuery.extend(jQuery.Event(type),event):jQuery.Event(type);if(type.indexOf("!")>=0){event.type=type=type.slice(0,-1);
event.exclusive=true}if(!elem){event.stopPropagation();if(this.global[type]){jQuery.each(jQuery.cache,function(){if(this.events&&this.events[type]){jQuery.event.trigger(event,data,this.handle.elem)}})}}if(!elem||elem.nodeType==3||elem.nodeType==8){return undefined}event.result=undefined;event.target=elem;data=jQuery.makeArray(data);data.unshift(event)}event.currentTarget=elem;var handle=jQuery.data(elem,"handle");if(handle){handle.apply(elem,data)}if((!elem[type]||(jQuery.nodeName(elem,"a")&&type=="click"))&&elem["on"+type]&&elem["on"+type].apply(elem,data)===false){event.result=false
}if(!bubbling&&elem[type]&&!event.isDefaultPrevented()&&!(jQuery.nodeName(elem,"a")&&type=="click")){this.triggered=true;try{elem[type]()}catch(e){}}this.triggered=false;if(!event.isPropagationStopped()){var parent=elem.parentNode||elem.ownerDocument;if(parent){jQuery.event.trigger(event,data,parent,true)}}},handle:function(event){var all,handlers;event=arguments[0]=jQuery.event.fix(event||window.event);event.currentTarget=this;var namespaces=event.type.split(".");event.type=namespaces.shift();all=!namespaces.length&&!event.exclusive;
var namespace=RegExp("(^|\\.)"+namespaces.slice().sort().join(".*\\.")+"(\\.|$)");handlers=(jQuery.data(this,"events")||{})[event.type];for(var j in handlers){var handler=handlers[j];if(all||namespace.test(handler.type)){event.handler=handler;event.data=handler.data;var ret=handler.apply(this,arguments);if(ret!==undefined){event.result=ret;if(ret===false){event.preventDefault();event.stopPropagation()}}if(event.isImmediatePropagationStopped()){break}}}},props:"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),fix:function(event){if(event[expando]){return event
}var originalEvent=event;event=jQuery.Event(originalEvent);for(var i=this.props.length,prop;i;){prop=this.props[--i];event[prop]=originalEvent[prop]}if(!event.target){event.target=event.srcElement||document}if(event.target.nodeType==3){event.target=event.target.parentNode}if(!event.relatedTarget&&event.fromElement){event.relatedTarget=event.fromElement==event.target?event.toElement:event.fromElement}if(event.pageX==null&&event.clientX!=null){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc.clientLeft||0);
event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc.clientTop||0)}if(!event.which&&((event.charCode||event.charCode===0)?event.charCode:event.keyCode)){event.which=event.charCode||event.keyCode}if(!event.metaKey&&event.ctrlKey){event.metaKey=event.ctrlKey}if(!event.which&&event.button){event.which=(event.button&1?1:(event.button&2?3:(event.button&4?2:0)))}return event},proxy:function(fn,proxy){proxy=proxy||function(){return fn.apply(this,arguments)};proxy.guid=fn.guid=fn.guid||proxy.guid||this.guid++;
return proxy},special:{ready:{setup:bindReady,teardown:function(){}}},specialAll:{live:{setup:function(selector,namespaces){jQuery.event.add(this,namespaces[0],liveHandler)},teardown:function(namespaces){if(namespaces.length){var remove=0,name=RegExp("(^|\\.)"+namespaces[0]+"(\\.|$)");jQuery.each((jQuery.data(this,"events").live||{}),function(){if(name.test(this.type)){remove++}});if(remove<1){jQuery.event.remove(this,namespaces[0],liveHandler)}}}}}};jQuery.Event=function(src){if(!this.preventDefault){return new jQuery.Event(src)
}if(src&&src.type){this.originalEvent=src;this.type=src.type}else{this.type=src}this.timeStamp=now();this[expando]=true};function returnFalse(){return false}function returnTrue(){return true}jQuery.Event.prototype={preventDefault:function(){this.isDefaultPrevented=returnTrue;var e=this.originalEvent;if(!e){return }if(e.preventDefault){e.preventDefault()}e.returnValue=false},stopPropagation:function(){this.isPropagationStopped=returnTrue;var e=this.originalEvent;if(!e){return }if(e.stopPropagation){e.stopPropagation()
}e.cancelBubble=true},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue;this.stopPropagation()},isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse};var withinElement=function(event){var parent=event.relatedTarget;while(parent&&parent!=this){try{parent=parent.parentNode}catch(e){parent=this}}if(parent!=this){event.type=event.data;jQuery.event.handle.apply(this,arguments)}};jQuery.each({mouseover:"mouseenter",mouseout:"mouseleave"},function(orig,fix){jQuery.event.special[fix]={setup:function(){jQuery.event.add(this,orig,withinElement,fix)
},teardown:function(){jQuery.event.remove(this,orig,withinElement)}}});jQuery.fn.extend({bind:function(type,data,fn){return type=="unload"?this.one(type,data,fn):this.each(function(){jQuery.event.add(this,type,fn||data,fn&&data)})},one:function(type,data,fn){var one=jQuery.event.proxy(fn||data,function(event){jQuery(this).unbind(event,one);return(fn||data).apply(this,arguments)});return this.each(function(){jQuery.event.add(this,type,one,fn&&data)})},unbind:function(type,fn){return this.each(function(){jQuery.event.remove(this,type,fn)
})},trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this)})},triggerHandler:function(type,data){if(this[0]){var event=jQuery.Event(type);event.preventDefault();event.stopPropagation();jQuery.event.trigger(event,data,this[0]);return event.result}},toggle:function(fn){var args=arguments,i=1;while(i<args.length){jQuery.event.proxy(fn,args[i++])}return this.click(jQuery.event.proxy(fn,function(event){this.lastToggle=(this.lastToggle||0)%i;event.preventDefault();
return args[this.lastToggle++].apply(this,arguments)||false}))},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut)},ready:function(fn){bindReady();if(jQuery.isReady){fn.call(document,jQuery)}else{jQuery.readyList.push(fn)}return this},live:function(type,fn){var proxy=jQuery.event.proxy(fn);proxy.guid+=this.selector+type;jQuery(document).bind(liveConvert(type,this.selector),this.selector,proxy);return this},die:function(type,fn){jQuery(document).unbind(liveConvert(type,this.selector),fn?{guid:fn.guid+this.selector+type}:null);
return this}});function liveHandler(event){var check=RegExp("(^|\\.)"+event.type+"(\\.|$)"),stop=true,elems=[];jQuery.each(jQuery.data(this,"events").live||[],function(i,fn){if(check.test(fn.type)){var elem=jQuery(event.target).closest(fn.data)[0];if(elem){elems.push({elem:elem,fn:fn})}}});elems.sort(function(a,b){return jQuery.data(a.elem,"closest")-jQuery.data(b.elem,"closest")});jQuery.each(elems,function(){if(this.fn.call(this.elem,event,this.fn.data)===false){return(stop=false)}});return stop
}function liveConvert(type,selector){return["live",type,selector.replace(/\./g,"`").replace(/ /g,"|")].join(".")}jQuery.extend({isReady:false,readyList:[],ready:function(){if(!jQuery.isReady){jQuery.isReady=true;if(jQuery.readyList){jQuery.each(jQuery.readyList,function(){this.call(document,jQuery)});jQuery.readyList=null}jQuery(document).triggerHandler("ready")}}});var readyBound=false;function bindReady(){if(readyBound){return }readyBound=true;if(document.addEventListener){document.addEventListener("DOMContentLoaded",function(){document.removeEventListener("DOMContentLoaded",arguments.callee,false);
jQuery.ready()},false)}else{if(document.attachEvent){document.attachEvent("onreadystatechange",function(){if(document.readyState==="complete"){document.detachEvent("onreadystatechange",arguments.callee);jQuery.ready()}});if(document.documentElement.doScroll&&window==window.top){(function(){if(jQuery.isReady){return }try{document.documentElement.doScroll("left")}catch(error){setTimeout(arguments.callee,0);return }jQuery.ready()})()}}}jQuery.event.add(window,"load",jQuery.ready)}jQuery.each(("blur,focus,load,resize,scroll,unload,click,dblclick,mousedown,mouseup,mousemove,mouseover,mouseout,mouseenter,mouseleave,change,select,submit,keydown,keypress,keyup,error").split(","),function(i,name){jQuery.fn[name]=function(fn){return fn?this.bind(name,fn):this.trigger(name)
}});jQuery(window).bind("unload",function(){for(var id in jQuery.cache){if(id!=1&&jQuery.cache[id].handle){jQuery.event.remove(jQuery.cache[id].handle.elem)}}});(function(){jQuery.support={};var root=document.documentElement,script=document.createElement("script"),div=document.createElement("div"),id="script"+(new Date).getTime();div.style.display="none";div.innerHTML='   <link/><table></table><a href="/a" style="color:red;float:left;opacity:.5;">a</a><select><option>text</option></select>';var all=div.getElementsByTagName("*"),a=div.getElementsByTagName("a")[0];
if(!all||!all.length||!a){return }jQuery.support={leadingWhitespace:div.firstChild.nodeType==3,tbody:!div.getElementsByTagName("tbody").length,htmlSerialize:!!div.getElementsByTagName("link").length,style:/red/.test(a.getAttribute("style")),hrefNormalized:a.getAttribute("href")==="/a",opacity:a.style.opacity==="0.5",cssFloat:!!a.style.cssFloat,scriptEval:false,noCloneEvent:true,boxModel:null};script.type="text/javascript";try{script.appendChild(document.createTextNode("window."+id+"=1;"))}catch(e){}root.insertBefore(script,root.firstChild);
if(window[id]){jQuery.support.scriptEval=true;delete window[id]}root.removeChild(script);if(div.attachEvent&&div.fireEvent){div.attachEvent("onclick",function(){jQuery.support.noCloneEvent=false;div.detachEvent("onclick",arguments.callee)});div.cloneNode(true).fireEvent("onclick")}jQuery(function(){var div=document.createElement("div");div.style.width=div.style.paddingLeft="1px";document.body.appendChild(div);jQuery.boxModel=jQuery.support.boxModel=div.offsetWidth===2;document.body.removeChild(div).style.display="none"
})})();var styleFloat=jQuery.support.cssFloat?"cssFloat":"styleFloat";jQuery.props={"for":"htmlFor","class":"className","float":styleFloat,cssFloat:styleFloat,styleFloat:styleFloat,readonly:"readOnly",maxlength:"maxLength",cellspacing:"cellSpacing",rowspan:"rowSpan",tabindex:"tabIndex"};jQuery.fn.extend({_load:jQuery.fn.load,load:function(url,params,callback){if(typeof url!=="string"){return this._load(url)}var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off)
}var type="GET";if(params){if(jQuery.isFunction(params)){callback=params;params=null}else{if(typeof params==="object"){params=jQuery.param(params);type="POST"}}}var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(res,status){if(status=="success"||status=="notmodified"){self.html(selector?jQuery("<div/>").append(res.responseText.replace(/<script(.|\s)*?\/script>/g,"")).find(selector):res.responseText)}if(callback){self.each(callback,[res.responseText,status,res])
}}});return this},serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?jQuery.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||/select|textarea/i.test(this.nodeName)||/text|hidden|password|search/i.test(this.type))}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:jQuery.isArray(val)?jQuery.map(val,function(val,i){return{name:elem.name,value:val}
}):{name:elem.name,value:val}}).get()}});jQuery.each("ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend".split(","),function(i,o){jQuery.fn[o]=function(f){return this.bind(o,f)}});var jsc=now();jQuery.extend({get:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data=null}return jQuery.ajax({type:"GET",url:url,data:data,success:callback,dataType:type})},getScript:function(url,callback){return jQuery.get(url,null,callback,"script")},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")
},post:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data={}}return jQuery.ajax({type:"POST",url:url,data:data,success:callback,dataType:type})},ajaxSetup:function(settings){jQuery.extend(jQuery.ajaxSettings,settings)},ajaxSettings:{url:location.href,global:true,type:"GET",contentType:"application/x-www-form-urlencoded",processData:true,async:true,xhr:function(){return window.ActiveXObject?new ActiveXObject("Microsoft.XMLHTTP"):new XMLHttpRequest()},accepts:{xml:"application/xml, text/xml",html:"text/html",script:"text/javascript, application/javascript",json:"application/json, text/javascript",text:"text/plain",_default:"*/*"}},lastModified:{},ajax:function(s){s=jQuery.extend(true,s,jQuery.extend(true,{},jQuery.ajaxSettings,s));
var jsonp,jsre=/=\?(&|$)/g,status,data,type=s.type.toUpperCase();if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data)}if(s.dataType=="jsonp"){if(type=="GET"){if(!s.url.match(jsre)){s.url+=(s.url.match(/\?/)?"&":"?")+(s.jsonp||"callback")+"=?"}}else{if(!s.data||!s.data.match(jsre)){s.data=(s.data?s.data+"&":"")+(s.jsonp||"callback")+"=?"}}s.dataType="json"}if(s.dataType=="json"&&(s.data&&s.data.match(jsre)||s.url.match(jsre))){jsonp="jsonp"+jsc++;if(s.data){s.data=(s.data+"").replace(jsre,"="+jsonp+"$1")
}s.url=s.url.replace(jsre,"="+jsonp+"$1");s.dataType="script";window[jsonp]=function(tmp){data=tmp;success();complete();window[jsonp]=undefined;try{delete window[jsonp]}catch(e){}if(head){head.removeChild(script)}}}if(s.dataType=="script"&&s.cache==null){s.cache=false}if(s.cache===false&&type=="GET"){var ts=now();var ret=s.url.replace(/(\?|&)_=.*?(&|$)/,"$1_="+ts+"$2");s.url=ret+((ret==s.url)?(s.url.match(/\?/)?"&":"?")+"_="+ts:"")}if(s.data&&type=="GET"){s.url+=(s.url.match(/\?/)?"&":"?")+s.data;
s.data=null}if(s.global&&!jQuery.active++){jQuery.event.trigger("ajaxStart")}var parts=/^(\w+:)?\/\/([^\/?#]+)/.exec(s.url);if(s.dataType=="script"&&type=="GET"&&parts&&(parts[1]&&parts[1]!=location.protocol||parts[2]!=location.host)){var head=document.getElementsByTagName("head")[0];var script=document.createElement("script");script.src=s.url;if(s.scriptCharset){script.charset=s.scriptCharset}if(!jsonp){var done=false;script.onload=script.onreadystatechange=function(){if(!done&&(!this.readyState||this.readyState=="loaded"||this.readyState=="complete")){done=true;
success();complete();script.onload=script.onreadystatechange=null;head.removeChild(script)}}}head.appendChild(script);return undefined}var requestDone=false;var xhr=s.xhr();if(s.username){xhr.open(type,s.url,s.async,s.username,s.password)}else{xhr.open(type,s.url,s.async)}try{if(s.data){xhr.setRequestHeader("Content-Type",s.contentType)}if(s.ifModified){xhr.setRequestHeader("If-Modified-Since",jQuery.lastModified[s.url]||"Thu, 01 Jan 1970 00:00:00 GMT")}xhr.setRequestHeader("X-Requested-With","XMLHttpRequest");
xhr.setRequestHeader("Accept",s.dataType&&s.accepts[s.dataType]?s.accepts[s.dataType]+", */*":s.accepts._default)}catch(e){}if(s.beforeSend&&s.beforeSend(xhr,s)===false){if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}xhr.abort();return false}if(s.global){jQuery.event.trigger("ajaxSend",[xhr,s])}var onreadystatechange=function(isTimeout){if(xhr.readyState==0){if(ival){clearInterval(ival);ival=null;if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}}}else{if(!requestDone&&xhr&&(xhr.readyState==4||isTimeout=="timeout")){requestDone=true;
if(ival){clearInterval(ival);ival=null}status=isTimeout=="timeout"?"timeout":!jQuery.httpSuccess(xhr)?"error":s.ifModified&&jQuery.httpNotModified(xhr,s.url)?"notmodified":"success";if(status=="success"){try{data=jQuery.httpData(xhr,s.dataType,s)}catch(e){status="parsererror"}}if(status=="success"){var modRes;try{modRes=xhr.getResponseHeader("Last-Modified")}catch(e){}if(s.ifModified&&modRes){jQuery.lastModified[s.url]=modRes}if(!jsonp){success()}}else{jQuery.handleError(s,xhr,status)}complete();
if(isTimeout){xhr.abort()}if(s.async){xhr=null}}}};if(s.async){var ival=setInterval(onreadystatechange,13);if(s.timeout>0){setTimeout(function(){if(xhr&&!requestDone){onreadystatechange("timeout")}},s.timeout)}}try{xhr.send(s.data)}catch(e){jQuery.handleError(s,xhr,null,e)}if(!s.async){onreadystatechange()}function success(){if(s.success){s.success(data,status)}if(s.global){jQuery.event.trigger("ajaxSuccess",[xhr,s])}}function complete(){if(s.complete){s.complete(xhr,status)}if(s.global){jQuery.event.trigger("ajaxComplete",[xhr,s])
}if(s.global&&!--jQuery.active){jQuery.event.trigger("ajaxStop")}}return xhr},handleError:function(s,xhr,status,e){if(s.error){s.error(xhr,status,e)}if(s.global){jQuery.event.trigger("ajaxError",[xhr,s,e])}},active:0,httpSuccess:function(xhr){try{return !xhr.status&&location.protocol=="file:"||(xhr.status>=200&&xhr.status<300)||xhr.status==304||xhr.status==1223}catch(e){}return false},httpNotModified:function(xhr,url){try{var xhrRes=xhr.getResponseHeader("Last-Modified");return xhr.status==304||xhrRes==jQuery.lastModified[url]
}catch(e){}return false},httpData:function(xhr,type,s){var ct=xhr.getResponseHeader("content-type"),xml=type=="xml"||!type&&ct&&ct.indexOf("xml")>=0,data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.tagName=="parsererror"){throw"parsererror"}if(s&&s.dataFilter){data=s.dataFilter(data,type)}if(typeof data==="string"){if(type=="script"){jQuery.globalEval(data)}if(type=="json"){data=window["eval"]("("+data+")")}}return data},param:function(a){var s=[];function add(key,value){s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value)
}if(jQuery.isArray(a)||a.jquery){jQuery.each(a,function(){add(this.name,this.value)})}else{for(var j in a){if(jQuery.isArray(a[j])){jQuery.each(a[j],function(){add(j,this)})}else{add(j,jQuery.isFunction(a[j])?a[j]():a[j])}}}return s.join("&").replace(/%20/g,"+")}});var elemdisplay={},timerId,fxAttrs=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]];function genFx(type,num){var obj={};jQuery.each(fxAttrs.concat.apply([],fxAttrs.slice(0,num)),function(){obj[this]=type
});return obj}jQuery.fn.extend({show:function(speed,callback){if(speed){return this.animate(genFx("show",3),speed,callback)}else{for(var i=0,l=this.length;i<l;i++){var old=jQuery.data(this[i],"olddisplay");this[i].style.display=old||"";if(jQuery.css(this[i],"display")==="none"){var tagName=this[i].tagName,display;if(elemdisplay[tagName]){display=elemdisplay[tagName]}else{var elem=jQuery("<"+tagName+" />").appendTo("body");display=elem.css("display");if(display==="none"){display="block"}elem.remove();
elemdisplay[tagName]=display}jQuery.data(this[i],"olddisplay",display)}}for(var i=0,l=this.length;i<l;i++){this[i].style.display=jQuery.data(this[i],"olddisplay")||""}return this}},hide:function(speed,callback){if(speed){return this.animate(genFx("hide",3),speed,callback)}else{for(var i=0,l=this.length;i<l;i++){var old=jQuery.data(this[i],"olddisplay");if(!old&&old!=="none"){jQuery.data(this[i],"olddisplay",jQuery.css(this[i],"display"))}}for(var i=0,l=this.length;i<l;i++){this[i].style.display="none"
}return this}},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2){var bool=typeof fn==="boolean";return jQuery.isFunction(fn)&&jQuery.isFunction(fn2)?this._toggle.apply(this,arguments):fn==null||bool?this.each(function(){var state=bool?fn:jQuery(this).is(":hidden");jQuery(this)[state?"show":"hide"]()}):this.animate(genFx("toggle",3),fn,fn2)},fadeTo:function(speed,to,callback){return this.animate({opacity:to},speed,callback)},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);
return this[optall.queue===false?"each":"queue"](function(){var opt=jQuery.extend({},optall),p,hidden=this.nodeType==1&&jQuery(this).is(":hidden"),self=this;for(p in prop){if(prop[p]=="hide"&&hidden||prop[p]=="show"&&!hidden){return opt.complete.call(this)}if((p=="height"||p=="width")&&this.style){opt.display=jQuery.css(this,"display");opt.overflow=this.style.overflow}}if(opt.overflow!=null){this.style.overflow="hidden"}opt.curAnim=jQuery.extend({},prop);jQuery.each(prop,function(name,val){var e=new jQuery.fx(self,opt,name);
if(/toggle|show|hide/.test(val)){e[val=="toggle"?hidden?"show":"hide":val](prop)}else{var parts=val.toString().match(/^([+-]=)?([\d+-.]+)(.*)$/),start=e.cur(true)||0;if(parts){var end=parseFloat(parts[2]),unit=parts[3]||"px";if(unit!="px"){self.style[name]=(end||1)+unit;start=((end||1)/e.cur(true))*start;self.style[name]=start+unit}if(parts[1]){end=((parts[1]=="-="?-1:1)*end)+start}e.custom(start,end,unit)}else{e.custom(start,val,"")}}});return true})},stop:function(clearQueue,gotoEnd){var timers=jQuery.timers;
if(clearQueue){this.queue([])}this.each(function(){for(var i=timers.length-1;i>=0;i--){if(timers[i].elem==this){if(gotoEnd){timers[i](true)}timers.splice(i,1)}}});if(!gotoEnd){this.dequeue()}return this}});jQuery.each({slideDown:genFx("show",1),slideUp:genFx("hide",1),slideToggle:genFx("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"}},function(name,props){jQuery.fn[name]=function(speed,callback){return this.animate(props,speed,callback)}});jQuery.extend({speed:function(speed,easing,fn){var opt=typeof speed==="object"?speed:{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!jQuery.isFunction(easing)&&easing};
opt.duration=jQuery.fx.off?0:typeof opt.duration==="number"?opt.duration:jQuery.fx.speeds[opt.duration]||jQuery.fx.speeds._default;opt.old=opt.complete;opt.complete=function(){if(opt.queue!==false){jQuery(this).dequeue()}if(jQuery.isFunction(opt.old)){opt.old.call(this)}};return opt},easing:{linear:function(p,n,firstNum,diff){return firstNum+diff*p},swing:function(p,n,firstNum,diff){return((-Math.cos(p*Math.PI)/2)+0.5)*diff+firstNum}},timers:[],fx:function(elem,options,prop){this.options=options;
this.elem=elem;this.prop=prop;if(!options.orig){options.orig={}}}});jQuery.fx.prototype={update:function(){if(this.options.step){this.options.step.call(this.elem,this.now,this)}(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this);if((this.prop=="height"||this.prop=="width")&&this.elem.style){this.elem.style.display="block"}},cur:function(force){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null)){return this.elem[this.prop]}var r=parseFloat(jQuery.css(this.elem,this.prop,force));
return r&&r>-10000?r:parseFloat(jQuery.curCSS(this.elem,this.prop))||0},custom:function(from,to,unit){this.startTime=now();this.start=from;this.end=to;this.unit=unit||this.unit||"px";this.now=this.start;this.pos=this.state=0;var self=this;function t(gotoEnd){return self.step(gotoEnd)}t.elem=this.elem;if(t()&&jQuery.timers.push(t)&&!timerId){timerId=setInterval(function(){var timers=jQuery.timers;for(var i=0;i<timers.length;i++){if(!timers[i]()){timers.splice(i--,1)}}if(!timers.length){clearInterval(timerId);
timerId=undefined}},13)}},show:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.show=true;this.custom(this.prop=="width"||this.prop=="height"?1:0,this.cur());jQuery(this.elem).show()},hide:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.hide=true;this.custom(this.cur(),0)},step:function(gotoEnd){var t=now();if(gotoEnd||t>=this.options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();
this.options.curAnim[this.prop]=true;var done=true;for(var i in this.options.curAnim){if(this.options.curAnim[i]!==true){done=false}}if(done){if(this.options.display!=null){this.elem.style.overflow=this.options.overflow;this.elem.style.display=this.options.display;if(jQuery.css(this.elem,"display")=="none"){this.elem.style.display="block"}}if(this.options.hide){jQuery(this.elem).hide()}if(this.options.hide||this.options.show){for(var p in this.options.curAnim){jQuery.attr(this.elem.style,p,this.options.orig[p])
}}this.options.complete.call(this.elem)}return false}else{var n=t-this.startTime;this.state=n/this.options.duration;this.pos=jQuery.easing[this.options.easing||(jQuery.easing.swing?"swing":"linear")](this.state,n,0,1,this.options.duration);this.now=this.start+((this.end-this.start)*this.pos);this.update()}return true}};jQuery.extend(jQuery.fx,{speeds:{slow:600,fast:200,_default:400},step:{opacity:function(fx){jQuery.attr(fx.elem.style,"opacity",fx.now)},_default:function(fx){if(fx.elem.style&&fx.elem.style[fx.prop]!=null){fx.elem.style[fx.prop]=fx.now+fx.unit
}else{fx.elem[fx.prop]=fx.now}}}});if(document.documentElement.getBoundingClientRect){jQuery.fn.offset=function(){if(!this[0]){return{top:0,left:0}}if(this[0]===this[0].ownerDocument.body){return jQuery.offset.bodyOffset(this[0])}var box=this[0].getBoundingClientRect(),doc=this[0].ownerDocument,body=doc.body,docElem=doc.documentElement,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,top=box.top+(self.pageYOffset||jQuery.boxModel&&docElem.scrollTop||body.scrollTop)-clientTop,left=box.left+(self.pageXOffset||jQuery.boxModel&&docElem.scrollLeft||body.scrollLeft)-clientLeft;
return{top:top,left:left}}}else{jQuery.fn.offset=function(){if(!this[0]){return{top:0,left:0}}if(this[0]===this[0].ownerDocument.body){return jQuery.offset.bodyOffset(this[0])}jQuery.offset.initialized||jQuery.offset.initialize();var elem=this[0],offsetParent=elem.offsetParent,prevOffsetParent=elem,doc=elem.ownerDocument,computedStyle,docElem=doc.documentElement,body=doc.body,defaultView=doc.defaultView,prevComputedStyle=defaultView.getComputedStyle(elem,null),top=elem.offsetTop,left=elem.offsetLeft;
while((elem=elem.parentNode)&&elem!==body&&elem!==docElem){computedStyle=defaultView.getComputedStyle(elem,null);top-=elem.scrollTop,left-=elem.scrollLeft;if(elem===offsetParent){top+=elem.offsetTop,left+=elem.offsetLeft;if(jQuery.offset.doesNotAddBorder&&!(jQuery.offset.doesAddBorderForTableAndCells&&/^t(able|d|h)$/i.test(elem.tagName))){top+=parseInt(computedStyle.borderTopWidth,10)||0,left+=parseInt(computedStyle.borderLeftWidth,10)||0}prevOffsetParent=offsetParent,offsetParent=elem.offsetParent
}if(jQuery.offset.subtractsBorderForOverflowNotVisible&&computedStyle.overflow!=="visible"){top+=parseInt(computedStyle.borderTopWidth,10)||0,left+=parseInt(computedStyle.borderLeftWidth,10)||0}prevComputedStyle=computedStyle}if(prevComputedStyle.position==="relative"||prevComputedStyle.position==="static"){top+=body.offsetTop,left+=body.offsetLeft}if(prevComputedStyle.position==="fixed"){top+=Math.max(docElem.scrollTop,body.scrollTop),left+=Math.max(docElem.scrollLeft,body.scrollLeft)}return{top:top,left:left}
}}jQuery.offset={initialize:function(){if(this.initialized){return }var body=document.body,container=document.createElement("div"),innerDiv,checkDiv,table,td,rules,prop,bodyMarginTop=body.style.marginTop,html='<div style="position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;"><div></div></div><table style="position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;" cellpadding="0" cellspacing="0"><tr><td></td></tr></table>';
rules={position:"absolute",top:0,left:0,margin:0,border:0,width:"1px",height:"1px",visibility:"hidden"};for(prop in rules){container.style[prop]=rules[prop]}container.innerHTML=html;body.insertBefore(container,body.firstChild);innerDiv=container.firstChild,checkDiv=innerDiv.firstChild,td=innerDiv.nextSibling.firstChild.firstChild;this.doesNotAddBorder=(checkDiv.offsetTop!==5);this.doesAddBorderForTableAndCells=(td.offsetTop===5);innerDiv.style.overflow="hidden",innerDiv.style.position="relative";
this.subtractsBorderForOverflowNotVisible=(checkDiv.offsetTop===-5);body.style.marginTop="1px";this.doesNotIncludeMarginInBodyOffset=(body.offsetTop===0);body.style.marginTop=bodyMarginTop;body.removeChild(container);this.initialized=true},bodyOffset:function(body){jQuery.offset.initialized||jQuery.offset.initialize();var top=body.offsetTop,left=body.offsetLeft;if(jQuery.offset.doesNotIncludeMarginInBodyOffset){top+=parseInt(jQuery.curCSS(body,"marginTop",true),10)||0,left+=parseInt(jQuery.curCSS(body,"marginLeft",true),10)||0
}return{top:top,left:left}}};jQuery.fn.extend({position:function(){var left=0,top=0,results;if(this[0]){var offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=/^body|html$/i.test(offsetParent[0].tagName)?{top:0,left:0}:offsetParent.offset();offset.top-=num(this,"marginTop");offset.left-=num(this,"marginLeft");parentOffset.top+=num(offsetParent,"borderTopWidth");parentOffset.left+=num(offsetParent,"borderLeftWidth");results={top:offset.top-parentOffset.top,left:offset.left-parentOffset.left}
}return results},offsetParent:function(){var offsetParent=this[0].offsetParent||document.body;while(offsetParent&&(!/^body|html$/i.test(offsetParent.tagName)&&jQuery.css(offsetParent,"position")=="static")){offsetParent=offsetParent.offsetParent}return jQuery(offsetParent)}});jQuery.each(["Left","Top"],function(i,name){var method="scroll"+name;jQuery.fn[method]=function(val){if(!this[0]){return null}return val!==undefined?this.each(function(){this==window||this==document?window.scrollTo(!i?val:jQuery(window).scrollLeft(),i?val:jQuery(window).scrollTop()):this[method]=val
}):this[0]==window||this[0]==document?self[i?"pageYOffset":"pageXOffset"]||jQuery.boxModel&&document.documentElement[method]||document.body[method]:this[0][method]}});jQuery.each(["Height","Width"],function(i,name){var tl=i?"Left":"Top",br=i?"Right":"Bottom",lower=name.toLowerCase();jQuery.fn["inner"+name]=function(){return this[0]?jQuery.css(this[0],lower,false,"padding"):null};jQuery.fn["outer"+name]=function(margin){return this[0]?jQuery.css(this[0],lower,false,margin?"margin":"border"):null};
var type=name.toLowerCase();jQuery.fn[type]=function(size){return this[0]==window?document.compatMode=="CSS1Compat"&&document.documentElement["client"+name]||document.body["client"+name]:this[0]==document?Math.max(document.documentElement["client"+name],document.body["scroll"+name],document.documentElement["scroll"+name],document.body["offset"+name],document.documentElement["offset"+name]):size===undefined?(this.length?jQuery.css(this[0],type):null):this.css(type,typeof size==="string"?size:size+"px")
}})})();
/*
 * ibmCommon - ibm.com common JavaScript library
 * Copyright (c) 2009 IBM Corporation
 */
$j=jQuery.noConflict();jQuery.ajaxSetup({cache:true});String.prototype.normalizeSpace=function(){return this.replace(/\s+/g," ")};String.prototype.trim=function(){return this.replace(/^\s+/,"").replace(/\s+$/,"")};String.prototype.htmlspecialchars=function(){return this.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/'/g,"&#039;").replace(/"/g,"&quot;")};if(typeof ibmCommon!="object"||ibmCommon==null){ibmCommon={}
}if(typeof ibmCommon.meta!="object"||ibmCommon.meta==null){ibmCommon.meta={}}ibmCommon.meta.isLoaded=false;ibmCommon.meta.init=function(){var D=jQuery("head meta");for(var E=0,C=D.length;E<C;E++){var A=D.get(E);var B=A.httpEquiv||A.name;B=B.toLowerCase().replace(/[^\w]/g,"_");ibmCommon.meta[B]=jQuery(A).attr("content")}this.wwCase="";this.cc="";this.lc="";if(!!this.ibm_country){this.cc=this.ibm_country.toLowerCase().trim();if(this.cc.indexOf(",")>-1){this.cc=this.cc.substring(0,this.cc.indexOf(",")).trim()
}if(this.cc=="gb"){this.cc="uk"}if(this.cc=="zz"){this.cc="us";this.wwCase="Y"}}if(!!this.dc_language){this.lc=this.dc_language.substring(0,2).toLowerCase()}this.cpi=this.cc+this.lc;if(this.ibm_pageattributes==null){this.ibm_pageattributes=""}this.encoding="utf8";this.encodingRaw="UTF-8";if(this.content_type!=null){this.encodingRaw=this.content_type.substring(this.content_type.indexOf("=")+1);this.encoding=this.encodingRaw.replace("-","").replace("_","").toLowerCase()}ibmCommon.meta.isLoaded=true
};if(typeof ibmCommon.info!="object"||ibmCommon.info==null){ibmCommon.info={}}ibmCommon.info.isLoaded=false;ibmCommon.info.init=function(){this.isLenovo=this.v11=this.v14=this.v15=this.v16=false;this.lenovoVersion="";jQuery('link[rel^="style"]').each(function(){if(this.href.indexOf("//www.lenovo.com/common/v14/")!=-1){ibmCommon.info.lenovoversion="lenovo-think-v14"}else{if(this.href.indexOf("//www.lenovo.com/common/v15/")!=-1){ibmCommon.info.lenovoversion="lenovo-v15"}else{if(this.href.indexOf("//www.lenovo.com/common/v14/")!=-1){ibmCommon.info.lenovoversion="lenovo-v14"
}else{if(this.href.indexOf("/www.ibm.com/common/v16/")!=-1){ibmCommon.info.v16=true}else{if(this.href.indexOf("/www.ibm.com/common/v15/")!=-1){ibmCommon.info.v15=true}else{if(this.href.indexOf("/www.ibm.com/common/v14/")!=-1){ibmCommon.info.v14=true}else{if(this.href.indexOf("/www.ibm.com/data/css/v11/")!=-1){ibmCommon.info.v11=true}}}}}}}ibmCommon.info.isLenovo=ibmCommon.info.lenovoVersion!=""});var B="msie",F=navigator.userAgent.toLowerCase(),D=0;var C=F.indexOf(B);if(F.indexOf("opera")==-1&&C!=-1){this.isIE=true;
D=parseFloat(F.substring(C+B.length).replace(/^[^0-9]+/,""))}else{this.isIE=false}this.ieVersion=isNaN(D)?0:D;var G=[];this.isGecko=F.indexOf("gecko")!=-1&&F.indexOf("khtml")==-1;this.geckoVersion=0;if(this.isGecko){G=F.split("rv:");if(G.length>1){D=parseFloat(G[1])}this.geckoVersion=isNaN(D)?0:D}var H="opera";var E=F.indexOf(H);if(E==-1){this.isOldOpera=false}else{var A=parseFloat(F.substring(E+H.length));if(A<9){this.isOldOpera=true}else{this.isOldOpera=false}}this.isLinux=(navigator.userAgent.indexOf("Linux")>-1);
this.isDOM=(!!document.createElement&&!!document.createTextNode&&!!document.getElementById&&!!document.getElementsByTagName);ibmCommon.isDOM=ibmCommon.info.isDOM;ibmCommon.info.isLoaded=true};if(typeof ibmCommon.cookie!="object"||ibmCommon.cookie==null){ibmCommon.cookie={}}ibmCommon.cookie.set=function(B,D,A,F,C,E){var G=null;if(A){if(A.toUTCString){G=A}else{if(typeof (A)=="number"){G=new Date();G.setTime(G.getTime()+1000*parseInt(A))}}}document.cookie=B+"="+encodeURIComponent(D)+((G)?"; expires="+G.toUTCString():"")+((F)?"; path="+F:"")+((C)?"; domain="+C:"")+((E)?"; secure":"")
};ibmCommon.cookie.get=function(B){var F=document.cookie.split(";");for(var D=0,A=F.length;D<A;D++){var C=F[D].trim();var E=C.indexOf("=");if(E==-1){continue}if(C.substring(0,E)==B){return decodeURIComponent(C.substring(E+1))}}return null};ibmCommon.cookie.remove=function(A,D,C){var B=ibmCommon.cookie.get(A);if(B!=null){document.cookie=A+"="+((D)?"; path="+D:"")+((C)?"; domain="+C:"")+"; expires="+new Date(0).toUTCString()}return B};ibmCommon.cookie.allowed=function(A,F,D,E){var B="allowsCookies";
var C=Math.random();ibmCommon.cookie.set(B,C,((A)?A:""),((F)?F:""),((D)?D:""),((E)?E:""));if(ibmCommon.cookie.get(B)==C){ibmCommon.cookie.remove(B,F,D);return true}else{return false}};ibmCommon.cookie.supported=function(A){return ibmCommon.cookie.allowed(0,((A)?A:""))};if(typeof ibmCommon.queue!="object"||ibmCommon.queue==null){ibmCommon.queue={}}ibmCommon.queue._queue=[];ibmCommon.queue._timer=null;ibmCommon.queue._count=0;ibmCommon.queue._lock=false;ibmCommon.queue.push=function(B,A){ibmCommon.queue._count++;
ibmCommon.queue._queue.push([ibmCommon.queue._count,B,A]);ibmCommon.queue._work();return ibmCommon.queue._count};ibmCommon.queue.unshift=function(B,A){ibmCommon.queue._count++;ibmCommon.queue._queue.unshift([ibmCommon.queue._count,B,A]);ibmCommon.queue._work();return ibmCommon.queue._count};ibmCommon.queue.remove=function(C){for(var B=0,A=ibmCommon.queue._queue.length;B<A;B++){if(ibmCommon.queue._queue[B][0]==C){ibmCommon.queue._queue.splice(B,1);return true}}return false};ibmCommon.queue._work=function(){if(ibmCommon.queue._lock){return 
}if(ibmCommon.queue._queue.length==0){return }ibmCommon.queue._lock=true;for(var B=0,A=ibmCommon.queue._queue.length;B<A;B++){if(ibmCommon.queue._queue[B][1]()){ibmCommon.queue._queue[B][2]();ibmCommon.queue._queue.splice(B,1);B--;A=ibmCommon.queue._queue.length}}ibmCommon.queue._lock=false;ibmCommon.queue._timer=setTimeout(ibmCommon.queue._work,50)};ibmCommon.queue.waitForElement=function(C,E,D){if(jQuery.isReady&&typeof (D)!="undefined"&&D==true){E();return }var A=false;var B=ibmCommon.queue.push(function(){return document.getElementById(C)!=null
},function(){if(A){return }A=true;E()});if(typeof (D)!="undefined"&&D==true){jQuery(function(){if(A){return }A=true;ibmCommon.queue.remove(B);E()})}};ibmCommon.queue.waitForElement("ibm-top",function(){ibmCommon.meta.init()},true);ibmCommon.queue.waitForElement("ibm-top",function(){ibmCommon.info.init()},true);if(typeof (ibmCommon.callback)!="object"||ibmCommon.callback==null){ibmCommon.callback={}}ibmCommon.callback.__callbacks={};ibmCommon.callback.register=function(A,B){if(!!B&&!!A&&jQuery.isFunction(B)){if(jQuery.inArray(A,ibmCommon.callback.__callbacks)==-1){ibmCommon.callback.__callbacks[A]=[]
}ibmCommon.callback.__callbacks[A].push(B)}};ibmCommon.callback.call=function(A,D){if(!!A&&!!ibmCommon.callback.__callbacks[A]!=-1){for(var C=0,B=ibmCommon.callback.__callbacks[A].length;C<B;C++){ibmCommon.callback.__callbacks[A][C].call(null,D)}}};if(typeof (ibmCommon.data)!="object"||ibmCommon.data==null){ibmCommon.data={}}ibmCommon.data.settings={url:"//www.ibm.com/common/translations/{TOKEN}/{CC}/{LC}/{ENC}.js",cc:null,lc:null,enc:null};ibmCommon.data.require=function(C,G,F){if(!C){return }if(!jQuery.isArray(C)){C=[C]
}var E=true;for(var B=0,A=C.length;B<A;B++){E=E&&ibmCommon.data.exists(C[B])}if(!E){var D=jQuery.extend(D,ibmCommon.data.settings,F);ibmCommon.queue.push(function(){return ibmCommon.meta.isLoaded},function(){var H=function(L){var K=D.url.replace("{CC}",D.cc?D.cc:ibmCommon.meta.cc).replace("{LC}",D.lc?D.lc:ibmCommon.meta.lc).replace("{TOKEN}",L).replace("{ENC}",D.enc?D.enc:ibmCommon.meta.encoding);ibmCommon.getScript(K,ibmCommon.meta.encodingRaw)};for(var J=0,I=C.length;J<I;J++){if(!ibmCommon.data.exists(C[J])){H(C[J])
}}ibmCommon.queue.push(function(){var M=true;for(var L=0,K=C.length;L<K;L++){M=M&&ibmCommon.data.exists(C[L])}return M},function(){if(typeof (G)=="function"){G(ibmCommon.data)}})})}else{if(typeof (G)=="function"){G(ibmCommon.data)}}};ibmCommon.data.provide=function(A,B){ibmCommon.data[A]=B};ibmCommon.data.exists=function(A){return !!ibmCommon.data[A]};ibmCommon.init=function(){if(ibmCommon.info.v16&&!document.getElementById("ibm-print-masthead")){jQuery("#ibm-masthead").prepend('<img src="//www.ibm.com/i/v14/t/print-header.gif" width="510" height="32" id="ibm-print-masthead" />')
}if(ibmCommon.info.v15&&!document.getElementById("print-masthead")){jQuery("#ibm-masthead").prepend('<img src="//www.ibm.com/i/v15/t/print-header.gif" width="510" height="32" alt="" id="print-masthead" />')}if(ibmCommon.info.v15){jQuery("div#ibm-masthead").append('<a name="main"></a>')}};jQuery(ibmCommon.init);function ibmIsv16(){return ibmCommon.info.v16}function ibmSurveySelect(){var A=document.cookie;var D="ibmSurvey=";var C=A.indexOf(D);var B=new Date();if(C==-1||(C>0&&A.indexOf("; "+D)==-1)){if(window.location.href.indexOf(".ibm.com")>0){document.cookie=D+B.getTime().toString()+"; path=/; domain=.ibm.com"
}}}ibmSurveySelect();function ibmShareThis(B,A,E,D,C){return }ibmCommon.addScript=function(A,B){jQuery.getScript(A)};ibmCommon.getScript=function(A,B){if(!B){B="utf-8"}jQuery.ajax({url:A,scriptCharset:B,dataType:"script"})};ibmCommon.classNamesToArray=function(A){if(!A){throw"Invalid argument."}if(typeof A.className!="string"){return[]}return A.className.normalizeSpace().trim().split(" ")};ibmCommon.closeBody=function(){var A=ibmCommon.closeBodyFuncs.length;for(var B=0;B<A;B++){if(!ibmCommon.closeBodyFuncs[B].obj){ibmCommon.closeBodyFuncs[B].func(ibmCommon.closeBodyFuncs[B].args)
}else{ibmCommon.closeBodyFuncs[B].func.call(ibmCommon.closeBodyFuncs[B].obj,ibmCommon.closeBodyFuncs[B].args)}}};ibmCommon.deleteClassName=function(A,B){jQuery(A).removeClass(B)};ibmCommon.__idcount=0;ibmCommon.generateId=function(){var A;do{ibmCommon.__idcount++;A="gi-"+ibmCommon.__idcount}while(document.getElementById(A)!=null);return A};ibmCommon.getElementsInClass=function(A,B){return jQuery("."+B,A).get()};ibmCommon.getEventX=function(A){return(A.clientX+document.body.scrollLeft-document.body.clientLeft)||A.pageX
};ibmCommon.getEventY=function(A){return(A.clientY+document.body.scrollTop-document.body.clientTop)||A.pageY};ibmCommon.getX=function(B){var A=0;if(B.offsetParent){while(B.offsetParent){A+=B.offsetLeft;B=B.offsetParent}}else{if(B.x){A+=B.x}}return A};ibmCommon.getY=function(A){var B=0;if(A.offsetParent){while(A.offsetParent){B+=A.offsetTop;A=A.offsetParent}}else{if(A.y){B+=A.y}}return B};ibmCommon.inClass=function(A,B){return jQuery(A).hasClass(B)};ibmCommon.setCookie=function(A,B){ibmCommon.cookie.set(A,B)
};ibmCommon.getCookie=function(A){return ibmCommon.cookie.get(A)};ibmCommon.deleteCookie=function(A){return ibmCommon.cookie.remove(A)};ibmCommon.onload=function(){var A=ibmCommon.onloadFuncs.length;for(var B=0;B<A;B++){if(!ibmCommon.onloadFuncs[B].obj){ibmCommon.onloadFuncs[B].func(ibmCommon.onloadFuncs[B].args)}else{ibmCommon.onloadFuncs[B].func.call(ibmCommon.onloadFuncs[B].obj,ibmCommon.onloadFuncs[B].args)}}};ibmCommon.putCloseBodyFunction=function(C,B,A){ibmCommon.closeBodyFuncs[ibmCommon.closeBodyFuncs.length]={obj:C,func:B,args:A}
};ibmCommon.putOnloadFunction=function(C,B,A){ibmCommon.onloadFuncs[ibmCommon.onloadFuncs.length]={obj:C,func:B,args:A}};ibmCommon.setOnloadHandler=function(){if(typeof window.onload=="function"){ibmCommon.putOnloadFunction(null,window.onload,[])}jQuery(function(){ibmCommon.onload})};ibmCommon.initSimpleShowHide=function(B){var C=B instanceof jQuery?B:jQuery(B);if(!C.hasClass("ibm-simple-show-hide")){return }var A=jQuery("div.ibm-hideable",C).slideUp();jQuery("p.ibm-show-hide-controls",C).css("display","block").after('<div class="ibm-rule"><hr /></div>').find("a").click(function(){var D=jQuery(this);
D.parent().find("a").removeClass("ibm-active").end().end().addClass("ibm-active");if(D.attr("href")==="#show"){A.slideDown()}else{if(D.attr("href")==="#hide"){A.slideUp()}}return false})};ibmCommon.initShowHide=function(E){var H=E instanceof jQuery?E:jQuery(E);if(!H.hasClass("ibm-show-hide")){return }var B=null,C=jQuery("div.ibm-container-body",H),A=null,F=null,G=jQuery("> h2",H);if(G.length===1){A=jQuery(C[0]);jQuery(G[0]).find("a").attr("href","#show-hide").click(function(){var I=jQuery(this);if(I.hasClass("ibm-show-active")){A.slideUp();
I.removeClass("ibm-show-active")}else{A.slideDown();I.addClass("ibm-show-active")}return false});A.slideUp();return }for(var D=0;D<G.length;D++){A=jQuery(C[D]);F=jQuery(G[D]);B=F.find("a");B.attr("href","#show-hide");if(D===0){B.addClass("ibm-show-active")}else{F.css("border-top","none");A.slideUp()}B.bind("click",function(){var I,K;if(jQuery(this).hasClass("ibm-show-active")){return false}for(var J=0;J<G.length;J++){K=jQuery(C[J]);I=jQuery(G[J]).find("a");if(I.get(0)===this){I.addClass("ibm-show-active");
K.slideDown()}else{I.removeClass("ibm-show-active");K.slideUp()}}return false})}};jQuery(function(){jQuery("div.ibm-simple-show-hide").each(function(){ibmCommon.initSimpleShowHide(this)});jQuery("div.ibm-container.ibm-show-hide").each(function(){ibmCommon.initShowHide(this)})});ibmCommon.collapseTwisty=function(A){A.removeClass("ibm-active").find("> a.ibm-twisty-trigger").addClass("ibm-twisty-trigger-closed").find("img").attr("alt","+ Expand").end().end().find("> div.ibm-twisty-body").hide()};ibmCommon.initTwisty=function(B){var C=B instanceof jQuery?B:jQuery(B),A=C.find("> li");
if(!C.hasClass("ibm-twisty")){if(console.log){console.log("ul is not an ibm-twisty")}return }if(!A.hasClass("ibm-active")){ibmCommon.collapseTwisty(A)}A.find("a.ibm-twisty-trigger").click(ibmCommon.toggleTwisty)};ibmCommon.expandTwisty=function(A){A.addClass("ibm-active").find("> a.ibm-twisty-trigger").removeClass("ibm-twisty-trigger-closed").find("img").attr("alt","- Collapse").end().end().find("> div.ibm-twisty-body").show()};ibmCommon.toggleTwisty=function(){var A=jQuery(this).parent();if(A.hasClass("ibm-active")){ibmCommon.collapseTwisty(A)
}else{ibmCommon.expandTwisty(A)}return false};jQuery(function(){(new Image()).src="//www.ibm.com/i/v16/icons/tw_closed.gif";jQuery("ul.ibm-twisty").each(function(){ibmCommon.initTwisty(this)})});var IBMCommon=ibmCommon;if(typeof (encodeURIComponent)!="function"){encodeURIComponent=escape}if(typeof (decodeURIComponent)!="function"){decodeURIComponent=unescape}jQuery(function(){if(ibmCommon.meta.encoding!="utf8"){jQuery('#ibm-search-form input[name="en"][value="utf"]').remove()}});if(typeof (window.external)=="object"&&window.external&&typeof (window.external.AddSearchProvider)!="undefined"&&String(window.location.hostname).indexOf(".ibm.com")!=-1){jQuery("<link />").attr({rel:"search",type:"application/opensearchdescription+xml",href:"http://www.ibm.com/search/opensearch/description.xml",title:"IBM Search"}).appendTo("head")
}if(String(window.location.href).toLowerCase().indexOf("www.ibm.com/search/")>=0||String(window.location.href).toLowerCase().indexOf("wwwstage.ibm.com/search/")>=0){jQuery.ajax({url:"//www.ibm.com/search/addons/search.js",dataType:"script",cache:true,scriptCharset:"utf-8"})}if(typeof (sa_onclick)=="undefined"){sa_onclick=function(B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){sa_onclick(B,A)})}}if(typeof (ibmCreateShop5Tag)=="undefined"){ibmCreateShop5Tag=function(E,D,C,B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"
},function(){ibmCreateShop5Tag(E,D,C,B,A)})}}if(typeof (ibmCreateProductViewTag)=="undefined"){ibmCreateProductViewTag=function(C,B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmCreateProductViewTag(C,B,A)})}}if(typeof (ibmCreatePageViewTag)=="undefined"){ibmCreatePageViewTag=function(B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmCreatePageViewTag(B,A)})}}if(typeof (ibmCreateRegistrationTag)=="undefined"){ibmCreateRegistrationTag=function(G,F,E,D,C,B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"
},function(){ibmCreateRegistrationTag(G,F,E,D,C,B,A)})}}if(typeof (ibmDisplayShop5s)=="undefined"){ibmDisplayShop5s=function(){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmDisplayShop5s()})}}if(typeof (ibmCreateShop9Tag)=="undefined"){ibmCreateShop9Tag=function(H,G,F,E,D,C,B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmCreateShop9Tag(H,G,F,E,D,C,B,A)})}}if(typeof (cmCreatePageElementTag)=="undefined"){cmCreatePageElementTag=function(){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"
},function(){cmCreatePageElementTag()})}}if(typeof (ibmDisplayShop9s)=="undefined"){ibmDisplayShop9s=function(){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmDisplayShop9s()})}}if(typeof (ibmCreateOrderTag)=="undefined"){ibmCreateOrderTag=function(G,F,E,D,C,B,A){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"},function(){ibmCreateOrderTag(G,F,E,D,C,B,A)})}}if(typeof (ibmCreateFlashPageviewTag)=="undefined"){ibmCreateFlashPageviewTag=function(){ibmCommon.queue.push(function(){return typeof (sa_ver)!="undefined"
},function(){ibmCreateFlashPageviewTag()})}}var ibmStats=ibmStats||{};if(!ibmStats.event){ibmStats.event=function(A){ibmCommon.queue.push(function(){return !!ibmStats.loaded},function(){ibmStats.event(A)})}}IBMCreateShop5Tag=cmCreateShop5Tag=IBMDisplayShop5s=cmDisplayShop5s=IBMCreateShop9Tag=cmCreateShop9Tag=IBMDisplayShop9s=cmDisplayShop9s=IBMCreateOrderTag=cmCreateOrderTag=IBMCreateRegistrationTag=cmCreateRegistrationTag=IBMCreatePageViewTag=cmCreatePageViewTag=cmCreateConversionEventTag=ibmCreateFlashPageviewTag=sa_onclick=function(){return true
};ibmCommon.initAltRowShading=function(A){(A instanceof jQuery?A:jQuery(A)).find("tbody tr.ibm-alt-row").removeClass("ibm-alt-row").end().find("tbody tr:odd").addClass("ibm-alt-row")};ibmCommon.initSortableTable=function(B){if(typeof jQuery.tablesorter==="undefined"){setTimeout(function(){ibmCommon.initSortableTable(B)},400);return }var A={cssAsc:"ibm-sort-up",cssDesc:"ibm-sort-down",cssHeader:"ibm-sort",headers:[]};jQuery.tablesorter.addParser({id:"ibmdate",is:function(C){return false},format:function(C){return Date.parse(jQuery.trim(C))
},type:"numeric"});(B instanceof jQuery?B:jQuery(B)).find("thead tr:first > th").each(function(D){var E=jQuery(this),C;if(!E.hasClass("ibm-sort")){A.headers[D]={sorter:false}}else{if(E.find("a").length<1){C=E.text();E.empty().append('<a href="#sort"><span>'+C+'</span><span class="ibm-icon">&nbsp;</span></a>')}if(E.hasClass("ibm-date")){A.headers[D]={sorter:"ibmdate"}}}}).end().tablesorter(A).bind("sortEnd",function(){if(jQuery(this).hasClass("ibm-alternating")){ibmCommon.initAltRowShading(B)}})};
jQuery(function(){if(jQuery.browser.msie&&parseInt(jQuery.browser.version,10)<7){jQuery("table.ibm-data-table tbody tr").hover(function(){jQuery(this).addClass("ibm-highlight-row")},function(){jQuery(this).removeClass("ibm-highlight-row")})}jQuery("table.ibm-alternating").each(function(){if(jQuery("tbody tr.ibm-alt-row",this).length>0){return }ibmCommon.initAltRowShading(this)});var A=jQuery("table.ibm-sortable-table");if(A.length>0){jQuery.ajax({url:"//www.ibm.com/common/js/jquery.tablesorter.js",dataType:"script",cache:true,success:function(){for(var C=0,B=A.length;
C<B;C++){ibmCommon.initSortableTable(A[C])}}})}});jQuery(document).ready(function(){if(jQuery("a.ibm-leaving-prompt").length>0&&(typeof (ibmCommon.leavingIbm)!="object"||ibmCommon.leavingIbm==null)){jQuery.getScript("//www.ibm.com/common/js/leaving-ibm.js")}});jQuery(function(){if(jQuery(".ibm-tooltip").length>0||jQuery(".ibm-tooltip-html").length>0){jQuery.getScript("//www.ibm.com/common/js/tooltip.js")}});if(document.cookie.indexOf("ipcInfo=")==-1&&document.cookie.indexOf("lenovoPrefs=")!=-1&&!!window&&!!window.location&&String(window.location.hostname).toLowerCase().indexOf("ibm.com")!=-1){document.cookie="ipcInfo="+escape("cc=;lc=")+"; path=/; domain=.ibm.com";
if(document.cookie.indexOf("ipcInfo=")!=-1){if(typeof ibmCommonCookie=="undefined"){document.write("<scr",'ipt type="text/javascript" src="//www.ibm.com/common/cookie/cookie.js"></scr',"ipt>")}document.write("<scr",'ipt type="text/javascript" src="//www.ibm.com/common/ocaiset.js"></scr',"ipt>")}}if(typeof ibmDynNav!="object"||ibmDynNav==null){ibmDynNav={}}if(typeof ibmDynNav.share!="object"||ibmDynNav.share==null){ibmDynNav.share={register:function(B,A){A=true;ibmCommon.queue.push(function(){return typeof (PMM)=="object"&&!!PMM.footerToolData
},function(){if(!B){B=jQuery(".ibm-share-this")}else{B=(B instanceof jQuery?B:jQuery(B))}if(B.length==0){return }var C=ibmDynNav.share.createList(A);B.hover(function(){jQuery(this).addClass("ibm-active")},function(){jQuery(this).removeClass("ibm-active")});B.each(function(){if(jQuery(this).children().length==0){C.clone(true).appendTo(this)}}).show()})},registerRightNav:function(){jQuery("#ibm-content-sidebar").prepend('<div id="ibm-social-tools-sidebar" class="ibm-share-this"></div>');ibmDynNav.share.register("#ibm-social-tools-sidebar",true)
},createList:function(I){var F=jQuery("<ul></ul>");var C=ibmDynNav.share.getUrl();var H=jQuery("title").text();var G=ibmCommonDynamicNavIgnService("1007");for(var E=0,D=PMM.footerToolData.length;E<D;E++){var J=PMM.footerToolData[E];if(J.id=="print"){if(!I){continue}F.append(ibmDynNav.share.getPTPLink(J));continue}if(J.id=="email"){F.append(ibmDynNav.share.getETPLink(J));continue}if(!G){continue}if(!J.url){continue}var A=J.url.replace(/%\{URL\}/g,encodeURIComponent(C)).replace(/%\{TITLE\}/g,encodeURIComponent(H));
var B=jQuery("<a></a>").addClass("ibm-share-"+J.id).attr({title:J.title,href:A,rel:J.id}).click(ibmDynNav.share.clickHandler).wrap("<li></li>").parent().appendTo(F)}F.find("a").mousedown(function(){jQuery(this).addClass("ibm-share-active-"+this.rel)}).mouseleave(function(){jQuery(this).removeClass("ibm-share-active-"+this.rel)});return F},clickHandler:function(){ibmStats.event({ibmEV:"external link",ibmEvAction:this.href,ibmEvGroup:"SBS icons",ibmEvName:"sbs-"+this.rel,ibmEvLinkTitle:jQuery("title").text()});
return true},getUrl:function(){var C=jQuery("link[rel=canonical]").attr("href");if(!!C){return C}C=location.href;if(C.indexOf("?")!=-1){var F=C.substr(0,C.indexOf("?"));var G=C.substr(C.indexOf("?")+1).split("&");var E=/^(cm_re|ca|me|met|re)=/;var B=[];for(var D=0,A=G.length;D<A;D++){if(!E.test(G[D])){B.push(G[D])}}C=F+"?"+B.join("&")}return C},getETPLink:function(A){if(ibmCommonDynamicNavIgnService("110")){return jQuery("<a></a>").addClass("ibm-share-email").attr({title:A.title,href:"#",rel:"email"}).click(function(B){ibmDynNav.share.clickHandler.call(this,B);
displayFormLayer(B,2);return false}).wrap("<li></li>").parent()}return null},getPTPLink:function(A){if(ibmCommonDynamicNavIgnService("1001")){return jQuery("<a></a>").addClass("ibm-share-print").attr({title:A.title,href:"#",rel:"print"}).click(function(B){ibmDynNav.share.clickHandler.call(this,B);javascript:print();return false}).wrap("<li></li>").parent()}return null}}}jQuery(function(){ibmDynNav.share.register()});jQuery(function(){ibmCommon.cookie.remove("CoreID6","/",".ibm.com");ibmCommon.cookie.remove("cmTPSet","/",".ibm.com");
ibmCommon.cookie.remove("sauidp","/",".ibm.com")});