/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Aixdump;
import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import com.ibm.jvm.j9.dump.systemdump.Elfdump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.PageCache;
import com.ibm.jvm.j9.dump.systemdump.StackFrame;
import com.ibm.jvm.j9.dump.systemdump.Windump;
import com.ibm.jvm.j9.dump.systemdump.ZOSdump;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public abstract class Dump
implements DumpFile {
    protected boolean bIs32Bit = true;
    protected static int systemType;
    protected static boolean bIsLittleEndian;
    protected String dumpName;
    protected long dumpTime;
    protected int processorCount;
    protected String processorType;
    protected String processorSubType;
    protected String systemSubType;
    protected String size;
    protected String endian;
    protected J9AddressSpace[] addressSpaces;
    protected int currentAS = 0;
    protected J9Jvm currentJvm;
    private String stamp;
    private String version;
    private String shortVersion;
    private int intVersion;
    private String arch;
    private long memory = 0L;
    private long environ;
    private Properties envVars;
    private final DumpFile delegate;
    private String uuid;
    protected String fullversion = "<unknown>";
    protected int prevMemRange = -1;
    protected long pmrStartAddr = 0L;
    protected long pmrSize = 0L;
    protected MemoryRange[] sortedMemoryRanges;
    protected PageCache memoryPages;
    protected long filesize;
    public static final int IS_EXECUTEABLE_FLAG = 1;
    public static final int IS_READONLY_FLAG = 2;
    public static final int IS_SHARED_FLAG = 4;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WINDOWS = 1;
    public static final int TYPE_LINUX = 2;
    public static final int TYPE_ZOS = 3;
    public static final int TYPE_AIX = 4;
    public static final int FILE_EXISTS = 1;
    public static final int FILE_READABLE = 2;
    public static final int DUMP_SUPPORTED = 4;
    private static final String[] types;
    private static final String[][] subTypes;

    protected void initialize() {
        try {
            this.filesize = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.memoryPages = this instanceof Windump ? new PageCache(8, 262144, 0.5, 0.1) : new PageCache();
    }

    protected Dump(DumpFile file) throws FileNotFoundException {
        this.delegate = file;
        this.initialize();
    }

    public final String getSystemTypeAsString(int i) {
        return types[i];
    }

    protected static int compareAddress(long lhs, long rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs >= 0L && rhs >= 0L || lhs < 0L && rhs < 0L) {
            return lhs < rhs ? -1 : 1;
        }
        return lhs < rhs ? 1 : -1;
    }

    protected abstract MemoryRange[] getRawMemoryRanges();

    protected void refreshMemoryRanges() {
        this.sortedMemoryRanges = null;
    }

    public MemoryRange[] getMemoryRanges() {
        if (this.sortedMemoryRanges == null) {
            this.sortedMemoryRanges = this.getRawMemoryRanges();
            if (null == this.sortedMemoryRanges) {
                System.err.println("No raw memory ranges found in core.  The core is likely truncated or otherwise incomplete.");
                this.sortedMemoryRanges = new MemoryRange[0];
            } else {
                Arrays.sort(this.sortedMemoryRanges);
            }
        }
        return this.sortedMemoryRanges;
    }

    public byte[] getMemoryBytes(long vaddr, int size) {
        PageCache.Page page;
        int key = this.findWhichMemoryRange(vaddr);
        if (key < 0) {
            return null;
        }
        byte[] buf = null;
        PageCache.Page page2 = page = this.memoryPages != null ? this.memoryPages.find(key, vaddr, size) : null;
        if (page != null) {
            byte[] raw;
            if (page.isEmpty() && (raw = this.getRawMemoryBytes(vaddr, this.memoryPages.pageSize)) != null) {
                page.push(key, vaddr, raw);
            }
            buf = page.pull(key, vaddr, size);
        }
        if (buf == null) {
            buf = this.getRawMemoryBytes(vaddr, size);
        }
        return buf;
    }

    protected byte[] getRawMemoryBytes(long vaddr, int size) {
        byte[] buf = null;
        try {
            long available = this.seekToMemoryAddress(vaddr);
            if (available < (long)size) {
                size = (int)available;
            }
            if (size < 0) {
                return null;
            }
            buf = new byte[size];
            this.readFully(buf, 0, size);
            return buf;
        }
        catch (IOException ioe) {
            return buf;
        }
    }

    public long seekToMemoryAddress(long vaddr) {
        int range = this.findWhichMemoryRange(vaddr);
        if (range >= 0) {
            try {
                MemoryRange owningRange = this.sortedMemoryRanges[range];
                long howFarIn = vaddr - owningRange.getVaddr();
                long startOfMR = owningRange.getFileoffset();
                long sizeOfMR = owningRange.getSize();
                long seekPos = startOfMR + howFarIn;
                if (seekPos > this.filesize) {
                    return 0L;
                }
                this.seek(seekPos);
                long available = sizeOfMR - howFarIn;
                if (this.filesize - seekPos < available) {
                    available = this.filesize - seekPos;
                }
                return available;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0L;
    }

    public int findWhichMemoryRange(long addr) {
        int retI = -1;
        MemoryRange[] memoryRanges = this.getMemoryRanges();
        if (null != memoryRanges) {
            long mraStartAddr;
            if (this.prevMemRange != -1 && Dump.compareAddress(addr, this.pmrStartAddr) >= 0 && Dump.compareAddress(addr, this.pmrStartAddr + this.pmrSize) < 0) {
                return this.prevMemRange;
            }
            int highpos = memoryRanges.length - 1;
            int lowpos = 0;
            while (lowpos <= highpos) {
                int currentPos = lowpos + (highpos - lowpos >>> 1);
                mraStartAddr = memoryRanges[currentPos].getVaddr();
                if (Dump.compareAddress(addr, mraStartAddr) >= 0) {
                    if (Dump.compareAddress(addr, mraStartAddr + memoryRanges[currentPos].getSize()) < 0) {
                        retI = currentPos;
                        break;
                    }
                    lowpos = currentPos + 1;
                    continue;
                }
                highpos = currentPos - 1;
            }
            if (-1 == retI) {
                for (int i = 0; i < lowpos; ++i) {
                    mraStartAddr = memoryRanges[i].getVaddr();
                    if (Dump.compareAddress(addr, mraStartAddr) < 0 || Dump.compareAddress(addr, mraStartAddr + memoryRanges[i].getSize()) >= 0) continue;
                    retI = i;
                    break;
                }
            }
        }
        if (-1 != retI) {
            this.prevMemRange = retI;
            this.pmrStartAddr = memoryRanges[retI].getVaddr();
            this.pmrSize = memoryRanges[retI].getSize();
        }
        return retI;
    }

    public int findWhichMemoryRange(long addr, int asid) {
        int retI = -1;
        MemoryRange[] memoryRanges = this.getMemoryRanges();
        if (null != memoryRanges) {
            for (int i = 0; i < memoryRanges.length; ++i) {
                if (memoryRanges[i].getAsid() != asid) continue;
                long mraStartAddr = memoryRanges[i].getVaddr();
                if (Dump.compareAddress(addr, mraStartAddr) >= 0) {
                    if (Dump.compareAddress(addr, mraStartAddr + memoryRanges[i].getSize()) >= 0) continue;
                    retI = i;
                    i = memoryRanges.length;
                    continue;
                }
                return -1;
            }
        }
        return retI;
    }

    public long findBytes(byte[] whatBytes, int boundary) {
        long retLong = -1L;
        retLong = this.findPattern(whatBytes, boundary, 0L);
        return retLong;
    }

    public long findPattern(byte[] whatBytes, int boundary, long startFrom) {
        long retLong = -1L;
        Vector v = DumpUtils.findInMemory(this, whatBytes, startFrom, -1L, boundary, 1, false);
        if (0 != v.size()) {
            retLong = (Long)v.get(0);
        }
        return retLong;
    }

    public static int dumpStat(String fileName) {
        return Aixdump.dumpStat(fileName) | Elfdump.dumpStat(fileName) | ZOSdump.dumpStat(fileName) | Windump.dumpStat(fileName);
    }

    private static boolean isSupportedDump(int flags) {
        return (flags & 4) != 0;
    }

    public static Dump getDump(String fileName) throws FileNotFoundException {
        if (Dump.isSupportedDump(Aixdump.dumpStat(fileName))) {
            return new Aixdump(fileName);
        }
        if (Dump.isSupportedDump(Elfdump.dumpStat(fileName))) {
            return new Elfdump(fileName);
        }
        if (Dump.isSupportedDump(ZOSdump.dumpStat(fileName))) {
            return new ZOSdump(fileName);
        }
        if (Dump.isSupportedDump(Windump.dumpStat(fileName))) {
            return new Windump(fileName);
        }
        return null;
    }

    public boolean is32bit() {
        return this.bIs32Bit;
    }

    public boolean is64bit() {
        return !this.is32bit();
    }

    public boolean isLittleEndian() {
        return bIsLittleEndian;
    }

    public long readPtr(byte[] bArray, int offset) throws IOException {
        int lenToRead = 8;
        if (this.bIs32Bit) {
            lenToRead = 4;
        }
        long[] ia = new long[8];
        for (int i = 0; i < lenToRead; ++i) {
            ia[i] = bArray[offset + i];
            ia[i] = ia[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return ia[0] + (ia[1] << 8) + (ia[2] << 16) + (ia[3] << 24) + (ia[4] << 32) + (ia[5] << 40) + (ia[6] << 48) + (ia[7] << 56);
        }
        return ia[7] + (ia[6] << 8) + (ia[5] << 16) + (ia[4] << 24) + (ia[3] << 32) + (ia[2] << 40) + (ia[1] << 48) + (ia[0] << 56);
    }

    public long readPtr() throws IOException {
        long retPtr = -1L;
        retPtr = this.bIs32Bit ? (long)this.readIntEx() & 0xFFFFFFFFL : this.readLongEx();
        return retPtr;
    }

    public long readPtr(long addr) throws IOException {
        long retPtr = -1L;
        if (this.seekToMemoryAddress(addr) > 0L) {
            if (this.bIs32Bit) {
                retPtr = (long)this.readIntEx() & 0xFFFFFFFFL;
            }
            retPtr = this.readLongEx();
        } else {
            throw new IOException("jformat: seek to memory address failed");
        }
        return retPtr;
    }

    public int getSystemType() {
        return systemType;
    }

    public void setSystemType(int i) {
        systemType = i;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Operating System : " + this.getSystemTypeAsString(systemType));
        sb.append("\nArchitecture     : ");
        if (this.is32bit()) {
            sb.append("32bit - ");
        } else {
            sb.append("64bit - ");
        }
        if (this.isLittleEndian()) {
            sb.append("Little Endian");
        } else {
            sb.append("Big Endian");
        }
        sb.append("\nSystem Memory    : " + this.getMemory());
        sb.append("\nJVM Version      : " + this.version);
        sb.append("\nBuild Level      : " + this.stamp);
        sb.append("\nUuid             : " + this.uuid);
        sb.append("\n\n" + this.fullversion);
        return sb.toString();
    }

    public void setStamp(String stampIn) {
        this.stamp = stampIn;
    }

    public void setVersion(String versionIn) {
        this.version = versionIn;
    }

    public void setUuid(String uuidIn) {
        this.uuid = uuidIn;
    }

    public String getStamp() {
        return this.stamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        StringBuffer sb = new StringBuffer("J2RE IBM J9 ");
        if (this.version != null) {
            sb.append(this.version.trim());
        }
        if (this.arch != null) {
            sb.append(" ");
            sb.append(this.arch);
        }
        if (this.size != null) {
            sb.append("-");
            sb.append(this.size);
        }
        if (this.stamp != null) {
            sb.append(" build " + this.stamp);
        }
        return sb.toString();
    }

    public void setFullVersion(String fullversionIn) {
        this.fullversion = fullversionIn;
    }

    public String getFullVersion() {
        return this.fullversion;
    }

    public void set32Bit(boolean is32Bit) {
        this.bIs32Bit = is32Bit;
    }

    public static void setLittleEndian(boolean isLittleEndian) {
        bIsLittleEndian = isLittleEndian;
    }

    public String getDumpName() {
        return this.delegate.getDumpName();
    }

    public long readLongEx() throws IOException {
        long retLong = this.readLong();
        if (bIsLittleEndian) {
            retLong = DumpUtils.convertEndian(retLong);
        }
        return retLong;
    }

    public int readIntEx() throws IOException {
        int retInt = this.readInt();
        if (bIsLittleEndian) {
            retInt = DumpUtils.convertEndian(retInt);
        }
        return retInt;
    }

    public short readShortEx() throws IOException {
        short retShort = this.readShort();
        if (bIsLittleEndian) {
            retShort = DumpUtils.convertEndian(retShort);
        }
        return retShort;
    }

    public void readFullyEx(byte[] b) throws IOException {
        this.readFully(b);
    }

    public int readEx(byte[] b) throws IOException {
        return this.read(b);
    }

    public int readEx(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len);
    }

    public long getDumpTime() {
        return this.dumpTime;
    }

    public long getInstalledMemory() {
        return this.memory;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public String getProcessorSubType() {
        return this.processorSubType;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public String getSystemSubType() {
        return this.systemSubType;
    }

    public int getCurrentAS() {
        return this.currentAS;
    }

    public String getCurrentASName() {
        return this.addressSpaces[this.currentAS].getAddressSpaceName();
    }

    public void setCurrentAS(int currentAS) {
        this.currentAS = currentAS;
    }

    public int getAddressSpaceCount() {
        return this.addressSpaces.length;
    }

    public J9AddressSpace getAddressSpace(int i) {
        return this.addressSpaces[i];
    }

    public int getSREFlags(long addr, int asid) {
        int index = this.findWhichMemoryRange(addr, asid);
        if (-1 != index) {
            MemoryRange[] memoryRanges = this.getMemoryRanges();
            int flags = 0;
            if (memoryRanges[index].isExecutable()) {
                ++flags;
            }
            if (memoryRanges[index].isReadOnly()) {
                flags += 2;
            }
            if (memoryRanges[index].isShared()) {
                flags += 4;
            }
            return flags;
        }
        return -1;
    }

    public void setProcessorCount(int processorCount) {
        this.processorCount = processorCount;
    }

    public String getShortVersion() {
        return this.shortVersion;
    }

    public void setShortVersion(String shortVersion) {
        this.shortVersion = shortVersion;
        float floatversion = 0.0f;
        try {
            floatversion = Float.parseFloat(shortVersion);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.intVersion = (int)(floatversion * 10.0f);
    }

    public int getIntVersion() {
        return this.intVersion;
    }

    public J9Jvm getCurrentJvm() {
        return this.currentJvm;
    }

    public void setCurrentJvm(J9Jvm currentJvm) {
        this.currentJvm = currentJvm;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public static Vector findDebugFiles(String name, Dump core, boolean createModules) {
        if (core instanceof Elfdump) {
            return Elfdump.findDebugFiles(name, core, createModules);
        }
        if (core instanceof Windump) {
            return Windump.findDebugFiles(name, core, createModules);
        }
        if (core instanceof Aixdump) {
            return Aixdump.findDebugFiles(name, core, false);
        }
        return null;
    }

    public String readString() throws IOException {
        int i;
        int size = 512;
        byte[] b = new byte[size];
        for (i = 0; i < size; ++i) {
            b[i] = this.readByte();
            if (b[i] == 0) break;
        }
        return new String(b, 0, i);
    }

    public String getMemory() {
        String memoryString = this.memory == 0L ? "<unknown>" : this.memory + " Mb";
        return memoryString;
    }

    public void setMemory(String memoryIn) {
        this.memory = null == memoryIn ? 0L : Long.parseLong(memoryIn);
    }

    public long getEnviron() {
        return this.environ;
    }

    public void setEnviron(String environString) {
        if (null != environString) {
            try {
                this.environ = Long.parseLong(DumpUtils.stripOff0x(environString), 16);
            }
            catch (NumberFormatException nfe) {
                this.environ = 0L;
            }
        } else {
            this.environ = 0L;
        }
    }

    public Properties getEnvVars() {
        if (this.envVars == null) {
            this.envVars = new Properties();
            if (this.environ != 0L) {
                long addr;
                boolean bFinished = false;
                Vector<Long> v = new Vector<Long>();
                if (-1L == this.seekToMemoryAddress(this.environ)) {
                    bFinished = true;
                } else {
                    try {
                        addr = this.readPtr();
                        if (-1L == this.seekToMemoryAddress(addr)) {
                            bFinished = true;
                        }
                    }
                    catch (IOException ioe) {
                        bFinished = true;
                    }
                }
                while (!bFinished && v.size() < 1024) {
                    try {
                        addr = this.readPtr();
                        if (addr == 0L) {
                            bFinished = true;
                            continue;
                        }
                        v.add(new Long(addr));
                    }
                    catch (IOException ioe) {
                        bFinished = true;
                    }
                }
                for (int i = 0; i < v.size(); ++i) {
                    int eqPosition;
                    long addr2 = (Long)v.get(i);
                    byte[] b = this.getMemoryBytes(addr2, 256);
                    String s = "";
                    if (b != null) {
                        int firstNull = b.length;
                        for (int j = 0; j < b.length; ++j) {
                            if (b[j] != 0) continue;
                            firstNull = j;
                            j = b.length;
                        }
                        s = new String(b, 0, firstNull);
                    }
                    if ((eqPosition = s.indexOf("=")) <= 0) continue;
                    String key = s.substring(0, eqPosition);
                    String value = s.substring(eqPosition + 1);
                    this.envVars.put(key, value);
                }
            } else {
                this.envVars = null;
            }
        }
        return this.envVars;
    }

    protected void analyseStack(GenericThread gt) {
        Vector frames = new Vector();
        long sp = 0L;
        long bp = 0L;
        long pc = 0L;
        try {
            sp = gt.context.getSp();
            bp = gt.context.getBp();
            pc = gt.context.getPc();
        }
        catch (Exception e) {
            return;
        }
        if (pc == 0L || -1 == this.findWhichMemoryRange(pc)) {
            pc = gt.context.getLr();
        }
        if (pc != 0L && bp != 0L && -1 != this.findWhichMemoryRange(pc)) {
            boolean frameCount = false;
            long start = gt.getStackstart();
            long size = gt.getStacksize();
            StackFrame f = new StackFrame(bp, pc);
            gt.addNativeFrame(f);
            this.seekToMemoryAddress(bp);
            try {
                while (bp < start + size && bp > start) {
                    bp = this.readPtr();
                    pc = this.readPtr();
                    f = new StackFrame(bp, pc);
                    gt.addNativeFrame(f);
                    this.seekToMemoryAddress(bp);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void setProcessorSubType(String processorSubType) {
        this.processorSubType = processorSubType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public void setSystemSubType(String systemSubType) {
        this.systemSubType = systemSubType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getEndian() {
        return this.endian;
    }

    public void setEndian(String endian) {
        this.endian = endian;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.delegate.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.delegate.readFully(b);
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public long readLong() throws IOException {
        return this.delegate.readLong();
    }

    public short readShort() throws IOException {
        return this.delegate.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.readUnsignedByte();
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        return this.delegate.read(b, offset, length);
    }

    public int read(byte[] buf) throws IOException {
        return this.delegate.read(buf);
    }

    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    public long getFilePointer() throws IOException {
        return this.delegate.getFilePointer();
    }

    static {
        types = new String[]{"unknown", "Windows", "Linux", "zOS", "AIX"};
        subTypes = new String[][]{{"unknown"}, {"Windows unknown", "Windows XP", "Windows 2000", "Windows ME", "Windows NT", "Windows 95", "Windows 98"}, {"Linux ia32", "ZOS64", "ZOS32"}, {"AIX51", "AIX52"}};
    }
}

