/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleUtils;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.ZipHandler;
import com.ibm.jvm.j9.dump.saxhandler.GenericSaxHandler;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Module;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.J9Thread;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;

public class DumpBaseCmds
extends CommandPlugin {
    private Observer observer;
    private DumpBaseCmds mySelf = this;
    private Command[] myCommands;
    private Command[] commandsPostSetDump;
    private static Dump theDump;
    private static GenericThread currentThread;
    private static ZipHandler zh;
    private static String zipDir;

    public DumpBaseCmds() {
        int numCommands = 1;
        this.myCommands = new Command[numCommands];
        this.myCommands[0] = new Command("set", "dump", this.mySelf, false, false, false, "Identifies the dump to work with");
        this.commandsPostSetDump = new Command[]{new Command("dis", "mmap", this.mySelf, true, false, false, "Displays the virtual address ranges within the dump"), new Command("dis", "mem", this.mySelf, true, false, false, "Formats and displays portions of memory"), new Command("dis", "sys", this.mySelf, true, false, false, "Displays build and version info for the JVM"), new Command("dis", "ptr", this.mySelf, true, false, false, "Displays the value at an address as a pointer"), new Command("dis", "long", this.mySelf, true, false, false, "Displays the value at an address as a long (8 bytes)"), new Command("dis", "int", this.mySelf, true, false, false, "Displays the value at an address as an int (4 bytes)"), new Command("find", "*", this.mySelf, true, false, false, "Find a string in memory"), new Command("findptr", "*", this.mySelf, true, false, false, "Find a pointer in memory"), new Command("findnext", "*", this.mySelf, true, false, false, "Repeat previous find command"), new Command("whatis", "*", this.mySelf, true, false, false, "Attempt to identify where an address "), new Command("+", "*", this.mySelf, true, false, false, "Scroll forwards through memory"), new Command("-", "*", this.mySelf, true, false, false, "Scroll backwards through memory"), new Command("set", "as", this.mySelf, true, false, false, "Set current AddressSpace"), new Command("set", "proc", this.mySelf, true, false, false, "Set current Process within AddressSpace"), new Command("dis", "proc", this.mySelf, true, false, false, "Display details on current process"), new Command("dis", "thread", this.mySelf, true, false, false, "Display thread details"), new Command("set", "thread", this.mySelf, true, false, false, "Set the current thread"), new Command("dis", "rs", this.mySelf, true, false, false, "Display raw stack for native threads"), new Command("dis", "sym", this.mySelf, true, false, false, "Display all known symbols"), new Command("dis", "ns", this.mySelf, true, false, false, "Display native stack for thread")};
    }

    public String go(String input, String origInput) {
        String retString = null;
        CommandDetails cd = new CommandDetails(input);
        String verb = cd.getVerb();
        String noun = cd.getNoun();
        if (verb.equals("SET") && noun.equals("DUMP")) {
            retString = this.doSetDump(cd.getRest());
        }
        if (verb.equals("SET") && noun.equals("AS")) {
            retString = this.doSetAS(cd.getRest());
        }
        if (verb.equals("SET") && noun.equals("PROC")) {
            retString = this.doSetProc(cd.getRest());
        }
        if (null == theDump) {
            theDump = DumpConsole.getTheDump();
        }
        if (null != theDump) {
            if (verb.equals("DIS") && noun.equals("MMAP")) {
                retString = this.doMemMap();
            } else if (verb.equals("DIS") && noun.equals("MEM")) {
                retString = this.doDisplayMem(cd.getRest());
            } else if (verb.equals("DIS") && noun.equals("SYS")) {
                retString = this.doDisplaySys();
            } else if (verb.equals("DIS") && noun.equals("PROC")) {
                retString = this.doDisProc();
            } else if (verb.equals("DIS") && noun.equals("THREAD")) {
                retString = this.doDisplayThread(cd.getRest());
            } else if (verb.equals("DIS") && noun.equals("NS")) {
                retString = this.doDisplayNativeStack(cd.getRest());
            } else if (verb.equals("DIS") && noun.equals("RS")) {
                retString = this.doRawStack();
            } else if (verb.equals("DIS") && noun.equals("SYM")) {
                retString = this.doDisSym();
            } else if (verb.equals("SET") && noun.equals("THREAD")) {
                retString = this.doSetThread(cd.getRest());
            } else if (verb.equals("FIND")) {
                retString = this.goFind("FIND", noun, cd, origInput);
            } else if (verb.equals("FINDNEXT")) {
                retString = this.doFindNext();
            } else if (verb.equals("FINDPTR")) {
                retString = this.doFindPtr(noun, cd);
            } else if (verb.equals("DIS") && (noun.equals("PTR") || noun.equals("INT") || noun.equals("LONG"))) {
                retString = this.doDisplayPIL(cd.getRest(), noun);
            } else if (verb.equals("WHATIS")) {
                retString = this.doWhatis(noun);
            } else if (verb.equals("+") || verb.equals("-")) {
                retString = this.doPlusMinus(verb);
            }
        }
        return retString;
    }

    public String cleanUp() {
        if (theDump != null) {
            try {
                theDump.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException when closing Dump file. /n" + ioe);
            }
        }
        if (zh != null) {
            zh.close();
        }
        if (zipDir != null) {
            boolean bAllGone = true;
            File tempDir = new File(zipDir);
            File[] filesToDelete = tempDir.listFiles();
            if (filesToDelete != null) {
                int length = filesToDelete.length;
                for (int i = 0; i < length; ++i) {
                    bAllGone = bAllGone && filesToDelete[i].delete();
                }
            }
            boolean bl = bAllGone = bAllGone && tempDir.delete();
            if (bAllGone) {
                return null;
            }
            return zipDir;
        }
        return null;
    }

    private String goFind(String verb, String noun, CommandDetails cd, String origInput) {
        String retString = null;
        StringTokenizer st = new StringTokenizer(origInput, " ,");
        String realNoun = null;
        if (st.countTokens() > 1) {
            st.nextToken();
            realNoun = st.nextToken();
        }
        if (realNoun == null) {
            retString = this.doFindHelp();
            return retString;
        }
        boolean quoted = false;
        if (realNoun.startsWith("\"")) {
            int commaPos;
            int firstQuote = origInput.indexOf("\"");
            int lastQuote = origInput.lastIndexOf("\"");
            if (lastQuote != firstQuote) {
                quoted = true;
                int len = origInput.length();
                if (len > lastQuote + 1) {
                    if (origInput.substring(lastQuote + 1, lastQuote + 2).equals(",")) {
                        realNoun = origInput.substring(firstQuote + 1, lastQuote);
                        cd.setRest(origInput.substring(lastQuote + 2));
                    }
                } else if (len == lastQuote + 1) {
                    realNoun = origInput.substring(firstQuote + 1, lastQuote);
                    cd.setRest(null);
                }
            }
            if ((-1 == lastQuote || lastQuote == firstQuote) && -1 != (commaPos = origInput.indexOf(","))) {
                cd.setRest(origInput.substring(commaPos));
            }
        } else {
            int commaPos = origInput.indexOf(",");
            if (-1 != commaPos) {
                cd.setRest(origInput.substring(commaPos));
            }
        }
        retString = this.findInMemory(verb, realNoun, cd.getRest(), quoted);
        return retString;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doSetAS(String name) {
        String retString = "Not yet supported";
        if (theDump.getAddressSpaceCount() <= 1) {
            retString = "Only 1 address space (" + theDump.getCurrentASName() + ")";
        }
        return retString;
    }

    private String doSetProc(String name) {
        return "Not yet supported";
    }

    private String doDisProc() {
        String retString = null;
        StringBuffer sb = new StringBuffer();
        sb.append("\nProcess Information\n===================\n");
        sb.append("Architecture: ");
        Dump theDump = DumpConsole.getTheDump();
        if (theDump.is32bit()) {
            sb.append("32bit - ");
        } else {
            sb.append("64bit - ");
        }
        if (theDump.isLittleEndian()) {
            sb.append("Little Endian\n");
        } else {
            sb.append("Big Endian\n");
        }
        J9Jvm jvm = theDump.getCurrentJvm();
        if (jvm != null) {
            for (int i = 0; i < jvm.getThreads().size(); ++i) {
                GenericThread t = (GenericThread)jvm.getThreads().get(i);
                sb.append("\n Thread: " + t.getThreadId() + "   Thread name: " + t.getThreadName());
            }
        } else {
            sb.append("\n No known java threads");
        }
        int asIndex = theDump.getCurrentAS();
        J9AddressSpace as = theDump.getAddressSpace(asIndex);
        int procIndex = as.getCurrentProcess();
        J9Process proc = as.getProcess(procIndex);
        sb.append("\n\nCommandLine = " + proc.getCmdLine());
        if (null != GenericSaxHandler.getGpfSb()) {
            sb.append("\n\nGPF details\n===============\n");
            sb.append(GenericSaxHandler.getGpfSb());
        }
        sb.append("\n\nEnvironment Variables\n=====================\n\n");
        Properties p = theDump.getEnvVars();
        if (p == null) {
            sb.append("  Data Unavailable\n");
        } else {
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append("\t" + key + "=" + p.get(key) + "\n");
            }
        }
        sb.append("\n\nLoaded Information\n==================\n");
        J9Module[] loaded = proc.getLoadedInfo();
        if (null == loaded) {
            sb.append("\n\nNO LOADED DATA AVAILABLE\n\n");
        } else {
            for (int i = 0; i < loaded.length; ++i) {
                sb.append("\n\t" + loaded[i].getName());
                sb.append("\n\t\t at 0x" + Long.toHexString(loaded[i].getStartAddress()));
                long size = loaded[i].getSize();
                sb.append("  length=" + size + "(0x" + Long.toHexString(size) + ")");
            }
        }
        this.notifyObservers(sb.toString());
        return retString;
    }

    private String doSetDump(String name) {
        String retString = null;
        Dump theDump = DumpConsole.getTheDump();
        if (theDump != null) {
            return "Set dump has already been done";
        }
        try {
            if (zh != null) {
                zh.close();
            }
            DumpConsole.setInputFilePath(name);
            if (name.indexOf(".zip") >= 0) {
                File zipFile = new File(name);
                zh = new ZipHandler(zipFile, null, null);
                name = zh.openAndProcessZipFile();
                zipDir = zh.getTempDirName();
                this.notifyObservers("\nCompressed files extracted into temporary folder at:  " + zipDir + "\n");
            }
            int stat = Dump.dumpStat(name);
            theDump = Dump.getDump(name);
            if ((4 & stat) == 0) {
                retString = (1 & stat) == 0 ? "\"" + name + "\" does not exist" : ((2 & stat) == 0 ? "\"" + name + "\" exists but is not readable" : "\"" + name + "\" exists and is readable, but is not recognised as a valid dump");
            } else if (theDump == null) {
                retString = "Dump exists, is readable and is supported, but cannot be parsed for reasons unknown.";
            } else {
                retString = "  Input file recognised as a ";
                retString = theDump.is32bit() ? retString + "32-bit " : retString + "64-bit ";
                retString = theDump.isLittleEndian() ? retString + "little-endian " : retString + "big-endian ";
                retString = retString + theDump.getSystemTypeAsString(theDump.getSystemType()) + " dump.";
                this.notifyObservers(retString);
                retString = null;
                DumpConsole.setTheDump(theDump);
                Vector loadedLibraries = Dump.findDebugFiles(null, theDump, false);
                if (loadedLibraries == null || loadedLibraries.size() == 0) {
                    this.notifyObservers(" Unable to establish loaded libraries.....");
                }
                DumpConsole.addInAdditionalCommands(this.commandsPostSetDump, this);
                String xmlFileName = theDump.getDumpName() + ".xml";
                File xmlFile = new File(xmlFileName);
                if (xmlFile.exists()) {
                    String input = "SET METADATA " + xmlFileName;
                    this.notifyObservers(" Issuing \"" + input + "\"");
                    int pos = Console.findVerbNounCombo(input);
                    if (-1 != pos) {
                        String out = Console.doCommand(pos, input, null);
                        if (null != out) {
                            this.notifyObservers("\n " + out);
                        }
                    } else {
                        Console.reportError("Unable to find \"SET METADATA\" as a command", null);
                    }
                } else {
                    this.notifyObservers(" Unable to find \"" + xmlFileName + "\" ..... set metadata will need to be entered manually");
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            String workdir = Console.getProperty("WORKDIR");
            retString = null != workdir && !name.startsWith(workdir) ? this.doSetDump(workdir + File.separator + name) : "File \"" + name + "\" not found";
        }
        catch (ZipException ze) {
            this.notifyObservers("Zip Exception when creating ZipHandler object." + ze);
        }
        catch (IOException ioe) {
            this.notifyObservers("IO Exception when creating ZipHandler object." + ioe);
        }
        return retString;
    }

    private String doFindNext() {
        String retString = null;
        String findnext = Console.getProperty("FINDNEXT");
        if (null == findnext) {
            retString = "No previous find has been done";
        } else {
            this.notifyObservers("issuing FIND " + findnext);
            Console.handleInput("FIND " + findnext, false);
        }
        return retString;
    }

    private String doFindPtr(String noun, CommandDetails cd) {
        String retString = null;
        if (noun == null) {
            this.notifyObservers("No parameter specified - ");
            String helpString = Console.getHelp("FINDPTR");
            this.notifyObservers(helpString);
            return retString;
        }
        String trueNoun = DumpUtils.stripOff0x(noun);
        boolean bInError = false;
        for (int i = 0; i < trueNoun.length(); ++i) {
            int digit = ConsoleUtils.hexValue(trueNoun.charAt(i));
            if (digit != -1) continue;
            bInError = true;
        }
        if (bInError) {
            this.notifyObservers("\nInvalid hex value in input: 0x" + trueNoun + "\n");
        } else {
            int i;
            int len = trueNoun.length();
            if (theDump.is32bit()) {
                if (len > 8) {
                    this.notifyObservers("\nPointer is too long (max 8 hex characters!\n");
                    return retString;
                }
                if (len < 8) {
                    for (i = 0; i < 8 - len; ++i) {
                        trueNoun = "0" + trueNoun;
                    }
                }
            } else {
                if (len > 16) {
                    this.notifyObservers("\nPointer is too long (max 16 hex characters!\n");
                    return retString;
                }
                if (len < 16) {
                    for (i = 0; i < 16 - len; ++i) {
                        trueNoun = "0" + trueNoun;
                    }
                }
            }
            if (theDump.isLittleEndian()) {
                if (theDump.is32bit()) {
                    String temp = trueNoun.substring(6, 8) + trueNoun.substring(4, 6) + trueNoun.substring(2, 4) + trueNoun.substring(0, 2);
                    trueNoun = "0x" + temp;
                } else {
                    String temp = trueNoun.substring(14, 16) + trueNoun.substring(12, 14) + trueNoun.substring(10, 12) + trueNoun.substring(8, 10) + trueNoun.substring(6, 8) + trueNoun.substring(4, 6) + trueNoun.substring(2, 4) + trueNoun.substring(0, 2);
                    trueNoun = "0x" + temp;
                }
                retString = this.findInMemory("FINDPTR", trueNoun, cd.getRest(), false);
            }
        }
        return retString;
    }

    private String doDisSym() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\nSymbols (address followed by name)....");
        Iterator it = Symbol.getSymbolsIterator();
        while (it.hasNext()) {
            Long o = (Long)it.next();
            Symbol s = Symbol.getSymbolUsingValue(o);
            sb.append("\n\t0x" + Long.toHexString(o) + "\t" + s.getSymbolName());
            if (sb.length() <= 2000) continue;
            this.notifyObservers(sb.toString());
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            this.notifyObservers(sb.toString());
        }
        return "\n\nSymbol display finished";
    }

    private String doRawStack() {
        Object retString = null;
        int ptrsize = 8;
        if (J9JVMConsole.getTheDump().is32bit()) {
            ptrsize = 4;
        }
        J9Process currentProcess = null;
        J9AddressSpace currentAs = theDump.getAddressSpace(theDump.getCurrentAS());
        if (currentAs != null) {
            currentProcess = currentAs.getProcess(currentAs.getCurrentProcess());
        }
        if (currentProcess != null) {
            Iterator it = currentProcess.getThreads();
            while (it.hasNext()) {
                GenericThread gt = (GenericThread)it.next();
                boolean doDisplay = false;
                long start = gt.getStackstart();
                int size = gt.getStacksize();
                StringBuffer sb = new StringBuffer();
                if (start != 0L && size != 0) {
                    sb.append("\n\n Thread id: " + gt.getThreadId() + " Stack Start: 0x" + Long.toHexString(start) + " Size: 0x" + Integer.toHexString(size) + "\n");
                    NativeThreadContext ntc = gt.getContext();
                    if (ntc != null) {
                        String symbol = null;
                        long addr = 0L;
                        addr = ntc.getBp();
                        sb.append("\n\tBack Pointer(bp equiv): 0x" + Long.toHexString(addr));
                        if (addr != 0L && null != (symbol = Symbol.getSymbolForAddress(addr))) {
                            sb.append("  " + symbol);
                        }
                        addr = ntc.getPc();
                        sb.append("\n\tProgram Counter(pc equiv): 0x" + Long.toHexString(addr));
                        if (addr != 0L && null != (symbol = Symbol.getSymbolForAddress(addr))) {
                            sb.append("  " + symbol);
                        }
                        addr = ntc.getSp();
                        sb.append("\n\tStack Pointer(sp equiv): 0x" + Long.toHexString(addr));
                        if (addr != 0L && null != (symbol = Symbol.getSymbolForAddress(addr))) {
                            sb.append("  " + symbol);
                        }
                    } else {
                        sb.append("  !!! No native thread context found !!!");
                    }
                    try {
                        theDump.seekToMemoryAddress(start);
                        long lTemp = 0L;
                        int iTemp = 0;
                        for (int i = 0; i < size; i += ptrsize) {
                            String symbol;
                            if (ptrsize == 4) {
                                iTemp = theDump.readIntEx();
                                sb.append("\n\t0x" + Long.toHexString(start + (long)i) + "\t" + DumpUtils.padToPtrSize(Integer.toHexString(iTemp)));
                                if ((long)iTemp >= start && (long)iTemp <= start + (long)size) {
                                    sb.append("  *");
                                    int diff = iTemp - ((int)start + i);
                                    if (start + (long)i <= (long)iTemp) {
                                        sb.append("+ 0x" + Integer.toHexString(diff));
                                    } else {
                                        sb.append("- 0x" + Integer.toHexString(-diff));
                                    }
                                }
                                if (null != (symbol = Symbol.getSymbolForAddress(iTemp)) && iTemp != 0) {
                                    sb.append(" " + symbol);
                                }
                            } else {
                                lTemp = theDump.readLongEx();
                                sb.append("\n\t0x" + Long.toHexString(start + (long)i) + "\t" + DumpUtils.padToPtrSize(Long.toHexString(lTemp)));
                                if (lTemp >= start && lTemp <= start + (long)size) {
                                    sb.append("  *");
                                    int diff = (int)(lTemp - (long)((int)start + i));
                                    if (start + (long)i <= lTemp) {
                                        sb.append("+ 0x" + Integer.toHexString(diff));
                                    } else {
                                        sb.append("- 0x" + Integer.toHexString(-diff));
                                    }
                                }
                                if (null != (symbol = Symbol.getSymbolForAddress(lTemp)) && lTemp != 0L) {
                                    sb.append(" " + symbol);
                                }
                            }
                            if (sb.length() <= 2048) continue;
                            this.notifyObservers(sb.toString());
                            sb.setLength(0);
                        }
                    }
                    catch (Exception e) {
                        sb.append("\n Exception whilst traversing stack\n");
                    }
                }
                if (sb.length() <= 0) continue;
                this.notifyObservers(sb.toString());
            }
        }
        return " dis rs finished";
    }

    private String doMemMap() {
        String retString = null;
        MemoryRange[] mra = theDump.getMemoryRanges();
        if (null != mra) {
            this.notifyObservers("\nMemory Map\n==========");
            for (int i = 0; i < mra.length; ++i) {
                if (null == mra[i] || mra[i].getSize() == 0L) continue;
                this.notifyObservers(mra[i].toString());
            }
        }
        return retString;
    }

    private String doDisplayPIL(String whatMem, String noun) {
        String retString;
        block11: {
            retString = null;
            String address = new String(whatMem);
            if (address.startsWith("@") && null == (address = DumpUtils.chainViaPtr(address, theDump.isLittleEndian()))) {
                retString = "Error - Invalid pointer using @ in " + whatMem;
            }
            if (retString == null) {
                if (ConsoleUtils.verifyAsHex(address = DumpUtils.stripOff0x(address))) {
                    try {
                        long lAddress = DumpUtils.parseLongHex(address);
                        Dump theDump = DumpConsole.getTheDump();
                        long lVal = 0L;
                        if (theDump.seekToMemoryAddress(lAddress) > 0L) {
                            try {
                                if (noun.equals("INT")) {
                                    lVal = DumpUtils.convertEndian(theDump.readIntEx());
                                    retString = lVal + " (0x" + Long.toHexString(lVal) + ")";
                                    break block11;
                                }
                                if (noun.equals("LONG")) {
                                    lVal = DumpUtils.convertEndian(theDump.readLongEx());
                                    retString = lVal + " (0x" + Long.toHexString(lVal) + ")";
                                    break block11;
                                }
                                lVal = theDump.readPtr(lAddress);
                                retString = " 0x" + Long.toHexString(lVal);
                            }
                            catch (IOException ioe) {}
                            break block11;
                        }
                        retString = "Error address not found in dump - 0x" + Long.toHexString(lAddress);
                    }
                    catch (NumberFormatException nfe) {
                        retString = "Error - was expecting valid hex and not " + whatMem;
                    }
                } else {
                    retString = "Error - was expecting valid hex and not " + whatMem;
                }
            }
        }
        return retString;
    }

    private String doDisplayMem(String whatMem) {
        String retString;
        block14: {
            retString = null;
            Vector inParms = new Vector();
            inParms = ConsoleUtils.breakUpInput(whatMem, ",. ");
            if (inParms.size() == 1) {
                inParms.add("256");
            }
            if (inParms.size() != 0) {
                String address = (String)inParms.get(0);
                String origAddress = new String(address);
                if (address.startsWith("@") && null == (address = DumpUtils.chainViaPtr(address, theDump.isLittleEndian()))) {
                    retString = "Error - Invalid pointer using @ in " + origAddress;
                }
                address = DumpUtils.stripOff0x(address);
                String size = (String)inParms.get(1);
                if (ConsoleUtils.verifyAsHex(address)) {
                    if (!ConsoleUtils.verifyAsPositiveNumber(size)) {
                        retString = "Error - Invalid Length!";
                    } else {
                        try {
                            long lAddress = DumpUtils.parseLongHex(address);
                            int iSize = Integer.parseInt(size);
                            Dump theDump = DumpConsole.getTheDump();
                            byte[] memoryBytes = theDump.getMemoryBytes(lAddress, iSize);
                            if (null != memoryBytes) {
                                boolean ascii = true;
                                if (theDump.getSystemType() == 3) {
                                    ascii = false;
                                }
                                long nextAddress = lAddress;
                                long prevAddress = lAddress;
                                String disNextMem = "0x" + Long.toHexString(nextAddress += (long)iSize) + "," + iSize;
                                String disPrevMem = "0x" + Long.toHexString(prevAddress -= (long)iSize) + "," + iSize;
                                Console.setProperty("DISNEXTMEM", disNextMem);
                                Console.setProperty("DISPREVMEM", disPrevMem);
                                Vector v = DumpUtils.formatMemory(memoryBytes, lAddress, 16, ascii);
                                if (v.size() != 0) {
                                    for (int i = 0; i < v.size(); ++i) {
                                        this.notifyObservers(v.get(i));
                                    }
                                }
                                break block14;
                            }
                            retString = "Error - Address not in memory: " + origAddress;
                        }
                        catch (NumberFormatException nfe) {}
                    }
                } else {
                    retString = "Error - Invalid Address!";
                }
            } else {
                retString = "Error - No address specified!";
            }
        }
        return retString;
    }

    private String doDisplaySys() {
        this.notifyObservers("\nSystem Summary\n==============");
        this.notifyObservers(theDump.toString());
        return null;
    }

    public static Dump getTheDump() {
        return theDump;
    }

    public String checkCommandValidity(Command cmd) {
        String retString;
        StringBuffer sb = new StringBuffer();
        if (cmd.isSetDumpRun() && null == DumpConsole.getTheDump()) {
            sb.append("\n \"Set dump\" needs to be run before this command! (no dump file established)");
        }
        if (cmd.isSetMetadataRun() && null == J9JVMConsole.getKnownHeaps()) {
            sb.append("\n \"Set metadata\" needs to be run before this command! (no known heaps)");
        }
        if (cmd.isDisOsRun() && null == J9JVMConsole.getNamesFile()) {
            sb.append("\n \"Dis os\" needs to be run before this command! (no names index file)");
        }
        if ((retString = sb.toString()).equals("")) {
            retString = null;
        }
        return retString;
    }

    private String findInMemory(String verb, String noun, String theRest, boolean quotes) {
        long startPos = 0L;
        long endPos = -1L;
        boolean caseSensitive = false;
        int sizeToPrint = 256;
        int boundary = 1;
        boolean bhexSpecified = false;
        int stopAt = 1;
        String stopLimit = "1";
        boolean bInError = false;
        Vector<Object> vOutput = new Vector<Object>();
        String retString = null;
        String trueNoun = noun;
        boolean findPtr = false;
        Vector vect = null;
        if (verb.equals("FINDPTR")) {
            findPtr = true;
        }
        if (null == noun) {
            bInError = true;
            String helpString = this.doFindHelp();
            this.notifyObservers(helpString);
        } else {
            int digit;
            int i;
            boolean bIsOS390 = false;
            if (theDump.getSystemType() == 3) {
                bIsOS390 = true;
            }
            String paramPossibilities = null;
            if (null != theRest) {
                paramPossibilities = theRest;
                int posQuote = theRest.indexOf("\"");
                if (-1 != posQuote) {
                    paramPossibilities = theRest.substring(posQuote + 2);
                }
            }
            if (!bInError && !quotes && trueNoun.toUpperCase().startsWith("0X")) {
                if (2 < trueNoun.length()) {
                    bhexSpecified = true;
                    trueNoun = DumpUtils.stripOff0x(trueNoun);
                    trueNoun.trim();
                    if (1 == trueNoun.length() % 2) {
                        trueNoun = "0" + trueNoun;
                    }
                    for (i = 0; i < trueNoun.length(); ++i) {
                        digit = ConsoleUtils.hexValue(trueNoun.charAt(i));
                        if (digit != -1) continue;
                        bInError = true;
                    }
                    if (bInError) {
                        vOutput.add("\nInvalid hex value: 0x" + trueNoun + "\n");
                    }
                } else {
                    vOutput.add("\nInvalid command structure:" + trueNoun + "\n");
                    bInError = true;
                }
            }
            if (!bInError && findPtr) {
                bhexSpecified = true;
                for (i = 0; i < trueNoun.length(); ++i) {
                    digit = ConsoleUtils.hexValue(trueNoun.charAt(i));
                    if (digit != -1) continue;
                    bInError = true;
                }
                if (bInError) {
                    vOutput.add("\nInvalid hex value: 0x" + trueNoun + "\n");
                }
            }
            Vector<String> parameters = new Vector<String>();
            if (!bInError && null != paramPossibilities) {
                boolean replaceFinito = false;
                while (!replaceFinito) {
                    int x = paramPossibilities.indexOf(",,");
                    if (-1 == x) {
                        replaceFinito = true;
                        continue;
                    }
                    paramPossibilities = paramPossibilities.substring(0, x + 1) + " " + paramPossibilities.substring(x + 1);
                }
                StringTokenizer st = new StringTokenizer(paramPossibilities, ",");
                int tokenCount = st.countTokens();
                if (0 != tokenCount) {
                    for (int i2 = 0; i2 < tokenCount; ++i2) {
                        parameters.add(st.nextToken().trim());
                    }
                }
                if (tokenCount > 5) {
                    vOutput.add("\nInvalid command structure: too many parameters\n");
                    bInError = true;
                }
            }
            if (!bInError && 0 != parameters.size()) {
                String printSize;
                String bound;
                String hex2;
                String hex1 = (String)parameters.get(0);
                if (0 != hex1.length()) {
                    try {
                        startPos = ConsoleUtils.hexToLong(hex1);
                    }
                    catch (NumberFormatException e) {
                        bInError = true;
                        vOutput.add("Invalid parameter:" + hex1);
                    }
                }
                if (1 < parameters.size() && 0 != (hex2 = (String)parameters.get(1)).length()) {
                    try {
                        endPos = ConsoleUtils.hexToLong(hex2);
                    }
                    catch (NumberFormatException e) {
                        bInError = true;
                        vOutput.add("Invalid parameter:" + hex2);
                    }
                }
                if (2 < parameters.size() && (bound = (String)parameters.get(2)).length() != 0) {
                    try {
                        boundary = Integer.parseInt(bound);
                        if (1 > boundary || 256 < boundary) {
                            bInError = true;
                            vOutput.add("Invalid boundary parameter (between 1 and 256 are valid) :" + bound);
                        }
                    }
                    catch (NumberFormatException e) {
                        bInError = true;
                        vOutput.add("Invalid boundary parameter:" + bound);
                    }
                }
                if (3 < parameters.size() && (printSize = (String)parameters.get(3)).length() != 0) {
                    try {
                        sizeToPrint = Integer.parseInt(printSize);
                        if (16 > sizeToPrint) {
                            bInError = true;
                            vOutput.add("Invalid print length parameter (less than 16) :" + printSize);
                        }
                    }
                    catch (NumberFormatException e) {
                        bInError = true;
                        vOutput.add("Invalid print length parameter:" + printSize);
                    }
                }
                if (4 < parameters.size() && (stopLimit = (String)parameters.get(4)).length() != 0) {
                    try {
                        stopAt = Integer.parseInt(stopLimit);
                        if (stopAt > 100 || stopAt < 1) {
                            bInError = true;
                            vOutput.add("Invalid find limit (>100 or <1) :" + stopLimit);
                        }
                    }
                    catch (NumberFormatException e) {
                        bInError = true;
                        vOutput.add("Invalid find limit:" + stopLimit);
                    }
                }
            }
            if (!bInError) {
                byte[] byteArray;
                if (bhexSpecified) {
                    byteArray = new byte[trueNoun.length() / 2];
                    for (int i3 = 0; i3 < byteArray.length; ++i3) {
                        String s = trueNoun.substring(i3 * 2, i3 * 2 + 2);
                        int aAsInt = Integer.parseInt(s, 16);
                        if (aAsInt > 127) {
                            aAsInt -= 256;
                        }
                        s = String.valueOf(aAsInt);
                        byteArray[i3] = Byte.parseByte(s);
                    }
                } else {
                    byteArray = new byte[trueNoun.length()];
                    boolean forced_ebcdic = false;
                    boolean forced_ascii = false;
                    String formatAs = Console.getProperty("FORMATAS");
                    if (null != formatAs) {
                        if ((formatAs = formatAs.toUpperCase()).startsWith("E")) {
                            forced_ebcdic = true;
                        }
                        if (formatAs.startsWith("A")) {
                            forced_ascii = true;
                        }
                    }
                    if (bIsOS390 && !forced_ascii || forced_ebcdic) {
                        try {
                            byteArray = trueNoun.getBytes("Cp1047");
                        }
                        catch (UnsupportedEncodingException e) {
                            Console.reportError("Cp1047 not found", e);
                        }
                    } else {
                        byteArray = trueNoun.getBytes();
                    }
                }
                if ((vect = DumpUtils.findInMemory(theDump, byteArray, startPos, endPos, boundary, stopAt, caseSensitive)).size() == stopAt) {
                    vOutput.add("  Note: your search result limit was " + stopAt + " ... there may be more results\n");
                }
                if (1 < vect.size()) {
                    for (int j = 0; j < vect.size(); ++j) {
                        long elem = (Long)vect.elementAt(j);
                        vOutput.add("#" + j + ": " + Long.toHexString(elem));
                    }
                }
                if (0 != vect.size()) {
                    Long elem1 = (Long)vect.elementAt(vect.size() - 1);
                    String findnext = trueNoun;
                    if (quotes) {
                        findnext = "\"" + findnext + "\"";
                    }
                    if (bhexSpecified) {
                        findnext = "0x" + findnext;
                    }
                    long fnAddr = elem1;
                    findnext = findnext + "," + Long.toHexString(fnAddr += (long)boundary) + ",";
                    findnext = findnext + Long.toHexString(endPos) + "," + boundary + ",";
                    findnext = findnext + sizeToPrint + "," + stopLimit;
                    Console.setProperty("FINDNEXT", findnext);
                    byte[] ba = null;
                    ba = theDump.getMemoryBytes(fnAddr - (long)boundary, sizeToPrint);
                    Vector v = DumpUtils.formatMemory(ba, fnAddr - (long)boundary, 16, !bIsOS390);
                    if (null != v) {
                        vOutput.add(v);
                    }
                    vOutput.add("  Tip 1: Use FINDNEXT (FN) command to progress through them");
                    vOutput.add("  Tip 2: Use \"SET FINDMODE=V\" to do automatic WHATIS\n");
                } else if (findPtr) {
                    vOutput.add("\n No occurrence of pointer found.");
                } else {
                    vOutput.add("\n No occurrence of search parameter found.\n Note: If parameter was a string then check case.\nIf required \"SET FORMATAS=A\" can be used to\n force ASCII search on EBCDIC dump (and vice versa).\n Note: You can use \" SET FINDMODE=V\" to cause find to\n issue a WHATIS against each found memory position.");
                }
                vOutput.add(" Find finished...\n");
            }
        }
        if (null != vOutput) {
            this.notifyObservers(vOutput);
        }
        boolean bFindModeV = false;
        String findmode = Console.getProperty("FINDMODE");
        if (null != findmode && findmode.toUpperCase().startsWith("V")) {
            bFindModeV = true;
        }
        if (bFindModeV) {
            for (int j = 0; j < vect.size(); ++j) {
                long elem = (Long)vect.elementAt(j);
                this.notifyObservers("Issuing \"whatis " + Long.toHexString(elem) + "\" \n");
                String cmd = "whatis 0x" + Long.toHexString(elem);
                Console.handleInput(cmd, false);
            }
        }
        return retString;
    }

    private String doPlusMinus(String what) {
        String retString = null;
        String whatToDo = null;
        whatToDo = what.equals("+") ? Console.getProperty("DISNEXTMEM") : Console.getProperty("DISPREVMEM");
        retString = null == whatToDo ? " No previous \"dis mem\" command has been issued." : this.doDisplayMem(whatToDo);
        return retString;
    }

    private String doWhatis(String what) {
        String retString = null;
        if (null == what) {
            this.notifyObservers(" Sorry, but I need to know what you want to know about.\n\t e.g. whatis 0x888abc");
            return retString;
        }
        try {
            long addr = DumpUtils.parseLongHex(what);
            int memRangeId = theDump.findWhichMemoryRange(addr);
            if (-1 == memRangeId) {
                this.notifyObservers(" \"" + what + "\" is not a known address in memory  ");
            } else {
                this.notifyObservers(" \"" + what + "\" is a known address in memory (range = " + memRangeId + ")");
                if (J9JVMBaseCmds.isSetMetaDataDone()) {
                    retString = J9JVMBaseCmds.whatis(what, addr, this);
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.notifyObservers(" \"" + what + "\" is not recognised as a valid address");
        }
        return retString;
    }

    private String doFindHelp() {
        return Console.getHelp("FIND");
    }

    private String doDisplayThread(String whatThread) {
        String retString = null;
        J9Jvm jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (jvm == null || jvm.getThreads().size() == 0) {
            this.notifyObservers("No known jvm threads (possible xml metadata problem?)");
            return null;
        }
        if (null == whatThread || whatThread.equals("")) {
            this.notifyObservers(currentThread.toString());
        } else {
            int numDisplayed = 0;
            if (null != jvm) {
                Vector threads = jvm.getThreads();
                for (int i = 0; i < threads.size(); ++i) {
                    GenericThread thread = (GenericThread)threads.get(i);
                    if (null == thread || !thread.matchIdOrName(whatThread)) continue;
                    StringBuffer sb = new StringBuffer();
                    thread.printHeader(sb);
                    sb.append(thread.toString());
                    this.notifyObservers(sb.toString());
                    ++numDisplayed;
                }
            }
            if (numDisplayed == 0) {
                this.notifyObservers("Unable to find thread identified with \"" + whatThread + "\" - use \"set thread\" to display valid values");
            }
        }
        return retString;
    }

    private String doDisplayNativeStack(String whatThread) {
        GenericThread t;
        J9Jvm jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (jvm == null || !jvm.getOwningProcess().getThreads().hasNext()) {
            this.notifyObservers("No known native threads");
            return null;
        }
        Vector<GenericThread> threads = new Vector<GenericThread>();
        if (null == whatThread || whatThread.equals("")) {
            if (currentThread instanceof J9Thread) {
                GenericThread nativeThread = ((J9Thread)currentThread).getNativeThread();
                if (nativeThread != null) {
                    threads.add(nativeThread);
                }
            } else {
                threads.add(currentThread);
            }
        } else if (null != jvm) {
            Iterator nativeThreads = jvm.getOwningProcess().getThreads();
            while (nativeThreads.hasNext()) {
                t = (GenericThread)nativeThreads.next();
                if (!t.matchIdOrName(whatThread)) continue;
                threads.add(t);
            }
            if (threads.isEmpty()) {
                Iterator javaThreads = jvm.getJavaThreads();
                while (javaThreads.hasNext()) {
                    GenericThread nativeThread;
                    J9Thread t2 = (J9Thread)javaThreads.next();
                    if (!t2.matchIdOrName(whatThread) || (nativeThread = t2.getNativeThread()) == null) continue;
                    threads.add(nativeThread);
                }
            }
        }
        if (threads.isEmpty()) {
            this.notifyObservers("Unable to find thread identified with \"" + whatThread + "\" - use \"set thread\" to display valid values");
        } else {
            for (int i = 0; i < threads.size(); ++i) {
                t = (GenericThread)threads.get(i);
                StringBuffer sb = new StringBuffer();
                if (t == null) {
                    this.notifyObservers("Invalid thread data - possible xml metadata problem");
                    continue;
                }
                t.printHeader(sb);
                t.printNativeFrames(sb);
                this.notifyObservers(sb.toString());
            }
        }
        return null;
    }

    private String doSetThread(String whatThread) {
        GenericThread t;
        int i;
        String retString = null;
        boolean foundIt = false;
        J9Jvm jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (jvm == null) {
            this.notifyObservers("No known jvm threads (possible xml metadata problem?)");
            return null;
        }
        if (whatThread != null) {
            whatThread = DumpUtils.stripOff0x(whatThread);
            whatThread = "0X" + whatThread;
            for (i = 0; i < jvm.getThreads().size(); ++i) {
                t = (GenericThread)jvm.getThreads().get(i);
                String tid = t.getThreadId().toUpperCase();
                if (!tid.equals(whatThread)) continue;
                currentThread = t;
                foundIt = true;
                break;
            }
        } else {
            whatThread = "";
        }
        if (!foundIt) {
            this.notifyObservers("Unable to find thread with Id: " + whatThread + " - valid ids are....");
            for (i = 0; i < jvm.getThreads().size(); ++i) {
                t = (GenericThread)jvm.getThreads().get(i);
                String output = "  " + t.getThreadId() + "  " + t.getThreadName();
                if (t == currentThread) {
                    output = output + "  <<<< Current Thread";
                }
                this.notifyObservers(output);
            }
        } else {
            this.notifyObservers("Current thread now: " + whatThread + "  " + currentThread.getThreadName());
        }
        return retString;
    }

    public static void setCurrentThread(GenericThread currentThread) {
        DumpBaseCmds.currentThread = currentThread;
    }
}

