/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.common.core.utils.SubtaskOnlyProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2MetadataSource;
import com.ibm.cic.p2.model.IP2Session;
import com.ibm.cic.p2.model.internal.Messages;
import com.ibm.cic.p2.model.internal.P2MetadataSource;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2Session
implements IP2Session {
    private IProvisioningAgent fProvisioningAgent;
    private IMetadataRepositoryManager fMetaService;
    private final ArrayList fMetaRepos = new ArrayList(2);

    @Override
    public IP2MetadataSource openExistingMetadataSource(URI uri, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.P2Session_taskLabelOpen, 1);
        try {
            P2MetadataSource src;
            SubProgressMonitor p2Mon = new SubProgressMonitor(monitor, 1);
            IMetadataRepository mr = this.openExistingMetadataRepository(uri, (IProgressMonitor)p2Mon);
            P2MetadataSource p2MetadataSource = src = new P2MetadataSource(mr);
            return p2MetadataSource;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IP2MetadataSource createMetadataComposite(File location, String name, URI[] composites, Map properties) throws CoreException {
        IMetadataRepository repo = this.getMetadataRepositoryManager().createRepository(location.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        if (repo != null) {
            ICompositeRepository comp = (ICompositeRepository)repo;
            this.fMetaRepos.add(repo);
            URI[] uRIArray = composites;
            int n = composites.length;
            int n2 = 0;
            while (n2 < n) {
                URI composite = uRIArray[n2];
                comp.addChild(composite);
                ++n2;
            }
        }
        return new P2MetadataSource(repo);
    }

    @Override
    public IP2MetadataSource createMetadataComposite(File location, String name, IP2MetadataSource[] composites, Map properties) throws CoreException {
        IMetadataRepository repo = this.getMetadataRepositoryManager().createRepository(location.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        if (repo != null) {
            ICompositeRepository comp = (ICompositeRepository)repo;
            this.fMetaRepos.add(repo);
            IP2MetadataSource[] iP2MetadataSourceArray = composites;
            int n = composites.length;
            int n2 = 0;
            while (n2 < n) {
                IP2MetadataSource composite = iP2MetadataSourceArray[n2];
                comp.addChild(composite.getLocation());
                ++n2;
            }
        }
        return new P2MetadataSource(repo);
    }

    @Override
    public IP2MetadataSource createP2Repository(File location, String name, boolean compressed) throws CoreException {
        IMetadataRepository repo = Publisher.createMetadataRepository((IProvisioningAgent)this.getProvisioningAgent(), (URI)location.toURI(), (String)name, (boolean)false, (boolean)compressed);
        if (repo == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", Messages.bind((String)Messages.P2Session_errCreateFailed, (Object)location.getAbsolutePath())));
        }
        this.fMetaRepos.add(repo);
        return new P2MetadataSource(repo);
    }

    private IMetadataRepository openExistingMetadataRepository(URI uri, IProgressMonitor monitor) throws CoreException {
        SubtaskOnlyProgressMonitor mon;
        IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
        IMetadataRepository repo = manager.loadRepository(uri, (IProgressMonitor)(mon = new SubtaskOnlyProgressMonitor(monitor)));
        if (repo != null) {
            this.fMetaRepos.add(repo);
        } else {
            manager.removeRepository(uri);
        }
        return repo;
    }

    private IProvisioningAgent getProvisioningAgent() throws CoreException {
        if (this.fProvisioningAgent == null) {
            this.fProvisioningAgent = CicP2Model.getDefault().getProvisioningAgentProvider().getDefaultProvisioningAgent();
        }
        return this.fProvisioningAgent;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() throws CoreException {
        if (this.fMetaService == null) {
            this.fMetaService = (IMetadataRepositoryManager)this.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        }
        return this.fMetaService;
    }

    @Override
    public void dispose() {
        if (this.fProvisioningAgent != null) {
            if (this.fMetaService != null) {
                for (IMetadataRepository mr : this.fMetaRepos) {
                    this.fMetaService.removeRepository(mr.getLocation());
                }
                this.fMetaRepos.clear();
                this.fMetaService = null;
            }
            this.fProvisioningAgent.stop();
            this.fProvisioningAgent = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (IProvisioningAgent.class.equals((Object)adapter)) {
            try {
                return this.getProvisioningAgent();
            }
            catch (CoreException e) {
                Logger.getLogger(this.getClass()).status(e.getStatus());
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

