/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2InstallUnit;
import com.ibm.cic.p2.model.IP2MetadataSource;
import com.ibm.cic.p2.model.IP2Require;
import com.ibm.cic.p2.model.internal.Messages;
import com.ibm.cic.p2.model.internal.P2IU;
import com.ibm.cic.p2.model.internal.P2MatchQuery;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.osgi.framework.Version;

public class P2MetadataSource
implements IP2MetadataSource {
    public static final boolean DEBUG = true;
    private final IMetadataRepository fMetaRepos;

    public P2MetadataSource(IMetadataRepository metaRepos) {
        this.fMetaRepos = metaRepos;
    }

    @Override
    public IP2InstallUnit[] findRequired(IP2Require req) {
        IRequirement requirement = (IRequirement)req.getAdapter(IRequirement.class);
        IMatchExpression matches = requirement.getMatches();
        IQuery query = QueryUtil.createMatchQuery((IExpression)matches, (Object[])new Object[0]);
        IQueryResult result = this.fMetaRepos.query(query, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] ret = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
        IP2InstallUnit[] arr = new IP2InstallUnit[ret.length];
        int i = 0;
        while (i < arr.length) {
            arr[i] = P2IU.create(ret[i]);
            ++i;
        }
        return arr;
    }

    @Override
    public boolean isReadOnly() {
        return !this.fMetaRepos.isModifiable();
    }

    @Override
    public void addInstallUnits(IP2InstallUnit[] units) throws CoreException {
        if (!this.fMetaRepos.isModifiable()) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", Messages.bind((String)Messages.P2MetadataSource_errReadOnly, (Object)this.fMetaRepos.getLocation().toString())));
        }
        ArrayList<Object> items = new ArrayList<Object>(units.length);
        IP2InstallUnit[] iP2InstallUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IP2InstallUnit unit = iP2InstallUnitArray[n2];
            items.add(unit.getAdapter(IInstallableUnit.class));
            ++n2;
        }
        this.fMetaRepos.addInstallableUnits(items);
    }

    @Override
    public String getLocationStr() {
        return this.fMetaRepos.getLocation().toString();
    }

    @Override
    public URI getLocation() {
        return this.fMetaRepos.getLocation();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.fMetaRepos.getClass())) {
            return this.fMetaRepos;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IP2InstallUnit[] getAllUnits() {
        IQueryResult result = this.fMetaRepos.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor());
        Set resultSet = result.toUnmodifiableSet();
        IP2InstallUnit[] ret = new IP2InstallUnit[resultSet.size()];
        Iterator iter = resultSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i] = P2IU.create((IInstallableUnit)iter.next());
            ++i;
        }
        return ret;
    }

    @Override
    public IP2InstallUnit[] findIU(String id) {
        IQuery q = QueryUtil.createIUQuery((String)id);
        IQueryResult res = this.fMetaRepos.query(q, (IProgressMonitor)new NullProgressMonitor());
        ArrayList<P2IU> ret = new ArrayList<P2IU>();
        for (IInstallableUnit iu : res) {
            ret.add(P2IU.create(iu));
        }
        return ret.toArray(new IP2InstallUnit[ret.size()]);
    }

    @Override
    public IP2InstallUnit findIU(String id, Version version) {
        IQueryResult result;
        org.eclipse.equinox.p2.metadata.Version p2Version = CicP2Model.fromOSGiVersion(version);
        IQuery query = QueryUtil.createIUQuery((String)id, (org.eclipse.equinox.p2.metadata.Version)p2Version);
        if (version == null || Version.emptyVersion.equals((Object)version)) {
            query = QueryUtil.createLatestQuery((IQuery)query);
        }
        if ((result = this.fMetaRepos.query(query, null)).isEmpty()) {
            return null;
        }
        return P2IU.create((IInstallableUnit)result.iterator().next());
    }

    @Override
    public IP2InstallUnit[] findFragmentsOf(IP2InstallUnit unit) {
        FragmentQuery query = new FragmentQuery(unit);
        IQueryResult result = this.fMetaRepos.query((IQuery)query, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] ret = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
        IP2InstallUnit[] wrapped = new IP2InstallUnit[ret.length];
        int i = 0;
        while (i < ret.length) {
            wrapped[i] = P2IU.create(ret[i]);
            ++i;
        }
        return wrapped;
    }

    private static class FragmentQuery
    extends P2MatchQuery {
        private final IInstallableUnit fIu;

        FragmentQuery(IP2InstallUnit host) {
            this.fIu = (IInstallableUnit)host.getAdapter(IInstallableUnit.class);
        }

        @Override
        public boolean isMatch(Object candidate) {
            if (!(candidate instanceof IInstallableUnitFragment)) {
                return false;
            }
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)candidate;
            Collection hosts = fragment.getHost();
            for (IRequirement hostReq : hosts) {
                VersionRange tol;
                String name;
                IRequiredCapability host;
                String namespace;
                if (!(hostReq instanceof IRequiredCapability) || !"osgi.bundle".equals(namespace = (host = (IRequiredCapability)hostReq).getNamespace()) || (name = host.getName()) == null || !name.equals(this.fIu.getId()) || (tol = host.getRange()) == null || !tol.isIncluded(this.fIu.getVersion())) continue;
                return true;
            }
            return false;
        }
    }
}

