/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.IPlatformOperationsProvider;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PlatformOperationsProvider;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

class PPLumEnroller
extends AbstractPlatformPolicyFactory {
    static PPLumEnroller m_factory = new PPLumEnroller();

    PPLumEnroller() {
    }

    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        PPCommon() {
        }

        abstract boolean platformDependentWriteToRegistry(String var1, String var2, String var3);

        abstract String getRegKey(String var1, String var2);

        abstract String checkRegistry(String var1, String var2);
    }

    class PPLinux
    extends PPCommon {
        private static final String ETC_DOTSDP_LICENSE = "/etc/.sdp/license/";
        private final String REGLINUX_ETC_DOTSDP_LICENSE = CicCommonSettings.getAccessRightsMode().isAdminMode() ? "/etc/.sdp/license/" : (CicCommonSettings.getAccessRightsMode().isGroupMode() ? String.valueOf(CicCommonSettings.getApplicationDataLocation()) + "/etc/.sdp/license/" : new CicFileLocation(System.getProperty("user.home")).append("/etc/.sdp/license/").toString());

        PPLinux() {
        }

        @Override
        boolean platformDependentWriteToRegistry(String regKeyOrFileName, String propkey, String propvalue) {
            boolean regWriteOK = false;
            File regfileparentdir = new File(regKeyOrFileName).getParentFile();
            if (!regfileparentdir.exists()) {
                regfileparentdir.mkdirs();
            }
            regWriteOK = LicUserUtils.storeProperties((String)regKeyOrFileName, (String)propkey, (String)propvalue);
            return regWriteOK;
        }

        @Override
        String getRegKey(String productID, String productVersion) {
            return String.valueOf(this.REGLINUX_ETC_DOTSDP_LICENSE) + productID;
        }

        @Override
        String checkRegistry(String productVersion, String regKey) {
            try {
                File regFile = new File(regKey);
                if (regFile.exists()) {
                    Properties prop = LicUserUtils.loadProperties((String)regFile.getCanonicalPath());
                    return prop.getProperty(productVersion);
                }
            }
            catch (IOException ioe) {
                Logger.logNtrace((String)ioe.getMessage(), (Exception)ioe);
            }
            return null;
        }
    }

    class PPWindows
    extends PPCommon {
        private final String REGWIN_SOFTWARE_IBM_SDP_LICENSE = CicCommonSettings.getAccessRightsMode().isAdminMode() ? "HKEY_LOCAL_MACHINE\\SOFTWARE\\IBM\\SDP\\license\\" : "HKEY_CURRENT_USER\\SOFTWARE\\IBM\\SDP\\license\\";
        private final int accessMask = Platform.getOSArch().equals("x86_64") ? 256 : 512;

        PPWindows() {
        }

        @Override
        boolean platformDependentWriteToRegistry(String regKeyOrFileName, String propkey, String propvalue) {
            boolean regWriteOK = false;
            try {
                IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
                regWriteOK = provider.regWrite(regKeyOrFileName, propvalue, "reg_sz", this.accessMask);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            return regWriteOK;
        }

        @Override
        String getRegKey(String productID, String productVersion) {
            return String.valueOf(this.REGWIN_SOFTWARE_IBM_SDP_LICENSE) + productID + "\\" + productVersion;
        }

        @Override
        String checkRegistry(String productVersion, String regKey) {
            try {
                IPlatformOperationsProvider provider = PlatformOperationsProvider.getProvider();
                return provider.regRead(regKey, true, this.accessMask);
            }
            catch (CoreException ce) {
                Logger.logNtrace((String)ce.getMessage(), (Exception)((Object)ce));
                return null;
            }
        }
    }
}

