/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu;

import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.AbstractDesktopElement;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopEntry;
import com.ibm.cic.common.commonNativeAdapterData.CommonDesktopEntyNativeData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DesktopDirectory
extends AbstractDesktopElement {
    private final StringTokenizer m_subdirectories;
    private final ArrayList m_desktopDirectories = new ArrayList();
    private final ArrayList m_desktopEntries = new ArrayList();
    private final String m_iconPath;

    DesktopDirectory(AbstractDesktopElement parent, CommonDesktopEntyNativeData data, String name, StringTokenizer subdirectores) {
        super(parent.getHandler());
        this.setContainingDir(parent.getHandler().getPolicy().calculateContainingDir(parent, this));
        this.setName(name);
        this.m_subdirectories = subdirectores;
        this.m_iconPath = this.getTrimmedSubstitutedValue(data.getIconPath());
        this.addSubDirectoriesAndDesktopElements(data, this.m_subdirectories);
    }

    public List getContatinedDirectories() {
        return this.m_desktopDirectories;
    }

    public List getContatinedEntries() {
        return this.m_desktopEntries;
    }

    public String getIconPath() {
        return this.m_iconPath;
    }

    IStatus addSubDirectoriesAndDesktopElements(CommonDesktopEntyNativeData data, StringTokenizer subcategories) {
        if (subcategories.hasMoreTokens()) {
            String subName = subcategories.nextToken();
            if (subName.length() > 0) {
                DesktopDirectory dir = this.findDesktopDirectory(subName);
                if (dir != null) {
                    dir.setToDeleted(false);
                } else {
                    dir = new DesktopDirectory(this, data, subName, subcategories);
                    this.m_desktopDirectories.add(dir);
                }
            }
        } else {
            String entryName = this.getTrimmedSubstitutedValue(data.getName());
            DesktopEntry entry = this.findDesktopEntry(entryName);
            if (entry != null) {
                entry.setToDeleted(false);
            } else {
                entry = new DesktopEntry(this, data);
                this.m_desktopEntries.add(entry);
            }
        }
        return Status.OK_STATUS;
    }

    DesktopDirectory findDesktopDirectory(String name) {
        DesktopDirectory return_value = null;
        Iterator I = this.m_desktopDirectories.iterator();
        while (I.hasNext() && return_value == null) {
            DesktopDirectory dir = (DesktopDirectory)I.next();
            if (!name.equals(dir.getName())) continue;
            return_value = dir;
        }
        return return_value;
    }

    DesktopEntry findDesktopEntry(String name) {
        DesktopEntry return_value = null;
        Iterator I = this.m_desktopEntries.iterator();
        while (I.hasNext() && return_value == null) {
            DesktopEntry entry = (DesktopEntry)I.next();
            if (!name.equals(entry.getName())) continue;
            return_value = entry;
        }
        return return_value;
    }

    @Override
    public boolean writeToDisk() throws CoreException {
        boolean return_value = true;
        if (!this.isToBeDeleted()) {
            return_value = this.getHandler().getPolicy().createDiskFiles(this);
            if (return_value) {
                Iterator I = this.m_desktopDirectories.iterator();
                while (I.hasNext() && return_value) {
                    DesktopDirectory dir = (DesktopDirectory)I.next();
                    return_value = dir.writeToDisk();
                }
                I = this.m_desktopEntries.iterator();
                while (I.hasNext() && return_value) {
                    DesktopEntry entry = (DesktopEntry)I.next();
                    return_value = entry.writeToDisk();
                }
            }
        } else {
            Iterator I = this.m_desktopEntries.iterator();
            while (I.hasNext() && return_value) {
                DesktopEntry entry = (DesktopEntry)I.next();
                return_value = entry.writeToDisk();
            }
            if (return_value) {
                I = this.m_desktopDirectories.iterator();
                while (I.hasNext() && return_value) {
                    DesktopDirectory dir = (DesktopDirectory)I.next();
                    return_value = dir.writeToDisk();
                }
            }
            if (return_value) {
                return_value = this.getHandler().getPolicy().deleteDiskFiles(this);
            }
        }
        return return_value;
    }

    @Override
    public void remove() {
        for (DesktopDirectory dir : this.m_desktopDirectories) {
            dir.remove();
        }
        for (DesktopEntry entry : this.m_desktopEntries) {
            entry.remove();
        }
        super.remove();
    }

    @Override
    public String toString() {
        return "DIR Name      : " + this.getName() + "\nContains  dirs: " + this.m_desktopDirectories.size() + "\nContains entrs: " + this.m_desktopEntries.size() + "\n" + super.toString();
    }
}

