/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.sharedUI.OfferingFeatureStatus;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPreChecks;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPagePreChecks
extends AConPage {
    private IStatus m_status = Status.OK_STATUS;
    private ConDataCtxtPreChecks m_context = null;
    private ConViewList options;

    public ConPagePreChecks(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.ConDataCtxtPreChecks_Header);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        this.m_status = this.m_context.getPreChecksValidationStatus();
        if (this.m_status.isOK()) {
            this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.ConditionalInstallPage_validationSuccess));
        } else {
            this.addView((IConView)new ConViewText(Messages.ConDataCtxtPreChecks_Description));
            int index = 1;
            for (OfferingFeatureStatus ofs : this.m_context.getSelectedProductValidationStatuses()) {
                CicMultiStatus st = ofs.getOfferingValidationSummaryStatus();
                String label = ofs.getOfferingValidationSummaryStatus().matches(4) ? NLS.bind((String)Messages.ConDataCtxtPreChecks_OfferingHasValidationError, (Object)AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)ofs.getOfferingOrFix())) : (ofs.getOfferingValidationSummaryStatus().matches(2) ? NLS.bind((String)Messages.ConDataCtxtPreChecks_OfferingHasValidationWarning, (Object)AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)ofs.getOfferingOrFix())) : (ofs.getOfferingValidationSummaryStatus().matches(8) ? NLS.bind((String)Messages.ConDataCtxtPreChecks_OfferingHasValidationCancelled, (Object)AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)ofs.getOfferingOrFix())) : NLS.bind((String)Messages.ConDataCtxtPreChecks_OfferingHasValidationInformation, (Object)AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)ofs.getOfferingOrFix()))));
                ConViewListNumbered offeringStatuses = new ConViewListNumbered(label, false, index);
                if (!st.isOK()) {
                    index += this.addStatusesToView((IStatus)st, index, offeringStatuses);
                }
                this.addView((IConView)offeringStatuses);
            }
            this.addView((IConView)new ConViewText(Messages.ConDataCtxtPreChecks_helpUser1));
        }
        this.options = new ConViewList(Messages.General_Options, true);
        this.options.addEntry(Messages.ConDataCtxtPreChecks_RecheckStatus, "R", (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

            public void run(IConManager a_conManager) {
                ConPagePreChecks.this.m_context.getPreChecksValidationStatus(true);
            }
        });
        this.addView((IConView)this.options);
        super.present(a_output);
    }

    private int addStatusesToView(final IStatus ost, int index, ConViewListNumbered offeringStatuses) {
        int count = 0;
        if (!ost.isOK()) {
            if (ost.isMultiStatus()) {
                IStatus[] iStatusArray = ost.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus cost = iStatusArray[n2];
                    int inc = this.addStatusesToView(cost, index, offeringStatuses);
                    index += inc;
                    count += inc;
                    ++n2;
                }
            } else {
                ++count;
                IStatus status = ConViewStatus.fixStatusToDisplay((IStatus)ost);
                String msg = String.valueOf(ConViewStatus.getSeverityLabel((IStatus)status)) + " " + StatusUtil.combineAnchors((String)status.getMessage());
                if (CommonSharedUIUtils.shouldShowViewDetails((IStatus)ost)) {
                    offeringStatuses.addEntry(msg, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                        public void run(IConManager conManager) {
                            ConStatusMessageDialog.open((IConManager)conManager, null, null, (IStatus)ost, (int)15, (boolean)true);
                        }
                    });
                } else {
                    offeringStatuses.addEntry(msg, (AConActionEntry)new AConActionEntry<ConViewListEntry>(){

                        public void run(IConManager a_conManager) {
                            ConStatusMessageDialog.open((IConManager)a_conManager, (String)Messages.ConDataCtxtPreChecks_Header, null, (IStatus)ost, (int)15, (boolean)false);
                        }
                    });
                }
            }
        }
        return count;
    }

    public boolean isPageComplete() {
        return !StatusUtil.isErrorOrCancel((IStatus)this.m_status);
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtPreChecks)this.conManager().getDataContext(ConDataCtxtPreChecks.class);
        return this.m_context.getPreChecksValidationStatus().isOK();
    }
}

