/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.custompanel.GeneratedConsoleUICustomPanel;
import com.ibm.cic.agent.internal.console.pages.ConPageCustomPanelList;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewFooter;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewHeader;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import org.eclipse.core.runtime.IStatus;

public class ConPageCustomPanelContainer
extends AConPage {
    private CustomPanelJobPair m_panelJobPair;
    private final ConPageCustomPanelList m_conPagePanelList;
    private GeneratedConsoleUICustomPanel m_customPanel;
    private ConViewText m_subProgressView;
    private ConViewStatus m_statusView;
    private ConViewList m_navigationListView;

    public ConPageCustomPanelContainer(IConManager aConManager, CustomPanelJobPair pair, ConPageCustomPanelList customPanelListPage) {
        super(aConManager);
        this.m_panelJobPair = pair;
        this.m_conPagePanelList = customPanelListPage;
        ICustomPanel panel = this.m_panelJobPair.getPanel();
        if (panel instanceof GeneratedConsoleUICustomPanel) {
            this.m_customPanel = (GeneratedConsoleUICustomPanel)panel;
        }
    }

    public void init() {
        this.setHeaderView("");
        this.m_customPanel.initializeViews();
        ConViewGroup newFooter = new ConViewGroup();
        newFooter.addView((IConView)new ConViewText(""));
        this.m_navigationListView = new ConViewList(null, false);
        newFooter.addView((IConView)this.m_navigationListView);
        newFooter.addView((IConView)new ConViewFooter());
        this.setFooterView((IConView)newFooter);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        IOffering offering;
        this.clear();
        AgentJob job = this.m_panelJobPair.getJob();
        StringBuffer subProgress = new StringBuffer("---- ");
        String header = com.ibm.cic.agent.core.sharedUI.Messages.SingleConfigurationPage_allPackages;
        if (job != null && (offering = job.getOffering()) != null) {
            header = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering);
        }
        subProgress.append(header);
        subProgress.append("> ");
        subProgress.append(this.m_panelJobPair.getPanel().getPanelId());
        this.m_subProgressView = new ConViewText(subProgress.toString(), true);
        this.addView((IConView)this.m_subProgressView);
        this.addView((IConView)new ConViewText(""));
        ConViewGroup customPanelGroup = new ConViewGroup();
        this.m_customPanel.createContents(customPanelGroup, a_output);
        this.addView((IConView)customPanelGroup);
        IStatus status = this.m_customPanel.getValidationStatus();
        if (this.m_customPanel.isVisited() || AgentInput.getInstance().showValidationResult()) {
            if (StatusUtil.isErrorOrCancel((IStatus)status) || status.matches(2)) {
                this.addView((IConView)new ConViewText(""));
            }
            if (this.m_statusView == null) {
                this.m_statusView = new ConViewStatus(status);
            } else {
                this.m_statusView.setStatus(status);
            }
            this.addView((IConView)this.m_statusView);
        } else {
            this.m_customPanel.setVisited(true);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            this.m_customPanel.setPageComplete(false);
        } else {
            this.m_customPanel.setPageComplete(true);
        }
        this.generateFooter(a_output);
        super.present(a_output);
    }

    public IConAction getAction(IConIO a_input) {
        IConAction return_value = null;
        if (this.getFooterView() != null) {
            return_value = this.getFooterView().getAction(a_input);
        }
        if (return_value == null) {
            return_value = super.getAction(a_input);
        }
        return return_value;
    }

    private void generateFooter(OutputFormatter a_output) {
        if (this.getFooterView() != null) {
            this.m_navigationListView.clearList();
            if (this.m_conPagePanelList.canNavigateToPreviousPanel()) {
                this.m_navigationListView.addEntry(com.ibm.cic.common.core.console.Messages.WizardPage_Back, ConCommonCommandKeys.keys_Back, (AConActionEntry)new ConActionCustomPanelPrevious());
            }
            if (this.m_conPagePanelList.canNavigateToNextPanel()) {
                if (!this.isSuggestedInputSet()) {
                    this.setSuggestedInput(ConCommonCommandKeys.keys_Next[0]);
                }
                this.m_navigationListView.addEntry(com.ibm.cic.common.core.console.Messages.WizardPage_Next, ConCommonCommandKeys.keys_Next, (AConActionEntry)new ConActionCustomPanelNext());
            }
            if (!this.isSuggestedInputSet()) {
                this.setSuggestedInput("R");
            }
            this.m_navigationListView.addEntry(Messages.ConPageCustomPanelContainer_ReturnToListPage, "R", (AConActionEntry)new ConActionCustomPanelReturnToMenu());
            if (!this.isSuggestedInputSet()) {
                this.setSuggestedInput(ConCommonCommandKeys.keys_Cancel[0]);
            }
            this.m_navigationListView.addEntry(com.ibm.cic.common.core.console.Messages.WizardPage_Cancel, ConCommonCommandKeys.keys_Cancel, ConUtils.getCancelAction());
        }
    }

    protected void setHeaderView(String a_headerView) {
        String prevHeader = this.calculatePreviousHeader(this);
        if (prevHeader != null) {
            this.setHeaderView((IConView)new ConViewHeader(String.valueOf(prevHeader) + a_headerView));
        } else {
            this.setHeaderView((IConView)new ConViewHeader(a_headerView));
        }
    }

    public boolean isPageComplete() {
        return this.m_customPanel.isPageComplete() && !StatusUtil.isErrorOrCancel((IStatus)this.m_customPanel.getValidationStatus());
    }

    public void setCustomPanelJobPair(CustomPanelJobPair pair) {
        this.m_panelJobPair = pair;
        ICustomPanel panel = pair.getPanel();
        if (panel instanceof GeneratedConsoleUICustomPanel) {
            this.m_customPanel = (GeneratedConsoleUICustomPanel)panel;
        }
    }

    public void dispose() {
        this.m_customPanel.dispose();
    }

    public boolean isSuggestedInputSet() {
        String suggestedInput = this.m_customPanel.getSuggestedInput();
        return suggestedInput != null && suggestedInput.length() > 0;
    }

    public String getSuggestedInput() {
        return this.m_customPanel.getSuggestedInput();
    }

    public void setSuggestedInput(String a_suggestedInput) {
        this.m_customPanel.setSuggestedInput(a_suggestedInput);
    }

    public void setVisible(boolean a_visible) {
        super.setVisible(a_visible);
        this.m_customPanel.setVisible(a_visible);
    }

    class ConActionCustomPanelNext
    extends AConActionEntry {
        ConActionCustomPanelNext() {
        }

        public void run(IConManager a_conManager) {
            IStatus status = ConPageCustomPanelContainer.this.m_customPanel.validateConsoleCustomPanel();
            if (StatusUtil.isErrorOrCancel((IStatus)status) || status.matches(2)) {
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    ConStatusMessageDialog.openError((IConManager)a_conManager, (String)com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error, (String)Messages.ConPageNavigation_Error_Next, (IStatus)status);
                } else {
                    boolean navigateAway = ConStatusMessageDialog.openQuestion((IConManager)a_conManager, (String)com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning, (String)Messages.ConPageNavigation_Warning_Next, (IStatus)status, (int)6, (int)1);
                    if (navigateAway) {
                        ConPageCustomPanelContainer.this.m_conPagePanelList.navigateToNextPanel();
                    }
                }
            } else {
                ConPageCustomPanelContainer.this.m_conPagePanelList.navigateToNextPanel();
            }
            super.run(a_conManager);
        }
    }

    class ConActionCustomPanelPrevious
    extends AConActionEntry {
        ConActionCustomPanelPrevious() {
        }

        public void run(IConManager a_conManager) {
            IStatus status = ConPageCustomPanelContainer.this.m_customPanel.validateConsoleCustomPanel();
            boolean navigateAway = true;
            String title = com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning;
            String msg = Messages.ConPageNavigation_Warning_Back;
            int defaultIndex = 0;
            if (StatusUtil.isErrorOrCancel((IStatus)status) || status.matches(2)) {
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    title = com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error;
                    msg = Messages.ConPageNavigation_Error_Back;
                    defaultIndex = 1;
                }
                navigateAway = ConStatusMessageDialog.openQuestion((IConManager)a_conManager, (String)title, (String)msg, (IStatus)status, (int)6, (int)defaultIndex);
            }
            if (navigateAway) {
                ConPageCustomPanelContainer.this.m_conPagePanelList.navigateToPreviousPanel();
            }
            super.run(a_conManager);
        }
    }

    class ConActionCustomPanelReturnToMenu
    extends AConActionEntry {
        ConActionCustomPanelReturnToMenu() {
        }

        public void run(IConManager a_conManager) {
            IStatus status = ConPageCustomPanelContainer.this.m_customPanel.validateConsoleCustomPanel();
            boolean navigateAway = true;
            String title = com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning;
            String msg = Messages.ConPageNavigation_Warning_Menu;
            int defaultIndex = 0;
            if (StatusUtil.isErrorOrCancel((IStatus)status) || status.matches(2)) {
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    title = com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error;
                    msg = Messages.ConPageNavigation_Error_Menu;
                    defaultIndex = 1;
                }
                navigateAway = ConStatusMessageDialog.openQuestion((IConManager)a_conManager, (String)title, (String)msg, (IStatus)status, (int)6, (int)defaultIndex);
            }
            if (navigateAway) {
                ConActionReturnToPreviousPage.INSTANCE_PREVIOUS.run(a_conManager);
            }
            super.run(a_conManager);
        }
    }
}

