/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ConDataCtxtUtils {
    private static final Logger log = Logger.getLogger(ConDataCtxtUtils.class);

    public static IOffering[] getSelectedProductOfferingArray(List<? extends AbstractJob> selectedProductJobs) {
        ArrayList<IOffering> offeringList = new ArrayList<IOffering>();
        for (AbstractJob abstractJob : selectedProductJobs) {
            IOffering offering = abstractJob.getOffering();
            if (offering == null || Agent.getInstance().isAgentOffering((IOfferingOrFix)offering) || LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            offeringList.add(offering);
        }
        return offeringList.toArray(new IOffering[offeringList.size()]);
    }

    public static void unloadBundlesForOfferingOrFix(IOfferingOrFix oof, IProgressMonitor monitor) {
        String msg = NLS.bind((String)Messages.Director_Unpreparing, (Object)(oof.getIdentity() + " " + oof.getVersion()));
        Agent agent = Agent.getInstance();
        monitor.beginTask(msg, -1);
        IStatus status = agent.unloadAgentBundles(oof, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        log.statusNotOK(status);
    }

    public static void unprepareAndClear(JobListManager<? extends AgentJob> managedJobs) {
        if (managedJobs.containsJobs()) {
            Agent agent = Agent.getInstance();
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask("", -1);
                IStatus status = agent.unprepare(managedJobs.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(status);
                managedJobs.clear();
            }
            finally {
                monitor.done();
            }
        }
    }
}

