/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.CDRInputHandler;
import com.ibm.rmi.iiop.CDRReader;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;

public final class LocateReplyMessage
extends Message {
    private static final String CLASS = LocateReplyMessage.class.getName();
    public static final int UNKNOWN_OBJECT = 0;
    public static final int OBJECT_HERE = 1;
    public static final int OBJECT_FORWARD = 2;
    public static final int OBJECT_FORWARD_PERM = 3;
    public static final int LOC_SYSTEM_EXCEPTION = 4;
    public static final int LOC_NEEDS_ADDRESSING_MODE = 5;
    int status;
    protected String exClassName;
    protected int minorCode;
    protected CompletionStatus completionStatus;
    protected short addressingDisposition = 0;
    protected boolean needsReAddressing;

    public LocateReplyMessage(byte by, byte by2) {
        super(by, by2);
    }

    public LocateReplyMessage(int n, int n2, byte by, byte by2) {
        super(by, by2);
        this.setType(4);
        this.requestId = n;
        this.status = n2;
    }

    public LocateReplyMessage() {
    }

    public int getLocateReplyStatus() {
        return this.status;
    }

    public boolean needsReAddressing() {
        return this.needsReAddressing;
    }

    public short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    public SystemException getSystemException() {
        SystemException systemException;
        if (Trc.enabled(5)) {
            Trc.begin1(Trc.FINEST, this.exClassName, CLASS, "getSystemException:106");
        }
        try {
            Class<UNKNOWN> clazz;
            try {
                clazz = Util.loadClass((String)this.exClassName, null, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Trc.enabled()) {
                    Trc.warn(classNotFoundException.toString(), CLASS, "getSystemException:117");
                }
                clazz = UNKNOWN.class;
            }
            systemException = (SystemException)((Object)clazz.newInstance());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "getSystemException:130");
            } else {
                Trc.ffdc(throwable.toString() + throwable, CLASS, "getSystemException:132");
            }
            throw new INTERNAL("BAD SystemException(2): " + this.exClassName, 1229125019, CompletionStatus.COMPLETED_MAYBE);
        }
        systemException.minor = this.minorCode;
        systemException.completed = this.completionStatus;
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, systemException.toString(), CLASS, "getSystemException:144");
        }
        return systemException;
    }

    @Override
    public void write(CDRWriter cDRWriter) throws SystemException {
        super.write(cDRWriter);
        cDRWriter.write_long(this.requestId);
        cDRWriter.write_long(this.status);
        this.setHeaderWritten(true);
        if (Trc.enabled(5)) {
            Trc.info(Trc.FINEST, "offset = " + this.getWriteOffset(), CLASS, "write:161");
        }
    }

    @Override
    public void read(InputStream inputStream) throws SystemException {
        if (this.preGIOP12()) {
            this.requestId = inputStream.read_long();
            this.status = inputStream.read_long();
        } else {
            if (inputStream instanceof CDRInputHandler) {
                this.requestId = inputStream.read_long();
            }
            this.status = inputStream.read_long();
            if (this.status == 3) {
                this.status = 2;
            }
            if (this.status == 4) {
                String string = inputStream.read_string();
                this.exClassName = Utility.classNameOf(string);
                this.minorCode = inputStream.read_long();
                int n = inputStream.read_long();
                this.completionStatus = CompletionStatus.from_int((int)n);
            }
            if (this.status == 5) {
                this.addressingDisposition = inputStream.read_short();
                this.needsReAddressing = true;
            }
        }
        this.bodyOffset = ((CDRReader)inputStream).get_offset();
        if (Trc.enabled(5)) {
            Trc.info(Trc.FINEST, this + " bodyOffset =" + this.bodyOffset, CLASS, "read:207");
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.status);
        if (!this.preGIOP12()) {
            if (this.status == 4) {
                objectOutput.writeObject(this.exClassName);
                objectOutput.writeInt(this.minorCode);
                objectOutput.writeObject(this.completionStatus);
            } else if (this.status == 5) {
                objectOutput.writeShort(this.addressingDisposition);
                this.needsReAddressing = true;
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.status = objectInput.readInt();
        if (!this.preGIOP12()) {
            if (this.status == 4) {
                this.exClassName = (String)objectInput.readObject();
                this.minorCode = objectInput.readInt();
                this.completionStatus = (CompletionStatus)objectInput.readObject();
            } else if (this.status == 5) {
                this.addressingDisposition = objectInput.readShort();
                this.needsReAddressing = true;
            }
        }
    }
}

