/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.giop.GIOPOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBWorkQueueUsePolicy;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ConnectionKeyGeneratorImpl;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import java.util.Map;

public class IIOPChannelPluginImpl
implements IIOPChannelPlugin {
    private static final String CLASS = IIOPChannelPluginImpl.class.getName();
    private ORB orb;
    private int connectTimeout;
    private static ChannelFramework channelFramework = null;
    private String chainGroupName = null;
    private String outTCPChainName = null;
    private String inChainTPInUse = null;
    private String outChainTPInUse = null;
    private int tpMinSize = 0;
    private int tpMaxSize = 50;
    private int tpQueueSize = 1024;
    private long tpKeepAliveTime = 5000L;
    private String bufferSizeValue;

    @Override
    public void init(ORB oRB) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "init:124");
        }
        this.orb = oRB;
        if (channelFramework == null) {
            channelFramework = ChannelFrameworkFactory.getChannelFramework();
        }
        this.connectTimeout = oRB.getConnectTimeout();
        this.bufferSizeValue = Integer.toString(oRB.getReceiveBufferSize());
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "init:144");
        }
    }

    public synchronized void initTCPOutChain() {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "initTCPOutChain:162");
        }
        if (this.outTCPChainName != null) {
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, this.outTCPChainName + " already initialized", CLASS, "initTCPOutChain:169");
            }
            return;
        }
        String string = this.orb.getORBId();
        String string2 = "tcpOut-" + string;
        String string3 = "giopOut-" + string;
        String string4 = "orbOut-" + string;
        String string5 = "ORB-GIOP-TCP(Out)-" + string;
        try {
            channelFramework.addChannel(string2, TCPChannelFactory.class, null);
            channelFramework.addChannel(string3, GIOPOutboundChannelFactory.class, null);
            channelFramework.addChannel(string4, ORBOutboundChannelFactory.class, null);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPOutChain:187");
            return;
        }
        ChannelData channelData = channelFramework.getChannel(string2);
        Map map = channelData.getPropertyBag();
        String string6 = "TP-Out-" + string;
        ThreadPool threadPool = this.createThreadPool(string6);
        if (threadPool == null) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Default ThreadPool used", CLASS, "initTCPOutChain:202");
            }
        } else {
            map.put("threadPoolName", string6);
            this.outChainTPInUse = string6;
        }
        map.put("receiveBufferSize", this.bufferSizeValue);
        map.put("sendBufferSize", this.bufferSizeValue);
        try {
            channelFramework.addChain(string5, FlowType.OUTBOUND, new String[]{string4, string3, string2});
            this.outTCPChainName = string5;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPOutChain:223");
            return;
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, channelFramework.getChain(this.outTCPChainName).getName(), CLASS, "initTCPOutChain:227");
        }
    }

    @Override
    public ConnectionKeyGenerator getConnectionKeyGenerator(IOR iOR, ClientDelegate clientDelegate, String string) {
        if (this.outTCPChainName == null) {
            this.initTCPOutChain();
        }
        ConnectionKeyGeneratorImpl connectionKeyGeneratorImpl = new ConnectionKeyGeneratorImpl(iOR, clientDelegate, string, this.outTCPChainName, null, this.connectTimeout);
        return connectionKeyGeneratorImpl;
    }

    @Override
    public ChannelFramework getChannelFramework() {
        return channelFramework;
    }

    @Override
    public String getChainGroupName() {
        return this.chainGroupName;
    }

    public ThreadPool createThreadPool(String string) {
        ThreadPoolRepository threadPoolRepository = ThreadPoolRepositoryManager.getThreadPoolRepository();
        ThreadPool threadPool = null;
        try {
            threadPool = threadPoolRepository.createThreadPool(string, this.tpMinSize, this.tpMaxSize, this.tpKeepAliveTime, this.tpQueueSize);
        }
        catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
            Trc.ffdc("Unexpected exception creating ThreadPool '" + string + "': " + (Object)((Object)threadPoolAlreadyKnownException), CLASS, "initTCPChainGroup:317");
            threadPool = threadPoolRepository.getThreadPool(string);
        }
        return threadPool;
    }

    public void initTCPChainGroup(String string, int n) {
        if (Trc.enabled(2)) {
            Trc.begin2(Trc.FINEST, string, Trc.str(n), CLASS, "initTCPChainGroup:336");
        }
        String string2 = Integer.valueOf(n).toString();
        String string3 = this.orb.getORBId();
        String string4 = "tcpIn-" + string3;
        String string5 = "giopIn-" + string3;
        String string6 = "orbIn-" + string3;
        String string7 = "ORB-GIOP-TCP(In)-" + string3;
        this.chainGroupName = "ORBInbound-" + string3;
        try {
            channelFramework.addChannel(string4, TCPChannelFactory.class, null);
            channelFramework.addChannel(string5, GIOPInboundChannelFactory.class, null);
            channelFramework.addChannel(string6, ORBInboundChannelFactory.class, null);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPChainGroup:355 " + this.chainGroupName);
            return;
        }
        ChannelData channelData = channelFramework.getChannel(string4);
        Map map = channelData.getPropertyBag();
        String string8 = "TP-In-" + string3;
        ThreadPool threadPool = this.createThreadPool(string8);
        if (threadPool == null) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Default ThreadPool used", CLASS, "initTCPChainGroup:374");
            }
        } else {
            map.put("threadPoolName", string8);
            this.inChainTPInUse = string8;
        }
        map.put("newConnectionBufferSize", this.bufferSizeValue);
        map.put("receiveBufferSize", this.bufferSizeValue);
        map.put("sendBufferSize", this.bufferSizeValue);
        if (this.orb.getSocketQueueDepth() != 0) {
            map.put("listenBacklog", new Integer(this.orb.getSocketQueueDepth()).toString());
        }
        map.put("port", string2);
        try {
            channelFramework.addChain(string7, FlowType.INBOUND, new String[]{string4, string5, string6});
            channelFramework.addChainGroup(this.chainGroupName, new String[]{string7});
            channelFramework.initChainGroup(this.chainGroupName);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPChainGroup:411");
            return;
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, channelFramework.getChainGroup(this.chainGroupName).getName(), CLASS, "initTCPChainGroup:415");
        }
    }

    @Override
    public void shutdown() {
        if (Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, this.chainGroupName, CLASS, "shutdown:429 ");
        }
        try {
            ThreadPool threadPool;
            if (this.chainGroupName != null) {
                channelFramework.stopChainGroup(this.chainGroupName, 0L);
                channelFramework.destroyChainGroup(this.chainGroupName);
                channelFramework.removeChainGroup(this.chainGroupName);
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "removed ", this.chainGroupName, CLASS, "shutdown:439");
                }
            }
            ChainData[] chainDataArray = channelFramework.getRunningChains(GIOPInboundChannelFactory.class);
            ChainData[] chainDataArray2 = channelFramework.getRunningChains(GIOPOutboundChannelFactory.class);
            if (chainDataArray.length == 0 && chainDataArray2.length == 0) {
                channelFramework.destroy();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Destroyed CFW", CLASS, "shutdown:457");
                }
            }
            if (this.inChainTPInUse != null) {
                threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.inChainTPInUse);
                threadPool.shutdown();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Shutdown In-Chain ThreadPool ", this.inChainTPInUse, CLASS, "shutdown:470");
                }
            }
            if (this.outChainTPInUse != null) {
                threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.outChainTPInUse);
                threadPool.shutdown();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Shutdown Out-Chain ThreadPool ", this.outChainTPInUse, CLASS, "shutdown:479");
                }
            }
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "shutdown:485");
            return;
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "shutdown:489");
        }
    }

    @Override
    public Object getServerConnectionData(GIOPConnectionContext gIOPConnectionContext) {
        return null;
    }

    @Override
    public ORBWorkQueueUsePolicy getOrbWorkQueueUsePolicy() {
        return ORBWorkQueueUsePolicy.ALWAYS;
    }

    @Override
    public int nextRequestId(GIOPConnectionContext gIOPConnectionContext) {
        return 0;
    }
}

