/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.SocketConnection;
import com.ibm.CORBA.transport.TransportConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public abstract class TransportConnectionBase
implements TransportConnection,
SocketConnection {
    private static final String CLASS = TransportConnectionBase.class.getName();
    private int MAX_SOCKET_RETRIES;
    private Socket socket;
    private ConnectionKey key;
    private ORBConnection conn;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ReaderPool readerPool;
    private ConnectionTable table;
    private Object readerHandle;
    private ORBForTransports orbForTransports;
    private String remoteHostName;
    private int remotePort;
    private String remoteHost;
    private String localHostName;
    private int localPort;
    private String localHost;
    private InetAddress localInetAddress;
    private int connectTimeout;
    private static final String DEFAULT_LOCAL_HOST = "127.0.0.1";
    private static final String DEFAULT_LOCAL_HOST_NAME = "localHost";
    private String theParameterString;

    protected TransportConnectionBase(ConnectionTable connectionTable, Socket socket, ReaderPool readerPool, ORBForTransports oRBForTransports) {
        block6: {
            this.MAX_SOCKET_RETRIES = 5;
            this.socket = null;
            this.key = null;
            this.conn = null;
            this.inputStream = null;
            this.outputStream = null;
            this.readerPool = null;
            this.table = null;
            this.readerHandle = null;
            this.orbForTransports = null;
            this.remoteHostName = null;
            this.remotePort = 0;
            this.remoteHost = null;
            this.localHostName = null;
            this.localPort = -1;
            this.localHost = null;
            this.localInetAddress = null;
            this.connectTimeout = 0;
            this.theParameterString = null;
            if (Trc.enabled(3)) {
                Trc.begin1(Trc.FINEST, "socket=" + socket, CLASS, "<init> (server-side):166");
            }
            try {
                this.table = connectionTable;
                this.socket = socket;
                this.readerPool = readerPool;
                this.orbForTransports = oRBForTransports;
                this.getIOStreams();
                this.remoteHostName = socket.getInetAddress().getHostName();
                this.remotePort = socket.getPort();
                this.conn = oRBForTransports.createORBConnectionForServer();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "<init> (server-side):190");
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    if (!Trc.enabled()) break block6;
                    Trc.warn(exception2.toString(), CLASS, "<init> (server-side):197");
                }
            }
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "<init> (server-side):203");
        }
    }

    protected TransportConnectionBase(ORBForTransports oRBForTransports, ConnectionTable connectionTable, ConnectionKey connectionKey, ORBConnection oRBConnection, ReaderPool readerPool, Profile profile) {
        this.MAX_SOCKET_RETRIES = 5;
        this.socket = null;
        this.key = null;
        this.conn = null;
        this.inputStream = null;
        this.outputStream = null;
        this.readerPool = null;
        this.table = null;
        this.readerHandle = null;
        this.orbForTransports = null;
        this.remoteHostName = null;
        this.remotePort = 0;
        this.remoteHost = null;
        this.localHostName = null;
        this.localPort = -1;
        this.localHost = null;
        this.localInetAddress = null;
        this.connectTimeout = 0;
        this.theParameterString = null;
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, "key=" + connectionKey, CLASS, "<init> (client-side):240");
        }
        this.orbForTransports = oRBForTransports;
        this.table = connectionTable;
        this.key = connectionKey;
        this.conn = oRBConnection;
        this.readerPool = readerPool;
        try {
            this.remoteHostName = profile.getHostIPAddress();
        }
        catch (Exception exception) {
            this.remoteHostName = profile.getHost();
        }
        this.remotePort = profile.getPort();
        this.localInetAddress = this.getLocalInetAddress();
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, "localHost=" + this.localInetAddress, CLASS, "<init> (client-side):258");
        }
        this.connectTimeout = oRBForTransports.getConnectTimeout();
    }

    private InetAddress getLocalInetAddress() {
        InetAddress inetAddress = null;
        Object object = this.orbForTransports.getTransportData();
        if (object == null) {
            String string = this.orbForTransports.getUserSpecifiedLocalHost();
            if (string != null && string.length() > 0) {
                try {
                    inetAddress = InetAddress.getByName(string);
                    this.localHost = inetAddress.getHostAddress();
                    this.localHostName = inetAddress.getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    Trc.ffdc(unknownHostException, CLASS, "getLocalInetAddress:287");
                }
            }
            if (inetAddress == null) {
                this.localHost = DEFAULT_LOCAL_HOST;
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            } else {
                this.localHost = inetAddress.getHostAddress();
                this.localHostName = inetAddress.getHostName();
            }
            this.orbForTransports.setTransportData(inetAddress);
        } else {
            inetAddress = (InetAddress)object;
        }
        return inetAddress;
    }

    private void getIOStreams() {
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "getIOStreams:321");
            TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":socket=" + this.socket, 1229127173, CompletionStatus.COMPLETED_NO);
            tRANSIENT.initCause((Throwable)exception);
            throw tRANSIENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect() {
        int n = 0;
        while (true) {
            try {
                block19: {
                    this.socket = this.localInetAddress == null ? this.createSocket(this.remoteHostName, this.remotePort) : this.createSocket(new InetSocketAddress(this.remoteHostName, this.remotePort), new InetSocketAddress(this.localInetAddress, 0));
                    if (Trc.enabled(3)) {
                        Trc.info(Trc.FINEST, "new socket " + this.socket, CLASS, "connect:355");
                    }
                    try {
                        this.socket.setKeepAlive(true);
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {
                        if (!Trc.enabled()) break block19;
                        Trc.warn(exception.toString(), CLASS, "connect:363");
                    }
                }
                this.getIOStreams();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
                TransportConnectionBase transportConnectionBase = this;
                synchronized (transportConnectionBase) {
                    this.readerHandle = this.readerPool.addConnection(this.conn);
                }
            }
            catch (Exception exception) {
                boolean bl;
                boolean bl2 = bl = exception instanceof SocketException && !(exception instanceof BindException) && !(exception instanceof ConnectException) && !(exception instanceof NoRouteToHostException);
                if (Trc.enabled() || !(exception instanceof ConnectException) && !(exception instanceof SocketTimeoutException)) {
                    Trc.ffdc(exception, CLASS, "connect:389");
                }
                if (!bl || n == this.MAX_SOCKET_RETRIES || !this.table.cleanUp()) {
                    if (exception instanceof INTERNAL) {
                        try {
                            this.conn.cleanUp();
                        }
                        catch (Exception exception2) {}
                    } else {
                        this.table.removeConnection(this.conn);
                        this.conn.abortConnection();
                    }
                    if (exception instanceof SystemException) {
                        throw (SystemException)((Object)exception);
                    }
                    int n2 = exception instanceof SocketTimeoutException ? 1229127174 : 1229127170;
                    TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":host=" + this.remoteHostName + ",port=" + this.remotePort, n2, CompletionStatus.COMPLETED_NO);
                    tRANSIENT.initCause((Throwable)exception);
                    throw tRANSIENT;
                }
                ++n;
                continue;
            }
            catch (Error error) {
                Trc.ffdc(error.getMessage(), this.toString(), "connect:429");
                try {
                    this.conn.cleanUp();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection() {
        block7: {
            if (Trc.enabled(3)) {
                Trc.begin1(Trc.FINEST, "socket=" + this.socket, CLASS, "removeConnection:456");
            }
            this.table.removeConnection(this.conn);
            TransportConnectionBase transportConnectionBase = this;
            synchronized (transportConnectionBase) {
                this.readerPool.removeConnection(this.conn, this.readerHandle);
                this.readerHandle = null;
            }
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.socket.close();
            }
            catch (Exception exception) {
                if (!Trc.enabled()) break block7;
                Trc.warn(exception.toString(), CLASS, "removeConnection:476");
            }
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "removeConnection:479");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateServer() {
        this.key = this.createKey(this.remoteHostName, this.remotePort);
        this.table.addConnection(this.key, this.conn);
        this.table.checkConnectionTable();
        try {
            TransportConnectionBase transportConnectionBase = this;
            synchronized (transportConnectionBase) {
                this.readerHandle = this.readerPool.addConnection(this.conn);
            }
        }
        catch (INTERNAL iNTERNAL) {
            try {
                this.conn.cleanUp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iNTERNAL;
        }
        catch (Error error) {
            try {
                this.conn.cleanUp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trc.ffdc(error.getMessage(), this.toString(), "activateServer:520");
            throw error;
        }
    }

    @Override
    public String getConnectionParameterString() {
        if (this.theParameterString == null) {
            String string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            String string2 = n == -1 ? string : string.substring(n + 1);
            this.theParameterString = string2 + "[addr=" + this.getRemoteHost() + ",port=" + this.getRemotePort() + ",local=" + this.getLocalPort() + "]";
        }
        return this.theParameterString;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " socket=" + this.socket + " key=" + this.key;
    }

    public abstract ConnectionKey createKey(String var1, int var2);

    public Socket createSocket(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) throws Exception {
        if (Trc.enabled()) {
            Trc.warn("createSocket(InetAddress remote,  InetAddress local) is not implemented by this transport. Using default values for local address.", CLASS, "createSocket:602");
        }
        return this.createSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    public abstract Socket createSocket(String var1, int var2) throws Exception;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public abstract Object getConnectionData();

    public ORBForTransports getORBForTransports() {
        return this.orbForTransports;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null && this.socket != null) {
            this.remoteHost = this.socket.getInetAddress().getHostAddress();
        }
        return this.remoteHost;
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort < 0 && this.socket != null) {
            this.localPort = this.socket.getLocalPort();
        }
        return this.localPort;
    }

    @Override
    public String getLocalHost() {
        if (this.localHost == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST;
            }
            this.localHost = this.socket.getLocalAddress().getHostAddress();
        }
        return this.localHost;
    }

    @Override
    public String getLocalHostName() {
        if (this.localHostName == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST_NAME;
            }
            try {
                this.localHostName = this.socket.getLocalAddress().getHostName();
            }
            catch (Throwable throwable) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
            if (this.localHostName == null) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
        }
        return this.localHostName;
    }

    @Override
    public void preWrite(boolean bl) {
    }

    @Override
    public void preReply() {
    }
}

