/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.iiop;

import com.ibm.CORBA.iiop.UserKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.UserKeyImpl;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.Validator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;

public class ObjectKey
implements Externalizable {
    private static final String CLASS = "ObjectKey";
    private ByteBuffer objectKeyBuffer;
    private UserKey userKey;
    private final Object lockObject = new NamedLockObject();
    public static final int INVALID_SERVER_ID = -1;
    private static final int JMBI_VERSION = 74;
    private static final int KMBI_VERSION = 75;
    private static final int LMBI_VERSION = 76;
    private static final int XMBI_MAGIC = 5063241;
    private static final String MBI_MAGIC_SUFFIX = "MBI";
    private static final int IBM_OBJECTKEY_SIZE = 14;
    private static final int IBM_MAGIC_OFFSET = 0;
    private static final int IBM_SCID_OFFSET = 4;
    private static final int IBM_SERVERID_OFFSET = 8;
    private static final int IBM_USERKEYOFFSET_OFFSET = 12;
    private static final int IBM_USERKEYLEN_SIZE = 2;
    private static final int IBM_POANAMELEN_SIZE = 2;
    private static final int JMBI_SERVERUUID_SIZE = 16;
    private static final int JMBI_SERVERUUID_OFFSET = 12;
    private static final int JMBI_USERKEYOFFSET_OFFSET = 28;
    private static final int JMBI_OBJECTKEY_SIZE = 36;
    private static final int JMBI_USERKEYLEN_OFFSET = 32;
    private static final int JMBI_USERKEY_OFFSET = 36;
    private String stringOfKey = null;
    private int hash = 0;
    private static final ObjectKey SINOObjectKey = new ObjectKey(new byte[]{73, 78, 73, 84});
    private static final ObjectKey SINOObjectKeyReversed = new ObjectKey(new byte[]{84, 73, 78, 73});

    public ObjectKey() {
    }

    public ObjectKey(byte[] byArray) {
        byte[] byArray2;
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, Trc.hex(byArray), CLASS, "<init>:351");
        }
        if (byArray == null) {
            throw new BAD_PARAM("null parameter passed to ObjectKey(byte[])", 1229124141, CompletionStatus.COMPLETED_NO);
        }
        this.objectKeyBuffer = ByteBuffer.wrap(byArray);
        this.userKey = null;
        if (this.isMBI() && (byArray2 = this.getUserKeyBytes()) != null) {
            this.userKey = new UserKeyImpl(byArray2);
        }
    }

    public ObjectKey(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, Trc.hex(byteBuffer), CLASS, "<init>:383");
        }
        if (byteBuffer == null) {
            throw new BAD_PARAM("null parameter passed to ObjectKey(ByteBuffer)", 1229124141, CompletionStatus.COMPLETED_NO);
        }
        this.objectKeyBuffer = byteBuffer;
        this.userKey = null;
        if (this.isMBI() && (byArray = this.getUserKeyBytes()) != null) {
            this.userKey = new UserKeyImpl(byArray);
        }
    }

    public ObjectKey(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, null);
    }

    public ObjectKey(int n, int n2, int n3, UserKey userKey) {
        this(n, n2, n3, userKey, null);
    }

    public ObjectKey(int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        this.createObjectKey(n, n2, n3, byArray, byArray2);
        this.userKey = new UserKeyImpl(byArray);
    }

    public ObjectKey(int n, int n2, int n3, UserKey userKey, byte[] byArray) {
        if (userKey == null) {
            throw new NullPointerException("null UserKey");
        }
        this.createObjectKey(n, n2, n3, userKey.getBytes(), byArray);
        this.userKey = userKey;
    }

    private void createObjectKey(int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        int n4;
        if (Trc.enabled(1)) {
            String string = Trc.concat("magic=", Trc.hex(n), ",subcontractId=", Trc.hex(n2), ",serverId=", Trc.hex(n3), ",userKey=", Trc.hex(byArray), ",poaName=", Trc.hex(byArray2));
            Trc.begin1(Trc.FINER, string, CLASS, "createObjectKey:482");
        }
        int n5 = n >>> 24;
        int n6 = 0;
        int n7 = 0;
        switch (n5) {
            case 74: {
                n7 = 36 + byArray.length;
                break;
            }
            case 75: {
                n7 = 16 + byArray.length;
                break;
            }
            default: {
                n6 = byArray2 == null ? 2 : byArray2.length + 2;
                n4 = 2 + byArray.length;
                n7 = 14 + n6 + n4;
            }
        }
        this.objectKeyBuffer = ByteBuffer.allocate(n7);
        this.objectKeyBuffer.putInt(n);
        this.objectKeyBuffer.putInt(n2);
        this.objectKeyBuffer.putInt(n3);
        switch (n5) {
            case 74: {
                this.objectKeyBuffer.position(28);
                this.objectKeyBuffer.putInt(36);
                this.objectKeyBuffer.putInt(byArray.length);
                this.objectKeyBuffer.put(byArray, 0, byArray.length);
                break;
            }
            case 75: {
                this.objectKeyBuffer.putShort((short)14);
                this.objectKeyBuffer.putShort((short)byArray.length);
                this.objectKeyBuffer.put(byArray, 0, byArray.length);
                break;
            }
            default: {
                this.objectKeyBuffer.position(14);
                if (byArray2 != null) {
                    this.objectKeyBuffer.putShort((short)byArray2.length);
                    this.objectKeyBuffer.put(byArray2, 0, byArray2.length);
                } else {
                    this.objectKeyBuffer.putShort((short)0);
                }
                this.objectKeyBuffer.position(12);
                n4 = 14 + n6;
                this.objectKeyBuffer.putShort((short)n4);
                this.objectKeyBuffer.position(n4);
                this.objectKeyBuffer.putShort((short)byArray.length);
                this.objectKeyBuffer.put(byArray, 0, byArray.length);
            }
        }
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINER, Trc.hex(this.objectKeyBuffer), CLASS, "createObjectKey:540");
        }
    }

    public int getMagic() {
        int n = this._getMagic();
        if (n != 0) {
            return n;
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error extracting magic ", this, CLASS, "getMagic:561");
        }
        throw new INV_OBJREF("Malformed objectKey - error extracting magic.", 1229125523, CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getMagic() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.objectKeyBuffer.limit() >= 4) {
                return this.objectKeyBuffer.getInt(0);
            }
        }
        return 0;
    }

    public boolean isMBI() {
        return ObjectKey.isMBI(this._getMagic());
    }

    public static boolean isMBI(int n) {
        return (n & 0xFFFFFF) == 5063241;
    }

    public static boolean isMBI(String string) {
        return string != null && string.length() >= 4 && string.regionMatches(1, MBI_MAGIC_SUFFIX, 0, 3);
    }

    public int getVersion() {
        return this._getMagic() >>> 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSCID() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isMBI() && this.objectKeyBuffer.limit() >= 8) {
                return this.objectKeyBuffer.getInt(4);
            }
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error getting Subcontract ID ", this, CLASS, "getSCID:638");
        }
        throw new INV_OBJREF("Malformed objectKey - error getting SCID.", 1229125524, CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSCID(int n) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINER, Trc.concat("subcontractId=", Trc.hex(n)), CLASS, "setSCID:654");
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isMBI() && this.objectKeyBuffer.limit() >= 8) {
                this.objectKeyBuffer.position(4);
                this.objectKeyBuffer.putInt(n);
                this.stringOfKey = null;
                this.hash = 0;
                return;
            }
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error setting Subcontract ID ", this, CLASS, "setSCID:667");
        }
        throw new INV_OBJREF("Malformed objectKey - error setting SCID.", 1229125529, CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerId() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.objectKeyBuffer.limit() >= 12) {
                return this.objectKeyBuffer.getInt(8);
            }
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error getting Server ID ", this, CLASS, "getServerId:690");
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerId(int n) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINER, Trc.concat("serverId=", Trc.hex(n)), CLASS, "setServerId:704");
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isMBI() && this.objectKeyBuffer.limit() >= 12) {
                this.objectKeyBuffer.position(8);
                this.objectKeyBuffer.putInt(n);
                this.stringOfKey = null;
                this.hash = 0;
                return;
            }
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error setting Server ID ", this, CLASS, "setServerId:717");
        }
        throw new INV_OBJREF("Malformed objectKey - error setting ServerId.", 1229125530, CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getServerUUID() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.getVersion() != 74) {
                return null;
            }
            if (this.objectKeyBuffer.limit() >= 28) {
                byte[] byArray = new byte[16];
                this.objectKeyBuffer.position(12);
                this.objectKeyBuffer.get(byArray, 0, 16);
                return byArray;
            }
        }
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINER, "Malformed objectKey - error getting ServerUUID ", this, CLASS, "getServerUUID:749");
        }
        throw new INV_OBJREF("Malformed objectKey - error getting ServerUUID.", 1229125526, CompletionStatus.COMPLETED_MAYBE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerUUID(byte[] byArray) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINER, Trc.concat("serverId=", Trc.hex(byArray)), CLASS, "setServerUUID:770");
        }
        if (byArray == null) {
            if (Trc.enabled(1)) {
                Trc.info(Trc.FINER, "Malformed ServerUUID - serverUUID of null specified ", this, CLASS, "setServerUUID:778");
            }
            throw new BAD_PARAM("NULL ServerUUID specified", 1229124136, CompletionStatus.COMPLETED_MAYBE);
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.getVersion()) {
                case 74: {
                    if (byArray.length == 16) {
                        this.objectKeyBuffer.position(12);
                        this.objectKeyBuffer.put(byArray, 0, 16);
                        this.stringOfKey = null;
                        this.hash = 0;
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl) {
            if (Trc.enabled(1)) {
                Trc.info(Trc.FINER, "Malformed ServerUUID - invalid length = " + byArray.length, this, CLASS, "setServerUUID:807");
            }
            throw new BAD_PARAM("Invalid length ServerUUID specified", 1229124135, CompletionStatus.COMPLETED_MAYBE);
        }
        if (bl2) {
            if (Trc.enabled(1)) {
                Trc.info(Trc.FINER, "Malformed objectkey - Attempt to set a ServerUUID on a key type of " + this.getVersion(), this, CLASS, "setServerUUID:819");
            }
            throw new INV_OBJREF("ServerUUID specified for non-JMBI ObjectKey", 1229125527, CompletionStatus.COMPLETED_MAYBE);
        }
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINER, this, CLASS, "setServerUUID:827");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserKey getUserKeyObject() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isMBI()) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINER, "Malformed objectkey - Attempt to get a UserKey from a key type of " + this.getVersion(), this, CLASS, "getUserKeyObject:841");
                }
                throw new INV_OBJREF("Attempt to get user key from non-IBM objectKey", 1229125531, CompletionStatus.COMPLETED_MAYBE);
            }
            return this.userKey;
        }
    }

    public byte[] getUserKey() {
        return this.getUserKeyObject().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getUserKeyBytes() {
        byte[] byArray = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isMBI()) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINER, "Malformed objectkey - Attempt to get a UserKey from a key type of " + this.getVersion(), this, CLASS, "getUserKeyBytes:876");
                }
                throw new INV_OBJREF("Attempt to get user key from non-IBM objectKey", 1229125531, CompletionStatus.COMPLETED_MAYBE);
            }
            try {
                if (this.getVersion() == 74) {
                    int n = this.objectKeyBuffer.getInt(32);
                    if (n > 0) {
                        byArray = new byte[n];
                        int n2 = this.objectKeyBuffer.getInt(28);
                        this.objectKeyBuffer.position(n2);
                        this.objectKeyBuffer.get(byArray, 0, n);
                    }
                } else {
                    short s = this.objectKeyBuffer.getShort(12);
                    short s2 = this.objectKeyBuffer.getShort(s);
                    if (s2 > 0) {
                        byArray = new byte[s2];
                        this.objectKeyBuffer.position(s + 2);
                        this.objectKeyBuffer.get(byArray, 0, s2);
                    }
                }
            }
            catch (Exception exception) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINER, exception, CLASS, "getUserKeyBytes:909");
                }
                byArray = null;
            }
        }
        return byArray;
    }

    public void setUserKey(byte[] byArray) {
        this.setUserKey(new UserKeyImpl(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserKey(UserKey userKey) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINER, userKey, CLASS, "setUserKey:936");
        }
        if (userKey == null) {
            throw new NullPointerException("null UserKey");
        }
        int n = 0;
        if (this.userKey != null) {
            n = this.userKey.length();
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isMBI()) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINER, "Malformed objectkey - Attempt to set a UserKey in a key type of " + this.getVersion(), this, CLASS, "setUserKey:950");
                }
                throw new INV_OBJREF("Attempt to set user key in non-IBM objectKey", 1229125532, CompletionStatus.COMPLETED_MAYBE);
            }
            this.userKey = userKey;
            int n2 = this.objectKeyBuffer.limit() - n + userKey.length();
            if (n2 <= this.objectKeyBuffer.limit()) {
                this.objectKeyBuffer.limit(n2);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
                this.objectKeyBuffer.rewind();
                byteBuffer.rewind();
                byteBuffer.put(this.objectKeyBuffer);
                this.objectKeyBuffer = byteBuffer;
            }
            if (this.getVersion() == 74) {
                this.objectKeyBuffer.position(32);
                this.objectKeyBuffer.putInt(userKey.length());
            } else {
                short s = this.objectKeyBuffer.getShort(12);
                this.objectKeyBuffer.position(s);
                this.objectKeyBuffer.putShort((short)userKey.length());
            }
            this.objectKeyBuffer.put(userKey.getBytes(), 0, userKey.length());
            this.stringOfKey = null;
            this.hash = 0;
        }
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINER, this, CLASS, "setUserKey:990");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.objectKeyBuffer.hasArray()) {
                return this.objectKeyBuffer.array();
            }
            byte[] byArray = new byte[this.objectKeyBuffer.limit()];
            this.objectKeyBuffer.rewind();
            this.objectKeyBuffer.get(byArray);
            return byArray;
        }
    }

    public byte[] getObjectKey() {
        return this.getBytes();
    }

    public String toString() {
        if (this.stringOfKey == null) {
            this.stringOfKey = "0x" + Utility.bytesToHexString(this.getBytes());
        }
        return this.stringOfKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPOAName() {
        byte[] byArray = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isMBI() || this.getVersion() == 74 || this.getVersion() == 75) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINER, "Malformed objectkey - Attempt to get a POAName from a key type of " + this.getVersion(), this, CLASS, "getPOAName:1054");
                }
                return null;
            }
            try {
                short s = this.objectKeyBuffer.getShort(14);
                byArray = new byte[s];
                this.objectKeyBuffer.position(16);
                this.objectKeyBuffer.get(byArray, 0, s);
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "getPOAName:1066");
                throw new INV_OBJREF("Malformed objectKey - error extracting POA name.", 1229125528, CompletionStatus.COMPLETED_MAYBE);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            Object object = this.lockObject;
            synchronized (object) {
                byte[] byArray = this.getBytes();
                for (int i = 0; i < byArray.length; ++i) {
                    n = 31 * n + byArray[i];
                }
                this.hash = n;
            }
        }
        return n;
    }

    public boolean equals(ObjectKey objectKey) {
        return Arrays.equals(this.getBytes(), objectKey.getBytes());
    }

    public boolean equals(Object object) {
        return object instanceof ObjectKey && this.equals((ObjectKey)object);
    }

    public static ObjectKey getSINOKey() {
        return SINOObjectKey;
    }

    public boolean isSINO() {
        return this.equals(SINOObjectKey) || this.equals(SINOObjectKeyReversed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.objectKeyBuffer.limit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object = this.lockObject;
        synchronized (object) {
            byte[] byArray = this.getBytes();
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
            objectOutput.writeObject(this.userKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        boolean bl = Validator.isValidPostiveInteger(n);
        if (!bl) {
            throw new IOException("Invalid ObjectKey size " + n);
        }
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        Object object = this.lockObject;
        synchronized (object) {
            this.objectKeyBuffer = ByteBuffer.wrap(byArray);
            this.userKey = (UserKey)objectInput.readObject();
        }
    }

    private static class NamedLockObject {
        private NamedLockObject() {
        }
    }
}

