/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_GCM_PARAMS;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;

final class PKCS11Cipher {
    private boolean decrypting = false;
    private PKCS11Object key;
    private int mechanism;
    private int blocksize = 0;
    private boolean isWrap;
    private boolean isUpdate = false;
    private byte[] param = null;
    private CK_GCM_PARAMS ck_gcm_params = null;
    private int MAX_AAD = 0x100000;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher";

    protected PKCS11Cipher(int mechanism) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11Cipher", (Object)(" " + mechanism));
        }
        this.mechanism = mechanism;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11Cipher");
        }
    }

    protected void engineInit(Session session, int opmode, PKCS11Object key, byte[] param, int blocksize) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, param};
            debug.entry(16384L, (Object)className, "engineInit", parms);
        }
        this.isUpdate = false;
        if (key == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("No key given");
        }
        this.decrypting = opmode == 2 || opmode == 4;
        this.isWrap = opmode == 4 || opmode == 3;
        this.param = param;
        this.key = key;
        this.blocksize = blocksize;
        if (this.decrypting && !this.isWrap) {
            session.decryptInit(this.mechanism, param, key);
        } else if (!this.decrypting && !this.isWrap) {
            session.encryptInit(this.mechanism, param, key);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected void engineInitGCM(int opmode, PKCS11Object key, GCMParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params};
            debug.entry(16384L, (Object)className, "engineInitGCM", parms);
        }
        if (key == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInitGCM", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInitGCM");
            }
            throw new InvalidKeyException("No key given");
        }
        if (opmode == 3 || opmode == 4) {
            throw new PKCS11Exception("Wrap mode or Unwrap mode not supported for AES/GCM");
        }
        this.decrypting = opmode == 2;
        this.key = key;
        byte[] iv = params.getIV();
        if (iv.length < 1) {
            throw new InvalidAlgorithmParameterException("GCM IV length not supported.");
        }
        this.ck_gcm_params = new CK_GCM_PARAMS();
        this.ck_gcm_params.setIv(iv);
        this.ck_gcm_params.setTagBits(params.getTLen());
        this.ck_gcm_params.setAAD(new byte[0]);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitGCM");
        }
    }

    protected byte[] engineUpdate(Session session, byte[] input, int inputOffset, int inputLen) {
        byte[] output = null;
        byte[] out = null;
        int len = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        this.isUpdate = true;
        output = new byte[inputLen + this.blocksize];
        try {
            len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, 0) : session.encryptUpdate(input, inputOffset, inputLen, output, 0);
            if (len > output.length) {
                throw new PKCS11Exception(336);
            }
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, 0) : session.encryptUpdate(input, inputOffset, inputLen, output, 0);
                if (len > (output = new byte[len]).length) {
                    throw new PKCS11Exception(336);
                }
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(code);
        }
        if (len < output.length) {
            out = new byte[len];
            System.arraycopy(output, 0, out, 0, len);
        } else {
            out = output;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return out;
    }

    protected int engineUpdate(Session session, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int len = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (output == null || output.length - outputOffset < inputLen) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new ShortBufferException("Output buffer must be (at least) " + inputLen + " bytes long"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new ShortBufferException("Output buffer must be (at least) " + inputLen + " bytes long");
        }
        this.isUpdate = true;
        try {
            len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, outputOffset) : session.encryptUpdate(input, inputOffset, inputLen, output, outputOffset);
            if (len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineUpdate_3", (Throwable)new ShortBufferException("Output buffer must be (at least) " + len + " bytes long"));
                    debug.exit(16384L, (Object)className, "engineUpdate");
                }
                throw new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_4", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(code);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return len;
    }

    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{src, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)className, "engineUpdateAAD", parms);
        }
        if (src == null || offset < 0 || len < 0 || len + offset > src.length || this.ck_gcm_params.getAADLen() + len > this.MAX_AAD) {
            throw new IllegalArgumentException("Bad arguments");
        }
        int thisAADLen = this.ck_gcm_params.getAADLen();
        byte[] newAAD = new byte[thisAADLen + len];
        if (thisAADLen != 0) {
            System.arraycopy(this.ck_gcm_params.getAAD(), 0, newAAD, 0, thisAADLen);
        }
        System.arraycopy(src, offset, newAAD, thisAADLen, len);
        this.ck_gcm_params.setAAD(newAAD);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdateAAD");
        }
    }

    protected byte[] engineDoFinal(Session session, byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int len2;
        int len;
        byte[] out;
        byte[] output2;
        byte[] output;
        block34: {
            output = null;
            output2 = null;
            out = null;
            len = 0;
            len2 = 0;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(16384L, (Object)className, "engineDoFinal", parms);
            }
            if (this.isWrap) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This can not be called for (un)wrapping keys");
            }
            output = new byte[inputLen + this.blocksize];
            if (this.isUpdate) {
                int code;
                try {
                    if (inputLen > 0 && (len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, 0) : session.encryptUpdate(input, inputOffset, inputLen, output, 0)) > output.length) {
                        throw new PKCS11Exception(336);
                    }
                }
                catch (PKCS11Exception ex) {
                    code = ex.getCode();
                    if (code == 336) {
                        output = new byte[len];
                        try {
                            len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, 0) : session.encryptUpdate(input, inputOffset, inputLen, output, 0);
                            if (len > output.length) {
                                throw new PKCS11Exception(336);
                            }
                        }
                        catch (PKCS11Exception ex1) {
                            code = ex1.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_3", (Throwable)new PKCS11Exception(code));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(code);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_4", (Throwable)new PKCS11Exception(code));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(code);
                }
                output2 = new byte[inputLen + this.blocksize];
                try {
                    len2 = this.decrypting ? session.decryptFinal(output2, 0) : session.encryptFinal(output2, 0);
                    if (len2 > output2.length) {
                        throw new PKCS11Exception(336);
                    }
                    break block34;
                }
                catch (PKCS11Exception ex) {
                    code = ex.getCode();
                    if (code == 336) {
                        output2 = new byte[len2];
                        try {
                            len2 = this.decrypting ? session.decryptFinal(output2, 0) : session.encryptFinal(output2, 0);
                            if (len2 > output2.length) {
                                throw new PKCS11Exception(336);
                            }
                            break block34;
                        }
                        catch (PKCS11Exception ex1) {
                            code = ex1.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_6", (Throwable)new PKCS11Exception(code));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(code);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_7", (Throwable)new PKCS11Exception(code));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(code);
                }
            }
            try {
                len = this.decrypting ? session.decrypt(input, inputOffset, inputLen, output, 0) : session.encrypt(input, inputOffset, inputLen, output, 0);
                if (len > output.length) {
                    throw new PKCS11Exception(336);
                }
            }
            catch (PKCS11Exception ex) {
                int code = ex.getCode();
                if (code == 336) {
                    output = new byte[len];
                    try {
                        len = this.decrypting ? session.decrypt(input, inputOffset, inputLen, output, 0) : session.encrypt(input, inputOffset, inputLen, output, 0);
                        if (len > output.length) {
                            throw new PKCS11Exception(336);
                        }
                    }
                    catch (PKCS11Exception ex1) {
                        code = ex1.getCode();
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineDoFinal_9", (Throwable)new PKCS11Exception(code));
                            debug.exit(16384L, (Object)className, "engineDoFinal");
                        }
                        throw new PKCS11Exception(code);
                    }
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_10", (Throwable)ex);
                    debug.text(16384L, (Object)className, "engineDoFinal_10", "session handle = " + session.getID());
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new PKCS11Exception(code);
            }
            catch (Exception e) {
                System.out.println("here: " + e.getMessage());
            }
        }
        out = new byte[len + len2];
        System.arraycopy(output, 0, out, 0, len);
        if (len2 > 0) {
            System.arraycopy(output2, 0, out, len, len2);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return out;
    }

    protected int engineDoFinal(Session session, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int len = 0;
        int len2 = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineDoFinal", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineDoFinal");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (this.isUpdate) {
            if (inputLen > 0 && (len = this.decrypting ? session.decryptUpdate(input, inputOffset, inputLen, output, outputOffset) : session.encryptUpdate(input, inputOffset, inputLen, output, outputOffset)) > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
            len2 = this.decrypting ? session.decryptFinal(output, outputOffset + len) : session.encryptFinal(output, outputOffset + len);
            if (len2 + len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        } else {
            len = this.decrypting ? session.decrypt(input, inputOffset, inputLen, output, outputOffset) : session.encrypt(input, inputOffset, inputLen, output, outputOffset);
            if (len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return len + len2;
    }

    protected int engineDoFinalGCM(Session session, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws AEADBadTagException, ShortBufferException {
        int len = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineDoFinalGCM", parms);
        }
        byte[] inputBuffer = null;
        if (input == null || input.length == 0) {
            inputBuffer = new byte[]{};
        } else {
            inputBuffer = new byte[input.length];
            System.arraycopy(input, 0, inputBuffer, 0, input.length);
        }
        int tLen = this.ck_gcm_params.getTagBits();
        if (this.decrypting && inputBuffer.length < tLen / 8) {
            throw new IllegalArgumentException("Decrypting in GCM mode. The input buffer length must be at least as long as the Authentication tag.");
        }
        if (this.decrypting && inputLen < tLen / 8) {
            throw new IllegalArgumentException("Decrypting in GCM mode. The input length (inputLen) must be at least as long as the Authentication tag.");
        }
        if (0 == inputLen && 0 == this.ck_gcm_params.getAADLen()) {
            throw new IllegalArgumentException("In GCM mode. Input length and AAD length cannot both be zero.");
        }
        if (output == null) {
            throw new IllegalArgumentException("Bad arguments, output is null.");
        }
        try {
            len = this.decrypting ? session.decryptDoFinalGCM(this.mechanism, this.ck_gcm_params, this.key, inputBuffer, inputOffset, inputLen, output, outputOffset) : session.encryptDoFinalGCM(this.mechanism, this.ck_gcm_params, this.key, inputBuffer, inputOffset, inputLen, output, outputOffset);
        }
        catch (PKCS11Exception pe) {
            String exMsg = pe.getMessage();
            if (exMsg.equalsIgnoreCase("Mechanism parameter is invalid")) {
                throw new AEADBadTagException("The Authentication Tag is not correct.");
            }
            if (exMsg.equalsIgnoreCase("Encrypted data is invalid")) {
                throw new PKCS11Exception("Operation failed, this is caused by either an invalid IV, tLen or AAD.");
            }
            throw pe;
        }
        if (len > output.length - outputOffset) {
            throw new ShortBufferException("Buffer too small");
        }
        this.ck_gcm_params.setAAD(new byte[0]);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinalGCM");
        }
        return len;
    }

    protected byte[] engineWrap(Session session, PKCS11Object key, int length) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] tempresult = new byte[length];
        byte[] result = null;
        int len = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineWrap");
        }
        try {
            len = session.wrapKey(this.mechanism, this.param, this.key, key, tempresult, 0);
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                tempresult = new byte[len];
                try {
                    len = session.wrapKey(this.mechanism, this.param, this.key, key, tempresult, 0);
                }
                catch (PKCS11Exception ex1) {
                    int code1 = ex1.getCode();
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineWrap_1", (Throwable)new PKCS11Exception(code1));
                        debug.exit(16384L, (Object)className, "engineWrap");
                    }
                    throw new PKCS11Exception(code1);
                }
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineWrap_2", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineWrap");
            }
            throw new PKCS11Exception(code);
        }
        result = new byte[len];
        System.arraycopy(tempresult, 0, result, 0, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineWrap");
        }
        return result;
    }

    protected PKCS11Object engineUnwrap(Session session, byte[] wrappedKey, int[] attrTypes, Object[] attrValues) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUnwrap");
        }
        PKCS11Object result = session.unwrapKey(this.mechanism, this.param, this.key, wrappedKey, 0, wrappedKey.length, attrTypes, attrValues);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUnwrap");
        }
        return result;
    }

    boolean isDecrypting() {
        return this.decrypting;
    }

    protected int getGCMTagBits() {
        if (this.ck_gcm_params != null) {
            return this.ck_gcm_params.getTagBits();
        }
        return 0;
    }

    protected byte[] getGCMIV() {
        if (this.ck_gcm_params != null) {
            return this.ck_gcm_params.getIv();
        }
        return null;
    }
}

