/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.util.Date;

public class GeneralKey
implements GeneralPKCS11Key,
Serializable {
    private static final long serialVersionUID = 3617574881836020272L;
    private PKCS11Object object = null;
    private Session session = null;
    private SessionManager sessionManager;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private Boolean isSensitive = null;
    private Boolean isEncrypt = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isVerify = null;
    private Boolean isWrap = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private int keySize = -1;
    private byte[] value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralKey";
    KeyMechanismBuilder mechanismBuilder;

    GeneralKey(Session session, PKCS11Object object, String algorithm) throws InvalidKeyException {
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        Integer keyType = this.mechanismBuilder.getKeyType();
        this.sessionManager = session.getSessionManager();
        this.object = object;
    }

    void setSession(Session sess) {
        this.session = sess;
    }

    @Override
    public byte[] getEncoded() {
        if (this.getValue() != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    @Override
    public int getValueLen() {
        return this.getKeySizeInBytes();
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken == null && this.object != null) {
            this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        }
        if (debug != null) {
            System.out.println("GeneralKey.java:  getToken( ):  Returning a value of:  " + this.isToken);
        }
        return this.isToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.object != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.session = null;
                this.object = null;
            }
            catch (Exception exception) {}
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this GeneralKey object since it is a session key.");
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this GeneralKey object since it is a token.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    @Override
    public Boolean getPrivate() {
        if (this.isPrivate == null && this.object != null) {
            this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        }
        return this.isPrivate;
    }

    @Override
    public String getLabel() {
        if (this.label == null && this.object != null) {
            this.label = (String)this.getAttrValue(this.object, 3);
        }
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        if (this.isModifiable == null && this.object != null) {
            this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        }
        return this.isModifiable;
    }

    @Override
    public Integer getKeyType() {
        return this.mechanismBuilder.getKeyType();
    }

    @Override
    public byte[] getID() {
        if (this.ID == null && this.object != null) {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (this.ID != null) {
            return (byte[])this.ID.clone();
        }
        return null;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == null && this.object != null) {
            this.startDate = (Date)this.getAttrValue(this.object, 272);
        }
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null && this.object != null) {
            this.endDate = (Date)this.getAttrValue(this.object, 273);
        }
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    @Override
    public Boolean getDerive() {
        if (this.isDerive == null && this.object != null) {
            this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        }
        return this.isDerive;
    }

    @Override
    public Boolean getLocal() {
        if (this.isLocal == null && this.object != null) {
            this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        }
        return this.isLocal;
    }

    @Override
    public Boolean getSensitive() {
        if (this.isSensitive == null && this.object != null) {
            this.isSensitive = (Boolean)this.getAttrValue(this.object, 259);
        }
        return this.isSensitive;
    }

    @Override
    public Boolean getEncrypt() {
        if (this.isEncrypt == null && this.object != null) {
            this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        }
        return this.isEncrypt;
    }

    @Override
    public Boolean getDecrypt() {
        if (this.isDecrypt == null && this.object != null) {
            this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        }
        return this.isDecrypt;
    }

    public Boolean getSign() {
        if (this.isSign == null && this.object != null) {
            this.isSign = (Boolean)this.getAttrValue(this.object, 264);
        }
        return this.isSign;
    }

    @Override
    public Boolean getVerify() {
        if (this.isVerify == null && this.object != null) {
            this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        }
        return this.isVerify;
    }

    @Override
    public Boolean getWrap() {
        if (this.isWrap == null && this.object != null) {
            this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
        }
        return this.isWrap;
    }

    @Override
    public Boolean getUnwrap() {
        if (this.isUnwrap == null && this.object != null) {
            this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        }
        return this.isUnwrap;
    }

    public Boolean getExtractable() {
        if (this.isExtractable == null && this.object != null) {
            this.isExtractable = (Boolean)this.getAttrValue(this.object, 354);
        }
        return this.isExtractable;
    }

    @Override
    public Boolean getAlwaysSensitive() {
        if (this.isAlwaysSensitive == null && this.object != null) {
            this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        }
        return this.isAlwaysSensitive;
    }

    @Override
    public Boolean getNeverExtractable() {
        if (this.isNeverExtractable == null && this.object != null) {
            this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
        }
        return this.isNeverExtractable;
    }

    @Override
    public byte[] getValue() {
        if (this.getSensitive() != null && !this.getSensitive().booleanValue()) {
            if (this.value == null && this.object != null) {
                byte[] tempValue = (byte[])this.getAttrValue(this.object, 17);
                this.value = new byte[tempValue.length];
                System.arraycopy(tempValue, 0, this.value, 0, tempValue.length);
            }
            return this.value;
        }
        return null;
    }

    public int getKeySizeInBytes() {
        Integer intKeySize;
        if (this.keySize == -1 && this.object != null && (intKeySize = (Integer)this.getAttrValue(this.object, 353)) != null) {
            this.keySize = intKeySize;
        }
        return this.keySize;
    }

    public Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " General Key: ";
        output = output + "\n Token: ";
        if (this.getToken() != null) {
            output = output + this.isToken;
        }
        output = output + "\n Private: ";
        if (this.getPrivate() != null) {
            output = output + this.isPrivate;
        }
        output = output + "\n Label: ";
        if (this.getLabel() != null) {
            output = output + this.label;
        }
        output = output + "\n Modifiable: ";
        if (this.getModifiable() != null) {
            output = output + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.mechanismBuilder.getAlgorithm();
        output = output + "\n ID: ";
        if (this.getID() != null) {
            try {
                output = output + new String(this.ID, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + new String(this.ID);
            }
        }
        output = output + "\n Start Date: ";
        if (this.getStartDate() != null) {
            output = output + this.startDate.toString();
        }
        output = output + "\n End Date: ";
        if (this.getEndDate() != null) {
            output = output + this.endDate.toString();
        }
        output = output + "\n Derive: ";
        if (this.getDerive() != null) {
            output = output + this.isDerive;
        }
        output = output + "\n Local: ";
        if (this.getLocal() != null) {
            output = output + this.isLocal;
        }
        output = output + "\n Sensitive: ";
        if (this.getSensitive() != null) {
            output = output + this.isSensitive;
        }
        output = output + "\n Encrypt: ";
        if (this.getEncrypt() != null) {
            output = output + this.isEncrypt;
        }
        output = output + "\n Decrypt: ";
        if (this.getDecrypt() != null) {
            output = output + this.isDecrypt;
        }
        output = output + "\n Sign: ";
        if (this.getSign() != null) {
            output = output + this.isSign;
        }
        output = output + "\n Verify: ";
        if (this.getVerify() != null) {
            output = output + this.isVerify;
        }
        output = output + "\n Wrap: ";
        if (this.getWrap() != null) {
            output = output + this.isWrap;
        }
        output = output + "\n Unwrap: ";
        if (this.getUnwrap() != null) {
            output = output + this.isUnwrap;
        }
        output = output + "\n Extractable: ";
        if (this.getExtractable() != null) {
            output = output + this.isExtractable;
        }
        output = output + "\n Always Sensitive: ";
        if (this.getAlwaysSensitive() != null) {
            output = output + this.isAlwaysSensitive;
        }
        output = output + "\n Never Extractable: ";
        if (this.getNeverExtractable() != null) {
            output = output + this.isNeverExtractable;
        }
        output = output + "\n Value: ";
        if (this.getValue() != null) {
            output = output + this.value.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        int temp = this.getKeySizeInBytes();
        if (temp != -1) {
            output = output + "\n KeySize in bytes: " + this.getKeySizeInBytes();
        }
        return output;
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public String getAlgorithm() {
        return this.mechanismBuilder.getAlgorithm();
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object value = null;
        Session session = this.sessionManager.getOpSession();
        value = session.getAttrValue(pkcs11obj, attr);
        this.sessionManager.releaseSession(session);
        return value;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setKeyAsToken(boolean token) {
        this.isToken = token;
    }
}

