/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

final class C14nUtil {
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static final String RELATIVE_URI_MESSAGE = "Relative URI namespaces are not permitted.\nhttp://www.w3.org/TR/2001/REC-xml-c14n-20010315#DataModel\n<quote>\nNote: This specification supports the recent XML plenary decision\nto deprecate relative namespace URIs as follows: implementations\nof XML canonicalization MUST report an operation failure on\ndocuments containing relative namespace URIs. XML canonicalization\nMUST NOT be implemented with an XML parser that converts relative\nURIs to absolute URIs.\n</quote>\n";
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int[] fixTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, -2048, -2048, -2048, -2048};

    C14nUtil() {
    }

    static final void serializeText(String text, Writer wr) throws IOException {
        int len = text.length();
        int start = -1;
        for (int i = 0; i < len; ++i) {
            String escaped;
            char ch = text.charAt(i);
            String string = escaped = ch < '@' ? textTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            wr.write(text, start, len - start);
        }
    }

    static final void serializePI(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        ProcessingInstruction pi = (ProcessingInstruction)node;
        if (greater) {
            wr.write("\n");
        }
        wr.write("<?");
        wr.write(pi.getTarget());
        if (pi.getData() != null && pi.getData().length() > 0) {
            wr.write(" ");
            String data = pi.getData();
            int start = 0;
            for (int index = 0; index < data.length(); ++index) {
                if (data.charAt(index) != '\r') continue;
                if (index > start) {
                    wr.write(data, start, index - start);
                }
                wr.write("&#xD;");
                start = index + 1;
            }
            if (start < data.length()) {
                wr.write(data, start, data.length() - start);
            }
        }
        wr.write("?>");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeComment(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        if (greater) {
            wr.write("\n");
        }
        wr.write("<!--");
        wr.write(node.getNodeValue());
        wr.write("-->");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeAttribute(Node attr, Writer wr, boolean checkURI) throws IOException, XMLSignatureException {
        C14nUtil.serializeAttribute(attr.getNodeName(), attr.getNodeValue(), wr, checkURI);
    }

    static final void serializeAttribute(String name, String value, Writer wr, boolean checkURI) throws IOException, XMLSignatureException {
        int len = value.length();
        int start = -1;
        boolean hasColon = false;
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start < 0) {
                start = j;
            }
            if (!checkURI) continue;
            if (ch == ':') {
                hasColon = true;
                continue;
            }
            if (ch != '/' || hasColon) continue;
            throw new XMLSignatureException("Found a relative URI: " + name + "='" + value + "'\n" + RELATIVE_URI_MESSAGE);
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        if (value.length() > 0 && checkURI && !hasColon) {
            throw new XMLSignatureException("Found a relative URI: " + name + "='" + value + "'\n" + RELATIVE_URI_MESSAGE);
        }
        wr.write("\"");
    }

    static void heapSort(int[] indexMap, String[] pd, int length) {
        int i;
        for (i = length / 2; i >= 0; --i) {
            C14nUtil.fall(indexMap, pd, length, i);
        }
        for (i = length - 1; i > 0; --i) {
            int t = indexMap[0];
            indexMap[0] = indexMap[i];
            indexMap[i] = t;
            C14nUtil.fall(indexMap, pd, i, 0);
        }
    }

    private static void fall(int[] indexMap, String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > pd[indexMap[j]].compareTo(pd[indexMap[j + 1]])) {
                j = 2 * i + 2;
            }
            if (0 > C14nUtil.compareInUCS(pd[indexMap[i]], pd[indexMap[j]])) {
                int t = indexMap[i];
                indexMap[i] = indexMap[j];
                indexMap[j] = t;
                C14nUtil.fall(indexMap, pd, n, j);
            }
        }
    }

    private static final int compareInUCS(String s1, String s2) {
        int len2;
        int len1 = s1.length();
        int minlen = len1 < (len2 = s2.length()) ? len1 : len2;
        int i1 = 0;
        int i2 = 0;
        while (minlen-- != 0) {
            int c1 = s1.charAt(i1++);
            c1 += fixTable[c1 >> 11];
            int c2 = s2.charAt(i2++);
            if (c1 == (c2 += fixTable[c2 >> 11])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    static String createSortedString(Attr node, Node element) {
        if (node.getNodeType() != 2) {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        String name = node.getNodeName();
        if (name.equals("xmlns")) {
            return "\u0000";
        }
        String prefix = node.getPrefix();
        if (prefix == null) {
            return "\u0001" + name;
        }
        if (prefix.equals("xmlns")) {
            return "\u0000" + node.getLocalName();
        }
        String uri = node.getNamespaceURI();
        String ret = uri == null || uri.length() == 0 ? "\u0001" + name : uri + "\u0001" + node.getLocalName();
        return ret;
    }

    static boolean isAncestor(Object me, Node anc) {
        Node parent = me instanceof Attributes ? ((Attributes)me).parent : (Node)me;
        while (parent != anc) {
            if ((parent = parent.getNodeType() == 2 ? ((Attr)parent).getOwnerElement() : parent.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeAttributes(Node node, NamedNodeMap attributes, Writer wr) throws IOException, XMLSignatureException {
        int numAttributes = attributes.getLength();
        Node[] array = new Node[numAttributes];
        int n = 0;
        for (int j = 0; j < numAttributes; ++j) {
            Node parentNode;
            Node a = attributes.item(j);
            String name = a.getNodeName();
            String value = a.getNodeValue();
            if (name.equals("xmlns") && value.equals("http://www.w3.org/2000/09/xmldsig#")) {
                array[n++] = a;
                continue;
            }
            if (name.equals("xml") || name.startsWith("xml:")) continue;
            boolean ignore = false;
            for (parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                Hashtable nsTable = C14nUtil.collectNamespaceNodesInAncestors(parentNode, false);
                Enumeration elements = nsTable.elements();
                if (!nsTable.containsKey(name)) continue;
                Attr av = (Attr)nsTable.get(name);
                if (!av.getValue().equals(value)) break;
                ignore = true;
                break;
            }
            if (ignore) continue;
            if (!ignore && parentNode != null) {
                array[n++] = a;
                continue;
            }
            if (name.equals("xmlns") && (value.isEmpty() || value.equals("http://www.w3.org/2000/xmlns/")) || name.equals("xmlns:xml") && value.equals("http://www.w3.org/XML/1998/namespace")) continue;
            array[n++] = a;
        }
        C14nUtil.bubbleSortNodeArray(array, n - 1);
        for (int k = 0; k < n; ++k) {
            C14nUtil.serializeAttribute(array[k], wr, false);
        }
    }

    static void bubbleSortNodeArray(Node[] nodes, int endIndex) {
        int comp;
        Node n2;
        Node base;
        int k;
        int startIndex;
        int lastxmlns = startIndex = 0;
        for (int s = startIndex; s < endIndex + 1; ++s) {
            Node crntNode = nodes[s];
            if (!crntNode.getNodeName().startsWith("xmlns")) continue;
            Node tempNode = nodes[lastxmlns];
            nodes[lastxmlns] = crntNode;
            nodes[s] = tempNode;
            ++lastxmlns;
        }
        for (k = startIndex; k < lastxmlns - 1; ++k) {
            Node node = nodes[k];
            if (node.getNodeName() != "xmlns") continue;
            Node temp = nodes[startIndex];
            nodes[startIndex] = node;
            node = temp;
        }
        for (k = startIndex + 1; k < lastxmlns - 1; ++k) {
            base = nodes[k];
            for (int j = k + 1; j < lastxmlns; ++j) {
                n2 = nodes[j];
                String bln = base.getLocalName();
                String nln = n2.getLocalName();
                if (bln == null) {
                    bln = base.getNodeName();
                }
                if (nln == null) {
                    nln = n2.getNodeName();
                }
                if ((comp = bln.compareTo(nln)) <= 0) continue;
                nodes[j] = base;
                base = n2;
                nodes[k] = n2;
            }
        }
        for (k = lastxmlns; k < endIndex; ++k) {
            base = nodes[k];
            for (int j = k + 1; j < endIndex + 1; ++j) {
                n2 = nodes[j];
                String basens = base.getNamespaceURI();
                String n2ns = n2.getNamespaceURI();
                if (basens == null) {
                    basens = "";
                }
                if (n2ns == null) {
                    n2ns = "";
                }
                if ((comp = basens.compareTo(n2ns)) == 0) {
                    String bln = base.getLocalName();
                    String nln = n2.getLocalName();
                    if (bln == null) {
                        bln = base.getNodeName();
                    }
                    if (nln == null) {
                        nln = n2.getNodeName();
                    }
                    comp = bln.compareTo(nln);
                }
                if (comp <= 0) continue;
                nodes[j] = base;
                base = n2;
                nodes[k] = n2;
            }
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Attr> nsnodes = new Hashtable<String, Attr>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            Attr xa;
            if (useProxy) {
                xa = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
            } else {
                xa = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml");
                xa.setNodeValue("http://www.w3.org/XML/1998/namespace");
            }
            nsnodes.put("xmlns:xml", xa);
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr newAttr;
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || nsnodes.containsKey(attrName)) continue;
                if (node == startNode) {
                    nsnodes.put(attrName, attr);
                    continue;
                }
                if (useProxy) {
                    newAttr = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", attrName, attr.getNodeValue());
                } else {
                    newAttr = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", attrName);
                    newAttr.setNodeValue(attr.getNodeValue());
                }
                nsnodes.put(attrName, newAttr);
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        for (Node node = startNode.getParentNode(); node != null; node = node.getParentNode()) {
            NamedNodeMap attributeList2 = node.getAttributes();
            if (attributeList2 == null) continue;
            int nAttrs = attributeList2.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList2.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || attrs != null && attrs.containsKey(attrName)) continue;
                if (attrs == null) {
                    attrs = new Hashtable<String, Attr>();
                }
                attrs.put(attrName, attr);
            }
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || !attrs.containsKey(attrName)) continue;
                attrs.remove(attrName);
            }
        }
        return attrs;
    }

    static class Attributes {
        Node parent;
        Hashtable attributes;
        Hashtable rendered;

        Attributes(Node node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            this.rendered = null;
        }

        boolean contains(String attrname) {
            return this.attributes.containsKey(attrname);
        }

        private boolean rendered(String attrname) {
            if (this.rendered == null) {
                return false;
            }
            return this.rendered.containsKey(attrname);
        }

        private void setRendered(String attrname, Attr a) {
            if (this.rendered == null) {
                this.rendered = new Hashtable();
            }
            this.rendered.put(attrname, a);
        }

        void serialize(Attributes parent, Writer wr) throws IOException, XMLSignatureException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration e = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)e.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = C14nUtil.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                boolean checkURI = false;
                if (attrName.equals("xmlns:xml")) continue;
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                    checkURI = true;
                    if (parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue())) {
                        continue;
                    }
                } else if (attrName.startsWith("xml:")) {
                    // empty if block
                }
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        Enumeration e() {
            return this.attributes.elements();
        }

        Attr get(String name) {
            return (Attr)this.attributes.get(name);
        }

        private void remove(String name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                System.err.println("Internal logic error: No attribute named " + name);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.e();
            while (en.hasMoreElements()) {
                Attr attr = (Attr)en.nextElement();
                String p = attr.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        private static boolean renderedInAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (!attrs.rendered(name) || !attrs.get(name).getNodeValue().equals(ns)) continue;
                return true;
            }
            return false;
        }

        private boolean utilizedInNearest(Stack ancestors, Attr attr) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            String prefix = attr.getName().equals("xmlns") ? "" : attr.getLocalName();
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (attrs.parent == null) continue;
                String eprefix = attrs.parent.getPrefix();
                if (eprefix == null) {
                    eprefix = "";
                }
                if (!prefix.equals(eprefix) && !attrs.usePrefix(prefix)) continue;
                return attrs.contains(attr.getNodeName()) && attrs.get(attr.getNodeName()).getNodeValue().equals(attr.getNodeValue());
            }
            return false;
        }

        void serialize(Stack ancestors, List prefixList, String elprefix, Writer wr) throws IOException, XMLSignatureException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration e = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)e.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = C14nUtil.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                boolean checkURI = false;
                if (attrName.equals("xmlns:xml")) continue;
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                    String prefix = attrName.equals("xmlns") ? "" : attrName.substring(6);
                    checkURI = true;
                    if (prefixList != null && prefixList.contains(prefix.length() == 0 ? "#default" : prefix)) {
                        Attributes par = null;
                        if (ancestors != null && !ancestors.isEmpty()) {
                            par = (Attributes)ancestors.elementAt(ancestors.size() - 1);
                        }
                        if (par != null && par.contains(attrName) && par.get(attrName).getNodeValue().equals(attr.getNodeValue())) {
                            continue;
                        }
                    } else {
                        if (elprefix == null) continue;
                        if (Attributes.renderedInAncestors(ancestors, attrName, attr.getNodeValue()) && this.utilizedInNearest(ancestors, attr) || elprefix != null && !elprefix.equals(prefix) && !this.usePrefix(prefix)) continue;
                    }
                    this.setRendered(attrName, attr);
                }
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }

    static class NodeListImpl
    implements NodeList {
        Vector vector = null;

        public NodeListImpl() {
        }

        public NodeListImpl(int size) {
            this.vector = new Vector(size);
        }

        public NodeListImpl(Iterator iter) {
            while (iter.hasNext()) {
                this.add((Node)iter.next());
            }
        }

        public void add(Node node) {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            this.vector.addElement(node);
        }

        public Node item(int index) {
            return this.vector == null || index < 0 || this.vector.size() <= index ? null : (Node)this.vector.elementAt(index);
        }

        public int getLength() {
            return this.vector == null ? 0 : this.vector.size();
        }
    }
}

