/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.misc;

import java.math.BigInteger;
import java.security.PublicKey;

public class FlexlmPublicKey
implements PublicKey {
    private static final long serialVersionUID = -775964401367364210L;
    protected byte[] rawKey;

    public FlexlmPublicKey(String string, String string2) {
        BigInteger bigInteger = new BigInteger(string2, 16);
        this.rawKey = bigInteger.toByteArray();
        this.L_G(this.rawKey, string);
    }

    protected void L_G(byte[] byArray, String string) {
        byte[] byArray2 = string.getBytes();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i % 2 == 0) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] - byArray2[n]);
            } else if (i % 3 == 0) {
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] ^ byArray2[n]);
            } else {
                int n4 = i;
                byArray[n4] = (byte)(byArray[n4] + byArray2[n]);
            }
            if (++n < byArray2.length) continue;
            n = 0;
        }
    }

    public String getAlgorithm() {
        return "ECDSA";
    }

    public byte[] getEncoded() {
        return this.rawKey;
    }

    public String getFormat() {
        return "RAW";
    }
}

