/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class UpgradeLine
extends FeatureLine {
    public UpgradeLine(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo) throws FlexlmException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, "Keyword");
        arrayList.add(1, "Name");
        arrayList.add(2, "Vendor");
        arrayList.add(3, "FromVersion");
        arrayList.add(4, "Version");
        arrayList.add(5, "Expiration");
        arrayList.add(6, "Count");
        int n = 7;
        arrayList.add(7, "Code");
        arrayList.add(8, "VENDOR_STRING");
        arrayList.add(9, "HOSTID");
        this.assignTokensToFields(tokenizedLicenseLine, licenseCertificate, vendorInfo, n, arrayList, this.keywords);
        this.isDirty = false;
    }

    public static void applyUpgrades(LinkedList linkedList, LinkedList linkedList2) throws FlexlmException {
        if (linkedList == null || linkedList.size() < 1) {
            return;
        }
        if (linkedList2 == null || linkedList2.size() < 1) {
            return;
        }
        ListIterator listIterator = linkedList2.listIterator(0);
        while (listIterator.hasNext()) {
            UpgradeLine upgradeLine = (UpgradeLine)listIterator.next();
            FeatureLine featureLine = UpgradeLine.getFeatureToUpgrade(linkedList, upgradeLine);
            if (featureLine == null) continue;
            featureLine.upgradedBy = upgradeLine;
            if (featureLine.count == 0 && upgradeLine.count == 0) {
                linkedList.remove(featureLine);
                continue;
            }
            int n = featureLine.count - upgradeLine.count;
            if (n < 1) {
                linkedList.remove(featureLine);
                continue;
            }
            featureLine.count = n;
        }
    }

    private static FeatureLine getFeatureToUpgrade(LinkedList linkedList, UpgradeLine upgradeLine) {
        FeatureLine featureLine = null;
        if (linkedList != null && linkedList.size() > 0 && upgradeLine != null) {
            Object object;
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                int n;
                object = (FeatureLine)listIterator.next();
                if (!upgradeLine.getName().equals(((LicenseElement)object).getName()) || (n = upgradeLine.fromVersion.compareTo(((FeatureLine)object).version)) > 0) continue;
                linkedList2.add(object);
            }
            if (linkedList2.size() > 0) {
                featureLine = linkedList2.size() == 1 ? (FeatureLine)linkedList2.getFirst() : ((object = UpgradeLine.getSameFile(linkedList2, upgradeLine)) != null ? (((LinkedList)object).size() == 1 ? (FeatureLine)((LinkedList)object).getFirst() : UpgradeLine.closestPrevious((LinkedList)object, upgradeLine)) : (FeatureLine)linkedList2.getFirst());
            }
        }
        return featureLine;
    }

    private static LinkedList getSameFile(LinkedList linkedList, UpgradeLine upgradeLine) {
        LinkedList<FeatureLine> linkedList2 = new LinkedList<FeatureLine>();
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            FeatureLine featureLine = (FeatureLine)listIterator.next();
            if (upgradeLine.filename == null || !upgradeLine.filename.equals(featureLine.filename)) continue;
            linkedList2.add(featureLine);
        }
        return linkedList2.size() > 0 ? linkedList2 : null;
    }

    private static FeatureLine closestPrevious(LinkedList linkedList, UpgradeLine upgradeLine) {
        int n = 1000000;
        for (int i = 0; i < linkedList.size(); ++i) {
            FeatureLine featureLine = (FeatureLine)linkedList.get(i);
            int n2 = upgradeLine.lineNumber - featureLine.lineNumber;
            if (n2 <= 0 || n2 >= n) continue;
            n = i;
        }
        return (FeatureLine)linkedList.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPGRADE ");
        stringBuffer.append(this.getName() + " ");
        stringBuffer.append(this.getVendorName() + " ");
        stringBuffer.append(this.getFromVersion() + " ");
        return new String(stringBuffer) + this.toCommonString();
    }
}

