/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.comm.CheckinMessage;
import com.macrovision.flexlm.comm.CheckoutMessage;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.CommRev3;
import com.macrovision.flexlm.comm.FeatBundleMessage;
import com.macrovision.flexlm.comm.FeatureAvailableMessage;
import com.macrovision.flexlm.comm.ForceCheckinMessage;
import com.macrovision.flexlm.comm.FulfillStatusMessage;
import com.macrovision.flexlm.comm.FulfillStatusRespMessage;
import com.macrovision.flexlm.comm.GenericDaemonInfoMessage;
import com.macrovision.flexlm.comm.HandshakeMessage;
import com.macrovision.flexlm.comm.HeartbeatMessage;
import com.macrovision.flexlm.comm.HeartbeatResponseMessage;
import com.macrovision.flexlm.comm.HelloMessage;
import com.macrovision.flexlm.comm.HostIdMessage;
import com.macrovision.flexlm.comm.LicenseFileDataMessage;
import com.macrovision.flexlm.comm.MessageHeader;
import com.macrovision.flexlm.comm.NUsersMessage;
import com.macrovision.flexlm.comm.NeedHostIdMessage;
import com.macrovision.flexlm.comm.NewReportlogMessage;
import com.macrovision.flexlm.comm.NoSuchFeatureMessage;
import com.macrovision.flexlm.comm.NoUserMessage;
import com.macrovision.flexlm.comm.NotAdminMessage;
import com.macrovision.flexlm.comm.OKMessage;
import com.macrovision.flexlm.comm.QueuedMessage;
import com.macrovision.flexlm.comm.RereadMessage;
import com.macrovision.flexlm.comm.SendLicenseFileDataMessage;
import com.macrovision.flexlm.comm.ShutdownMessage;
import com.macrovision.flexlm.comm.SwitchDebuglogMessage;
import com.macrovision.flexlm.comm.SwitchReportlogMessage;
import com.macrovision.flexlm.comm.TooSoonMessage;
import com.macrovision.flexlm.comm.TryAnotherMessage;
import com.macrovision.flexlm.comm.UserlistMessage;
import com.macrovision.flexlm.comm.Username2Message;
import com.macrovision.flexlm.comm.UsernameMessage;
import com.macrovision.flexlm.comm.VDInfoMessage;
import com.macrovision.flexlm.comm.VendorListMessage;
import com.macrovision.flexlm.comm.VendorListRespMessage;
import com.macrovision.flexlm.comm.WhatMessage;
import com.macrovision.flexlm.fulfillstatus.Deduction;
import com.macrovision.flexlm.fulfillstatus.DetailedFulfillment;
import com.macrovision.flexlm.fulfillstatus.Fulfillment;
import com.macrovision.flexlm.fulfillstatus.StatusHandle;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class CommRev4
extends CommRev
implements FlexlmConstants,
FlexlmInternalConstants {
    private static final int MSG_CHECKIN = 256;
    private static final int MSG_CHECKOUT = 257;
    private static final int MSG_HELLO = 258;
    private static final int MSG_REMOVE = 262;
    private static final int MSG_FORCE_CHECKIN = 262;
    private static final int MSG_REREAD = 263;
    private static final int MSG_SEND_LF = 264;
    private static final int MSG_SHUTDOWN = 266;
    private static final int MSG_REPLY_OK = 269;
    private static final int MSG_REPLY_OK_HELLO = 270;
    private static final int MSG_REPLY_OK_CHECKIN = 271;
    private static final int MSG_REPLY_OK_CHECKOUT = 272;
    private static final int MSG_REPLY_OK_HELLO_VD = 273;
    private static final int MSG_REPLY_TRY_ANOTHER = 275;
    private static final int MSG_REPLY_USERNAME = 276;
    private static final int MSG_REPLY_USERNAME2 = 277;
    private static final int MSG_HOSTID = 280;
    private static final int MSG_VENDOR_LIST_RESP = 281;
    private static final int MSG_FULFILL_STATUS = 295;
    private static final int MSG_FULFILL_STATUS_RESP = 296;
    private static final int MSG_VENDOR_LIST = 297;
    private static final int COMM4_HEADER_SIZE = 20;
    private static final int HEADER_OLD_COMMAND = 0;
    private static final int HEADER_OLD_CHECKSUM = 1;
    private static final int HEADER_CHECKSUM = 2;
    private static final int HEADER_MSG_SIZE = 4;
    private static final int HEADER_NEW_COMMAND = 6;
    private static final int HEADER_MSG_ID = 8;
    private static final int HEADER_SESSION_ID = 12;
    private static final int HEADER_RESERVED = 16;
    private static final int HEADER_MSG_FLAGS = 18;
    private static final short CRC16_VALUE = 14941;
    private static final int MAX_UNSIGNED_SHORT = 65536;
    private static short[] thing_table;
    private static int thing_table_computed;
    private static CommRev4 instance;

    private CommRev4() {
        thing_table = new short[256];
        thing_table_computed = 0;
    }

    public static CommRev getInstance() {
        if (instance == null) {
            instance = new CommRev4();
        }
        return instance;
    }

    public byte[] encodeCheckin(CheckinMessage checkinMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getFeature());
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getCode());
        CommRev4.encodeByte(byteArrayOutputStream, checkinMessage.getCheckoutData() == null ? (byte)0 : 49);
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getCheckoutData());
        return CommRev4.addHeader(byteArrayOutputStream, 256);
    }

    public CheckinMessage decodeCheckin(byte[] byArray) {
        throw new RuntimeException("decodeCheckin unimplemented");
    }

    public byte[] encodeCheckout(CheckoutMessage checkoutMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        byte by = (byte)checkoutMessage.getQueueMode();
        byte by2 = 0;
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getNumLic());
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getDupGroup());
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getLinger());
        CommRev4.encodeShort(byteArrayOutputStream, (short)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)1);
        if (by == 0) {
            by2 = 48;
        } else if (by == 2 || by == 1) {
            by2 = 49;
        }
        by2 = (byte)(by2 | 0x40);
        CommRev4.encodeByte(byteArrayOutputStream, by2);
        CommRev4.encodeString(byteArrayOutputStream, null);
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getFeature());
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getVersion());
        String string = checkoutMessage.getCode();
        if (string == null) {
            string = "PORT_AT_HOST_PLUS   ";
        }
        CommRev4.encodeString(byteArrayOutputStream, string);
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getCheckoutData());
        return CommRev4.addHeader(byteArrayOutputStream, 257);
    }

    public CheckoutMessage decodeCheckout(byte[] byArray) {
        throw new RuntimeException("decodeCheckout unimplemented");
    }

    public byte[] encodeHello(HelloMessage helloMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)helloMessage.getVersion());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)helloMessage.getRevision());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)11);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)6);
        CommRev4.encodeShort(byteArrayOutputStream, (short)84);
        CommRev4.encodeShort(byteArrayOutputStream, (short)helloMessage.getServerTimeout());
        CommRev4.encodeInt(byteArrayOutputStream, 0);
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getUsername());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getDisplay());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getVendor());
        CommRev4.encodeString(byteArrayOutputStream, "java_01");
        return CommRev4.addHeader(byteArrayOutputStream, 258);
    }

    public HelloMessage decodeHello(byte[] byArray) {
        throw new RuntimeException("decodeHello unimplmented");
    }

    public byte[] encodeHostId(HostIdMessage hostIdMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeShort(byteArrayOutputStream, (short)hostIdMessage.getHostIdType());
        CommRev4.encodeString(byteArrayOutputStream, hostIdMessage.getHostId());
        return CommRev4.addHeader(byteArrayOutputStream, 280);
    }

    public HostIdMessage decodeHostId(byte[] byArray) {
        throw new RuntimeException("decodeHostId unimplemented");
    }

    public byte[] encodeOK(OKMessage oKMessage) {
        throw new RuntimeException("encodeOK unimplemented");
    }

    public OKMessage decodeOK(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        OKMessage oKMessage = new OKMessage();
        byteArrayInputStream.skip(20L);
        oKMessage.setFlexVer(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setFlexRev(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setCommVer(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setCommRev(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setFlexPatch(CommRev4.decodeString(byteArrayInputStream));
        oKMessage.setHost(CommRev4.decodeString(byteArrayInputStream));
        oKMessage.setDaemon(CommRev4.decodeString(byteArrayInputStream));
        return oKMessage;
    }

    public byte[] encodeForceCheckin(ForceCheckinMessage forceCheckinMessage) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        int n = forceCheckinMessage.getHandle();
        if (n != 0) {
            CommRev3 commRev3 = (CommRev3)CommRev3.getInstance();
            byArray = commRev3.encodeForceCheckin(forceCheckinMessage);
        } else {
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getFeature());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getUser());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getHost());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getDisplay());
            CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
            CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
            byArray = CommRev4.addHeader(byteArrayOutputStream, 262);
        }
        return byArray;
    }

    public ForceCheckinMessage decodeForceCheckin(byte[] byArray) {
        throw new RuntimeException("decodeForceCheckin unimplemented");
    }

    public byte[] encodeReread(RereadMessage rereadMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getUser());
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getDaemon());
        int n = rereadMessage.getIpAddress().getAddress()[0] << 24 & 0xFF000000;
        n |= rereadMessage.getIpAddress().getAddress()[1] << 16 & 0xFF0000;
        n |= rereadMessage.getIpAddress().getAddress()[2] << 8 & 0xFF00;
        CommRev4.encodeInt(byteArrayOutputStream, n |= rereadMessage.getIpAddress().getAddress()[3] & 0xFF);
        return CommRev4.addHeader(byteArrayOutputStream, 263);
    }

    public byte[] encodeShutdown(ShutdownMessage shutdownMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getUser());
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getDaemon());
        int n = shutdownMessage.getIpAddress().getAddress()[0] << 24 & 0xFF000000;
        n |= shutdownMessage.getIpAddress().getAddress()[1] << 16 & 0xFF0000;
        n |= shutdownMessage.getIpAddress().getAddress()[2] << 8 & 0xFF00;
        CommRev4.encodeInt(byteArrayOutputStream, n |= shutdownMessage.getIpAddress().getAddress()[3] & 0xFF);
        if (shutdownMessage.getForce()) {
            CommRev4.encodeByte(byteArrayOutputStream, (byte)2);
        } else {
            CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        }
        return CommRev4.addHeader(byteArrayOutputStream, 266);
    }

    public RereadMessage decodeReread(byte[] byArray) {
        throw new RuntimeException("decodeReread unimplemented");
    }

    public ShutdownMessage decodeShutdown(byte[] byArray) {
        throw new RuntimeException("decodeShutdown unimplemented");
    }

    public byte[] encodeSendLicenseFileData(SendLicenseFileDataMessage sendLicenseFileDataMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)sendLicenseFileDataMessage.getVersion());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)sendLicenseFileDataMessage.getRevision());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getUsername());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getVendor());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getDisplay());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getFinderType());
        return CommRev4.addHeader(byteArrayOutputStream, 264);
    }

    public SendLicenseFileDataMessage decodeSendLicenseFileData(byte[] byArray) {
        throw new RuntimeException("decodeSendLicenseFileData unimplmented");
    }

    public byte[] encodeTryAnother(TryAnotherMessage tryAnotherMessage) {
        throw new RuntimeException("encodeTryAnother unimplemented");
    }

    public TryAnotherMessage decodeTryAnother(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        TryAnotherMessage tryAnotherMessage = new TryAnotherMessage();
        byteArrayInputStream.skip(20L);
        tryAnotherMessage.setHost(CommRev4.decodeString(byteArrayInputStream));
        tryAnotherMessage.setPort(CommRev4.decodeInt(byteArrayInputStream));
        tryAnotherMessage.setHost2(CommRev4.decodeString(byteArrayInputStream));
        CommRev4.decodeInt(byteArrayInputStream);
        tryAnotherMessage.setProtocol(CommRev4.decodeByte(byteArrayInputStream));
        tryAnotherMessage.setReason(CommRev4.decodeByte(byteArrayInputStream));
        return tryAnotherMessage;
    }

    public byte[] encodeUsername(UsernameMessage usernameMessage) {
        throw new RuntimeException("encodeUsername unimplemented");
    }

    public UsernameMessage decodeUsername(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        UsernameMessage usernameMessage = new UsernameMessage();
        byteArrayInputStream.skip(20L);
        usernameMessage.setName(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setNode(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setDisplay(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setVersion(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setNumLic(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setFlags(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setTime(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setLinger(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setHandle(CommRev4.decodeInt(byteArrayInputStream));
        return usernameMessage;
    }

    public byte[] encodeUsername2(Username2Message username2Message) {
        throw new RuntimeException("encodeUsername2 unimplemented");
    }

    public Username2Message decodeUsername2(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        Username2Message username2Message = new Username2Message();
        byteArrayInputStream.skip(20L);
        username2Message.setCheckoutData(CommRev4.decodeString(byteArrayInputStream).getBytes());
        return username2Message;
    }

    public byte[] encodeFulfillStatus(FulfillStatusMessage fulfillStatusMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)fulfillStatusMessage.getDetail());
        CommRev4.encodeString(byteArrayOutputStream, fulfillStatusMessage.getFulfillId());
        CommRev4.encodeString(byteArrayOutputStream, fulfillStatusMessage.getProductId());
        CommRev4.encodeString(byteArrayOutputStream, fulfillStatusMessage.getEntitlementId());
        CommRev4.encodeString(byteArrayOutputStream, fulfillStatusMessage.getFeatureName());
        return CommRev4.addHeader(byteArrayOutputStream, 295);
    }

    public FulfillStatusMessage decodeFulfillStatus(byte[] byArray) {
        throw new RuntimeException("decodeFulfillStatus unimplemented");
    }

    public byte[] encodeFulfillStatusResp(FulfillStatusRespMessage fulfillStatusRespMessage) {
        throw new RuntimeException("encodeFulfillStatusResp unimplemented");
    }

    public FulfillStatusRespMessage decodeFulfillStatusResp(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
            FulfillStatusRespMessage fulfillStatusRespMessage = new FulfillStatusRespMessage();
            StatusHandle statusHandle = new StatusHandle();
            byteArrayInputStream.skip(20L);
            byte by = CommRev4.decodeByte(byteArrayInputStream);
            int n = CommRev4.decodeInt(byteArrayInputStream);
            if (by == 1) {
                for (int i = 0; i < n; ++i) {
                    DetailedFulfillment detailedFulfillment = this.decodeDetailedFulfillment(byteArrayInputStream);
                    statusHandle.addFulfillment(detailedFulfillment);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Fulfillment fulfillment = this.decodeFulfillment(byteArrayInputStream);
                    statusHandle.addFulfillment(fulfillment);
                }
            }
            fulfillStatusRespMessage.setStatusHandle(statusHandle);
            return fulfillStatusRespMessage;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("decodeFulfillStatusResp failed.");
        }
    }

    protected DetailedFulfillment decodeDetailedFulfillment(ByteArrayInputStream byteArrayInputStream) {
        try {
            DetailedFulfillment detailedFulfillment = new DetailedFulfillment();
            detailedFulfillment.setVersionNumber(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setFulfillmentId(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setEntitlementId(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setProductId(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setSuiteId(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setExpirationDate(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setOriginalExpirationDate(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setFulfillChain(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setServerChain(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setHops(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setActivationCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setConcurrentCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setHybridCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setActivationOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setConcurrentOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setHybridOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxActivationCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxConcurrentCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxHybridCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxActivationOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxConcurrentOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxHybridOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setRepairsToServe(CommRev4.decodeInt(byteArrayInputStream));
            detailedFulfillment.setMaxOverdraftDuration(CommRev4.decodeString(byteArrayInputStream));
            detailedFulfillment.setFeatureLines(CommRev4.decodeString(byteArrayInputStream));
            int n = CommRev4.decodeInt(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                Deduction deduction = this.decodeDeduction(byteArrayInputStream);
                detailedFulfillment.addDeduction(deduction);
            }
            return detailedFulfillment;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("decodeDetailedFulfillment failed.");
        }
    }

    protected Fulfillment decodeFulfillment(ByteArrayInputStream byteArrayInputStream) {
        try {
            Fulfillment fulfillment = new Fulfillment();
            fulfillment.setFulfillmentId(CommRev4.decodeString(byteArrayInputStream));
            fulfillment.setEntitlementId(CommRev4.decodeString(byteArrayInputStream));
            fulfillment.setProductId(CommRev4.decodeString(byteArrayInputStream));
            fulfillment.setExpirationDate(CommRev4.decodeString(byteArrayInputStream));
            fulfillment.setActivationCount(CommRev4.decodeInt(byteArrayInputStream));
            fulfillment.setConcurrentCount(CommRev4.decodeInt(byteArrayInputStream));
            fulfillment.setHybridCount(CommRev4.decodeInt(byteArrayInputStream));
            fulfillment.setActivationOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            fulfillment.setConcurrentOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            fulfillment.setHybridOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            return fulfillment;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("decodeFulfillment failed.");
        }
    }

    protected Deduction decodeDeduction(ByteArrayInputStream byteArrayInputStream) {
        try {
            Deduction deduction = new Deduction();
            deduction.setDestFulfillmentId(CommRev4.decodeString(byteArrayInputStream));
            deduction.setDestSystemName(CommRev4.decodeString(byteArrayInputStream));
            deduction.setActivationCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setConcurrentCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setHybridCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setActivationOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setConcurrentOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setHybridOverdraftCount(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setExpiration(CommRev4.decodeString(byteArrayInputStream));
            deduction.setRepairs(CommRev4.decodeInt(byteArrayInputStream));
            deduction.setType(CommRev4.decodeInt(byteArrayInputStream));
            return deduction;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("decodeDeduction failed.");
        }
    }

    public byte[] encodeFeatBundle(FeatBundleMessage featBundleMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeFeatBundle(featBundleMessage);
    }

    public FeatBundleMessage decodeFeatBundle(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeFeatBundle(byArray);
    }

    public byte[] encodeFeatureAvailable(FeatureAvailableMessage featureAvailableMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeFeatureAvailable(featureAvailableMessage);
    }

    public FeatureAvailableMessage decodeFeatureAvailable(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeFeatureAvailable(byArray);
    }

    public byte[] encodeGenericDaemonInfo(GenericDaemonInfoMessage genericDaemonInfoMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeGenericDaemonInfo(genericDaemonInfoMessage);
    }

    public GenericDaemonInfoMessage decodeGenericDaemonInfo(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeGenericDaemonInfo(byArray);
    }

    public byte[] encodeHandshake(HandshakeMessage handshakeMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHandshake(handshakeMessage);
    }

    public HandshakeMessage decodeHandshake(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHandshake(byArray);
    }

    public byte[] encodeHeartbeat(HeartbeatMessage heartbeatMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHeartbeat(heartbeatMessage);
    }

    public HeartbeatMessage decodeHeartbeat(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHeartbeat(byArray);
    }

    public byte[] encodeHeartbeatResponse(HeartbeatResponseMessage heartbeatResponseMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHeartbeatResponse(heartbeatResponseMessage);
    }

    public HeartbeatResponseMessage decodeHeartbeatResponse(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHeartbeatResponse(byArray);
    }

    public byte[] encodeLicenseFileData(LicenseFileDataMessage licenseFileDataMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeLicenseFileData(licenseFileDataMessage);
    }

    public LicenseFileDataMessage decodeLicenseFileData(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeLicenseFileData(byArray);
    }

    public byte[] encodeNeedHostId(NeedHostIdMessage needHostIdMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNeedHostId(needHostIdMessage);
    }

    public NeedHostIdMessage decodeNeedHostId(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNeedHostId(byArray);
    }

    public byte[] encodeNewReportlog(NewReportlogMessage newReportlogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNewReportlog(newReportlogMessage);
    }

    public NewReportlogMessage decodeNewReportlog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNewReportlog(byArray);
    }

    public byte[] encodeNUsers(NUsersMessage nUsersMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNUsers(nUsersMessage);
    }

    public NUsersMessage decodeNUsers(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNUsers(byArray);
    }

    public byte[] encodeQueued(QueuedMessage queuedMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeQueued(queuedMessage);
    }

    public QueuedMessage decodeQueued(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeQueued(byArray);
    }

    public byte[] encodeSwitchDebuglog(SwitchDebuglogMessage switchDebuglogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeSwitchDebuglog(switchDebuglogMessage);
    }

    public SwitchDebuglogMessage decodeSwitchDebuglog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeSwitchDebuglog(byArray);
    }

    public byte[] encodeSwitchReportlog(SwitchReportlogMessage switchReportlogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeSwitchReportlog(switchReportlogMessage);
    }

    public SwitchReportlogMessage decodeSwitchReportlog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeSwitchReportlog(byArray);
    }

    public byte[] encodeUserlist(UserlistMessage userlistMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeUserlist(userlistMessage);
    }

    public UserlistMessage decodeUserlist(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeUserlist(byArray);
    }

    public byte[] encodeVDInfo(VDInfoMessage vDInfoMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeVDInfo(vDInfoMessage);
    }

    public VDInfoMessage decodeVDInfo(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeVDInfo(byArray);
    }

    public byte[] encodeWhat(WhatMessage whatMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeWhat(whatMessage);
    }

    public WhatMessage decodeWhat(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeWhat(byArray);
    }

    public byte[] encodeNoSuchFeature(NoSuchFeatureMessage noSuchFeatureMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNoSuchFeature(noSuchFeatureMessage);
    }

    public NoSuchFeatureMessage decodeNoSuchFeature(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNoSuchFeature(byArray);
    }

    public byte[] encodeNotAdmin(NotAdminMessage notAdminMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNotAdmin(notAdminMessage);
    }

    public NotAdminMessage decodeNotAdmin(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNotAdmin(byArray);
    }

    public byte[] encodeTooSoon(TooSoonMessage tooSoonMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeTooSoon(tooSoonMessage);
    }

    public TooSoonMessage decodeTooSoon(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeTooSoon(byArray);
    }

    public byte[] encodeNoUser(NoUserMessage noUserMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNoUser(noUserMessage);
    }

    public NoUserMessage decodeNoUser(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNoUser(byArray);
    }

    public byte[] encodeVendorList(VendorListMessage vendorListMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeString(byteArrayOutputStream, vendorListMessage.getVendorName());
        return CommRev4.addHeader(byteArrayOutputStream, 297);
    }

    public VendorListMessage decodeVendorList(byte[] byArray) {
        throw new RuntimeException("decodeVendorList unimplemented");
    }

    public byte[] encodeVendorListResp(VendorListRespMessage vendorListRespMessage) {
        throw new RuntimeException("encodeVendorListResp unimplemented");
    }

    public VendorListRespMessage decodeVendorListResp(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
            VendorListRespMessage vendorListRespMessage = new VendorListRespMessage();
            byteArrayInputStream.skip(20L);
            int n = CommRev4.decodeShort(byteArrayInputStream);
            CommRev4.decodeShort(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                vendorListRespMessage.addVendorName(CommRev4.decodeString(byteArrayInputStream));
            }
            return vendorListRespMessage;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("decodeVendorListResp failed.");
        }
    }

    private static void encodeByte(ByteArrayOutputStream byteArrayOutputStream, byte by) {
        byteArrayOutputStream.write(by);
    }

    private static byte decodeByte(ByteArrayInputStream byteArrayInputStream) {
        return (byte)byteArrayInputStream.read();
    }

    private static void encodeShort(ByteArrayOutputStream byteArrayOutputStream, short s) {
        byteArrayOutputStream.write(s >> 8 & 0xFF);
        byteArrayOutputStream.write(s & 0xFF);
    }

    private static void encodeShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >> 8 & 0xFF);
        byArray[n] = (byte)(s & 0xFF);
    }

    private static short decodeShort(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        n = byteArrayInputStream.read() << 8;
        return (short)(n += byteArrayInputStream.read());
    }

    private static short decodeShort(byte[] byArray, int n) {
        short s = 0;
        s = (short)(byArray[n++] << 8);
        s = (short)(s + ((short)byArray[n] & 0xFF));
        return s;
    }

    private static void encodeInt(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n >> 24 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    private static void encodeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n] = (byte)(n2 & 0xFF);
    }

    private static int decodeInt(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        n = byteArrayInputStream.read() << 24;
        n += byteArrayInputStream.read() << 16 & 0xFF0000;
        n += byteArrayInputStream.read() << 8 & 0xFF00;
        return n += byteArrayInputStream.read() & 0xFF;
    }

    private static void encodeString(ByteArrayOutputStream byteArrayOutputStream, String string) {
        byte[] byArray = null;
        if (string != null && (byArray = string.getBytes()) != null && byArray.length > 0) {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        byteArrayOutputStream.write(0);
    }

    private static String decodeString(ByteArrayInputStream byteArrayInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = byteArrayInputStream.available();
        int n2 = 0;
        int n3 = 0;
        for (n2 = 0; n2 < n && (byte)(n3 = byteArrayInputStream.read()) != 0; ++n2) {
            byteArrayOutputStream.write((byte)n3);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private static byte calcOldChecksum(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        for (n2 = 2; n2 < n; ++n2) {
            by = (byte)(by + byArray[n2]);
        }
        return by;
    }

    private static short calcNewChecksum(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        short s = 0;
        int n5 = 0;
        if (thing_table_computed == 0) {
            n4 = 0;
            for (n4 = 0; n4 < 256; n4 = (int)((short)(n4 + 1))) {
                n3 = 0;
                n3 = n4;
                s = 0;
                for (n5 = 8; n5 != 0; --n5) {
                    s = ((n3 ^ s) & 1) != 0 ? (short)(s >> 1 ^ 0x3A5D) : (short)(s >> 1);
                    n3 = (short)(n3 >> 1);
                }
                CommRev4.thing_table[n4] = s;
            }
            thing_table_computed = 1;
        }
        s = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = s & 0xFF;
            n3 = byArray[n + n5];
            int n6 = (n4 ^ n3) & 0xFF;
            s = (short)(s >> 8 ^ thing_table[n6]);
        }
        return s;
    }

    private static void copyBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray == null || byArray2 == null) {
            return;
        }
        for (int i = 0; i < n2 && n + i < byArray.length && n3 + i < byArray2.length; ++i) {
            byArray[n + i] = byArray2[n3 + i];
        }
    }

    private static byte[] addHeader(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[20 + byArray.length];
        CommRev4.copyBytes(byArray2, 20, byArray.length, byArray, 0);
        byArray2[0] = 47;
        CommRev4.encodeShort(byArray2, 6, (short)n);
        CommRev4.encodeInt(byArray2, 8, 0);
        CommRev4.encodeInt(byArray2, 12, 0);
        CommRev4.encodeShort(byArray2, 16, (short)0);
        CommRev4.encodeShort(byArray2, 18, (short)0);
        CommRev4.encodeShort(byArray2, 4, (short)byArray2.length);
        CommRev4.encodeShort(byArray2, 2, CommRev4.calcNewChecksum(byArray2, 4, byArray2.length - 4));
        byArray2[1] = CommRev4.calcOldChecksum(byArray2, 20);
        return byArray2;
    }

    private static ByteArrayOutputStream getBuffer() {
        return new ByteArrayOutputStream();
    }

    private static ByteArrayInputStream setBuffer(byte[] byArray) {
        return new ByteArrayInputStream(byArray);
    }

    protected int getMessageLength(byte[] byArray, int n) {
        int n2 = CommRev4.decodeShort(byArray, 4);
        return n2 >= 0 ? n2 : n2 + 65536;
    }

    protected int getMessageFlags(byte[] byArray) {
        int n = CommRev4.decodeShort(byArray, 18);
        return n >= 0 ? n : n + 65536;
    }

    protected void setChecksum(byte[] byArray) {
        if (byArray[0] == 47) {
            CommRev4.encodeShort(byArray, 2, CommRev4.calcNewChecksum(byArray, 4, byArray.length - 4));
        } else {
            CommRev commRev = CommRev3.getInstance();
            commRev.setChecksum(byArray);
        }
    }

    protected boolean checkChecksum(byte[] byArray) {
        if (byArray[0] == 47) {
            short s;
            short s2 = CommRev4.decodeShort(byArray, 2);
            if (s2 == (s = CommRev4.calcNewChecksum(byArray, 4, byArray.length - 4))) {
                return this.checkHeaderChecksum(byArray);
            }
            return false;
        }
        CommRev commRev = CommRev3.getInstance();
        return commRev.checkChecksum(byArray);
    }

    protected boolean checkHeaderChecksum(byte[] byArray) {
        return byArray[1] == CommRev4.calcOldChecksum(byArray, 20);
    }

    public void encryptMessage(byte[] byArray, int n) {
        this.encryptBytes(byArray, n);
    }

    public void decryptMessage(byte[] byArray, MessageHeader messageHeader, int n) {
        this.decryptBytes(byArray, n);
    }

    public void encryptBytes(byte[] byArray, int n) {
        CommRev3.encryptBytes(byArray, n);
    }

    public void decryptBytes(byte[] byArray, int n) {
        CommRev3.decryptBytes(byArray, MessageHeader.getHeaderLength(), byArray.length - MessageHeader.getHeaderLength(), n);
    }

    protected int getMessageType(byte[] byArray) throws FlexlmException {
        int n = 65552;
        if (byArray == null || byArray.length == 0) {
            throw new FlexlmException(-506, 1021);
        }
        if (byArray[0] == 47) {
            n = CommRev4.decodeShort(byArray, 6);
            switch (n) {
                case 256: {
                    n = 65540;
                    break;
                }
                case 257: {
                    n = 65542;
                    break;
                }
                case 258: {
                    n = 65539;
                    break;
                }
                case 262: {
                    n = 65544;
                    break;
                }
                case 266: {
                    n = 65543;
                    break;
                }
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 273: {
                    n = 65561;
                    break;
                }
                case 275: {
                    n = 65553;
                    break;
                }
                case 276: {
                    n = 65569;
                    break;
                }
                case 277: {
                    n = 65568;
                    break;
                }
                case 280: {
                    n = 65567;
                    break;
                }
                case 295: {
                    n = 65572;
                    break;
                }
                case 296: {
                    n = 65573;
                    break;
                }
                case 297: {
                    n = 65574;
                    break;
                }
                case 281: {
                    n = 65575;
                    break;
                }
                default: {
                    CommRev commRev = CommRev3.getInstance();
                    n = commRev.getMessageType(byArray);
                }
            }
        }
        return n;
    }
}

