/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodedNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.MessageField;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.TargetInfo;
import java.io.UnsupportedEncodingException;

public class LogNTLMMessage {
    public static void logNTLMMessage(Logger log, byte[] bytes) {
        LogNTLMMessage.logNTLMMessage(log, bytes, null);
    }

    public static void logNTLMMessage(Logger log, byte[] bytes, int expectedMessageType) {
        LogNTLMMessage.logNTLMMessage(log, bytes, (Integer)expectedMessageType);
    }

    public static void logNTLMMessage(Logger log, byte[] bytes, Integer expectedMessageType) {
        try {
            DecodedNTLMMessage decodedMessage = DecodedNTLMMessage.decodeNTLMMessage(bytes);
            LogNTLMMessage.logNTLMMessage(log, decodedMessage, expectedMessageType);
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to decode NTLM AUTHENTICATE message [{0}]", new Object[]{bytes != null ? BitUtil.bytesToHexString(bytes) : null});
            log.debug((Throwable)e);
        }
        catch (DecodeBytes.DecodeBytesException e) {
            log.debug("Failed to decode NTLM AUTHENTICATE message [{0}]", new Object[]{bytes != null ? BitUtil.bytesToHexString(bytes) : null});
            log.debug((Throwable)e);
        }
    }

    public static void logNTLMMessage(Logger log, DecodedNTLMMessage decodedMessage, Integer expectedMessageType) {
        if (!log.isDebugLoggable()) {
            return;
        }
        int messageType = decodedMessage.getMessageType();
        if (expectedMessageType != null && decodedMessage.getMessageType() != expectedMessageType.intValue()) {
            log.debug("NTLM !!! UNEXPECTED msg type: expected={0}, actual={1}", new Object[]{expectedMessageType, messageType});
        }
        switch (messageType) {
            case 1: {
                LogNTLMMessage.logNegotiate(log, decodedMessage);
                break;
            }
            case 2: {
                LogNTLMMessage.logChallenge(log, decodedMessage);
                break;
            }
            case 3: {
                LogNTLMMessage.logAuthenticate(log, decodedMessage);
                break;
            }
        }
    }

    private static void logNegotiate(Logger log, DecodedNTLMMessage decodedMessage) {
        LogNTLMMessage.logFlagsAndFields(log, decodedMessage);
        if (decodedMessage.getVersionData() != null) {
            LogNTLMMessage.logData(log, decodedMessage.getMessageType(), "version", decodedMessage.getVersionData());
        }
    }

    private static void logChallenge(Logger log, DecodedNTLMMessage decodedMessage) {
        LogNTLMMessage.logFlagsAndFields(log, decodedMessage);
        if (decodedMessage.getServerChallenge() != null) {
            LogNTLMMessage.logData(log, decodedMessage.getMessageType(), "serverChallenge", decodedMessage.getServerChallenge());
        }
        if (decodedMessage.getVersionData() != null) {
            LogNTLMMessage.logData(log, decodedMessage.getMessageType(), "version", decodedMessage.getVersionData());
        }
    }

    private static void logAuthenticate(Logger log, DecodedNTLMMessage decodedMessage) {
        LogNTLMMessage.logFlagsAndFields(log, decodedMessage);
        if (decodedMessage.getVersionData() != null) {
            LogNTLMMessage.logData(log, decodedMessage.getMessageType(), "version", decodedMessage.getVersionData());
        }
    }

    private static void logFlagsAndFields(Logger log, DecodedNTLMMessage decodedMessage) {
        if (decodedMessage.getFlags() != null) {
            LogNTLMMessage.logFlags(log, decodedMessage.getMessageType(), decodedMessage.getFlags());
        }
        for (MessageField field : decodedMessage.getFields()) {
            LogNTLMMessage.logField(log, decodedMessage.getMessageType(), field);
        }
    }

    public static String getMsgTypeString(int messageType) {
        switch (messageType) {
            case 1: {
                return "NEGOTIATE";
            }
            case 2: {
                return "CHALLENGE";
            }
            case 3: {
                return "AUTHENTICATE";
            }
        }
        return "<UNKNOWN>";
    }

    public static void logFlags(Logger log, int messageType, int flags) {
        log.debug("NTLM {0} flags: {1}", new Object[]{LogNTLMMessage.getMsgTypeString(messageType), NTLMUtil.getFlagsDebugString(flags)});
    }

    public static void logTargetInfo(Logger log, int messageType, TargetInfo targetInfo) {
        TargetInfo.AVPair[] pairs;
        log.debug("NTLM {0} target info [{1}]", new Object[]{LogNTLMMessage.getMsgTypeString(messageType), targetInfo != null ? BitUtil.bytesToHexString(targetInfo.getData()) : null});
        if (targetInfo == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(targetInfo.getData().length);
        sb.append("challenge.targetInfo AVPairs:");
        TargetInfo.AVPair[] aVPairArray = pairs = targetInfo.getAVPairs();
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            TargetInfo.AVPair pair = aVPairArray[n2];
            sb.append(Logger.NEWLINE).append('\t').append(pair);
            ++n2;
        }
        log.debug((Object)sb);
    }

    public static void logStringData(Logger log, int messageType, String name, byte[] data, String valueAsString) {
        log.debug("NTLM {0} {1} {2}", new Object[]{LogNTLMMessage.getMsgTypeString(messageType), name, LogNTLMMessage.dataAsString(valueAsString, data)});
    }

    public static String bytesAsString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            chars[i] = LogNTLMMessage.toChar(b);
            ++i;
        }
        return new String(chars);
    }

    private static char toChar(byte b) {
        return (char)(Character.isLetterOrDigit((char)b) ? (int)b : 42);
    }

    public static void logField(Logger log, int messageType, MessageField field) {
        log.debug("NTLM {0} {1} {2}", new Object[]{LogNTLMMessage.getMsgTypeString(messageType), field.getName(), LogNTLMMessage.dataAsString(field.getData())});
    }

    public static String dataAsString(byte[] bytes) {
        return LogNTLMMessage.dataAsString(LogNTLMMessage.bytesAsString(bytes), bytes);
    }

    public static String dataAsString(String stringValue, byte[] bytes) {
        return NLS.bind((String)"len={0}: ''{1}'' [{2}]", (Object[])new Object[]{bytes.length, stringValue, BitUtil.bytesToHexString(bytes)});
    }

    public static void logData(Logger log, int messageType, String name, byte[] data) {
        log.debug("NTLM {0} {1} {2}", new Object[]{LogNTLMMessage.getMsgTypeString(messageType), name, LogNTLMMessage.dataAsString(data)});
    }
}

