/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.util.EncodingUtil;

public class LoggingNTLMScheme
extends NTLMScheme
implements NTLMConstants {
    private static final String NTLM_PREFIX = "NTLM ";
    private static final Logger log = CustomNTLM.log;

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        String response = super.authenticate(credentials, method);
        if (log.isDebugLoggable()) {
            assert (response.startsWith(NTLM_PREFIX));
            String s = response.substring(NTLM_PREFIX.length());
            byte[] bytes = Base64.decodeBase64((byte[])EncodingUtil.getBytes((String)s, (String)"ASCII"));
            LogNTLMMessage.logNTLMMessage(log, bytes);
        }
        return response;
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        int i;
        super.processChallenge(challenge);
        if (log.isDebugLoggable() && (i = challenge.indexOf(" ")) >= 0) {
            String ntlmChallenge = challenge.substring(i);
            if ((ntlmChallenge = ntlmChallenge.trim()).length() > 0) {
                byte[] bytes = Base64.decodeBase64((byte[])EncodingUtil.getBytes((String)ntlmChallenge, (String)"ASCII"));
                LogNTLMMessage.logNTLMMessage(log, bytes, 2);
            }
        }
    }
}

