/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.downloads.DownloadException;
import com.ibm.cic.common.downloads.NonsecureConnectionManager;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.downloads.handlerImpl.DownloadCancelMonitorPerThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class EventFiringSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLSocketFactory getSSLSocketFactory(String host) throws DownloadException {
        try {
            return NonsecureConnectionManager.INSTANCE.getSSLContext().getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new DownloadException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DownloadException((Exception)e);
        }
        catch (KeyStoreException e) {
            throw new DownloadException((Exception)e);
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(clientHost, clientPort);
        return this.createSocket(host, remoteInetAddress, localInetAddress, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, SocketTimeoutException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(localAddress, localPort);
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        return this.createSocket(host, remoteInetAddress, localInetAddress, timeout);
    }

    private SSLSocket createSSLSocket(SSLSocketFactory factory) throws IOException {
        SSLSocket socket = (SSLSocket)factory.createSocket();
        if (CicCommonSettings.isWindowsVista()) {
            socket.setReuseAddress(true);
        }
        return socket;
    }

    private Socket createSocket(String host, InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, int timeout) throws IOException {
        SSLSocket socket = this.createSSLSocket(this.getSSLSocketFactory(host));
        SocketEvents.SocketToConnect stc = new SocketEvents.SocketToConnect((Socket)socket, remoteInetAddress, localInetAddress);
        try {
            SocketEvents.FIRE.onBeforeSocketConnected(stc);
            socket.bind(localInetAddress);
            socket.connect(remoteInetAddress, timeout);
            this.doSSLConnectionHandshake(host, socket);
        }
        catch (IOException e) {
            SocketEvents.FIRE.onSocketConnectFailed(stc, (Throwable)e);
            throw e;
        }
        SocketEvents.FIRE.onSocketConnected(stc);
        return new SocketEvents.SocketEventEmittingWrapper((Socket)socket, DownloadCancelMonitorPerThread.INSTANCE.getThreadCancelMonitor());
    }

    private void doSSLConnectionHandshake(String host, SSLSocket socket) throws IOException {
        NonsecureConnectionManager.onBeforeSSLConnect((String)host);
        try {
            socket.getSession();
            socket.getInputStream().available();
        }
        finally {
            NonsecureConnectionManager.onPostSSLConnect();
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(0);
        return this.createSocket(host, remoteInetAddress, localInetAddress, 0);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket retSocket = null;
        SocketEvents.SocketToConnect stc = new SocketEvents.SocketToConnect(host, port);
        try {
            SocketEvents.FIRE.onBeforeSocketConnected(stc);
            retSocket = this.getSSLSocketFactory(host).createSocket(socket, host, port, autoClose);
            SSLSocket sslRetSocket = (SSLSocket)retSocket;
            stc.setSocket(retSocket);
            this.doSSLConnectionHandshake(host, sslRetSocket);
        }
        catch (IOException e) {
            SocketEvents.FIRE.onSocketConnectFailed(stc, (Throwable)e);
            throw e;
        }
        SocketEvents.FIRE.onSocketConnected(stc);
        return new SocketEvents.SocketEventEmittingWrapper(retSocket, DownloadCancelMonitorPerThread.INSTANCE.getThreadCancelMonitor());
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return EventFiringSSLProtocolSocketFactory.class.hashCode();
    }
}

