/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class BasicConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.BasicConstraints";
    public static final String NAME = "BasicConstraints";
    public static final String IS_CA = "is_ca";
    public static final String PATH_LEN = "path_len";
    private boolean ca = false;
    private int pathLen = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.BasicConstraintsExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.ca) {
            tmp.putBoolean(this.ca);
            if (this.pathLen >= 0) {
                tmp.putInteger(BigInteger.valueOf(this.pathLen));
            }
        }
        out.write((byte)48, tmp);
        this.extensionValue = out.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    public BasicConstraintsExtension(boolean ca, int len) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "BasicConstraintsExtension", new Boolean(ca), new Integer(len));
        }
        this.ca = ca;
        this.pathLen = len;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = ca;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "BasicConstraintsExtension");
        }
    }

    public BasicConstraintsExtension(Boolean critical, Object value) throws IOException {
        DerValue opt;
        if (debug != null) {
            debug.entry(16384L, className, "BasicConstraintsExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = critical;
        if (value instanceof byte[]) {
            int len = Array.getLength(value);
            byte[] extValue = new byte[len];
            System.arraycopy(value, 0, extValue, 0, len);
            this.extensionValue = extValue;
            DerValue val = new DerValue(extValue);
            if (val.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "BasicConstraintsExtension", "Invalid encoding of BasicConstraints");
                }
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            if (val.getData() == null || val.getData().available() == 0) {
                return;
            }
            opt = val.getData().getDerValue();
            if (opt.getTag() != 1) {
                return;
            }
            this.ca = opt.getBoolean();
            if (val.getData().available() == 0) {
                this.pathLen = Integer.MAX_VALUE;
                if (debug != null) {
                    debug.exit(16384L, className, "BasicConstraintsExtension_1");
                }
                return;
            }
            opt = val.getData().getDerValue();
            if (opt.getTag() != 2) {
                if (debug != null) {
                    debug.text(16384L, className, "BasicConstraintsExtension", "Invalid encoding of BasicConstraints");
                }
                throw new IOException("Invalid encoding of BasicConstraints");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "BasicConstraintsExtension", "Invalid argument type");
            }
            throw new IOException("Invalid argument type");
        }
        this.pathLen = opt.getInteger().intValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "BasicConstraintsExtension_2", "Invalid argument type");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "BasicConstraints:[\n";
        s = s + (this.ca ? "CA:true" : "CA:false") + "\n";
        s = this.pathLen >= 0 ? s + "PathLen:" + this.pathLen + "\n" : s + "PathLen: undefined\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s + "]\n");
        }
        return s + "]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.BasicConstraints_Id;
            this.critical = this.ca;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(IS_CA)) {
            if (!(obj instanceof Boolean)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                }
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.ca = (Boolean)obj;
        } else if (name.equalsIgnoreCase(PATH_LEN)) {
            if (!(obj instanceof Integer)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Integer.");
                }
                throw new IOException("Attribute value should be of type Integer.");
            }
            this.pathLen = (Integer)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(IS_CA)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Boolean(this.ca));
            }
            return new Boolean(this.ca);
        }
        if (name.equalsIgnoreCase(PATH_LEN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Integer(this.pathLen));
            }
            return new Integer(this.pathLen);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get_3", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(IS_CA)) {
            this.ca = false;
        } else if (name.equalsIgnoreCase(PATH_LEN)) {
            this.pathLen = -1;
        } else {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "delete", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(IS_CA);
        elements.addElement(PATH_LEN);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

