/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class SigningTime
extends PKCS9DerObject
implements Cloneable {
    private Date date;
    private boolean bUTCTime;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SigningTime";
    private volatile int cachedHashVal = 0;

    public SigningTime(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SigningTime", (Object)der);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", der, provider);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SigningTime", date);
        }
        this.date = date;
        this.bUTCTime = true;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", date, provider);
        }
        this.date = date;
        this.bUTCTime = true;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, boolean bUTCTime) {
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", date, new Boolean(bUTCTime));
        }
        this.date = date;
        this.bUTCTime = bUTCTime;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, boolean bUTCTime, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{date, new Boolean(bUTCTime), provider};
            debug.entry(16384L, (Object)className, "SigningTime", parms);
        }
        this.date = date;
        this.bUTCTime = bUTCTime;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", filename, new Boolean(base64));
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SigningTime", parms);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SigningTime result = new SigningTime(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, className, "equals");
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof SigningTime) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((SigningTime)obj)));
            }
            return this.equals((SigningTime)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNING_TIME_OID);
        }
        return PKCSOID.SIGNING_TIME_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.date == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Date not specified.");
            }
            throw new IOException("Date not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        if (this.bUTCTime) {
            tmpout2.putUTCTime(this.date);
        } else {
            tmpout2.putGeneralizedTime(this.date);
        }
        tmpout.write((byte)49, tmpout2.toByteArray());
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Date getDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getDate");
            debug.exit(16384L, (Object)className, "getDate", this.date.clone());
        }
        return (Date)this.date.clone();
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getDate());
        }
        return this.getDate();
    }

    @Override
    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 23 || tag == 24) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    @Override
    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "SigningTime");
        }
        return "SigningTime";
    }

    @Override
    public String toString() {
        String out = "PKCS9 SigningTime:\r\n";
        out = this.date != null ? out + "\t" + this.date + "\r\n" : out + "\tnull\r\n";
        out = this.bUTCTime ? out + "\tEncoded in UTCTime\r\n" : out + "\tEncoded in GeneralizedTime\r\n";
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        if (elems[0].getTag() == 23) {
            this.date = new DerInputStream(elems[0].toByteArray()).getUTCTime();
            this.bUTCTime = true;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (elems[0].getTag() == 24) {
            this.date = new DerInputStream(elems[0].toByteArray()).getGeneralizedTime();
            this.bUTCTime = false;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", "tag " + elems[0].getTag() + " not valid.");
        }
        throw new IOException("tag " + elems[0].getTag() + " not valid.");
    }

    private boolean equals(SigningTime other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

