/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.AuthenticatedData;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.DigestedData;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedAndEnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptedContentInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ENCRYPTED_CONTENT = 0;
    private ObjectIdentifier contentType;
    private AlgorithmId contentEncryptionAlgorithm;
    private byte[] encryptedContent;
    private SmudgedBytes encryptionKeyBytes;
    private static final String MODE_AND_PADDING = "/CBC/PKCS5Padding";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncryptedContentInfo";
    private volatile int cachedHashVal = 0;

    public EncryptedContentInfo(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", (Object)der);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "EncryptedContentInfo", der, provider);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ObjectIdentifier contentType, AlgorithmId contentEncryptionAlg, byte[] encryptedContent) {
        if (debug != null) {
            Object[] parms = new Object[]{contentType, contentEncryptionAlg, encryptedContent};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlg;
        this.encryptedContent = encryptedContent;
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ObjectIdentifier contentType, AlgorithmId contentEncryptionAlg, byte[] encryptedContent, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{contentType, contentEncryptionAlg, encryptedContent, provider};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlg;
        this.encryptedContent = encryptedContent;
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo cinfo, String algname, int keySize, String provider) throws PKCSException, IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, new Integer(keySize), provider};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.encrypt(cinfo, algname, keySize);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo cinfo, String algname, int keySize) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, new Integer(keySize)};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.encrypt(cinfo, algname, keySize);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo cinfo, String algname, byte[] key) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, key};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.encrypt(cinfo, algname, key);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(ContentInfo cinfo, String algname, byte[] key, String provider) throws PKCSException, IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, key, provider};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
        }
        this.encrypt(cinfo, algname, key);
        if (debug != null) {
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    public EncryptedContentInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "EncryptedContentInfo", parms);
            debug.exit(16384L, className, "EncryptedContentInfo");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.contentType);
        this.contentEncryptionAlgorithm.encode(bytes);
        if (this.encryptedContent != null) {
            DerOutputStream tmpout = new DerOutputStream();
            tmpout.putOctetString(this.encryptedContent);
            bytes.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmpout);
        }
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        DerValue opt;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncryptedContentInfo parsing error.");
            }
            throw new IOException("EncryptedContentInfo parsing error.");
        }
        this.contentType = encoding.getData().getOID();
        DerValue der = encoding.getData().getDerValue();
        this.contentEncryptionAlgorithm = AlgorithmId.parse(der);
        if (encoding.getData().available() != 0 && (opt = encoding.getData().getDerValue()).isContextSpecific((byte)0)) {
            if (opt.isConstructed()) {
                byte[] content = opt.getData().toByteArray();
                this.encryptedContent = PKCS7.stripOctetTags(content);
            } else {
                opt.resetTag((byte)4);
                this.encryptedContent = opt.getOctetString();
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof EncryptedContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((EncryptedContentInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 EncryptedContentInfo:\r\n";
        out = out + "\tcontentType: " + this.contentType;
        out = out + "\r\n\tcontentEncryptionAlgorithm: " + this.contentEncryptionAlgorithm;
        out = this.encryptedContent != null ? out + "\r\n\tencryptedDigest: \r\n" + hexDump.encodeBuffer(this.encryptedContent) + "\r\n" : out + "\r\n\tencryptedContent: null";
        return out;
    }

    private void encrypt(ContentInfo cinfo, String algname, int keySize) throws PKCSException, IOException {
        Cipher cipher;
        AlgorithmId tmpAlgId;
        String alg;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, new Integer(keySize)};
            debug.entry(8192L, (Object)className, "encrypt", parms);
        }
        String algIdName = alg = EncryptedContentInfo.getAlgorithm(algname);
        if (alg.equalsIgnoreCase("AES")) {
            if (keySize != 128 && keySize != 192 && keySize != 256) {
                throw new IllegalArgumentException("Invalid key size " + keySize + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (keySize) {
                case 128: {
                    algIdName = "AES128";
                    break;
                }
                case 192: {
                    algIdName = "AES192";
                    break;
                }
                case 256: {
                    algIdName = "AES256";
                    break;
                }
            }
        }
        try {
            tmpAlgId = AlgorithmId.get(algIdName);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + alg + ". Must be one of AES, DES, DESede or RC2.");
        }
        this.contentType = cinfo.getContentType();
        DerOutputStream derout = new DerOutputStream();
        cinfo.getContent().encode(derout);
        DerValue der = new DerValue(derout.toByteArray());
        byte[] toBeEncrypted = der.getData().toByteArray();
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(alg);
            keyGen.init(keySize);
            SecretKey encryptionKey = keyGen.generateKey();
            this.setEncryptionKeyBytes(encryptionKey.getEncoded());
            String cipherAlg = alg + MODE_AND_PADDING;
            cipher = this.provider != null ? Cipher.getInstance(cipherAlg, this.provider) : Cipher.getInstance(cipherAlg);
            cipher.init(1, encryptionKey);
            this.encryptedContent = cipher.doFinal(toBeEncrypted);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting contents (" + e.toString() + ")");
        }
        AlgorithmParameters params = cipher.getParameters();
        byte[] encodedParms = null;
        if (params != null) {
            encodedParms = params.getEncoded();
        }
        try {
            tmpAlgId = AlgorithmId.get(algIdName);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + alg + ". Must be one of DES, DESede or RC2.");
        }
        ObjectIdentifier oid = tmpAlgId.getOID();
        this.contentEncryptionAlgorithm = encodedParms != null ? new AlgorithmId(oid, encodedParms, this.provider) : new AlgorithmId(oid, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encrypt");
        }
    }

    private void encrypt(ContentInfo cinfo, String algname, byte[] key) throws PKCSException, IOException {
        Cipher cipher;
        SecretKey secretKey;
        ObjectIdentifier oid;
        String alg;
        if (debug != null) {
            Object[] parms = new Object[]{cinfo, algname, key};
            debug.entry(8192L, (Object)className, "encrypt", parms);
        }
        String algIdName = alg = EncryptedContentInfo.getAlgorithm(algname);
        if (alg.equalsIgnoreCase("AES")) {
            if (key.length != 16 && key.length != 24 && key.length != 32) {
                throw new IllegalArgumentException("Invalid key size " + key.length + ". Must be 128, " + "192 or 256 for AES key");
            }
            switch (key.length) {
                case 128: {
                    algIdName = "AES128";
                    break;
                }
                case 192: {
                    algIdName = "AES192";
                    break;
                }
                case 256: {
                    algIdName = "AES256";
                    break;
                }
            }
        }
        try {
            AlgorithmId tmpAlgId = AlgorithmId.get(algIdName);
            oid = tmpAlgId.getOID();
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new IllegalArgumentException("Unsupported algorithm " + alg + ". Must be one of AES, DES, DESede or RC2.");
        }
        this.contentType = cinfo.getContentType();
        DerOutputStream derout = new DerOutputStream();
        cinfo.getContent().encode(derout);
        DerValue der = new DerValue(derout.toByteArray());
        byte[] toBeEncrypted = der.getData().toByteArray();
        try {
            SecretKeyFactory keyFac;
            KeySpec keyspec;
            if (oid.equals(AlgorithmId.DESCBC_oid)) {
                keyspec = new DESKeySpec(key);
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            } else if (oid.equals(AlgorithmId.tripleDESCBC_oid)) {
                keyspec = new DESedeKeySpec(key);
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            } else {
                keyspec = new SecretKeySpec(key, "RC2");
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Key generation error (" + e.toString() + ")");
        }
        try {
            String cipherAlg = alg + MODE_AND_PADDING;
            cipher = this.provider != null ? Cipher.getInstance(cipherAlg, this.provider) : Cipher.getInstance(cipherAlg);
            cipher.init(1, secretKey);
            this.encryptedContent = cipher.doFinal(toBeEncrypted);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "encrypt", e);
            }
            throw new PKCSException(e, "Error encrypting contents (" + e.toString() + ")");
        }
        AlgorithmParameters params = cipher.getParameters();
        byte[] encodedParms = null;
        if (params != null) {
            encodedParms = params.getEncoded();
        }
        this.contentEncryptionAlgorithm = encodedParms != null ? new AlgorithmId(oid, encodedParms, this.provider) : new AlgorithmId(oid, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "encrypt");
        }
    }

    public ContentInfo decrypt(byte[] decryptionKey) throws IOException, PKCSException {
        Content content;
        byte[] decryptedContent;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decrypt", (Object)decryptionKey);
        }
        if (this.encryptedContent == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "No content to decrypt.");
            }
            throw new PKCSException("No content to decrypt.");
        }
        String algname = this.contentEncryptionAlgorithm.getName();
        ObjectIdentifier oid = this.contentEncryptionAlgorithm.getOID();
        if (!(oid.equals(AlgorithmId.DESCBC_oid) || oid.equals(AlgorithmId.tripleDESCBC_oid) || oid.equals(AlgorithmId.RC2CBC_oid) || oid.equals(AlgorithmId.AES128CBC_oid) || oid.equals(AlgorithmId.AES192CBC_oid) || oid.equals(AlgorithmId.AES256CBC_oid))) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Unsupported decryption algorithm: " + algname + ". Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Unsupported decryption algorithm: " + algname + ". Must be one of AES, DES, DESede or RC2.");
        }
        try {
            SecretKey secretKey;
            SecretKeyFactory keyFac;
            KeySpec keyspec;
            if (oid.equals(AlgorithmId.DESCBC_oid)) {
                keyspec = new DESKeySpec(decryptionKey);
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            } else if (oid.equals(AlgorithmId.tripleDESCBC_oid)) {
                keyspec = new DESedeKeySpec(decryptionKey);
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            } else if (oid.equals(AlgorithmId.RC2CBC_oid)) {
                keyspec = new SecretKeySpec(decryptionKey, "RC2");
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            } else {
                keyspec = new SecretKeySpec(decryptionKey, "AES");
                algname = "AES";
                keyFac = this.provider != null ? SecretKeyFactory.getInstance(algname, this.provider) : SecretKeyFactory.getInstance(algname);
                secretKey = keyFac.generateSecret(keyspec);
            }
            byte[] encodedParams = this.contentEncryptionAlgorithm.getParameters();
            AlgorithmParameters params = this.provider != null ? AlgorithmParameters.getInstance(algname, this.provider) : AlgorithmParameters.getInstance(algname);
            params.init(encodedParams);
            String cipherAlg = algname + MODE_AND_PADDING;
            Cipher cipher = null;
            cipher = this.provider != null ? Cipher.getInstance(cipherAlg, this.provider) : Cipher.getInstance(cipherAlg);
            cipher.init(2, (Key)secretKey, params);
            decryptedContent = cipher.doFinal(this.encryptedContent);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", e);
            }
            throw new PKCSException(e, "Content decryption error (" + e.toString() + ")");
        }
        DerOutputStream derout = new DerOutputStream();
        if (this.contentType.equals(PKCSOID.DATA_OID)) {
            derout.write((byte)4, decryptedContent);
            content = new Data(derout.toByteArray(), this.provider);
        } else {
            derout.write((byte)48, decryptedContent);
            DerValue der = new DerValue(derout.toByteArray());
            if (this.contentType.equals(PKCSOID.SIGNED_DATA_OID)) {
                content = new SignedData(der.toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.ENVELOPED_DATA_OID)) {
                content = new EnvelopedData(der.toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.SIGNED_AND_ENVELOPED_DATA_OID)) {
                content = new SignedAndEnvelopedData(der.toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.DIGESTED_DATA_OID)) {
                content = new DigestedData(der.toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.ENCRYPTED_DATA_OID)) {
                content = new EncryptedData(der.toByteArray(), this.provider);
            } else if (this.contentType.equals(PKCSOID.AUTHENTICATED_DATA_OID)) {
                content = new AuthenticatedData(der.toByteArray(), this.provider);
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "decrypt", "Unrecognized content type");
                }
                throw new IllegalArgumentException("Unrecognized content type");
            }
        }
        ContentInfo result = new ContentInfo(content);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", result);
        }
        return result;
    }

    public AlgorithmId getContentEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentEncryptionAlgorithm");
        }
        if (this.contentEncryptionAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.contentEncryptionAlgorithm.getOID(), this.contentEncryptionAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentEncryptionAlgorithm", result);
        }
        return result;
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public byte[] getEncryptedContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedContent");
            debug.exit(16384L, (Object)className, "getEncryptedContent", this.encryptedContent.clone());
        }
        return (byte[])this.encryptedContent.clone();
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            EncryptedContentInfo result = new EncryptedContentInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public byte[] getEncryptionKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionKey");
        }
        if (this.encryptionKeyBytes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptionKey", null);
            }
            return null;
        }
        byte[] bytes = this.getEncryptionKeyBytes();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptionKey", bytes.clone());
        }
        return (byte[])bytes.clone();
    }

    static String getAlgorithm(String input) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAlgorithm", input);
        }
        if (input == null) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "No algorithm given");
            }
            throw new IllegalArgumentException("No algorithm given");
        }
        int count = 0;
        String[] parts = new String[3];
        StringTokenizer parser = new StringTokenizer(input, "/");
        try {
            while (parser.hasMoreTokens() && count < 3) {
                parts[count++] = parser.nextToken();
            }
            if (count == 0 || count == 2 || parser.hasMoreTokens()) {
                if (debug != null) {
                    debug.text(16384L, className, "getAlgorithm", "Wrong algorithm format - too many tokens");
                }
                throw new IllegalArgumentException("Wrong algorithm format");
            }
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getAlgorithm", e);
                debug.text(16384L, className, "setAlgorithm", "Wrong algorithm format");
            }
            throw new IllegalArgumentException("Wrong algorithm format");
        }
        if (!(parts[0].equalsIgnoreCase("DES") || parts[0].equalsIgnoreCase("tripleDES") || parts[0].equalsIgnoreCase("DESede") || parts[0].equalsIgnoreCase("3DES") || parts[0].equalsIgnoreCase("RC2") || parts[0].equalsIgnoreCase("AES"))) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption algorithm: " + parts[0] + ". Must be one of DES, DESede or RC2.");
            }
            throw new IllegalArgumentException("Unsupported encryption algorithm: " + parts[0] + ". Must be one of AES, DES, DESede or RC2.");
        }
        if (parts[1] != null && !parts[1].equalsIgnoreCase("CBC")) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption mode: " + parts[1] + ". Must be CBC.");
            }
            throw new IllegalArgumentException("Unsupported encryption mode: " + parts[1] + ". Must be CBC.");
        }
        if (parts[2] != null && !parts[2].equalsIgnoreCase("PKCS5Padding")) {
            if (debug != null) {
                debug.text(16384L, className, "getAlgorithm", "Unsupported encryption padding: " + parts[2] + ". Must be PKCS5Padding.");
            }
            throw new IllegalArgumentException("Unsupported encryption padding: " + parts[2] + ". Must be PKCS5Padding.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAlgorithm", parts[0]);
        }
        return parts[0];
    }

    private void setEncryptionKeyBytes(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionKeyBytes", (Object)bytes);
        }
        this.encryptionKeyBytes = new SmudgedBytes(bytes, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionKeyBytes");
        }
    }

    private byte[] getEncryptionKeyBytes() {
        if (debug != null) {
            debug.entry(8192L, className, "getEncryptionKeyBytes");
        }
        if (this.encryptionKeyBytes == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEncryptionKeyBytes", null);
            }
            return null;
        }
        byte[] result = this.encryptionKeyBytes.getClearText();
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getAlgorithm", result);
        }
        return result;
    }

    protected void finalize() {
        this.encryptionKeyBytes = null;
    }
}

