/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.flexlm;

import com.ibm.cic.licensing.common.util.ILicUserActivityEventListener;
import com.ibm.cic.licensing.common.util.LicUserActivityEvent;
import com.ibm.cic.licensing.common.util.LicUserActivityEventManager;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import com.macrovision.flexlm.ConnectionDataAdapter;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.Heartbeat;
import com.macrovision.flexlm.HeartbeatEvent;
import com.macrovision.flexlm.HeartbeatListener;

public class HeartbeatWorker
extends ConnectionDataAdapter
implements HeartbeatListener,
ILicUserActivityEventListener {
    private Heartbeat heartbeat;
    private final int interval;
    private final int retryInterval;
    private final int retryLimit;

    private HeartbeatWorker(int interval, int retryInterval, int count) {
        this.interval = interval;
        this.retryInterval = retryInterval;
        this.retryLimit = count;
    }

    public HeartbeatWorker() {
        this(120, 120, -1);
    }

    private void setHearbeatBlocked(boolean blocked) {
        this.heartbeat.setHeartbeatBlocked(blocked);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("HeartbeatWorker - HeartbeatBolck set to " + blocked));
        }
    }

    public void initHeartbeat(Heartbeat hb) {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)"HeartbeatWorker - initHeartbeat entered");
        }
        this.heartbeat = hb;
        hb.addHeartbeatListener((HeartbeatListener)this);
        LicUserActivityEventManager.getInstance().addLicUserActivityListener((ILicUserActivityEventListener)this);
        try {
            this.heartbeat.setHeartbeatInterval(this.interval);
            this.heartbeat.setRetryInterval(this.retryInterval);
            this.heartbeat.setRetryLimit(this.retryLimit);
        }
        catch (FlexlmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void reconnectAttempted(HeartbeatEvent event) {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("reconnectAttempted for License of feature" + event.getFeature().getName()));
        }
        this.performReconnect();
    }

    public void reconnectSucceeded(HeartbeatEvent event) {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("reconnectSucceeded for License of feature" + event.getFeature().getName()));
        }
        this.performReconnect();
    }

    public void reconnectFailed(HeartbeatEvent event) {
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)("reconnectFailed for License of feature" + event.getFeature().getName()));
        }
        this.performReconnect();
    }

    private void performReconnect() {
        if (LicUserUtils.isRunningHeadless() || LicUserUtils.isUiActive()) {
            this.setHearbeatBlocked(false);
            this.heartbeat.doHeartbeat();
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)"performReconnect(): doHeartbeat called as UI is active");
            }
        } else if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)"performReconnect(): doHeartbeat NOT called as UI is idle");
        }
    }

    public void handleLicUserActivityEvent(LicUserActivityEvent event) {
        if (!event.isBlock()) {
            this.setHearbeatBlocked(false);
            this.heartbeat.doHeartbeat();
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)"handleLicUserActivityEvent(): doHeartbeat called as UI is active");
            }
        } else {
            this.setHearbeatBlocked(true);
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.trace((String)"handleLicUserActivityEvent(): setHeartbeatBlocked as UI is idle");
            }
        }
    }
}

