/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.flexlm;

import java.util.ArrayList;
import java.util.Iterator;
import org.osgi.framework.Version;

public class FlexUsageData {
    public static final String TS_FILE_EXT = "ts";
    public static final String TS_FILE_NAME = "flexuse.ts";
    public static final String ROOT_ELEMENT_NAME = "flexuse";
    private final AbstractTopLevelData root = new RootData(false);

    public AbstractTopLevelData getRoot() {
        return this.root;
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.root.toXML());
        return sb.toString();
    }

    public static abstract class AbstractData {
        private AbstractData parent = null;
        private final ArrayList childList;
        private ArrayList listeners = null;
        protected static final AbstractData[] NO_CHILDREN = new AbstractData[0];
        protected static final String[] NO_ATTRIBUTES = new String[0];
        protected static final String NO_ELEMENT_TEXT = "";

        protected AbstractData() {
            this(null);
        }

        protected AbstractData(ArrayList childList) {
            this.childList = childList;
        }

        public String toString() {
            return this.toXML();
        }

        public String toXML() {
            StringBuffer sb = new StringBuffer();
            this.toXML(sb, NO_ELEMENT_TEXT);
            return sb.toString();
        }

        public void toXML(StringBuffer sb, String indent) {
            String elemName = this.getElementName();
            String[] nameValuePairs = this.getAttrNameValuePairs();
            sb.append(indent).append('<').append(elemName);
            String attrPrefix = " ";
            int totalLen = indent.length() + elemName.length() + 3;
            int i = 0;
            while (i < nameValuePairs.length) {
                if ((totalLen += nameValuePairs[i].length() + 2) >= 72) {
                    attrPrefix = String.valueOf('\n') + indent + "    ";
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < nameValuePairs.length) {
                String name = nameValuePairs[i++];
                String value = this.escape(nameValuePairs[i++]);
                sb.append(attrPrefix).append(name);
                sb.append("=\"").append(value).append('\"');
            }
            AbstractData[] children = this.getChildren();
            String elemText = this.getElementText();
            if (children.length == 0 && elemText.length() == 0) {
                sb.append("/>");
                return;
            }
            sb.append('>');
            sb.append(this.escape(elemText));
            String newIndent = String.valueOf(indent) + "  ";
            int i2 = 0;
            while (i2 < children.length) {
                AbstractData child = children[i2];
                sb.append('\n');
                child.toXML(sb, newIndent);
                ++i2;
            }
            if (children.length != 0) {
                sb.append('\n').append(indent);
            }
            sb.append("</").append(elemName).append('>');
        }

        public AbstractData getParent() {
            return this.parent;
        }

        private void setParent(AbstractData parent) {
            this.parent = parent;
        }

        public AbstractData[] getChildren() {
            if (this.childList == null) {
                return NO_CHILDREN;
            }
            return this.childList.toArray(new AbstractData[this.childList.size()]);
        }

        protected ArrayList getChildList() {
            return this.childList;
        }

        public void addChild(AbstractData child) {
            this.addChild(-1, child);
        }

        public void addChild(int index, AbstractData child) {
            if (this.childList == null) {
                return;
            }
            AbstractData currentParent = child.getParent();
            if (currentParent != null) {
                currentParent.removeChild(child);
            }
            child.setParent(this);
            if (index < 0) {
                this.childList.add(child);
            } else {
                this.childList.add(index, child);
            }
            this.notifyAdd(index, child);
        }

        public void removeChild(AbstractData child) {
            if (this.childList == null) {
                return;
            }
            int i = this.childList.indexOf(child);
            if (i >= 0) {
                child.setParent(null);
                this.childList.remove(i);
                this.notifyRemove(i, child);
            }
        }

        public void removeAllChildren() {
            if (this.childList == null) {
                return;
            }
            Iterator iter = this.childList.iterator();
            while (iter.hasNext()) {
                AbstractData child = (AbstractData)iter.next();
                child.setParent(null);
            }
            this.childList.clear();
            this.notifyRemove(-1, null);
        }

        public void addDataChangeListener(IDataChangeListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public void removeDataChangeListener(IDataChangeListener listener) {
            if (this.listeners != null && listener != null) {
                this.listeners.remove(listener);
            }
        }

        public void notifyAdd(int childIndex, AbstractData childData) {
            if (this.listeners != null) {
                DataAddEvent event = new DataAddEvent(this, childIndex, childData);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyAdd(childIndex, childData);
            }
        }

        public void notifyRemove(int childIndex, AbstractData childData) {
            if (this.listeners != null) {
                DataRemoveEvent event = new DataRemoveEvent(this, childIndex, childData);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyRemove(childIndex, childData);
            }
        }

        public void notifyChange() {
            if (this.listeners != null) {
                DataChangeEvent event = new DataChangeEvent(this);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyChange();
            }
        }

        private void notifyEvent(DataEvent event) {
            if (this.listeners != null) {
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    IDataChangeListener listener = (IDataChangeListener)iter.next();
                    try {
                        listener.dataChanged(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.parent != null) {
                this.parent.notifyEvent(event);
            }
        }

        protected abstract String getElementName();

        protected String[] getAttrNameValuePairs() {
            return NO_ATTRIBUTES;
        }

        protected String getElementText() {
            return NO_ELEMENT_TEXT;
        }

        protected String escape(String x) {
            int i = x.length() - 1;
            while (i >= 0) {
                block8: {
                    String replace;
                    switch (x.charAt(i)) {
                        case '<': {
                            replace = "&lt;";
                            break;
                        }
                        case '>': {
                            replace = "&gt;";
                            break;
                        }
                        case '\"': {
                            replace = "&quot;";
                            break;
                        }
                        case '\'': {
                            replace = "&apos;";
                            break;
                        }
                        case '&': {
                            replace = "&amp;";
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    x = String.valueOf(x.substring(0, i)) + replace + x.substring(i + 1);
                }
                --i;
            }
            return x;
        }

        protected boolean isDifferent(Object o1, Object o2) {
            if (o1 == o2) {
                return false;
            }
            if (o1 == null) {
                return true;
            }
            return !o1.equals(o2);
        }
    }

    public static abstract class AbstractTopLevelData
    extends AbstractData {
        public static final String READONLY_ATTR = "readonly";
        private boolean readonly;

        protected AbstractTopLevelData(boolean readonly) {
            super(new ArrayList());
            this.readonly = readonly;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            if (this.readonly != readonly) {
                this.readonly = readonly;
                this.notifyChange();
            }
        }
    }

    public static abstract class ChildDataEvent
    extends DataEvent {
        private final int childIndex;
        private final AbstractData childData;

        protected ChildDataEvent(int eventKind, AbstractData parentData, int childIndex, AbstractData childData) {
            super(eventKind, parentData);
            this.childIndex = childIndex;
            this.childData = childData;
        }

        public AbstractData getParentData() {
            return this.getChangedData();
        }

        public AbstractData getChildData() {
            return this.childData;
        }

        public int getChildIndex() {
            return this.childIndex;
        }
    }

    public static class DataAddEvent
    extends ChildDataEvent {
        public DataAddEvent(AbstractData parentData, int childIndex, AbstractData childData) {
            super(1, parentData, childIndex, childData);
        }
    }

    public static class DataChangeEvent
    extends DataEvent {
        public DataChangeEvent(AbstractData changedData) {
            super(3, changedData);
        }
    }

    public static abstract class DataEvent {
        public static final int ADD_EVENT = 1;
        public static final int REMOVE_EVENT = 2;
        public static final int CHANGE_EVENT = 3;
        private final int eventKind;
        private final AbstractData changedData;

        protected DataEvent(int eventKind, AbstractData changedData) {
            this.eventKind = eventKind;
            this.changedData = changedData;
        }

        public AbstractData getChangedData() {
            return this.changedData;
        }

        public int getEventKind() {
            return this.eventKind;
        }
    }

    public static class DataRemoveEvent
    extends ChildDataEvent {
        public DataRemoveEvent(AbstractData parentData, int childIndex, AbstractData childData) {
            super(2, parentData, childIndex, childData);
        }
    }

    public static interface IDataChangeListener {
        public void dataChanged(DataEvent var1);
    }

    public static class LastUseTagData
    extends AbstractData {
        public static final String ELEMENT_NAME = "lastuse";
        public static final String TIMESTAMP_ATTR = "time";
        private String ts;

        public LastUseTagData(String ats) {
            this.ts = ats;
        }

        public String getTime() {
            return this.ts;
        }

        public void setTime(String ats) {
            if (this.isDifferent(this.ts, ats)) {
                this.ts = ats;
                this.notifyChange();
            }
        }

        protected String getElementName() {
            return ELEMENT_NAME;
        }

        protected String[] getAttrNameValuePairs() {
            return new String[]{TIMESTAMP_ATTR, this.ts};
        }
    }

    public static class OfferingTagData
    extends AbstractTopLevelData {
        public static final String ELEMENT_NAME = "offering";
        public static final String ID_ATTR = "id";
        public static final String VERSION_ATTR = "version";
        private String id;
        private Version version;

        public OfferingTagData(boolean readonly) {
            super(readonly);
        }

        public OfferingTagData(String id, Version version) {
            super(false);
            this.id = id;
            this.version = version;
        }

        public static String toKeyString(String id, String version) {
            return String.valueOf(id) + '_' + version.toString();
        }

        public String toKeyString() {
            return OfferingTagData.toKeyString(this.id, this.version.toString());
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (this.isDifferent(this.id, id)) {
                this.id = id;
                this.notifyChange();
            }
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            if (this.isDifferent(this.version, version)) {
                this.version = version;
                this.notifyChange();
            }
        }

        public LastUseTagData getLastUseData() {
            ArrayList childList = this.getChildList();
            return childList.toArray(new LastUseTagData[childList.size()])[0];
        }

        public void addLastUseData(LastUseTagData ludata) {
            this.addChild(ludata);
        }

        public void removeLastUseData(LastUseTagData ludata) {
            this.removeChild(ludata);
        }

        protected String getElementName() {
            return ELEMENT_NAME;
        }

        protected String[] getAttrNameValuePairs() {
            return new String[]{ID_ATTR, this.id, VERSION_ATTR, this.version.toString()};
        }
    }

    public static class RootData
    extends AbstractTopLevelData {
        public RootData(boolean readonly) {
            super(readonly);
        }

        protected String getElementName() {
            return FlexUsageData.ROOT_ELEMENT_NAME;
        }
    }
}

