/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.core;

import com.ibm.cic.licensing.common.core.ILicenseCheckProvider;
import com.ibm.cic.licensing.common.core.LicenseCheckerFactory;
import com.ibm.cic.licensing.common.core.Messages;
import com.ibm.cic.licensing.common.core.RegScanner;
import com.ibm.cic.licensing.common.util.ComponentKey;
import com.ibm.cic.licensing.common.util.ComponentKeyVO;
import com.ibm.cic.licensing.common.util.LicPlatformUtils;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.common.util.ProductInformation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

public class LicenseChecker {
    private static String lastErrMsg = "";
    private static Hashtable lastErrCondtion = new Hashtable();

    public static void returnLicense(Plugin aPlugin, String aFeatureName, String aVersion) {
        String bundleName = LicUserUtils.getPluginName((Plugin)aPlugin, (String)aFeatureName);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("returnLicense(plugin, fname, fversion) called from " + bundleName + " for (" + aFeatureName + ", " + aVersion + ")"));
        }
        Hashtable piMap = RegScanner.getPiMap();
        List<ProductInformation> pis = new LinkedList();
        LicensePolicyData.ComponentData cdata = PolicyManager.getComponent((String)aFeatureName, (String)aVersion);
        if (cdata != null) {
            LicensePolicyData.OfferingData[] offeringIds = cdata.getOfferings();
            int i = 0;
            while (i < offeringIds.length) {
                String id = offeringIds[i].getId();
                ProductInformation pi = LicenseChecker.getPiById(id);
                if (pi != null) {
                    pis.add(pi);
                } else {
                    Logger.logNtrace((int)Logger.ERROR, (String)("LicenseChecker.returnLicense(): invalid offering id in componentmap " + id));
                }
                ++i;
            }
        } else {
            ComponentKey ck = new ComponentKey(aFeatureName, aVersion);
            pis = LicenseChecker.getPIsByCompKey(piMap, ck);
        }
        if (pis == null || pis.size() < 1) {
            String errmsg = NLS.bind((String)Messages.Plugin_No_Key, (Object)bundleName);
            LicenseChecker.setLastErrMsg(errmsg);
            lastErrCondtion.put(new ProductInformation("NILL"), new Exception(NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName)));
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName));
            }
        }
        Iterator iter = pis.iterator();
        while (iter.hasNext()) {
            ProductInformation pi = (ProductInformation)iter.next();
            String licType = pi.getLicType() == null ? "LUM" : pi.getLicType();
            ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker(licType);
            licenseChecker.checkin(pi);
        }
    }

    public static int requestLicense(Plugin aPlugin, String aFeatureName, String aVersion, boolean quiet) {
        String errmsg;
        boolean isSuccess = false;
        String purchaseURL = "http://www.ibm.com/software/info/ecatalog";
        boolean isServerVersionLower = false;
        LicenseChecker.setLastErrMsg("");
        lastErrCondtion.clear();
        String bundleName = LicUserUtils.getPluginName((Plugin)aPlugin, (String)aFeatureName);
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.logNtrace((String)("requestLicense(plugin, fname, fversion) called from " + bundleName + " for (" + aFeatureName + ", " + aVersion + ")"));
        }
        Hashtable piMap = RegScanner.getPiMap();
        List<ProductInformation> pis = new LinkedList();
        LicensePolicyData.ComponentData cdata = PolicyManager.getComponent((String)aFeatureName, (String)aVersion);
        if (cdata != null) {
            LicensePolicyData.OfferingData[] offeringIds = cdata.getOfferings();
            int i = 0;
            while (i < offeringIds.length) {
                String id = offeringIds[i].getId();
                ProductInformation pi = LicenseChecker.getPiById(id);
                if (pi != null) {
                    pis.add(pi);
                } else {
                    Logger.logNtrace((int)Logger.ERROR, (String)("LicenseChecker.requestLicense(): invalid offering id in componentmap " + id));
                }
                ++i;
            }
        } else {
            ComponentKey ck = new ComponentKey(aFeatureName, aVersion);
            pis = LicenseChecker.getPIsByCompKey(piMap, ck);
        }
        if (pis == null || pis.size() < 1) {
            if (!quiet) {
                errmsg = NLS.bind((String)Messages.Plugin_No_Key, (Object)bundleName);
                LicenseChecker.setLastErrMsg(errmsg);
                lastErrCondtion.put(new ProductInformation("NILL"), new Exception(NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName)));
            }
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.Offering_Not_Found, (Object)bundleName));
            }
            return 2;
        }
        if (pis.size() == 1) {
            purchaseURL = ((ProductInformation)pis.get(0)).getPurchaseUrl();
        }
        Iterator iter = pis.iterator();
        while (iter.hasNext()) {
            ProductInformation pi = (ProductInformation)iter.next();
            LicenseStatus licstatus = pi.getLicenseStatus();
            if (licstatus != null && licstatus.isLicenseGranted()) {
                if (pi.isExpirationWarned()) {
                    return 0;
                }
                if (licstatus.getStatusCode() == 4) {
                    LicenseChecker.setRunInDisconnectStatus(pi);
                } else if (licstatus.isLicenseWillExpire()) {
                    LicenseChecker.setWillExpireStatus(pi, licstatus);
                }
                return licstatus.getStatusCode();
            }
            String licType = pi.getLicType() == null ? "LUM" : pi.getLicType();
            ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker(licType);
            licstatus = licenseChecker.checkout(pi);
            if (licstatus.isLicenseGranted()) {
                isSuccess = true;
                if (licstatus.getStatusCode() == 4) {
                    LicenseChecker.setRunInDisconnectStatus(pi);
                } else if (licstatus.isLicenseWillExpire()) {
                    LicenseChecker.setWillExpireStatus(pi, licstatus);
                }
                return licstatus.getStatusCode();
            }
            if (pi.getLicenseStatus().getStatusCode() == 5) {
                isServerVersionLower = true;
            }
            LicenseChecker.updateErrCondition(pi);
        }
        if (!isSuccess && isServerVersionLower) {
            errmsg = NLS.bind((String)Messages.LicenseServerUpgradeRequired, (Object)bundleName);
            LicenseChecker.setLastErrMsg(errmsg);
            if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                Logger.logNtrace((int)Logger.ERROR, (String)NLS.bind((String)Messages.LicenseServerUpgradeRequired, (Object)bundleName));
            }
            return 5;
        }
        if (!isSuccess) {
            errmsg = pis.size() == 1 ? LicenseChecker.getLicenseMessageFormText(NLS.bind((String)Messages.License_Check_Failed_Single_Offering, (Object)((ProductInformation)pis.get(0)).getProductName()), purchaseURL) : LicenseChecker.getLicenseMessageFormText(NLS.bind((String)Messages.License_Check_Failed, (Object)bundleName), purchaseURL);
            LicenseChecker.setLastErrMsg(errmsg);
            return 2;
        }
        return -1;
    }

    public static int requestLicense(Plugin aPlugin, String aFeatureName, String aVersion) {
        return LicenseChecker.requestLicense(aPlugin, aFeatureName, aVersion, false);
    }

    private static void setWillExpireStatus(ProductInformation pi, LicenseStatus licstatus) {
        String purchaseURL = LicenseChecker.getProductPurchaseUrl(pi);
        String prodname = pi.getProductName();
        String daysToExpire = String.valueOf(licstatus.getDaysToExpire());
        String nlsmsg = NLS.bind((String)Messages.Prod_Will_Expire, (Object)prodname, (Object)daysToExpire);
        LicenseChecker.setLastErrMsg(LicenseChecker.getLicenseMessageFormText(nlsmsg, purchaseURL));
        lastErrCondtion.put(pi, new Exception(NLS.bind((String)Messages.Prod_Expires_In_Days, (Object[])new String[]{prodname, daysToExpire, purchaseURL})));
    }

    public static String getProductPurchaseUrl(ProductInformation pi) {
        String purchaseURL = "http://www.ibm.com/software/info/ecatalog";
        if (pi.getPurchaseUrl() != null) {
            purchaseURL = pi.getPurchaseUrl();
        }
        return purchaseURL;
    }

    public static String getLicenseMessageFormText(String nlsmsg, String purchaseURL) {
        purchaseURL = LicPlatformUtils.escapeXML((String)purchaseURL);
        String purchaseUrlWithTags = "<a href=\"" + purchaseURL + "\" nowrap=\"true\">" + purchaseURL + "</a>";
        StringBuffer errmsg = new StringBuffer();
        errmsg.append("<form>");
        if (nlsmsg != null && nlsmsg.trim().length() > 0) {
            errmsg.append("<p>");
            errmsg.append(LicPlatformUtils.escapeXML((String)nlsmsg));
            errmsg.append("</p>");
        }
        errmsg.append("<p>");
        errmsg.append(NLS.bind((String)Messages.Prod_Purchase_Link, (Object)purchaseUrlWithTags));
        errmsg.append("</p>");
        errmsg.append("<p>");
        String atagstart = "<a href=\"prodActivationDoc\" nowrap=\"true\">";
        String atagend = "</a>";
        errmsg.append(NLS.bind((String)Messages.Prod_Activate_Link, (Object)atagstart, (Object)atagend));
        errmsg.append("</p></form>");
        return errmsg.toString();
    }

    private static void setRunInDisconnectStatus(ProductInformation pi) {
        String prodname = pi.getProductName();
        String errmsg = NLS.bind((String)Messages.Run_As_Disconnected, (Object)prodname);
        LicenseChecker.setLastErrMsg(errmsg);
        lastErrCondtion.put(pi, new Exception(errmsg));
    }

    private static List getPIsByCompKey(Hashtable piMap, ComponentKey ck) {
        LinkedList rst = new LinkedList();
        Enumeration keys = piMap.keys();
        while (keys.hasMoreElements()) {
            ComponentKeyVO key = (ComponentKeyVO)keys.nextElement();
            if (!key.getId().equalsIgnoreCase(ck.getId()) && !key.getId().equals("*") || !key.getVersion().isIncluded(ck.getVersion())) continue;
            rst.addAll((List)piMap.get(key));
        }
        Collections.sort(rst);
        return rst;
    }

    private static ProductInformation getPiById(String prodID) {
        List piList = RegScanner.getPiList();
        if (piList != null) {
            Iterator iter = piList.iterator();
            while (iter.hasNext()) {
                ProductInformation pi = (ProductInformation)iter.next();
                if (!pi.getProductId().equalsIgnoreCase(prodID.trim())) continue;
                return pi;
            }
        }
        return null;
    }

    private static void updateErrCondition(ProductInformation pi) {
        if (pi.getLicenseStatus() != null && pi.getLicenseStatus().getErrException() != null) {
            lastErrCondtion.put(pi, pi.getLicenseStatus().getErrException());
        }
    }

    public static Hashtable getLastErrCondtion() {
        return lastErrCondtion;
    }

    public static String getLastErrMsg() {
        return lastErrMsg;
    }

    private static void setLastErrMsg(String lastErrMsg) {
        LicenseChecker.lastErrMsg = lastErrMsg;
    }

    public static String checkLicenseDirAclMsg() {
        IPath licenseDataPath;
        if (!(System.getProperty("DISABLE_LIC") != null || (licenseDataPath = LicUserUtils.getRuntimeLicenseLocation()) != null && licenseDataPath.toFile().canRead())) {
            String errmsg = NLS.bind((String)Messages.CAN_NOT_READ_LICENSE_FOLDER, (Object)licenseDataPath);
            return errmsg;
        }
        return null;
    }

    public static boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        ILicenseCheckProvider licenseChecker = LicenseCheckerFactory.getLicenseChecker("FLEX");
        return licenseChecker.configureRCLLogging(configFileLocation, logFileLocation, product, version, size, logLevel, traceLevel, maxFiles, enableLogging, enableTracing);
    }
}

