/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static final String[] z;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[13]);
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(z[6]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(z[11]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(z[5]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(z[7]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(z[12]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(z[10]);
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[9]);
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(z[8]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public String getFormat() {
        return z[14];
    }

    @Override
    public String getAlgorithm() {
        return z[4];
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[2] + this.y.toString() + "\n" + z[0] + this.p.toString() + "\n" + z[1] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(z[3] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public void zeroize() {
        this.y = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.g = BigInteger.ZERO;
        this.l = 0;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "H\rQ";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block26: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block26;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block27;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 56;
                                break;
                            }
                            case 1: {
                                n9 = 55;
                                break;
                            }
                            case 2: {
                                n9 = 91;
                                break;
                            }
                            case 3: {
                                n9 = 16;
                                break;
                            }
                            default: {
                                n9 = 86;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "_\rQ";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "qu\u0016Z\u0015}q\u0012@\u0005\u0018s2v0QRvX3T[6q8\u0018g.r:QT{[3A\rQil2";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2[a\u001av\u0018\u0017{";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "|\u007f";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "hV)q;]C>b%\u0018Z2c%QY<";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "qY-q:QS{{3A\u0017=\u007f$UV/";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "vB7|vHV)q;]C>b%";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "hE2f7LRvf7TB>0:]Y<d>\u0018C4\u007fvZ^<";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "}O8u%K\u00170u/\u0018S:d7";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "}O/b7\u0018G:b7UR/u$\u0018S:d7";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "y[<Y2\u0018^(08WC{qvkr\nE\u0013vt\u001e";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "hV)q;]C>b%\u0018Y4dvY\u0017\bU\u0007mr\u0015S\u0013";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "{V5~9L\u0017+b9\\B8uvyd\u0015>g\u0018R5s9\\^5w";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "`\u0019n o";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

