/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.swt.controls;

import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.wizardry.IWizardBreadCrumbs;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwtWizardBreadcrumbs
extends Canvas
implements PaintListener,
IWizardBreadCrumbs {
    private static final int TERMINUS_WIDTH = 5;
    private String[] crumbs;
    private int position;
    private Font selectedFont;
    private Font unselectedFont;
    private Color selectedBorderStartColor;
    private Color selectedBorderEndColor;
    private Color unselectedBorderStartColor;
    private Color unselectedBorderEndColor;
    private Color selectedFillStartColor;
    private Color selectedFillEndColor;
    private Color unselectedFillStartColor;
    private Color unselectedFillEndColor;
    private Color selectedTextColor;
    private Color unselectedTextColor;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        shell.setSize(100, 200);
        SwtWizardBreadcrumbs crumb = new SwtWizardBreadcrumbs((Composite)shell);
        crumb.setCrumbs(new String[]{"Lorem", "Ipsum", "Dolor", "Mattis"}, 1);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public SwtWizardBreadcrumbs(Composite parent) {
        super(parent, 0x20000001);
        this.addPaintListener(this);
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (SwtWizardBreadcrumbs.this.crumbs == null) {
                    return;
                }
                e.result = SwtWizardBreadcrumbs.this.crumbs[SwtWizardBreadcrumbs.this.position];
            }

            public void getDescription(AccessibleEvent e) {
                if (SwtWizardBreadcrumbs.this.crumbs == null) {
                    return;
                }
                e.result = SwtWizardBreadcrumbs.this.crumbs[SwtWizardBreadcrumbs.this.position];
            }

            public void getHelp(AccessibleEvent e) {
                if (SwtWizardBreadcrumbs.this.crumbs == null) {
                    return;
                }
                e.result = NLS.bind((String)Messages.WizardProgressLabel_AccessibilityHelp, (Object)SwtWizardBreadcrumbs.this.crumbs[SwtWizardBreadcrumbs.this.position]);
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = SwtWizardBreadcrumbs.this.getDisplay().map((Control)SwtWizardBreadcrumbs.this.getParent(), null, SwtWizardBreadcrumbs.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    public Point computeSize(int hintx, int hinty, boolean changed) {
        GC gc = new GC((Drawable)this);
        gc.setAdvanced(true);
        if (!gc.getAdvanced() || this.getDisplay().getDepth() <= 8) {
            gc.dispose();
            return new Point(0, 0);
        }
        gc.setFont(this.getSelectedFont());
        int biggestX = hintx;
        int biggestY = hinty;
        Path[][] paths = this.generatePaths(gc, hintx, hinty);
        float[] bounds = new float[4];
        Path[][] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path[] path = pathArray[n2];
            path[0].getBounds(bounds);
            biggestX = Math.max(biggestX, (int)(bounds[0] + bounds[2]) + 1);
            biggestY = Math.max(biggestY, (int)(bounds[1] + bounds[3]) + 1);
            path[0].dispose();
            path[1].dispose();
            ++n2;
        }
        gc.dispose();
        return new Point(biggestX, biggestY);
    }

    private Path[][] generatePaths(GC thisGC, int width, int height) {
        int outlineBaselineX = 4;
        int outlineBaselineY = 0;
        thisGC.setFont(this.getSelectedFont());
        int rowHeight = thisGC.getFontMetrics().getHeight() + 4;
        Path[][] paths = new Path[this.crumbs.length + 1][2];
        int i = 0;
        while (i < this.crumbs.length) {
            int horizontalDistance = thisGC.textExtent((String)this.crumbs[i]).x + 40;
            if (this.position == i && i != 0) {
                outlineBaselineX += 12;
            }
            if (width != -1 && outlineBaselineX + horizontalDistance + 8 + 2 > width) {
                outlineBaselineX = 0;
                outlineBaselineY += rowHeight + 5;
            }
            Path outlinePath = new Path(thisGC.getDevice());
            Path fillPath = new Path(thisGC.getDevice());
            int fillBaselineX = outlineBaselineX + 2;
            thisGC.setFont(this.getFontForCrumb(i));
            outlinePath.moveTo((float)outlineBaselineX, (float)(outlineBaselineY + 2));
            fillPath.moveTo((float)fillBaselineX, (float)(outlineBaselineY + 2 + 2));
            outlinePath.lineTo((float)outlineBaselineX, (float)(outlineBaselineY + rowHeight - 2));
            fillPath.lineTo((float)fillBaselineX, (float)(outlineBaselineY + rowHeight - 2 - 1));
            outlinePath.lineTo((float)(outlineBaselineX + 2), (float)(outlineBaselineY + rowHeight));
            fillPath.lineTo((float)(fillBaselineX + 2), (float)(outlineBaselineY + rowHeight - 1));
            outlinePath.lineTo((float)(outlineBaselineX + 2 + horizontalDistance), (float)(outlineBaselineY + rowHeight));
            fillPath.lineTo((float)(fillBaselineX + horizontalDistance), (float)(outlineBaselineY + rowHeight - 1));
            outlinePath.lineTo((float)(outlineBaselineX + 2 + horizontalDistance + 8), (float)(outlineBaselineY + rowHeight / 2 + 1));
            fillPath.lineTo((float)(fillBaselineX + 2 + horizontalDistance + 5), (float)(outlineBaselineY + rowHeight / 2 + 1));
            outlinePath.lineTo((float)(outlineBaselineX + 2 + horizontalDistance + 8), (float)(outlineBaselineY + rowHeight / 2 - 1));
            fillPath.lineTo((float)(fillBaselineX + 2 + horizontalDistance + 4), (float)(outlineBaselineY + rowHeight / 2 - 1));
            outlinePath.lineTo((float)(outlineBaselineX + 2 + horizontalDistance), (float)outlineBaselineY);
            fillPath.lineTo((float)(fillBaselineX + horizontalDistance), (float)(outlineBaselineY + 2));
            outlinePath.lineTo((float)(outlineBaselineX + 2), (float)outlineBaselineY);
            fillPath.lineTo((float)(fillBaselineX + 2), (float)(outlineBaselineY + 2));
            outlinePath.lineTo((float)outlineBaselineX, (float)(outlineBaselineY + 2));
            fillPath.lineTo((float)fillBaselineX, (float)(outlineBaselineY + 2 + 2));
            outlineBaselineX = outlineBaselineX + 2 + horizontalDistance + 3;
            paths[i][0] = outlinePath;
            paths[i][1] = fillPath;
            ++i;
        }
        if (width != -1 && (outlineBaselineX += 9) + 5 + 4 > width) {
            outlineBaselineX = 0;
            outlineBaselineY += rowHeight + 5;
        }
        Path outlinePath = new Path(thisGC.getDevice());
        Path fillPath = new Path(thisGC.getDevice());
        int fillBaselineX = outlineBaselineX + 2;
        outlinePath.moveTo((float)outlineBaselineX, (float)(outlineBaselineY + 2));
        outlinePath.lineTo((float)outlineBaselineX, (float)(outlineBaselineY + rowHeight - 2));
        outlinePath.lineTo((float)(outlineBaselineX + 2), (float)(outlineBaselineY + rowHeight));
        outlinePath.lineTo((float)(outlineBaselineX + 2 + 5), (float)(outlineBaselineY + rowHeight));
        outlinePath.lineTo((float)(outlineBaselineX + 2 + 5 + 2), (float)(outlineBaselineY + rowHeight - 2));
        outlinePath.lineTo((float)(outlineBaselineX + 2 + 5 + 2), (float)(outlineBaselineY + 2));
        outlinePath.lineTo((float)(outlineBaselineX + 2 + 5), (float)outlineBaselineY);
        outlinePath.lineTo((float)(outlineBaselineX + 2), (float)outlineBaselineY);
        outlinePath.lineTo((float)outlineBaselineX, (float)(outlineBaselineY + 2));
        fillPath.moveTo((float)fillBaselineX, (float)(outlineBaselineY + 2));
        fillPath.lineTo((float)fillBaselineX, (float)(outlineBaselineY + rowHeight - 1));
        fillPath.lineTo((float)(fillBaselineX + 5 + 1), (float)(outlineBaselineY + rowHeight - 1));
        fillPath.lineTo((float)(fillBaselineX + 5 + 1), (float)(outlineBaselineY + 2));
        paths[paths.length - 1][0] = outlinePath;
        paths[paths.length - 1][1] = fillPath;
        return paths;
    }

    private Font getFontForCrumb(int i) {
        if (i == this.position) {
            return this.getSelectedFont();
        }
        return this.getUnselectedFont();
    }

    private Color getSelectedBorderEndColor() {
        return this.selectedBorderEndColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(2) : this.selectedBorderEndColor;
    }

    private Color getSelectedBorderStartColor() {
        return this.selectedBorderStartColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(1) : this.selectedBorderStartColor;
    }

    private Color getSelectedFillEndColor() {
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            return this.selectedFillEndColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(9) : this.selectedFillEndColor;
        }
        return this.selectedFillEndColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(31) : this.selectedFillEndColor;
    }

    private Color getSelectedFillStartColor() {
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            return this.selectedFillStartColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(15) : this.selectedFillStartColor;
        }
        return this.selectedFillStartColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(31) : this.selectedFillStartColor;
    }

    private Font getSelectedFont() {
        return this.selectedFont == null ? this.getFont() : this.selectedFont;
    }

    private Color getSelectedTextColor() {
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            return this.selectedTextColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(2) : this.selectedTextColor;
        }
        return this.selectedTextColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(30) : this.selectedTextColor;
    }

    private Color getUnselectedBorderEndColor() {
        return this.unselectedBorderEndColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(16) : this.unselectedBorderEndColor;
    }

    private Color getUnselectedBorderStartColor() {
        return this.unselectedBorderStartColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(15) : this.unselectedBorderStartColor;
    }

    private Color getUnselectedFillEndColor() {
        return this.unselectedFillEndColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(15) : this.unselectedFillEndColor;
    }

    private Color getUnselectedFillStartColor() {
        return this.unselectedFillStartColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(15) : this.unselectedFillStartColor;
    }

    private Font getUnselectedFont() {
        return this.unselectedFont == null ? this.getFont() : this.unselectedFont;
    }

    private Color getUnselectedTextColor() {
        return this.unselectedTextColor == null ? DisplayKeeper.INSTANCE.getDisplay().getSystemColor(16) : this.unselectedTextColor;
    }

    public void paintControl(PaintEvent e) {
        GC thisGC = e.gc;
        thisGC.setAdvanced(true);
        if (!thisGC.getAdvanced() || this.getDisplay().getDepth() <= 8) {
            return;
        }
        thisGC.setAntialias(1);
        Rectangle carea = this.getClientArea();
        Path[][] paths = this.generatePaths(thisGC, carea.width - 1, carea.height - 1);
        thisGC.setBackground(this.getParent().getBackground());
        thisGC.fillRectangle(0, 0, carea.width, carea.height);
        int i = paths.length - 1;
        while (i >= 0) {
            Font font;
            Color textColor;
            Color fillEnd;
            Color fillStart;
            Color borderEnd;
            Color borderStart;
            Path borderPath = paths[i][0];
            Path fillPath = paths[i][1];
            float[] pathBounds = new float[4];
            borderPath.getBounds(pathBounds);
            thisGC.setBackground(this.getParent().getBackground());
            thisGC.setForeground(this.getParent().getForeground());
            thisGC.fillPath(borderPath);
            if (i == this.position) {
                borderStart = this.getSelectedBorderStartColor();
                borderEnd = this.getSelectedBorderEndColor();
                fillStart = this.getSelectedFillStartColor();
                fillEnd = this.getSelectedFillEndColor();
                textColor = this.getSelectedTextColor();
                font = this.getSelectedFont();
            } else {
                borderStart = this.getUnselectedBorderStartColor();
                borderEnd = this.getUnselectedBorderEndColor();
                fillStart = this.getUnselectedFillStartColor();
                fillEnd = this.getUnselectedFillEndColor();
                textColor = this.getUnselectedTextColor();
                font = this.getUnselectedFont();
            }
            Pattern borderPattern = new Pattern((Device)e.display, pathBounds[0] - 1.0f, pathBounds[3] / 2.0f, pathBounds[0] + pathBounds[2], pathBounds[3] / 2.0f, borderStart, borderEnd);
            Pattern fillPattern = new Pattern((Device)e.display, pathBounds[0], pathBounds[3] / 2.0f, pathBounds[0] + pathBounds[2], pathBounds[3] / 2.0f, fillStart, fillEnd);
            if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast() || i == this.position) {
                thisGC.setBackgroundPattern(fillPattern);
            }
            thisGC.fillPath(fillPath);
            if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
                thisGC.setForegroundPattern(borderPattern);
            }
            thisGC.drawPath(borderPath);
            if (i != paths.length - 1) {
                thisGC.setFont(font);
                if (i != this.position) {
                    if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
                        thisGC.setForeground(textColor);
                    } else {
                        thisGC.setForeground(this.getParent().getForeground());
                    }
                } else {
                    thisGC.setForeground(textColor);
                }
                thisGC.setBackground(this.getBackground());
                int textX = (int)((double)(pathBounds[0] + pathBounds[2] / 2.0f) - (double)thisGC.textExtent((String)this.crumbs[i]).x / 2.0);
                int textY = (int)((double)(pathBounds[1] + pathBounds[3] / 2.0f) - (double)thisGC.getFontMetrics().getHeight() / 2.0);
                thisGC.drawText(this.crumbs[i], textX, textY, true);
            }
            thisGC.setBackgroundPattern(null);
            thisGC.setForegroundPattern(null);
            borderPath.dispose();
            fillPath.dispose();
            fillPattern.dispose();
            borderPattern.dispose();
            --i;
        }
    }

    public void setCrumbs(String[] crumbs, int position) {
        if (crumbs.length <= 0) {
            throw new IllegalArgumentException();
        }
        this.crumbs = crumbs;
        if (position < 0 || position > crumbs.length) {
            throw new IllegalArgumentException();
        }
        this.update();
        this.position = position;
        this.getParent().layout();
        this.redraw();
    }

    public void setSelectedFont(Font selectedFont) {
        this.selectedFont = selectedFont;
    }

    public void setUnselectedFont(Font unselectedFont) {
        this.unselectedFont = unselectedFont;
    }

    public void setSelectedBorderEndColor(Color selectedBorderEndColor) {
        this.selectedBorderEndColor = selectedBorderEndColor;
    }

    public void setSelectedBorderStartColor(Color selectedBorderStartColor) {
        this.selectedBorderStartColor = selectedBorderStartColor;
    }

    public void setSelectedFillEndColor(Color selectedFillEndColor) {
        this.selectedFillEndColor = selectedFillEndColor;
    }

    public void setSelectedFillStartColor(Color selectedFillStartColor) {
        this.selectedFillStartColor = selectedFillStartColor;
    }

    public void setSelectedTextColor(Color selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setUnselectedBorderEndColor(Color unselectedBorderEndColor) {
        this.unselectedBorderEndColor = unselectedBorderEndColor;
    }

    public void setUnselectedBorderStartColor(Color unselectedBorderStartColor) {
        this.unselectedBorderStartColor = unselectedBorderStartColor;
    }

    public void setUnselectedFillEndColor(Color unselectedFillEndColor) {
        this.unselectedFillEndColor = unselectedFillEndColor;
    }

    public void setUnselectedFillStartColor(Color unselectedFillStartColor) {
        this.unselectedFillStartColor = unselectedFillStartColor;
    }

    public void setUnselectedTextColor(Color unselectedTextColor) {
        this.unselectedTextColor = unselectedTextColor;
    }

    public Control getControl() {
        return this;
    }
}

