/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.im.plugin;

import com.ibm.cic.agent.core.api.IInvokeContext;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.tivoli.omnibus.im.plugin.DefaultFileHandlerException;
import com.ibm.tivoli.omnibus.im.plugin.MD5Digest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultFileHandler {
    public static final String POST_INSTALL_CONFIGURE = "post_install_configure";
    public static final String PRE_UNINSTALL_CONFIGURE = "pre_uninstall_configure";
    public static final int NUMBER_OF_ARGUMENTS = 4;
    ILogger logger = IMLogger.getLogger((String)this.getClass().getCanonicalName());

    public void run(IInvokeContext context, String[] args, PrintWriter writer, IProgressMonitor monitor) throws Exception {
        if (args.length != 4) {
            ResourceBundle messages = ResourceBundle.getBundle("OMNIbusIMExtension");
            String status = MessageFormat.format(messages.getString(this.getClass().getCanonicalName() + ".parameters"), this.getClass().getCanonicalName(), 4, args.length);
            this.logger.error(status);
            this.logger.debug("Input arguments expected format:\nargs[0] - Path to default configuration file.\nargs[1] - Path to the actual configuration file.\nargs[2] - Installation phase this action is invoked.\nargs[3] - The locale IM is using - ${system:osgi.nl}");
            throw new DefaultFileHandlerException(status);
        }
        File defaultFile = new File(args[0]);
        File userFile = new File(args[1]);
        String phase = args[2].trim();
        Locale imLocale = new Locale(args[3].trim());
        ResourceBundle messages = ResourceBundle.getBundle("OMNIbusIMExtension", imLocale);
        if (!defaultFile.exists()) {
            String messageKey = null;
            if (phase.equals(POST_INSTALL_CONFIGURE)) {
                messageKey = this.getClass().getCanonicalName() + ".installnodefault";
            } else if (phase.equals(PRE_UNINSTALL_CONFIGURE)) {
                messageKey = this.getClass().getCanonicalName() + ".uninstallnodefault";
            }
            String message = messages.getString(messageKey);
            String status = MessageFormat.format(message, defaultFile);
            if (phase.equals(POST_INSTALL_CONFIGURE)) {
                throw new DefaultFileHandlerException(status);
            }
            if (phase.equals(PRE_UNINSTALL_CONFIGURE)) {
                this.logger.warning(status);
            }
        }
        if (phase.equals(POST_INSTALL_CONFIGURE)) {
            if (!userFile.exists()) {
                try {
                    this.logger.debug("Copying [" + defaultFile + "] to [" + userFile + "]");
                    this.copyFile(defaultFile, userFile);
                }
                catch (IOException ioe) {
                    this.logger.debug("Error creating user file " + userFile);
                    throw ioe;
                }
            } else {
                this.logger.debug("File " + defaultFile + " - user version already exists");
            }
        } else if (phase.equals(PRE_UNINSTALL_CONFIGURE) && defaultFile.exists() && userFile.exists()) {
            try {
                this.checkAndDeleteFile(defaultFile, userFile);
            }
            catch (Exception e) {
                this.logger.debug("Error caught trying to remove file:" + userFile);
                writer.print(e.getStackTrace());
            }
        }
    }

    private void checkAndDeleteFile(File defaultFile, File destinationFile) throws Exception {
        if (this.isIdentical(defaultFile, destinationFile)) {
            boolean isDeleted = destinationFile.delete();
            if (isDeleted) {
                this.logger.debug("Removed unmodified file [" + defaultFile + "].");
            } else {
                this.logger.debug("Failed to remove identical default file [" + defaultFile + "].");
            }
        }
    }

    private boolean isIdentical(File sourceFile, File destinationFile) throws Exception {
        boolean retval = false;
        MD5Digest digest = new MD5Digest();
        retval = digest.compareDigest(sourceFile, destinationFile);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File dest) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        int BUFFER_SIZE = 8192;
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            File targetPath = dest.getParentFile();
            if (targetPath != null && !targetPath.exists()) {
                targetPath.mkdirs();
            }
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

