/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.structure.MM_HeapLinkedFreeHeader;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.CheckElement;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.CheckError;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;

public class CheckReporterTTY
extends CheckReporter {
    private PrintStream out;
    private static String[] errorTypes = new String[]{"no error", "not aligned", "double array not aligned", "object not in an object region", "not in an object segment", "overlaps segment boundary", "heap object on stack", "class pointer is null", "class pointer not aligned", "class pointer not in a class segment", "class pointer overlaps segment boundary", "class pointer of class is not java.lang.Class", "class pointer on stack", "invalid flags", "in an old segment, old bit not set", "in a new segment, old or remembered bit set", "hole has size <= 0", "new pointer in old object without remembered bit set", "not in an old segment or class segment", "old bit or remembered bit not set", "not in remembered set, new object reference", "pool and puddle newstore flag mismatch", "puddle newstore flag invalid", "heap object has remembered bit set when cardtable active", "new pointer in old object without card dirtied", "dead object", "class header invalid", "class object not java.lang.Class", "scope internal pointer refers outside its scope", "class pointer is in an undead class segment", "class ramStatics field points to wrong object", "class ramStatics must be NULL for hot swapped class", "class ramStatics field points to object but out of GC scan range", "class ramStatics number of references not equal specified in ROM class", "offset of @Packed object is invalid", "offset of @Packed object is out of range", "target of @Packed object is not @Packed", "target of @Packed object is a derived @Packed object", "class object not a subclass of java.util.concurrent.locks.AbstractOwnableSynchronizer", "array class can not be hot swapped", "replaced class has no hot swapped out flag set", "object slot appears to contain a J9Class pointer", "Ownable Synchronizer Object is not attached to the list", "Ownable Synchronizer List has a circular reference", "hole size is not aligned", "hole next is not a hole", "hole next is outside of current region", "hole next is pointed inside of the hole"};

    public CheckReporterTTY(PrintStream out) {
        this.out = out;
    }

    public CheckReporterTTY() {
        this(System.out);
    }

    public void report(CheckError error) {
        if (!this.shouldReport(error)) {
            return;
        }
        try {
            if (error._slot != null && error._slot.notNull()) {
                UDATA slotValue;
                VoidPointer slot = error._slot;
                switch (error._objectType) {
                    case 1: {
                        J9ObjectPointer fieldValue = ObjectReferencePointer.cast(slot).at(0L);
                        slotValue = UDATA.cast(fieldValue);
                        break;
                    }
                    case 3: {
                        slotValue = UDATAPointer.cast(slot).at(0L);
                        slot = error._stackLocation;
                        break;
                    }
                    case 5: {
                        slotValue = UDATA.cast(slot);
                        slot = VoidPointer.NULL;
                        break;
                    }
                    default: {
                        slotValue = UDATAPointer.cast(slot).at(0L);
                    }
                }
                this.out.println(String.format("  <gc check (%d): %s: %s: %sslot %x(%x) -> %x: %s>", error._errorNumber, "from debugger", error._check.getCheckName(), error._elementName, error._object.getAddress(), slot.getAddress(), slotValue.longValue(), this.getErrorType(error._errorCode)));
            } else {
                this.out.println(String.format("  <gc check (%d): %s: %s: %s%x: %s>", error._errorNumber, "from debugger", error._check.getCheckName(), error._elementName, error._object.getAddress(), this.getErrorType(error._errorCode)));
                if (error._objectType == 1) {
                    this.reportObjectHeader(error, J9ObjectPointer.cast(error._object), "");
                }
            }
        }
        catch (CorruptDataException cde) {
            this.out.println(String.format("  <gc check (%d): %s: %s: %s%x: %s>", error._errorNumber, "from debugger", error._check.getCheckName(), error._elementName, error._object.getAddress(), this.getErrorType(error._errorCode)));
        }
    }

    private String getErrorType(int errorCode) {
        if (errorCode == Integer.MAX_VALUE) {
            return "corrupt data exception";
        }
        return errorTypes[errorCode];
    }

    public void reportClass(CheckError error, J9ClassPointer clazz, String prefix) {
        String prefixString;
        String string = prefixString = prefix == null ? "" : prefix;
        if (!this.shouldReport(error)) {
            return;
        }
        this.out.println(String.format("  <gc check (%d): %sClass %x>", error._errorNumber, prefixString, clazz.getAddress()));
    }

    public void reportFatalError(CheckError error) {
        this.out.println(String.format("  <gc check (%d): Cannot resolve problem detected on heap, aborting check>", error._errorNumber));
    }

    public void reportHeapWalkError(CheckError error, CheckElement previousObjectPtr1, CheckElement previousObjectPtr2, CheckElement previousObjectPtr3) {
        this.reportFatalError(error);
        if (!previousObjectPtr1.isNone()) {
            this.reportGenericType(error, previousObjectPtr1, "Previous ");
            if (!previousObjectPtr2.isNone()) {
                this.reportGenericType(error, previousObjectPtr2, "Previous ");
                if (!previousObjectPtr3.isNone()) {
                    this.reportGenericType(error, previousObjectPtr3, "Previous ");
                }
            }
        } else {
            this.out.println(String.format("  <gc check (%d): %x was first object encountered on heap>", error._errorNumber, error._object.getAddress()));
        }
    }

    public void reportObjectHeader(CheckError error, J9ObjectPointer object, String prefix) {
        String prefixString;
        String string = prefixString = prefix == null ? "" : prefix;
        if (!this.shouldReport(error)) {
            return;
        }
        boolean isValid = false;
        boolean isHole = false;
        boolean isIndexable = false;
        try {
            isHole = ObjectModel.isDeadObject(object);
            if (!isHole) {
                isIndexable = ObjectModel.isIndexable(object);
            }
            isValid = true;
        }
        catch (CorruptDataException cde) {
            // empty catch block
        }
        if (isValid) {
            if (isIndexable) {
                this.out.print(String.format("  <gc check (%d): %sIObject %x header:", error._errorNumber, prefixString, object.getAddress()));
            } else {
                String elementName = isHole ? "Hole" : "Object";
                this.out.print(String.format("  <gc check (%d): %s%s %x header:", error._errorNumber, prefixString, elementName, object.getAddress()));
            }
        } else {
            this.out.print(String.format("  <gc check (%d): %s%s %x header:", error._errorNumber, prefixString, "Corrupt", object.getAddress()));
        }
        int headerSize = (int)J9Object.SIZEOF;
        if (isHole) {
            headerSize = (int)MM_HeapLinkedFreeHeader.SIZEOF;
        } else {
            try {
                headerSize = ObjectModel.getHeaderSize(object).intValue();
            }
            catch (CorruptDataException cde) {
                // empty catch block
            }
        }
        try {
            U32Pointer data = U32Pointer.cast(object);
            for (int i = 0; i < headerSize / 4; ++i) {
                this.out.print(String.format(" %08X", data.at(i).longValue()));
            }
        }
        catch (CorruptDataException cde) {
            // empty catch block
        }
        this.out.println(">");
    }

    public void println(String arg) {
        this.out.println(arg);
    }

    public void print(String arg) {
        this.out.print(arg);
    }

    public void reportForwardedObject(J9ObjectPointer object, J9ObjectPointer newObject) {
        this.out.println(String.format("  <gc check: found forwarded pointer %x -> %x>", object.getAddress(), newObject.getAddress()));
    }
}

