/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.exceptions.UnknownArchitectureException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.VMRegMapHelper;
import java.io.PrintStream;

public class J9RegCommand
extends Command {
    public J9RegCommand() {
        this.addCommand("j9reg", "<level>", "list VM named registers");
    }

    private void printUsage(PrintStream out) {
        out.println("j9reg <level> - list VM named registers");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        int level = 0;
        if (0 == args.length) {
            level = 1;
        } else if (1 == args.length) {
            try {
                level = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                out.println(args[0] + " is not a valid integer. Please try again.");
                return;
            }
        } else {
            this.printUsage(out);
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            VMRegMapHelper.printRegisters(vm, level, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException("Failed to get vm address from RAS");
        }
        catch (UnknownArchitectureException uae) {
            throw new DDRInteractiveCommandException(uae.getMessage(), uae);
        }
    }
}

