/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.commands.J9BCUtil;
import java.io.PrintStream;

public class DumpRomClassCommand
extends Command {
    public DumpRomClassCommand() {
        this.addCommand("dumpromclass", "<address|name:<classname>> [maps]", "cfdump the specified J9ROMClass. Wild cards are allowed in class name. (maps is optional)");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long maps = 0L;
            if (args.length != 1 && args.length != 2) {
                this.printUsage(out);
                return;
            }
            if (args.length == 2 && args[1].equals("maps")) {
                maps |= J9BCTranslationData.BCT_DumpMaps;
            }
            maps = J9BuildFlags.env_littleEndian ? (maps |= J9BCTranslationData.BCT_LittleEndianOutput) : (maps |= J9BCTranslationData.BCT_BigEndianOutput);
            if (args[0].startsWith("name:")) {
                long hitCount = 0L;
                String searchClassName = args[0].substring(args[0].indexOf(58) + 1);
                PatternString pattern = new PatternString(searchClassName);
                J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                ClassSegmentIterator iterator = new ClassSegmentIterator(vm.classMemorySegments());
                while (iterator.hasNext()) {
                    J9ClassPointer classPointer = (J9ClassPointer)iterator.next();
                    String javaName = J9ClassHelper.getJavaName(classPointer);
                    if (!pattern.isMatch(javaName)) continue;
                    ++hitCount;
                    J9ROMClassPointer clazz = classPointer.romClass();
                    String hexString = clazz.getHexAddress();
                    out.println(String.format("ROMClass %1$s named %2$s\n", hexString, javaName));
                    J9BCUtil.j9bcutil_dumpRomClass(out, clazz, maps);
                }
                out.println(String.format("Found %1$d class(es) with name %2$s\n", hitCount, searchClassName));
            } else {
                long addr = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
                J9ROMClassPointer clazz = J9ROMClassPointer.cast(addr);
                J9BCUtil.j9bcutil_dumpRomClass(out, clazz, maps);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printUsage(PrintStream out) {
        out.println("dumpromclass <address|name:<classname>> [map] - cfdump the specified J9ROMClass. Wild cards are allowed in class name. (maps is optional)");
    }
}

