/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm26.structure.J9JavaAccessFlags;

public class J9ROMClassHelper {
    public static J9ROMConstantPoolItemPointer constantPool(J9ROMClassPointer romclass) {
        return J9ROMConstantPoolItemPointer.cast(romclass.add(1L));
    }

    public static boolean isPublic(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccPublic);
    }

    public static boolean isFinal(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccFinal);
    }

    public static boolean isSuper(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccSuper);
    }

    public static boolean isInterface(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccInterface);
    }

    public static boolean isAbstract(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccAbstract);
    }

    public static boolean isModule(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccModule);
    }

    public static boolean isSynthetic(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccSynthetic);
    }

    public static boolean isArray(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccClassArray);
    }

    public static boolean isPrimitiveType(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.modifiers().allBitsIn(J9JavaAccessFlags.J9AccClassInternalPrimitiveType);
    }

    public static boolean isUnsafe(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassUnsafe);
    }

    public static boolean hasVerifyData(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassHasVerifyData);
    }

    public static boolean hasModifiedByteCodes(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassBytecodesModified);
    }

    public static boolean hasEmptyFinalize(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassHasEmptyFinalize);
    }

    public static boolean hasJDBCNatives(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassHasJDBCNatives);
    }

    public static boolean isGCSpecial(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassGCSpecial);
    }

    public static boolean hasFinalFields(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassHasFinalFields);
    }

    public static boolean isHotSwappedOut(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static boolean isDying(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassDying);
    }

    public static boolean referenceWeek(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassReferenceWeak);
    }

    public static boolean referenceSoft(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassReferenceSoft);
    }

    public static boolean referencePhantom(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassReferencePhantom);
    }

    public static boolean finalizeNeeded(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassFinalizeNeeded);
    }

    public static boolean isClonable(J9ROMClassPointer romclass) throws CorruptDataException {
        return romclass.extraModifiers().allBitsIn(J9JavaAccessFlags.J9AccClassCloneable);
    }
}

