/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.IAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlgorithmPicker<T extends IAlgorithm> {
    private final String algorithmId;

    protected AlgorithmPicker(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public T pickAlgorithm() {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf(this.algorithmId);
        for (IAlgorithm thisAlg : this.allAlgorithms()) {
            if (!thisAlg.matches(version)) continue;
            return (T)thisAlg;
        }
        throw new UnsupportedOperationException("No implementation of " + this.algorithmId + " available for version " + version);
    }

    protected abstract Iterable<? extends T> allAlgorithms();
}

