/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckStringTable
extends Check {
    CheckStringTable() {
    }

    public void check() {
        try {
            J9HashTablePointer stringTable = this._javaVM.stringTable();
            GCStringTableIterator stringTableIterator = GCStringTableIterator.fromJ9JavaVM(this._javaVM);
            while (stringTableIterator.hasNext()) {
                PointerPointer objectIndirect = PointerPointer.cast(stringTableIterator.nextAddress());
                if (this._engine.checkSlotPool(objectIndirect, VoidPointer.cast(stringTable)) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error checking string table", e, false);
        }
    }

    public String getCheckName() {
        return "STRING TABLE";
    }

    public void print() {
        try {
            J9HashTablePointer stringTable = this._javaVM.stringTable();
            GCStringTableIterator stringTableIterator = GCStringTableIterator.fromJ9JavaVM(this._javaVM);
            ScanFormatter formatter = new ScanFormatter(this, "StringTable", stringTable);
            while (stringTableIterator.hasNext()) {
                formatter.entry(stringTableIterator.next());
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error checking string table", e, false);
        }
    }
}

