/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ClassForNameCommand
extends Command {
    public ClassForNameCommand() {
        this.addCommand("classforname", "<name>", "find the class corresponding to name (with wildcards)");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.printUsage(out);
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            vm.classMemorySegments();
            ClassSegmentIterator iterator = new ClassSegmentIterator(vm, vm.classMemorySegments());
            int hitCount = 0;
            String searchClassName = args[0];
            PatternString pattern = new PatternString(searchClassName);
            out.println(String.format("Searching for classes named '%1$s' in VM=%2$s", searchClassName, Long.toHexString(vm.getAddress())));
            while (iterator.hasNext()) {
                J9ClassPointer classPointer = (J9ClassPointer)iterator.next();
                String javaName = J9ClassHelper.getJavaName(classPointer);
                if (!pattern.isMatch(javaName)) continue;
                ++hitCount;
                String hexString = classPointer.getHexAddress();
                out.println(String.format("!j9class %1$s named %2$s", hexString, javaName));
            }
            out.println(String.format("Found %1$d class(es) named %2$s", hitCount, searchClassName));
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printUsage(PrintStream out) {
        out.println("classforname <name> - find the class corresponding to name (with wildcards)");
    }
}

