/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.types.I64;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class I64Pointer
extends Pointer {
    public static final int SIZEOF = 8;
    public static final I64Pointer NULL = new I64Pointer(0L);

    protected I64Pointer(long address) {
        super(address);
    }

    public static I64Pointer cast(AbstractPointer pointer) {
        return I64Pointer.cast(pointer.getAddress());
    }

    public static I64Pointer cast(UDATA udata) {
        return I64Pointer.cast(udata.longValue());
    }

    public static I64Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new I64Pointer(address);
    }

    public I64 at(long index) throws CorruptDataException {
        return new I64(this.getLongAtOffset(index * 8L));
    }

    public I64 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public I64Pointer untag() {
        return this.untag(7L);
    }

    public I64Pointer untag(long mask) {
        return new I64Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public I64Pointer add(long count) {
        return new I64Pointer(this.address + 8L * count);
    }

    public I64Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public I64Pointer addOffset(long offset) {
        return new I64Pointer(this.address + offset);
    }

    public I64Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public I64Pointer sub(long count) {
        return new I64Pointer(this.address - 8L * count);
    }

    public I64Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public I64Pointer subOffset(long offset) {
        return new I64Pointer(this.address - offset);
    }

    public I64Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return 8L;
    }
}

