/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.MonitorTable;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.j9.ObjectMonitor;
import com.ibm.j9ddr.vm24.j9.gc.MMObjectAccessBarrier;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.types.UDATA;

class MMObjectAccessBarrier_V1
extends MMObjectAccessBarrier {
    protected MonitorTable monitorTable = MonitorTable.from();
    private int shift = 0;
    private UDATA displacement = null;

    protected MMObjectAccessBarrier_V1() throws CorruptDataException {
        if (J9BuildFlags.gc_compressedPointers) {
            try {
                J9JavaVMPointer vm = DataType.getJ9RASPointer().getVM();
                this.shift = vm.compressedPointersShift().intValue();
                this.displacement = vm.compressedPointersDisplacement();
                if (this.displacement.eq(0L)) {
                    this.displacement = null;
                }
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error initializing the object access barrier", cde, true);
            }
        }
    }

    public int getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        return ObjectModel.getObjectHashCode(object);
    }

    public J9ObjectMonitorPointer getLockword(J9ObjectPointer object) throws CorruptDataException {
        return this.getMonitor(object).getLockword();
    }

    public ObjectMonitor getMonitor(J9ObjectPointer object) throws CorruptDataException {
        return ObjectMonitor.fromJ9Object(object);
    }

    public J9ObjectPointer convertPointerFromToken(long token) {
        if (token == 0L) {
            return J9ObjectPointer.NULL;
        }
        if (J9BuildFlags.gc_compressedPointers) {
            UDATA ref = new UDATA(token);
            ref = ref.leftShift(this.shift);
            if (this.displacement != null) {
                ref = ref.add(this.displacement);
            }
            return J9ObjectPointer.cast(ref);
        }
        return J9ObjectPointer.cast(token);
    }

    public long convertTokenFromPointer(J9ObjectPointer pointer) {
        if (pointer.isNull()) {
            return 0L;
        }
        UDATA address = UDATA.cast(pointer);
        if (J9BuildFlags.gc_compressedPointers) {
            if (this.displacement != null) {
                address = address.sub(this.displacement);
            }
            address = address.rightShift(this.shift);
        }
        return address.longValue();
    }
}

