/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive;

import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.StackWalkCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.StructureCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.ThreadsCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.commands.BuildFlagsCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.commands.DumpAllSegmentsCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.commands.DumpStringTableCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.commands.SearchStringTableCommand;
import com.ibm.j9ddr.vm23.tools.ddrinteractive.commands.WalkJ9PoolCommand;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommandsTask
implements IBootstrapRunnable {
    private final Logger logger = CommandUtils.getLogger();

    @Override
    public void run(IVMData vmData, Object[] userData) {
        Object[] passbackArray = (Object[])userData[0];
        Object loader = passbackArray[1];
        LinkedList<ICommand> toPassBack = new LinkedList<ICommand>();
        toPassBack.add(new BuildFlagsCommand());
        toPassBack.add(new StackWalkCommand());
        toPassBack.add(new StructureCommand());
        toPassBack.add(new ThreadsCommand());
        toPassBack.add(new DumpAllSegmentsCommand());
        toPassBack.add(new WalkJ9PoolCommand());
        toPassBack.add(new DumpStringTableCommand());
        toPassBack.add(new SearchStringTableCommand());
        this.loadPlugins(toPassBack, loader);
        passbackArray[0] = toPassBack;
    }

    private void loadPlugins(List<ICommand> toPassBack, Object obj) {
        if (!(obj instanceof DDRInteractiveClassLoader)) {
            this.logger.fine("Plugin classloader is not an instance of DRRInteractiveClassLoader. No plugins have been loaded");
            return;
        }
        DDRInteractiveClassLoader loader = (DDRInteractiveClassLoader)obj;
        for (PluginConfig plugin : loader.getPlugins()) {
            try {
                ICommand command = plugin.newInstance();
                toPassBack.add(command);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to create an instance of " + plugin.getId(), e);
            }
        }
    }
}

