/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U64Pointer;
import com.ibm.j9ddr.vm23.pointer.U8Pointer;
import com.ibm.j9ddr.vm23.structure.J9Statistic;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U64;
import com.ibm.j9ddr.vm23.types.U8;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=J9Statistic.class)
public class J9StatisticPointer
extends StructurePointer {
    public static final J9StatisticPointer NULL = new J9StatisticPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9StatisticPointer(long address) {
        super(address);
    }

    public static J9StatisticPointer cast(AbstractPointer structure) {
        return J9StatisticPointer.cast(structure.getAddress());
    }

    public static J9StatisticPointer cast(UDATA udata) {
        return J9StatisticPointer.cast(udata.longValue());
    }

    public static J9StatisticPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9StatisticPointer(address);
    }

    public J9StatisticPointer add(long count) {
        return J9StatisticPointer.cast(this.address + J9Statistic.SIZEOF * count);
    }

    public J9StatisticPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9StatisticPointer addOffset(long offset) {
        return J9StatisticPointer.cast(this.address + offset);
    }

    public J9StatisticPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9StatisticPointer sub(long count) {
        return J9StatisticPointer.cast(this.address - J9Statistic.SIZEOF * count);
    }

    public J9StatisticPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9StatisticPointer subOffset(long offset) {
        return J9StatisticPointer.cast(this.address - offset);
    }

    public J9StatisticPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9StatisticPointer untag(long mask) {
        return J9StatisticPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9StatisticPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9Statistic.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataSlotOffset_", declaredType="U64")
    public U64 dataSlot() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9Statistic._dataSlotOffset_));
    }

    public U64Pointer dataSlotEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)J9Statistic._dataSlotOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U8")
    public U8 dataType() throws CorruptDataException {
        return new U8(this.getByteAtOffset(J9Statistic._dataTypeOffset_));
    }

    public U8Pointer dataTypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)J9Statistic._dataTypeOffset_);
    }

    public U8Pointer nameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)J9Statistic._nameOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextStatisticOffset_", declaredType="struct J9Statistic*")
    public J9StatisticPointer nextStatistic() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9Statistic._nextStatisticOffset_);
        return J9StatisticPointer.cast(pointer);
    }

    public PointerPointer nextStatisticEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9Statistic._nextStatisticOffset_);
    }
}

