/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U64;
import com.ibm.j9ddr.vm23.types.UDATA;

public class U64Pointer
extends Pointer {
    public static final int SIZEOF = 8;
    public static final U64Pointer NULL = new U64Pointer(0L);

    protected U64Pointer(long address) {
        super(address);
    }

    public static U64Pointer cast(AbstractPointer pointer) {
        return U64Pointer.cast(pointer.getAddress());
    }

    public static U64Pointer cast(UDATA udata) {
        return U64Pointer.cast(udata.longValue());
    }

    public static U64Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new U64Pointer(address);
    }

    public U64 at(long index) throws CorruptDataException {
        return new U64(this.getLongAtOffset(index * 8L));
    }

    public U64 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public U64Pointer untag() {
        return this.untag(7L);
    }

    public U64Pointer untag(long mask) {
        return new U64Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public U64Pointer add(long count) {
        return new U64Pointer(this.address + 8L * count);
    }

    public U64Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public U64Pointer addOffset(long offset) {
        return new U64Pointer(this.address + offset);
    }

    public U64Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public U64Pointer sub(long count) {
        return new U64Pointer(this.address - 8L * count);
    }

    public U64Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public U64Pointer subOffset(long offset) {
        return new U64Pointer(this.address - offset);
    }

    public U64Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return 8L;
    }
}

