/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

public class DoublePointer
extends Pointer {
    public static final int SIZEOF = 8;
    public static final DoublePointer NULL = new DoublePointer(0L);

    protected DoublePointer(long address) {
        super(address);
    }

    public static DoublePointer cast(AbstractPointer pointer) {
        return DoublePointer.cast(pointer.getAddress());
    }

    public static DoublePointer cast(UDATA udata) {
        return DoublePointer.cast(udata.longValue());
    }

    public static DoublePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new DoublePointer(address);
    }

    public DoublePointer at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException("Use doubleAt(long index)");
    }

    public DoublePointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public long longAt(long index) throws CorruptDataException {
        return (long)this.doubleAt(index);
    }

    public double doubleAt(long index) throws CorruptDataException {
        return this.getDoubleAtOffset(index * 8L);
    }

    public float floatAt(long index) throws CorruptDataException {
        return (float)this.doubleAt(index);
    }

    public DoublePointer add(long count) {
        return new DoublePointer(this.address + 8L * count);
    }

    public DoublePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public DoublePointer addOffset(long offset) {
        return new DoublePointer(this.address + offset);
    }

    public DoublePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public DoublePointer sub(long count) {
        return new DoublePointer(this.address - 8L * count);
    }

    public DoublePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public DoublePointer subOffset(long offset) {
        return new DoublePointer(this.address - offset);
    }

    public DoublePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public DoublePointer untag() {
        return this.untag(7L);
    }

    public DoublePointer untag(long mask) {
        return new DoublePointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    protected long sizeOfBaseType() {
        return 8L;
    }
}

